/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util.management;

import com.hynnet.util.management.JMException;
import com.hynnet.util.management.MBeanServerFactory;
import java.security.AccessControlException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicMBeanAbstract
implements DynamicMBean {
    private static final Logger logger = LoggerFactory.getLogger((String)DynamicMBeanAbstract.class.getName());
    private String m_name;
    private String m_desc;
    private MBeanInfo m_mBeanInfo;

    protected abstract MBeanOperationInfo[] getMBeanOperationInfos();

    protected abstract MBeanAttributeInfo[] getMBeanAttributeInfos();

    protected abstract MBeanNotificationInfo[] getMBeanNotificationInfos();

    protected abstract void setAttribute(String var1, Object var2);

    public DynamicMBeanAbstract() {
        block3: {
            try {
                this.m_name = this.getClass().getSimpleName();
            }
            catch (Throwable e) {
                this.m_name = this.getClass().getName();
                int index = this.m_name.lastIndexOf(46);
                if (index > 0) {
                    this.m_name = this.m_name.substring(index + 1);
                }
                if ((index = this.m_name.lastIndexOf(36)) <= 0) break block3;
                this.m_name = this.m_name.substring(index + 1);
            }
        }
    }

    public DynamicMBeanAbstract(String name, String desc) {
        this.m_name = name;
        this.m_desc = desc;
    }

    private void buildDynamicMBean() {
        this.m_mBeanInfo = new MBeanInfo(this.m_name, this.m_desc, this.getMBeanAttributeInfos(), null, this.getMBeanOperationInfos(), this.getMBeanNotificationInfos());
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            return;
        }
        String attrName = attribute.getName();
        Object attrValue = attribute.getValue();
        this.setAttribute(attrName, attrValue);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            return null;
        }
        AttributeList resList = new AttributeList();
        for (String attr : attributes) {
            try {
                Object value = this.getAttribute(attr);
                resList.add(new Attribute(attr, value));
            }
            catch (Throwable e) {
                logger.error("\u8bfb\u53d6\u5c5e\u6027\uff1a{} \u5f02\u5e38", (Object)attr, (Object)e);
            }
        }
        return resList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            return null;
        }
        AttributeList resList = new AttributeList();
        for (Object obj : attributes) {
            Attribute attr = (Attribute)obj;
            String attrName = null;
            Object attrValue = null;
            try {
                this.setAttribute(attr);
                attrName = attr.getName();
                attrValue = attr.getValue();
                resList.add(new Attribute(attrName, attrValue));
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u5c5e\u6027\uff1a{} \u4e3a\uff1a{} \u5f02\u5e38", new Object[]{attrName, attrValue, e});
            }
        }
        return resList;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.m_mBeanInfo == null) {
            this.buildDynamicMBean();
        }
        return this.m_mBeanInfo;
    }

    protected String getMBeanName() {
        return this.getDefaultMBeanName();
    }

    private final String getDefaultMBeanName() {
        if (this.m_name == null || this.m_name.indexOf(58) < 0) {
            int endIndex;
            String packagePath = this.getClass().getName();
            int index = packagePath.indexOf(46);
            int n = endIndex = index > 0 ? packagePath.indexOf(46, index + 1) : -1;
            if (endIndex > 0) {
                packagePath = packagePath.substring(0, endIndex);
            }
            return packagePath + ":name=" + this.m_name;
        }
        return this.m_name;
    }

    public void registerMBean() {
        String mBeanName = this.getMBeanName();
        if (mBeanName == null || mBeanName.length() == 0) {
            mBeanName = this.getDefaultMBeanName();
        }
        try {
            if (MBeanServerFactory.getMBeanServer().isRegistered(mBeanName)) {
                MBeanServerFactory.getMBeanServer().unregisterMBean(mBeanName);
                logger.info("multiple instances for same host, jmx numbers might be off");
            }
            MBeanServerFactory.getMBeanServer().registerMBean(this, mBeanName);
        }
        catch (JMException e) {
            logger.info("JMX registration \"{}\" error: {}\nContinuing...", (Object)mBeanName, (Object)e.getMessage());
        }
        catch (AccessControlException e) {
            logger.info("JMX registration \"{}\" error: {}\nContinuing...", (Object)mBeanName, (Object)e.getMessage());
        }
        catch (Throwable e) {
            logger.info("\u521d\u59cb\u5316JMX:\"{}\"\u5f02\u5e38", (Object)mBeanName, (Object)e);
        }
    }

    public void unregisterMBean() {
        String mBeanName = this.getMBeanName();
        if (mBeanName == null || mBeanName.length() == 0) {
            mBeanName = this.getDefaultMBeanName();
        }
        try {
            if (MBeanServerFactory.getMBeanServer().isRegistered(mBeanName)) {
                MBeanServerFactory.getMBeanServer().unregisterMBean(mBeanName);
            }
        }
        catch (JMException e) {
            logger.info("JMX unregistration error: {}\nContinuing...", (Object)e.getMessage());
        }
        catch (AccessControlException e) {
            logger.info("JMX unregistration error: {}\nContinuing...", (Object)e.getMessage());
        }
        catch (Throwable e) {
            logger.info("\u6ce8\u9500JMX\u5f02\u5e38", e);
        }
    }
}

