/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util.log.impl;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.hynnet.exception.GeneralRuntimeException;
import com.hynnet.util.log.LogConfigurator;
import java.io.File;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator
implements LogConfigurator {
    public void loadConfig(String externalConfigFileLocation) throws GeneralRuntimeException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        File externalConfigFile = new File(externalConfigFileLocation);
        if (!externalConfigFile.exists()) {
            throw new GeneralRuntimeException("Logback External Config File Parameter does not reference a file that exists");
        }
        if (!externalConfigFile.isFile()) {
            throw new GeneralRuntimeException("Logback External Config File Parameter exists, but does not reference a file");
        }
        if (!externalConfigFile.canRead()) {
            throw new GeneralRuntimeException("Logback External Config File exists and is a file, but cannot be read.");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(externalConfigFileLocation);
        }
        catch (JoranException e) {
            throw new GeneralRuntimeException(e);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
    }
}

