/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util.code;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.hynnet.util.Base64;
import com.hynnet.util.code.LogoConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QrCode {
    private static final Logger log = LoggerFactory.getLogger(QrCode.class);
    private static final int QRCOLOR = -16777216;
    private static final int BGWHITE = -1;

    public static boolean makeLogoQRCode(String fileName, String qrUrl, String logoFilePath, String text, int width, int height) {
        return QrCode.saveImg(QrCode.makeLogoQRCode(qrUrl, logoFilePath, text, width, height), fileName);
    }

    public static String makeLogoQRCodeBase64String(String qrUrl, String logoFilePath, String text, int width, int height) {
        return QrCode.getImgBase64String(QrCode.makeLogoQRCode(qrUrl, logoFilePath, text, width, height));
    }

    public static BufferedImage makeLogoQRCode(String qrUrl, String logoFilePath, String text, int width, int height) {
        String content = qrUrl;
        try {
            QrCode zp = new QrCode();
            BufferedImage bim = zp.getQR_CODEBufferedImage(content, BarcodeFormat.QR_CODE, width, height, zp.getDecodeHintType());
            return zp.addLogo_QRCode(bim, logoFilePath != null ? new File(logoFilePath) : null, new LogoConfig(), text, "\u5b8b\u4f53", true, 20, 1);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public BufferedImage addLogo_QRCode(BufferedImage bim, File logoPic, LogoConfig logoConfig, String text, String fontName, boolean isBold, int fontSize, int txtSpace) {
        if (bim != null) {
            try {
                BufferedImage image = bim;
                Image logo = null;
                if (logoPic != null && logoPic.exists()) {
                    Graphics2D g = image.createGraphics();
                    logo = ImageIO.read(logoPic);
                    int widthLogo = ((BufferedImage)logo).getWidth(null) > image.getWidth() * 3 / 10 ? image.getWidth() * 3 / 10 : ((BufferedImage)logo).getWidth(null);
                    int heightLogo = ((BufferedImage)logo).getHeight(null) > image.getHeight() * 3 / 10 ? image.getHeight() * 3 / 10 : ((BufferedImage)logo).getWidth(null);
                    int x = (image.getWidth() - widthLogo) / 2;
                    int y = (image.getHeight() - heightLogo) / 2;
                    g.drawImage(logo, x, y, widthLogo, heightLogo, null);
                    g.dispose();
                }
                if (text != null && text.length() > 0) {
                    Font font = new Font(fontName, isBold ? 1 : 0, fontSize);
                    int imgWidth = image.getWidth();
                    Graphics2D outg = image.createGraphics();
                    outg.setFont(font);
                    int txtHeight = outg.getFontMetrics().getHeight();
                    int txtWidth = outg.getFontMetrics().stringWidth(text);
                    outg.dispose();
                    int txtLines = txtWidth <= imgWidth ? 1 : txtWidth / imgWidth + (txtWidth % imgWidth > 0 ? 1 : 0);
                    BufferedImage outImage = new BufferedImage(imgWidth, image.getHeight() + (txtHeight + txtSpace) * txtLines + txtSpace, 6);
                    outg = outImage.createGraphics();
                    outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                    outg.setColor(Color.BLACK);
                    outg.setFont(font);
                    if (txtLines > 1) {
                        int txtLen;
                        String outTxt = text;
                        int line = 1;
                        while ((txtLen = outTxt.length()) > 0) {
                            int curLen;
                            for (curLen = 0; curLen < txtLen && (txtWidth = outg.getFontMetrics().stringWidth(outTxt.substring(0, curLen + 1))) <= imgWidth; ++curLen) {
                            }
                            outg.drawString(outTxt.substring(0, curLen), 0, image.getHeight() + (txtHeight + txtSpace) * line - txtSpace);
                            outTxt = outTxt.substring(curLen);
                            ++line;
                        }
                    } else {
                        outg.drawString(text, (image.getWidth() - txtWidth) / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + txtSpace);
                    }
                    outg.dispose();
                    outImage.flush();
                    image = outImage;
                }
                if (logo != null) {
                    logo.flush();
                }
                image.flush();
                return image;
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public static boolean saveImg(BufferedImage image, String fileName) {
        try {
            if (image != null) {
                ImageIO.write((RenderedImage)image, "png", new File(fileName));
                return true;
            }
        }
        catch (IOException e) {
            log.error("\u56fe\u50cf\u5199\u5165\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImgBase64String(BufferedImage image) {
        if (image != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                String imageBase64QRCode;
                ImageIO.write((RenderedImage)image, "png", baos);
                baos.flush();
                String string = imageBase64QRCode = Base64.encodeBytes(baos.toByteArray());
                return string;
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u56fe\u50cfBase64\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            finally {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public BufferedImage fileToBufferedImage(BitMatrix bm) {
        BufferedImage image = null;
        try {
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -3351058);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public BufferedImage getQR_CODEBufferedImage(String content, BarcodeFormat barcodeFormat, int width, int height, Map<EncodeHintType, ?> hints) {
        MultiFormatWriter multiFormatWriter = null;
        BitMatrix bm = null;
        BufferedImage image = null;
        try {
            multiFormatWriter = new MultiFormatWriter();
            bm = multiFormatWriter.encode(content, barcodeFormat, width, height, hints);
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return image;
    }

    public Map<EncodeHintType, Object> getDecodeHintType() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.MAX_SIZE, 350);
        hints.put(EncodeHintType.MIN_SIZE, 100);
        return hints;
    }
}

