/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.FileOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipMaker {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.ZipMaker");
    private static final int BUFFER_SIZE = 2048;
    private ZipOutputStream objZipOut;
    private byte[] data;

    public void init(String strZipFileName) throws FileNotFoundException {
        this.data = new byte[2048];
        this.getZipStream(new FileOutputStream(strZipFileName));
    }

    public ZipOutputStream getZipStream(FileOutputStream objOutput) {
        Object objBufInput = null;
        CheckedOutputStream objCheckSum = new CheckedOutputStream(objOutput, new Adler32());
        this.objZipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(objCheckSum));
        return this.objZipOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(String strFileName, String strName) {
        BufferedInputStream objBufInput = null;
        try {
            int nCount;
            FileInputStream objFileInput = new FileInputStream(strFileName);
            objBufInput = new BufferedInputStream(objFileInput, 2048);
            if (strName == null || strName.length() == 0) {
                strName = FileOperation.getFileNameFromStr(strName);
            }
            ZipEntry objEntry = new ZipEntry(strName);
            this.objZipOut.putNextEntry(objEntry);
            while ((nCount = objBufInput.read(this.data, 0, 2048)) != -1) {
                this.objZipOut.write(this.data, 0, nCount);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (objBufInput != null) {
                try {
                    objBufInput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void putFile(File objFile, String strName) {
        if (objFile != null) {
            if (objFile.isFile()) {
                this.putFile(objFile.getAbsolutePath(), strName);
                return;
            }
            if (objFile.isDirectory()) {
                File[] arrayFile = objFile.listFiles();
                if (arrayFile == null || arrayFile.length == 0) {
                    return;
                }
                for (int n = 0; n < arrayFile.length; ++n) {
                    if (arrayFile[n].isFile()) {
                        this.putFile(arrayFile[n].getAbsolutePath(), strName + File.separatorChar + arrayFile[n].getName());
                        continue;
                    }
                    if (!arrayFile[n].isDirectory()) continue;
                    this.putFile(arrayFile[n], strName + File.separatorChar + arrayFile[n].getName());
                }
            }
        }
    }

    public void close() {
        try {
            if (this.objZipOut != null) {
                this.objZipOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

