/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Util;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.XMLUtil");
    public static String strErrorMsg = null;
    public static String NativeCharSet = Util.NativeCharSet;
    public static int iMaxTry = 5;

    public static String Replace(String inputString, String fromString, String toString) {
        String str = "";
        int iLen = inputString.length();
        int iFromLen = fromString.length();
        for (int i = 0; i < iLen; ++i) {
            int iFromPos;
            int iInputPos = i;
            for (iFromPos = 0; iFromPos < iFromLen && inputString.charAt(iInputPos) == fromString.charAt(iFromPos); ++iFromPos) {
                ++iInputPos;
            }
            if (iFromPos >= iFromLen) {
                str = str + toString;
                i += iFromLen - 1;
                continue;
            }
            char cTmp = inputString.charAt(i);
            str = str + cTmp;
        }
        return str;
    }

    public static String XMLEncode(String strInput) {
        if (strInput == null || strInput.length() == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer(strInput.length());
        char ch = ' ';
        for (int i = 0; i < strInput.length(); ++i) {
            ch = strInput.charAt(i);
            if (ch == '<') {
                sbuf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sbuf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sbuf.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                sbuf.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                sbuf.append("&quot;");
                continue;
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    public static String XMLToHtml(String strXML, String strXSLPath, boolean bIsXSLData) {
        int i;
        String strResult = "";
        TransformerFactory tFactory = null;
        Transformer transformer = null;
        Reader xslSource = null;
        StringReader xmlSource = null;
        StreamSource xslStream = null;
        try {
            if (strXML == null || strXML.length() == 0) {
                strErrorMsg = "\u6ca1\u6709\u6307\u5b9aXML";
                return "";
            }
            if (strXSLPath == null || strXSLPath.length() == 0) {
                strErrorMsg = "\u6ca1\u6709\u6307\u5b9aXSL";
                return strXML;
            }
            if (bIsXSLData) {
                xslSource = new StringReader(strXSLPath);
                xslStream = new StreamSource(xslSource);
            } else {
                xslSource = new InputStreamReader((InputStream)new FileInputStream(strXSLPath), NativeCharSet);
                xslStream = new StreamSource(xslSource);
                xslStream.setSystemId(strXSLPath);
            }
            tFactory = TransformerFactory.newInstance();
        }
        catch (Exception e) {
            System.out.print(" StreamSourceXSL Error!\uff01" + strXSLPath);
            try {
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter(out));
                strResult = strResult + out.toString();
                if (xslSource != null) {
                    xslSource.close();
                }
                return strResult;
            }
            catch (Exception ex) {
                return strResult;
            }
        }
        for (i = 1; i <= iMaxTry; ++i) {
            try {
                transformer = tFactory.newTransformer(xslStream);
                break;
            }
            catch (Exception e) {
                if (i >= iMaxTry) {
                    try {
                        StringWriter out = new StringWriter();
                        e.printStackTrace(new PrintWriter(out));
                        strResult = strResult + "newTransformer\u5931\u8d25\uff01\r\n<br>" + out.toString();
                        System.out.print(" newTransformer Error Stop!\uff01");
                        if (xslSource != null) {
                            xslSource.close();
                        }
                        return strResult;
                    }
                    catch (Exception ex1) {
                        return strResult;
                    }
                }
                try {
                    if (xslSource != null) {
                        xslSource.close();
                    }
                    if (bIsXSLData) {
                        xslSource = new StringReader(strXSLPath);
                        xslStream = new StreamSource(xslSource);
                        continue;
                    }
                    xslSource = new InputStreamReader((InputStream)new FileInputStream(strXSLPath), NativeCharSet);
                    xslStream = new StreamSource(xslSource);
                    xslStream.setSystemId(strXSLPath);
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                continue;
            }
        }
        xmlSource = new StringReader(strXML);
        StringWriter outResult = new StringWriter();
        transformer.setOutputProperty("encoding", NativeCharSet);
        for (i = 1; i <= iMaxTry; ++i) {
            try {
                transformer.transform(new StreamSource(xmlSource), new StreamResult(outResult));
                break;
            }
            catch (Exception e) {
                if (i >= iMaxTry) {
                    try {
                        StringWriter out = new StringWriter();
                        e.printStackTrace(new PrintWriter(out));
                        strResult = strResult + "transform\u5931\u8d25\uff01\r\n" + out.toString();
                        System.out.print(" transform Error!\uff01" + i);
                        outResult.close();
                        if (xslSource != null) {
                            xslSource.close();
                        }
                        return strResult;
                    }
                    catch (Exception ex1) {
                        return strResult;
                    }
                }
                try {
                    if (outResult != null) {
                        outResult.close();
                    }
                    outResult = new StringWriter();
                    if (xmlSource != null) {
                        ((Reader)xmlSource).close();
                    }
                    xmlSource = new StringReader(strXML);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            strResult = outResult.toString();
            if (xslSource != null) {
                xslSource.close();
            }
            outResult.close();
            ((Reader)xmlSource).close();
        }
        catch (Exception e) {
            strErrorMsg = "Error: " + e.getMessage();
            log.error("Error: " + e.getMessage(), (Throwable)e);
            try {
                if (xslSource != null) {
                    xslSource.close();
                }
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter(out));
                strResult = strResult + out.toString();
                outResult.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strResult;
    }

    public static String XMLToHtml(String strXML, String strXSLPath) {
        return XMLUtil.XMLToHtml(strXML, strXSLPath, false);
    }

    public static String ProcXMLRequest(HttpServletRequest request, HttpServletResponse response, String strXMLData, String strName, String strdefaultxslPath, String strdefaultxslFile) {
        return XMLUtil.ProcXMLRequest(request, response, strXMLData, strName, strdefaultxslPath, strdefaultxslFile, false);
    }

    public static String ProcXMLRequest(HttpServletRequest request, HttpServletResponse response, String strXMLData, String strName, String strdefaultxslPath, String strdefaultxslFile, boolean bAllowAllxsl) {
        String strXML = XMLUtil.MakeXMLData(request, strXMLData, strName, strdefaultxslPath, bAllowAllxsl);
        try {
            PrintWriter out = response.getWriter();
            if ("true".equals(request.getParameter("showXML"))) {
                response.setContentType("text/xml; charset=" + NativeCharSet);
                out.print(strXML);
            } else {
                response.setContentType("text/html; charset=" + NativeCharSet);
                String strXSLPath = request.getParameter("xslPath");
                if (strXSLPath == null || strXSLPath.length() == 0) {
                    strXSLPath = strdefaultxslFile;
                } else if (strXSLPath.charAt(0) != '.') {
                    String userID = request.getParameter("id");
                    if ("$DEFAULT".equals(strXSLPath.substring(0, 8)) && strdefaultxslFile != null) {
                        int lastCh = strdefaultxslFile.lastIndexOf(47);
                        if (lastCh < 0) {
                            lastCh = strdefaultxslFile.lastIndexOf(92);
                        }
                        String strNew = lastCh > 0 ? strdefaultxslFile.substring(0, lastCh + 1) : "";
                        strNew = strXSLPath.length() > 8 && (strXSLPath.charAt(8) == '/' || strXSLPath.charAt(8) == '\\') ? strNew + strXSLPath.substring(9) : strNew + strXSLPath.substring(8);
                        strXSLPath = strNew;
                    } else {
                        strXSLPath = userID != null && userID.length() > 0 && strXSLPath.length() > 5 ? ("$HOME".equals(strXSLPath.substring(0, 5)) ? "/home/" + userID + strXSLPath.substring(5) : "/" + strXSLPath) : "/" + strXSLPath;
                    }
                }
                String strResult = XMLUtil.XMLToHtml(strXML, strXSLPath, false);
                out.print(strResult);
            }
        }
        catch (Exception e) {
            log.error("Error: " + e.getMessage(), (Throwable)e);
            StringWriter MsgOut = new StringWriter();
            e.printStackTrace(new PrintWriter(MsgOut));
            strErrorMsg = MsgOut.toString();
            return MsgOut.toString();
        }
        return null;
    }

    public static String ProcXMLRequest(HttpServletRequest request, HttpServletResponse response, String strXMLData, String strName, String strdefaultxslPath, String strdefaultxslFile, int iConvert) {
        String strXML = XMLUtil.MakeXMLData(request, strXMLData, strName, strdefaultxslPath);
        log.debug("ProcXMLRequest now");
        try {
            PrintWriter out = response.getWriter();
            if ("true".equals(request.getParameter("showXML"))) {
                response.setContentType("text/xml; charset=" + NativeCharSet);
                out.print(strXML);
            } else {
                response.setContentType("text/html; charset=" + NativeCharSet);
                String strXSLPath = request.getParameter("xslPath");
                if (strXSLPath == null || strXSLPath.length() == 0) {
                    strXSLPath = strdefaultxslFile;
                } else if (strXSLPath.charAt(0) != '.') {
                    String userID = request.getParameter("id");
                    if ("$DEFAULT".equals(strXSLPath.substring(0, 8)) && strdefaultxslFile != null) {
                        int lastCh = strdefaultxslFile.lastIndexOf(47);
                        if (lastCh < 0) {
                            lastCh = strdefaultxslFile.lastIndexOf(92);
                        }
                        String strNew = lastCh > 0 ? strdefaultxslFile.substring(0, lastCh + 1) : "";
                        strNew = strXSLPath.length() > 8 && (strXSLPath.charAt(8) == '/' || strXSLPath.charAt(8) == '\\') ? strNew + strXSLPath.substring(9) : strNew + strXSLPath.substring(8);
                        strXSLPath = strNew;
                    } else {
                        strXSLPath = userID != null && userID.length() > 0 && strXSLPath.length() > 5 ? ("$HOME".equals(strXSLPath.substring(0, 5)) ? "/home/" + userID + strXSLPath.substring(5) : "/" + strXSLPath) : "/" + strXSLPath;
                    }
                }
                String strResult = XMLUtil.XMLToHtml(strXML, strXSLPath, false);
                switch (iConvert) {
                    case 1: {
                        out.print(XMLUtil.ConvertData1(strResult));
                        break;
                    }
                    default: {
                        out.print(strResult);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error: " + e.getMessage(), (Throwable)e);
            StringWriter MsgOut = new StringWriter();
            e.printStackTrace(new PrintWriter(MsgOut));
            strErrorMsg = MsgOut.toString();
            return MsgOut.toString();
        }
        return null;
    }

    public static String MakeXMLData(HttpServletRequest request, String strXMLData, String strName, String strdefaultxslPath) {
        return XMLUtil.MakeXMLData(request, strXMLData, strName, strdefaultxslPath, false);
    }

    public static String MakeXMLData(HttpServletRequest request, String strXMLData, String strName, String strdefaultxslPath, boolean bAllowAllxsl) {
        String xslPath = request.getParameter("xslPath");
        String userID = request.getParameter("id");
        String strResult = "<?xml version=\"1.0\" encoding=\"" + NativeCharSet + "\" ?>\r\n";
        if (xslPath == null || xslPath.length() == 0) {
            if (!"T".equals(userID)) {
                strResult = strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"" + strdefaultxslPath + "\"?>\r\n";
            }
        } else if ("$DEFAULT".equals(xslPath.substring(0, 8)) && strdefaultxslPath != null) {
            int lastCh = strdefaultxslPath.lastIndexOf(47);
            if (lastCh < 0) {
                lastCh = strdefaultxslPath.lastIndexOf(92);
            }
            String strNew = lastCh > 0 ? strdefaultxslPath.substring(0, lastCh + 1) : "";
            strNew = xslPath.length() > 8 && (xslPath.charAt(8) == '/' || xslPath.charAt(8) == '\\') ? strNew + xslPath.substring(9) : strNew + xslPath.substring(8);
            xslPath = strNew;
            strResult = strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"" + xslPath + "\"?>\r\n";
        } else {
            strResult = userID != null && userID.length() > 0 && xslPath.length() > 5 && !bAllowAllxsl ? ("$HOME".equals(xslPath.substring(0, 5)) ? strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"/home/" + userID + xslPath.substring(5) + "\"?>\r\n" : strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"/" + xslPath + "\"?>\r\n") : (bAllowAllxsl ? strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"" + xslPath + "\"?>\r\n" : strResult + "<?xml-stylesheet type=\"text/xsl\" href=\"/" + xslPath + "\"?>\r\n");
        }
        strResult = strResult + "<" + Util.XMLEncode(strName) + ">\r\n";
        strResult = strResult + "<Query>\r\n";
        strResult = strResult + "<Refrence>" + Util.XMLEncode(request.getHeader("Referer")) + "</Refrence>\r\n";
        strResult = strResult + "<User-Agent>" + Util.XMLEncode(request.getHeader("User-Agent")) + "</User-Agent>\r\n";
        strResult = strResult + "<IP>" + request.getRemoteAddr() + "</IP>\r\n";
        String servletPath = request.getServerPort() != 80 ? "http://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath() : "http://" + request.getServerName() + request.getServletPath();
        strResult = strResult + "<ServletPath>" + Util.XMLEncode(servletPath) + "</ServletPath>\r\n";
        strResult = strResult + "\r\n<Parameter>\r\n";
        Enumeration ParEnu = request.getParameterNames();
        while (ParEnu.hasMoreElements()) {
            String ParameterName = String.valueOf(ParEnu.nextElement());
            if (ParameterName == null || ParameterName.length() <= 0) continue;
            String[] ParameterValueArray = request.getParameterValues(ParameterName);
            if (ParameterValueArray != null) {
                for (int i = 0; i < ParameterValueArray.length; ++i) {
                    strResult = strResult + "<" + Util.XMLEncode(ParameterName) + ">" + Util.XMLEncode(ParameterValueArray[i]) + "</" + Util.XMLEncode(ParameterName) + ">\r\n";
                }
                continue;
            }
            String ParameterValue = request.getParameter(ParameterName);
            if (ParameterValue == null) continue;
            strResult = strResult + "<" + Util.XMLEncode(ParameterName) + ">" + Util.XMLEncode(ParameterValue) + "</" + Util.XMLEncode(ParameterName) + ">\r\n";
        }
        strResult = strResult + "</Parameter>\r\n";
        strResult = strResult + "</Query>\r\n\r\n";
        strResult = strResult + strXMLData + "</" + Util.XMLEncode(strName) + ">";
        return strResult;
    }

    public static String ConvertData1(String strData) {
        int i;
        if (strData == null) {
            return null;
        }
        int oLength = "&lt;".length();
        char[] line2 = strData.toCharArray();
        StringBuffer buf = new StringBuffer(line2.length);
        int iLength = line2.length - oLength;
        for (i = 0; i <= iLength; ++i) {
            if (line2[i] == '&' && line2[i + 2] == 't' && line2[i + 3] == ';') {
                if (line2[i + 1] == 'l') {
                    buf.append('<');
                    i += oLength - 1;
                    continue;
                }
                if (line2[i + 1] == 'g') {
                    buf.append('>');
                    i += oLength - 1;
                    continue;
                }
            }
            buf.append(line2[i]);
        }
        log.debug("iLength=" + iLength + "  i=" + i);
        log.debug("iLength=" + (iLength += oLength));
        if (i < iLength) {
            buf.append(line2, i, iLength - i);
        }
        return buf.toString();
    }

    static {
        System.err.println("XSL File NativeCharSet=" + NativeCharSet);
    }
}

