/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.model.util.Globals;
import com.hynnet.util.FileOperation;
import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import com.hynnet.util.Util;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProperties
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.XMLProperties");
    protected String m_strErrorMessage;
    private static final String SPLIT_ATTRIBUTE = "@";
    private static final String SPLIT_VALUE = "=";
    private File m_objFileDoc;
    private String m_strFileName;
    private Document m_docXML;
    private Map<String, String> m_propertyCache = new HashMap<String, String>();
    private Map<String, StringList> m_allPropertyCache = new HashMap<String, StringList>();
    private Map<String, String> m_attributeCache = new HashMap<String, String>();
    private boolean m_isFile = true;
    private boolean m_isDoc = true;
    private boolean m_isChange = false;
    private String m_defaultPath = null;
    private boolean m_isAutoBackup = true;
    private SimpleDateFormat m_backupExtFormater = null;
    private static HashMap<XMLProperties, XMLProperties> g_tasks = new HashMap();
    public static final String BACKUP_FILE_EXT = ".backup";

    public XMLProperties() {
        this((String)null, (String)null);
    }

    public XMLProperties(boolean bAutoBackup) {
        this();
        this.m_isAutoBackup = bAutoBackup;
    }

    public XMLProperties(boolean bAutoBackup, String strBackupExtTimeFormater) {
        this();
        this.m_isAutoBackup = bAutoBackup;
        this.m_backupExtFormater = new SimpleDateFormat("." + strBackupExtTimeFormater, Globals.getLocale());
    }

    public XMLProperties(byte[] datas) {
        if (!this.load(datas)) {
            this.m_isDoc = false;
            this.m_isFile = false;
            this.m_isChange = false;
            this.m_isAutoBackup = false;
        }
    }

    public XMLProperties(InputStream stream) {
        this(stream, null, null);
    }

    public XMLProperties(InputStream stream, EntityResolver resolver, String resourcePath) {
        if (!this.load(stream, resolver, resourcePath)) {
            this.m_isDoc = false;
            this.m_isFile = false;
            this.m_isChange = false;
            this.m_isAutoBackup = false;
        }
    }

    public XMLProperties(String strFile) {
        this.m_isDoc = false;
        if (strFile != null && strFile.length() > 0) {
            this.m_objFileDoc = new File(strFile);
            this.m_strFileName = this.m_objFileDoc.getAbsolutePath();
            if (!this.m_objFileDoc.exists() && new File(this.m_strFileName + BACKUP_FILE_EXT).exists()) {
                new FileOperation().copyFile(this.m_strFileName + BACKUP_FILE_EXT, this.m_strFileName);
            }
            if (this.m_objFileDoc.exists()) {
                File objBackupFile = new File(this.m_strFileName + BACKUP_FILE_EXT);
                if (this.loadXMLFile()) {
                    if (!objBackupFile.exists() || objBackupFile.lastModified() != this.m_objFileDoc.lastModified()) {
                        new FileOperation().copyFile(this.m_strFileName, objBackupFile.getAbsolutePath());
                    }
                } else if (objBackupFile.exists()) {
                    new FileOperation().copyFile(objBackupFile.getAbsolutePath(), this.m_strFileName);
                    this.loadXMLFile();
                }
            } else {
                this.m_strErrorMessage = "\u52a0\u8f7d\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + this.m_strFileName;
                System.err.println(this.m_strErrorMessage);
                log.error(this.m_strErrorMessage);
            }
        }
        if (!this.m_isDoc) {
            System.err.println("XML\u5c5e\u6027\u6587\u4ef6 " + strFile + " \u9519\u8bef\uff01\u65e0\u6cd5\u6b63\u786e\u88c5\u8f7d\u3002");
            this.m_isDoc = false;
            try {
                if (this.m_docXML == null) {
                    this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><B2C></B2C>".getBytes()));
                }
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u7a7a\u6587\u6863\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public XMLProperties(String strFile, boolean bAutoBackup) {
        this(strFile);
        this.m_isAutoBackup = bAutoBackup;
    }

    public XMLProperties(String strFile, boolean bAutoBackup, String strBackupExtTimeFormater) {
        this(strFile);
        this.m_isAutoBackup = bAutoBackup;
        this.m_backupExtFormater = new SimpleDateFormat("." + strBackupExtTimeFormater, Globals.getLocale());
    }

    public XMLProperties(String strIn, String strDefaultEncoding) {
        if (!this.load(strIn, strDefaultEncoding)) {
            this.m_isDoc = false;
            this.m_isFile = false;
        }
        try {
            if (this.m_docXML == null) {
                this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><B2C></B2C>".getBytes()));
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7a7a\u6587\u6863\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public XMLProperties(String strIn, String strDefaultEncoding, boolean bAutoBackup) {
        this(strIn, strDefaultEncoding);
        this.m_isAutoBackup = bAutoBackup;
    }

    public XMLProperties(String strIn, String strDefaultEncoding, boolean bAutoBackup, String strBackupExtTimeFormater) {
        this(strIn, strDefaultEncoding);
        this.m_isAutoBackup = bAutoBackup;
        this.m_backupExtFormater = new SimpleDateFormat("." + strBackupExtTimeFormater, Globals.getLocale());
    }

    public static XMLProperties fromStream(InputStream objStream) {
        if (objStream != null) {
            XMLProperties objXML = new XMLProperties(objStream);
            return objXML.isLoad() ? objXML : null;
        }
        return null;
    }

    public static XMLProperties fromString(String strData) {
        if (strData != null) {
            XMLProperties objXML = new XMLProperties(strData, "UTF-8");
            return objXML.isLoad() ? objXML : null;
        }
        return null;
    }

    public static XMLProperties fromString(String strData, String charsetName) {
        if (strData != null) {
            XMLProperties objXML = new XMLProperties(strData, charsetName);
            return objXML.isLoad() ? objXML : null;
        }
        return null;
    }

    protected void finalize() {
        if (this.m_isChange) {
            this.save();
        }
    }

    public String getErrorMessage() {
        return this.m_strErrorMessage;
    }

    public String getFileName() {
        return this.m_strFileName;
    }

    public boolean setFileName(String strFileName) {
        if (strFileName == null || strFileName.length() <= 0) {
            return false;
        }
        File objFileNew = new File(strFileName);
        if (this.m_objFileDoc == null || !objFileNew.getAbsolutePath().equals(this.m_objFileDoc.getAbsolutePath())) {
            this.m_objFileDoc = objFileNew;
            this.m_strFileName = this.m_objFileDoc.getAbsolutePath();
            this.m_isChange = true;
        }
        return true;
    }

    public String getProperty(String namePath, boolean isAllowEmpty) {
        String res = this.getProperty(namePath);
        return res != null && res.length() > 0 ? res : (isAllowEmpty ? "" : null);
    }

    public boolean getPropertyBoolean(String pathName, boolean defaultValue) {
        String value = this.getProperty(pathName);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).compareToIgnoreCase("true") == 0 || value.compareToIgnoreCase("y") == 0 || value.compareToIgnoreCase("enable") == 0 || value.compareToIgnoreCase("success") == 0 || value.compareTo("1") == 0) {
            return true;
        }
        if (value.compareToIgnoreCase("false") == 0 || value.compareToIgnoreCase("n") == 0 || value.compareToIgnoreCase("disable") == 0 || value.compareToIgnoreCase("fail") == 0 || value.compareTo("0") == 0) {
            return false;
        }
        return defaultValue;
    }

    public double getPropertyDouble(String strPathName, double dbDefaultValue) {
        String strValue = this.getProperty(strPathName, false);
        if (strValue != null) {
            try {
                return Double.parseDouble(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dbDefaultValue;
    }

    public int getPropertyInt(String strPathName, int nDefaultValue) {
        String strValue = this.getProperty(strPathName, false);
        if (strValue != null) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nDefaultValue;
    }

    public long getPropertyLong(String strPathName, long lDefaultValue) {
        String strValue = this.getProperty(strPathName, false);
        if (strValue != null) {
            try {
                return Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lDefaultValue;
    }

    public long getPropertyTime(String strPathName) {
        String strValue = this.getProperty(strPathName, false);
        if (strValue != null && (strValue = strValue.trim()).length() > 0) {
            SimpleDateFormat objFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date objDate = objFormatter.parse(strValue);
                if (objDate == null) {
                    return 0L;
                }
                return objDate.getTime();
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public StringList findPropertyName(String strNamePath) {
        if (strNamePath == null || strNamePath.length() == 0) {
            return new StringList(0);
        }
        String strPathName = strNamePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (strNamePath.startsWith(".@") ? this.m_defaultPath + strNamePath.substring(1) : this.m_defaultPath + strNamePath) : strNamePath.substring(1)) : strNamePath;
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return new StringList(0);
        }
        String[] arrayPropName = XMLProperties.parsePropertyName(this.m_defaultPath, strPathName);
        Node objElement = this.m_docXML.getDocumentElement();
        Node[] arrayElement = this.getChildrenElementRegex(objElement, arrayPropName);
        if (arrayElement == null) {
            return new StringList(0);
        }
        StringList lstResult = new StringList(arrayElement.length);
        StringBuffer sbufNamePath = new StringBuffer();
        for (int n = 0; n < arrayElement.length; ++n) {
            sbufNamePath.delete(0, sbufNamePath.length());
            objElement = arrayElement[n];
            for (int i = arrayPropName.length - 1; i >= 0; --i) {
                String[] arrayName = arrayPropName[i].split(SPLIT_ATTRIBUTE);
                String[] arrayAttribute = arrayName != null && arrayName.length > 1 ? arrayName[1].split(SPLIT_VALUE) : null;
                if (sbufNamePath.length() > 0) {
                    sbufNamePath.insert(0, '.');
                }
                if (arrayAttribute != null) {
                    String strValue = XMLProperties.getAttributeValue(objElement, arrayAttribute[0]);
                    if (strValue != null) {
                        sbufNamePath.insert(0, strValue);
                    }
                    sbufNamePath.insert(0, '=');
                    sbufNamePath.insert(0, arrayAttribute[0]);
                    sbufNamePath.insert(0, '@');
                }
                sbufNamePath.insert(0, objElement.getNodeName());
                objElement = objElement.getParentNode();
            }
            lstResult.append(sbufNamePath);
        }
        return lstResult;
    }

    public StringList getAllProperty(String namePath) {
        if (namePath == null || namePath.length() == 0) {
            return new StringList(0);
        }
        String pathName = namePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (namePath.startsWith(".@") ? this.m_defaultPath + namePath.substring(1) : this.m_defaultPath + namePath) : namePath.substring(1)) : namePath;
        if (this.m_allPropertyCache.containsKey(pathName)) {
            return this.m_allPropertyCache.get(pathName);
        }
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return new StringList(0);
        }
        String[] propNames = XMLProperties.parsePropertyName(this.m_defaultPath, pathName);
        Element element = this.m_docXML.getDocumentElement();
        Node[] elements = XMLProperties.getChildrenElement(element, propNames, false);
        if (elements == null) {
            return new StringList(0);
        }
        StringList results = new StringList(elements.length);
        for (int n = 0; n < elements.length; ++n) {
            String value = XMLProperties.getText(elements[n]);
            if (value == null || value.length() == 0) continue;
            value = value.trim();
            results.add(value);
        }
        this.m_allPropertyCache.put(pathName, results);
        return results;
    }

    public final String getProperty(String namePath) {
        String res = null;
        if (namePath != null && namePath.length() > 0) {
            String curPathName = namePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (namePath.startsWith(".@") ? this.m_defaultPath + namePath.substring(1) : this.m_defaultPath + namePath) : namePath.substring(1)) : namePath;
            try {
                if (this.m_propertyCache.containsKey(curPathName)) {
                    res = this.m_propertyCache.get(curPathName);
                } else if (this.m_docXML == null) {
                    log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
                } else {
                    String[] propNames = XMLProperties.parsePropertyName(this.m_defaultPath, curPathName);
                    Node element = this.m_docXML.getDocumentElement();
                    if (element != null) {
                        element = this.getChildElement(element, propNames);
                    }
                    if (element != null) {
                        res = XMLProperties.getText(element);
                    }
                }
            }
            catch (Exception e) {
                Object[] objectArray = new Object[4];
                objectArray[0] = this.m_isFile ? (this.m_objFileDoc != null ? this.m_objFileDoc.getAbsolutePath() : this.m_strFileName) : this.m_docXML;
                objectArray[1] = namePath;
                objectArray[2] = e.getMessage();
                objectArray[3] = e;
                log.error("\u83b7\u53d6\uff1a{}\u7684\u5c5e\u6027\uff1a{}\u5f02\u5e38\uff1a{}", objectArray);
            }
            if (res != null && (res = res.trim()).length() > 0) {
                this.m_propertyCache.put(curPathName, res);
            }
        }
        return res;
    }

    public String[] getChildrenProperties(String strParentPath) {
        int n;
        if (strParentPath == null || strParentPath.length() == 0) {
            return null;
        }
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return null;
        }
        String[] arrayPropName = XMLProperties.parsePropertyName(this.m_defaultPath, strParentPath);
        Element objElement = this.m_docXML.getDocumentElement();
        for (n = 0; n < arrayPropName.length; ++n) {
            if (n < arrayPropName.length - 1) {
                if ((objElement = this.getChildElement(objElement, arrayPropName[n])) != null) continue;
                return new String[0];
            }
            Node[] arrayElement = XMLProperties.getChildrenElement(objElement, arrayPropName[n]);
            if (arrayElement == null || arrayElement.length <= 0) {
                return null;
            }
            String[] arrayChildrenNames = new String[arrayElement.length];
            for (int j = 0; j < arrayElement.length; ++j) {
                arrayChildrenNames[j] = arrayElement[j].getNodeName();
            }
            return arrayChildrenNames;
        }
        List<Node> lstChildren = XMLProperties.getChildren(objElement, null);
        int nChildCount = lstChildren.size();
        String[] arrayChildrenNames = new String[nChildCount];
        for (n = 0; n < nChildCount; ++n) {
            arrayChildrenNames[n] = ((Element)lstChildren.get(n)).getNodeName();
        }
        return arrayChildrenNames;
    }

    public void setProperty(String strPath, String strValue) {
        Element objElement;
        if (strPath == null || strPath.length() <= 0) {
            return;
        }
        if (strValue != null && strValue.equals(this.getProperty(strPath))) {
            this.m_strErrorMessage = "\u503c\u6ca1\u6709\u6539\u53d8\u3002";
            return;
        }
        String strPathName = strPath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (strPath.startsWith(".@") ? this.m_defaultPath + strPath.substring(1) : this.m_defaultPath + strPath) : strPath.substring(1)) : strPath;
        this.m_propertyCache.put(strPathName, strValue);
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return;
        }
        String[] arrayPropName = XMLProperties.parsePropertyName(this.m_defaultPath, strPathName);
        Element objNewElement = null;
        Node objLastNewElement = null;
        Element objChildElement = objElement = this.m_docXML.getDocumentElement();
        for (int i = 0; i < arrayPropName.length; ++i) {
            if (objChildElement != null) {
                objChildElement = this.getChildElement(objElement, arrayPropName[i]);
            }
            if (objChildElement == null) {
                String strName = arrayPropName[i];
                String[] arrayAttribute = null;
                String[] arrayName = strName.split(SPLIT_ATTRIBUTE);
                if (arrayName != null && arrayName.length > 1) {
                    arrayAttribute = arrayName[1].split(SPLIT_VALUE);
                    if (arrayAttribute == null || arrayAttribute.length <= 1) {
                        arrayAttribute = null;
                    } else {
                        strName = arrayName[0];
                    }
                }
                Element objNewChildElement = this.m_docXML.createElement(strName);
                if (objNewElement == null) {
                    objNewElement = objNewChildElement;
                    objLastNewElement = objNewElement;
                } else {
                    objLastNewElement.appendChild(objNewChildElement);
                    objLastNewElement = objNewChildElement;
                }
                if (objNewChildElement != null && arrayName != null && arrayAttribute != null) {
                    objNewChildElement.setAttribute(arrayAttribute[0], arrayAttribute[1]);
                }
            }
            if (objChildElement == null) continue;
            objElement = objChildElement;
        }
        if (objNewElement != null) {
            XMLProperties.setText(objLastNewElement, strValue);
            objElement.appendChild(objNewElement);
        } else {
            XMLProperties.setText(objElement, strValue);
        }
        this.m_isChange = true;
        this.m_allPropertyCache.clear();
    }

    public void setProperty(String strPath, boolean value) {
        this.setProperty(strPath, String.valueOf(value));
    }

    public void setProperty(String strPath, double value) {
        this.setProperty(strPath, String.valueOf(value));
    }

    public void setProperty(String strPath, int value) {
        this.setProperty(strPath, String.valueOf(value));
    }

    public void setProperty(String strPath, long value) {
        this.setProperty(strPath, String.valueOf(value));
    }

    public void setPropertyTime(String strPath, long lTimeValue) {
        if (lTimeValue > 0L) {
            SimpleDateFormat objFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setProperty(strPath, objFormatter.format(new Date(lTimeValue)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteProperty(String strPath) {
        if (strPath == null || strPath.length() <= 0) {
            return false;
        }
        String strPathName = strPath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (strPath.startsWith(".@") ? this.m_defaultPath + strPath.substring(1) : this.m_defaultPath + strPath) : strPath.substring(1)) : strPath;
        String[] arrayPath = this.m_propertyCache.keySet().toArray(new String[0]);
        for (int n = 0; arrayPath != null && n < arrayPath.length; ++n) {
            if (arrayPath[n] == null || !arrayPath[n].startsWith(strPathName)) continue;
            this.m_propertyCache.remove(arrayPath[n]);
        }
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return false;
        }
        String[] arrayPropName = XMLProperties.parsePropertyName(this.m_defaultPath, strPathName);
        Element objElement = this.m_docXML.getDocumentElement();
        for (int i = 0; i < arrayPropName.length - 1; ++i) {
            if ((objElement = this.getChildElement(objElement, arrayPropName[i])) != null) continue;
            return false;
        }
        String strName = arrayPropName[arrayPropName.length - 1];
        String[] arrayAttribute = null;
        String[] arrayName = strName.split(SPLIT_ATTRIBUTE);
        if (arrayName != null && arrayName.length > 1) {
            arrayAttribute = arrayName[1].split(SPLIT_VALUE);
            if (arrayAttribute == null || arrayAttribute.length <= 1) {
                arrayAttribute = null;
                this.removeChild(objElement, arrayName[0]);
            } else {
                int n;
                List<Node> lstElement = XMLProperties.getChildren(objElement, arrayName[0]);
                if (lstElement == null) return false;
                for (n = 0; n < lstElement.size(); ++n) {
                    String strValue;
                    Node objChildElement = lstElement.get(n);
                    if (objChildElement == null || !arrayAttribute[1].equals(strValue = XMLProperties.getAttributeValue(objChildElement, arrayAttribute[0]))) continue;
                    objElement.removeChild(objChildElement);
                    break;
                }
                if (n >= lstElement.size()) {
                    return false;
                }
            }
        } else {
            this.removeChild(objElement, strName);
        }
        this.m_isChange = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean save() {
        if (this.m_strFileName == null || this.m_strFileName.length() <= 0 || !this.m_isChange) {
            if (log.isDebugEnabled() && this.m_strFileName != null) {
                log.debug("XML\u6587\u4ef6\uff1a{}\u6ca1\u6709\u6539\u53d8", (Object)this.m_strFileName);
            }
            return true;
        }
        OutputStream objOut = null;
        boolean bHasError = false;
        FileOperation objFileOp = new FileOperation();
        FileOutputStream objStream = null;
        FileLock objLock = null;
        HashMap<XMLProperties, XMLProperties> hashMap = g_tasks;
        synchronized (hashMap) {
            g_tasks.put(this, this);
        }
        try {
            if ((this.m_isAutoBackup || !this.isLoad()) && this.m_objFileDoc.exists() && this.m_objFileDoc.length() > 0L) {
                if (this.m_backupExtFormater == null) {
                    this.m_backupExtFormater = new SimpleDateFormat(".yyyy-MM-dd", Globals.getLocale());
                }
                String strBackupFile = this.m_objFileDoc.getAbsolutePath() + this.m_backupExtFormater.format(new Date(this.m_objFileDoc.lastModified()));
                File objBackupFile = new File(strBackupFile);
                if (!this.isLoad() && objBackupFile.exists()) {
                    objBackupFile = new File(strBackupFile + "." + new SimpleDateFormat("MM-dd hh_mm_ss_S").format(new Date(System.currentTimeMillis())));
                }
                if (!objBackupFile.exists() && !this.m_objFileDoc.renameTo(objBackupFile)) {
                    objFileOp.copyFile(this.m_objFileDoc.getAbsolutePath(), strBackupFile);
                }
                objBackupFile = null;
            }
            if (this.m_objFileDoc.getParentFile() != null && !this.m_objFileDoc.getParentFile().exists()) {
                objFileOp.createDir(this.m_objFileDoc.getAbsolutePath());
            }
            String strTmpFile = this.m_objFileDoc.getAbsolutePath() + ".tmp";
            objStream = new FileOutputStream(strTmpFile);
            FileChannel objChannel = objStream.getChannel();
            while ((objLock = objChannel.tryLock()) == null || !objLock.isValid()) {
                log.info("\u5199XML\u6587\u4ef6\u65f6\u6709\u5176\u4ed6\u7ebf\u7a0b\uff0c\u7b49\u5f85\u534a\u79d2:" + strTmpFile);
                Thread.sleep(500L);
            }
            TransformerFactory objFactory = TransformerFactory.newInstance();
            try {
                objFactory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception strBackupFile) {
                // empty catch block
            }
            Transformer objFormer = objFactory.newTransformer();
            DOMSource objSource = new DOMSource(this.m_docXML);
            StreamResult objResult = new StreamResult(new BufferedWriter(new OutputStreamWriter((OutputStream)objStream, this.m_docXML.getXmlEncoding())));
            objFormer.setOutputProperty("indent", "yes");
            objFormer.transform(objSource, objResult);
            objStream.close();
            objStream = null;
            objFileOp.copyFile(strTmpFile, this.m_objFileDoc.getAbsolutePath() + BACKUP_FILE_EXT);
            if (this.m_objFileDoc.exists()) {
                this.m_objFileDoc.delete();
            }
            boolean bl = bHasError = !objFileOp.rename(this.m_objFileDoc.getAbsolutePath(), strTmpFile);
            if (bHasError) {
                bHasError = !objFileOp.moveFile(strTmpFile, this.m_objFileDoc.getAbsolutePath());
            }
        }
        catch (NoClassDefFoundError eClass) {
            log.error("\u7f3a\u5c11\u76f8\u5173JAR\u5305\uff0c\u65e0\u6cd5\u52a0\u8f7d\u7c7b\uff1a{}", (Object)eClass.getMessage());
            bHasError = true;
        }
        catch (TransformerException e) {
            log.error("XML\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            bHasError = true;
        }
        catch (AbstractMethodError e) {
            log.error("\u7f3a\u5c11dom\u76f8\u5173jar\uff1a" + e.getMessage(), (Throwable)e);
            bHasError = true;
        }
        catch (OverlappingFileLockException e) {
            log.error("\u5199\u6587\u4ef6" + this.m_strFileName + "\u9501\u51b2\u7a81\uff1a" + e.getMessage(), (Throwable)e);
            bHasError = true;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5f02\u5e38\u3002" + this.m_objFileDoc + " : " + e.getMessage(), (Throwable)e);
            bHasError = true;
        }
        finally {
            try {
                if (objOut != null) {
                    objOut.close();
                }
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                bHasError = true;
            }
            if (objStream != null) {
                try {
                    objStream.close();
                }
                catch (Exception e) {}
            }
        }
        if (!bHasError) {
            this.m_isFile = true;
            this.m_isDoc = true;
        }
        if (objLock != null) {
            try {
                objLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_isChange = false;
        hashMap = g_tasks;
        synchronized (hashMap) {
            g_tasks.remove(this);
        }
        return !bHasError;
    }

    private static String[] parsePropertyName(String defaultPath, String strPath) {
        if (strPath == null) {
            return new String[0];
        }
        String strPathName = strPath.startsWith(".") ? (defaultPath != null && defaultPath.length() > 0 ? (strPath.startsWith(".@") ? defaultPath + strPath.substring(1) : defaultPath + strPath) : strPath.substring(1)) : strPath;
        StringList lstNamePath = new StringList();
        StringTokenizer objToken = new StringTokenizer(strPathName, ".");
        while (objToken.hasMoreTokens()) {
            String strValue = objToken.nextToken();
            if (strValue == null || strValue.length() <= 0) continue;
            lstNamePath.add(strValue);
        }
        return lstNamePath.toStringArray();
    }

    public String getAttribute(String namePath, boolean isAllowEmpty) {
        String res;
        block6: {
            res = null;
            try {
                int n;
                if (namePath == null || namePath.length() <= 0) break block6;
                String pathName = namePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (namePath.startsWith(".@") ? this.m_defaultPath + namePath.substring(1) : this.m_defaultPath + namePath) : namePath.substring(1)) : namePath;
                if (this.m_attributeCache.containsKey(pathName)) {
                    res = this.m_attributeCache.get(pathName);
                    break block6;
                }
                String[] allNames = XMLProperties.parsePropertyName(this.m_defaultPath, pathName);
                if (allNames == null) {
                    log.debug("\u65e0\u6b64\u5c5e\u6027" + pathName);
                    break block6;
                }
                String[] propNames = new String[allNames.length - 1];
                for (n = 0; n < propNames.length; ++n) {
                    propNames[n] = allNames[n];
                }
                Element element = this.m_docXML.getDocumentElement();
                Node[] elements = XMLProperties.getChildrenElement(element, propNames, false);
                if (elements == null || elements.length <= 0) break block6;
                for (n = 0; n < elements.length; ++n) {
                    res = XMLProperties.getAttributeValue(elements[n], allNames[allNames.length - 1]);
                    if (res == null || !isAllowEmpty && (res = res.trim()).length() == 0) continue;
                    this.m_attributeCache.put(pathName, res);
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("getAttribute \u5931\u8d25\uff01");
                log.error("\u53d6\u5c5e\u6027\u5f02\u5e38" + namePath, (Throwable)e);
            }
        }
        return res != null && res.length() > 0 ? res : (isAllowEmpty ? "" : null);
    }

    public boolean getAttributeBoolean(String strPathName, boolean bDefaultValue) {
        String strValue = this.getAttribute(strPathName);
        if (strValue == null) {
            return bDefaultValue;
        }
        return strValue.compareToIgnoreCase("true") == 0 || strValue.compareTo("1") == 0;
    }

    public double getAttributeDouble(String strPathName, double dbDefaultValue) {
        String strValue = this.getAttribute(strPathName, false);
        if (strValue != null) {
            try {
                return Double.parseDouble(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dbDefaultValue;
    }

    public int getAttributeInt(String strPathName, int nDefaultValue) {
        String strValue = this.getAttribute(strPathName, false);
        if (strValue != null) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nDefaultValue;
    }

    public long getAttributeLong(String strPathName, long lDefaultValue) {
        String strValue = this.getAttribute(strPathName, false);
        if (strValue != null) {
            try {
                return Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lDefaultValue;
    }

    public String getAttribute(String namePath) {
        String res;
        block6: {
            res = null;
            try {
                int n;
                if (namePath == null || namePath.length() <= 0) break block6;
                String pathName = namePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (namePath.startsWith(".@") ? this.m_defaultPath + namePath.substring(1) : this.m_defaultPath + namePath) : namePath.substring(1)) : namePath;
                if (this.m_attributeCache.containsKey(pathName)) {
                    res = this.m_attributeCache.get(pathName);
                    break block6;
                }
                String[] allNames = XMLProperties.parsePropertyName(this.m_defaultPath, pathName);
                if (allNames == null) {
                    log.debug("\u65e0\u6b64\u5c5e\u6027" + pathName);
                    break block6;
                }
                String[] propNames = new String[allNames.length - 1];
                for (n = 0; n < propNames.length; ++n) {
                    propNames[n] = allNames[n];
                }
                Element element = this.m_docXML.getDocumentElement();
                Node[] elements = XMLProperties.getChildrenElement(element, propNames, false);
                if (elements == null || elements.length <= 0) break block6;
                for (n = 0; n < elements.length; ++n) {
                    String val = XMLProperties.getAttributeValue(elements[n], allNames[allNames.length - 1]);
                    if (val == null || (res = val.trim()).length() == 0) continue;
                    this.m_attributeCache.put(pathName, res);
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("getAttribute \u5931\u8d25\uff01");
                log.error("\u53d6\u5c5e\u6027\u5f02\u5e38" + namePath, (Throwable)e);
            }
        }
        return res;
    }

    public void setAttribute(String name, boolean value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, double value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String name, long value) {
        this.setAttribute(name, String.valueOf(value));
    }

    public void setAttribute(String strPath, String value) {
        if (strPath == null || strPath.length() <= 0) {
            return;
        }
        if (value != null && value.equals(this.getAttribute(strPath))) {
            this.m_strErrorMessage = "\u503c\u6ca1\u6709\u6539\u53d8\u3002";
            return;
        }
        String strPathName = strPath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (strPath.startsWith(".@") ? this.m_defaultPath + strPath.substring(1) : this.m_defaultPath + strPath) : strPath.substring(1)) : strPath;
        this.m_attributeCache.put(strPathName, value);
        String[] arrayPropName = XMLProperties.parsePropertyName(this.m_defaultPath, strPathName);
        Element objElement = this.m_docXML.getDocumentElement();
        for (int n = 0; n < arrayPropName.length - 1; ++n) {
            Element objChildElement = this.getChildElement(objElement, arrayPropName[n]);
            if (objChildElement == null) {
                String strName = arrayPropName[n];
                String[] arrayName = null;
                String[] arrayAttribute = null;
                arrayName = strName.split(SPLIT_ATTRIBUTE);
                if (arrayName != null && arrayName.length > 1) {
                    arrayAttribute = arrayName[1].split(SPLIT_VALUE);
                    if (arrayAttribute == null || arrayAttribute.length <= 1) {
                        arrayAttribute = null;
                    } else {
                        strName = arrayName[0];
                    }
                }
                objChildElement = this.m_docXML.createElement(strName);
                objElement.appendChild(objChildElement);
                if (objChildElement != null && arrayName != null && arrayAttribute != null) {
                    objChildElement.setAttribute(arrayAttribute[0], arrayAttribute[1]);
                }
            }
            objElement = objChildElement;
        }
        objElement.setAttribute(arrayPropName[arrayPropName.length - 1], value);
        this.m_isChange = true;
    }

    public StringList getAllAttribute(String path, String attrName) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        String pathName = path.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (path.startsWith(".@") ? this.m_defaultPath + path.substring(1) : this.m_defaultPath + path) : path.substring(1)) : path;
        StringList values = new StringList();
        String[] allNames = XMLProperties.parsePropertyName(this.m_defaultPath, pathName);
        String compareAttr = null;
        String compareValue = null;
        Node childElement = null;
        if (allNames == null || allNames.length <= 0) {
            return values;
        }
        Element element = this.m_docXML.getDocumentElement();
        Node[] elements = XMLProperties.getChildrenElement(element, allNames, false);
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                childElement = elements[n];
                if (childElement == null || compareAttr != null && compareValue != null && !compareValue.equals(XMLProperties.getAttributeValue(childElement, compareAttr))) continue;
                values.add(XMLProperties.getAttributeValue(childElement, attrName));
            }
        }
        return values;
    }

    private Element getChildElement(Element objElement, String strName) {
        Element objChildElement = null;
        String[] arrayAttribute = null;
        if (objElement == null || strName == null) {
            return null;
        }
        String[] arrayName = strName.split(SPLIT_ATTRIBUTE);
        if (arrayName != null && arrayName.length > 1 && ((arrayAttribute = arrayName[1].split(SPLIT_VALUE)) == null || arrayAttribute.length <= 1)) {
            arrayAttribute = null;
        }
        if (arrayName == null || arrayAttribute == null) {
            List<Node> lstChild = XMLProperties.getChildren(objElement, strName);
            objChildElement = lstChild.size() > 0 ? (Element)lstChild.get(0) : null;
        } else {
            List<Node> lstElement = XMLProperties.getChildren(objElement, arrayName[0]);
            if (lstElement != null) {
                for (int n = 0; n < lstElement.size(); ++n) {
                    objChildElement = (Element)lstElement.get(n);
                    if (objChildElement == null) continue;
                    String strValue = XMLProperties.getAttributeValue(objChildElement, arrayAttribute[0]);
                    if (!arrayAttribute[1].equals(strValue)) {
                        objChildElement = null;
                        continue;
                    }
                    break;
                }
            } else {
                objChildElement = null;
            }
        }
        return objChildElement;
    }

    private static Node[] getMatchChildElement(Node element, String name) {
        List<Node> lstElement;
        String[] arrayAttribute = null;
        if (element == null || name == null) {
            return null;
        }
        String[] arrayName = name.split(SPLIT_ATTRIBUTE);
        if (arrayName != null && arrayName.length > 1 && ((arrayAttribute = arrayName[1].split(SPLIT_VALUE)) == null || arrayAttribute.length <= 1)) {
            arrayAttribute = null;
        }
        if (arrayName == null) {
            arrayName = new String[]{name};
        }
        if ((lstElement = XMLProperties.getChildren(element, arrayName[0])) != null) {
            if (arrayAttribute == null) {
                return lstElement.toArray(new Node[0]);
            }
            ArrayList<Node> lstResult = new ArrayList<Node>();
            for (int n = 0; n < lstElement.size(); ++n) {
                Node objChildElement;
                Node objChild = lstElement.get(n);
                if (!(objChild instanceof Node) || !arrayAttribute[1].equals(XMLProperties.getAttributeValue(objChildElement = objChild, arrayAttribute[0]))) continue;
                lstResult.add(objChildElement);
            }
            return lstResult.toArray(new Node[0]);
        }
        return new Node[0];
    }

    private Node[] getMatchChildElementRegex(Node objElement, String strName) {
        List<Node> lstElement;
        String[] arrayName;
        String[] arrayAttribute = null;
        if (objElement == null || strName == null) {
            return null;
        }
        if (strName.trim().length() > 0) {
            arrayName = strName.split(SPLIT_ATTRIBUTE);
            if (arrayName != null && arrayName.length > 1) {
                arrayAttribute = arrayName[1].split(SPLIT_VALUE);
                if (arrayAttribute == null || arrayAttribute.length == 0) {
                    arrayAttribute = null;
                } else if (arrayAttribute.length == 1) {
                    String[] arrayNewAttr = new String[]{arrayAttribute[0], ".*"};
                    arrayAttribute = arrayNewAttr;
                } else if (arrayAttribute[1].indexOf(42) >= 0) {
                    arrayAttribute[1] = StringUtils.replace(arrayAttribute[1], "*", ".*");
                }
            }
            if (arrayName == null) {
                arrayName = new String[]{strName};
            }
        } else {
            arrayName = null;
        }
        if ((lstElement = XMLProperties.getChildren(objElement, null)) != null) {
            if (arrayName == null && arrayAttribute == null) {
                int nLen = lstElement.size();
                Node[] arrayResult = new Element[nLen];
                for (int n = 0; n < nLen; ++n) {
                    arrayResult[n] = (Element)lstElement.get(n);
                }
                return arrayResult;
            }
            ArrayList<Element> lstResult = new ArrayList<Element>();
            int nLen = lstElement.size();
            for (int n = 0; n < nLen; ++n) {
                String strValue;
                Element objChildElement;
                Node objChild = lstElement.get(n);
                if (!(objChild instanceof Element) || !(objChildElement = (Element)objChild).getNodeName().matches(arrayName[0]) || arrayAttribute != null && ((strValue = XMLProperties.getAttributeValue(objChildElement, arrayAttribute[0])) == null || !strValue.matches(arrayAttribute[1]))) continue;
                lstResult.add(objChildElement);
            }
            return lstResult.toArray(new Element[0]);
        }
        return new Element[0];
    }

    private Node getChildElement(Node element, String[] names) {
        int n;
        Node[] childrens = XMLProperties.getMatchChildElement(element, names[0]);
        if (names.length == 1 || childrens == null) {
            if (childrens != null && childrens.length > 0) {
                return childrens[0];
            }
            return null;
        }
        String[] childNames = new String[names.length - 1];
        for (n = 0; n < childNames.length; ++n) {
            childNames[n] = names[n + 1];
        }
        for (n = 0; n < childrens.length; ++n) {
            Node child = this.getChildElement(childrens[n], childNames);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private static Node[] getChildrenElement(Node objElement, String strName) {
        ArrayList<Element> lstAllChildren;
        block7: {
            String[] arrayName;
            String[] arrayAttribute;
            Element objChildElement;
            block6: {
                objChildElement = null;
                arrayAttribute = null;
                if (objElement == null || strName == null) {
                    return null;
                }
                lstAllChildren = new ArrayList<Element>();
                arrayName = strName.split(SPLIT_ATTRIBUTE);
                if (arrayName != null && arrayName.length > 1 && ((arrayAttribute = arrayName[1].split(SPLIT_VALUE)) == null || arrayAttribute.length <= 1)) {
                    arrayAttribute = null;
                }
                if (arrayName != null && arrayAttribute != null) break block6;
                List<Node> lstChildren = XMLProperties.getChildren(objElement, strName);
                for (int n = 0; n < lstChildren.size(); ++n) {
                    objChildElement = (Element)lstChildren.get(n);
                    if (objChildElement == null) continue;
                    List<Node> lstGrandChildren = XMLProperties.getChildren(objChildElement, null);
                    int nLen = lstGrandChildren.size();
                    for (int i = 0; i < nLen; ++i) {
                        lstAllChildren.add((Element)lstGrandChildren.get(i));
                    }
                }
                break block7;
            }
            List<Node> lstChildren = XMLProperties.getChildren(objElement, arrayName[0]);
            if (lstChildren == null) break block7;
            for (int n = 0; n < lstChildren.size(); ++n) {
                String strValue;
                objChildElement = (Element)lstChildren.get(n);
                if (objChildElement == null || !arrayAttribute[1].equals(strValue = XMLProperties.getAttributeValue(objChildElement, arrayAttribute[0]))) continue;
                List<Node> lstGrandChildren = XMLProperties.getChildren(objChildElement, null);
                int nLen = lstGrandChildren.size();
                for (int i = 0; i < nLen; ++i) {
                    lstAllChildren.add((Element)lstGrandChildren.get(i));
                }
            }
        }
        return lstAllChildren.toArray(new Element[0]);
    }

    private static Node[] getChildrenElement(Node element, String[] names, boolean autoCreate) {
        int n;
        if (names == null || names.length == 0) {
            log.error("\u83b7\u53d6\u5b50\u8282\u70b9\uff1a{} \u4e0b\u7ea7\u5b50\u8282\u70b9\u65f6\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u540d\u5b57\u5217\u8868\uff1a{}", new Object[]{XMLProperties.toString(element), names, new Exception()});
            return null;
        }
        Node[] childrens = XMLProperties.getMatchChildElement(element, names[0]);
        if (names.length == 1) {
            if (childrens != null && childrens.length > 0) {
                return childrens;
            }
            if (autoCreate) {
                Element objSubNode = element.getOwnerDocument().createElement(names[0]);
                element.appendChild(objSubNode);
                return new Node[]{objSubNode};
            }
            return null;
        }
        String[] childNames = new String[names.length - 1];
        for (n = 0; n < childNames.length; ++n) {
            childNames[n] = names[n + 1];
        }
        ArrayList<Node> lstResult = new ArrayList<Node>();
        for (n = 0; n < childrens.length; ++n) {
            Node[] childs = XMLProperties.getChildrenElement(childrens[n], childNames, autoCreate);
            if (childs == null) continue;
            for (int i = 0; i < childs.length; ++i) {
                lstResult.add(childs[i]);
            }
        }
        if (lstResult.size() == 0) {
            return null;
        }
        return lstResult.toArray(new Node[0]);
    }

    private Node[] getChildrenElementRegex(Node objElement, String[] arrayName) {
        int n;
        Node[] arrayChildren = this.getMatchChildElementRegex(objElement, arrayName[0]);
        if (arrayName.length == 1) {
            if (arrayChildren != null && arrayChildren.length > 0) {
                return arrayChildren;
            }
            return null;
        }
        String[] arrayChildName = new String[arrayName.length - 1];
        for (n = 0; n < arrayChildName.length; ++n) {
            arrayChildName[n] = arrayName[n + 1];
        }
        ArrayList<Node> lstResult = new ArrayList<Node>();
        for (n = 0; n < arrayChildren.length; ++n) {
            Node[] arrayChild = this.getChildrenElementRegex(arrayChildren[n], arrayChildName);
            if (arrayChild == null) continue;
            for (int i = 0; i < arrayChild.length; ++i) {
                lstResult.add(arrayChild[i]);
            }
        }
        if (lstResult.size() == 0) {
            return null;
        }
        return lstResult.toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeChild(Node element, String name) {
        Node node = element;
        synchronized (node) {
            NodeList childs = element.getChildNodes();
            int len = childs.getLength();
            ArrayList<Node> dels = new ArrayList<Node>(len);
            for (int n = 0; n < len; ++n) {
                try {
                    Node node2 = childs.item(n);
                    if (!(node2 instanceof Element) || !node2.getNodeName().equals(name)) continue;
                    dels.add(node2);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                }
            }
            for (Node node2 : dels) {
                element.removeChild(node2);
            }
        }
    }

    public static final String getAttributeValue(Node objElement, String strAttrName) {
        if (objElement != null) {
            Node objAttribute = objElement.getAttributes().getNamedItem(strAttrName);
            return objAttribute != null ? objAttribute.getNodeValue() : null;
        }
        return null;
    }

    public static final String getAttributeValue(Node objElement, String strAttrName, boolean isAllowEmpty) {
        String value;
        Node objAttribute;
        if (objElement != null && (objAttribute = objElement.getAttributes().getNamedItem(strAttrName)) != null && (value = objAttribute.getNodeValue()) != null && value.length() > 0) {
            return value;
        }
        return isAllowEmpty ? "" : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Node> getChildren(Node element, String name) {
        ArrayList<Node> results = new ArrayList<Node>();
        Node node = element;
        synchronized (node) {
            NodeList childrens = element.getChildNodes();
            int nLen = childrens.getLength();
            for (int n = 0; n < nLen; ++n) {
                try {
                    Node node2 = childrens.item(n);
                    if (!(node2 instanceof Element) || name != null && !node2.getNodeName().equals(name)) continue;
                    results.add(node2);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                }
            }
        }
        return results;
    }

    public static final Node getChildNode(Node element, String subElementName) {
        NodeList nodes = XMLProperties.getChildNodes(element, subElementName);
        return nodes != null && nodes.getLength() > 0 ? nodes.item(0) : null;
    }

    public final Node getChildNode(Node element, String eubElementName, boolean isForEdit) {
        NodeList nodes = this.getChildNodes(element, eubElementName, isForEdit);
        return nodes != null && nodes.getLength() > 0 ? nodes.item(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NodeList getChildNodes(Node element, String pathName) {
        Node[] elements;
        if (element == null) {
            return new PropertiesNodeList(new Element[0]);
        }
        Node node = element;
        synchronized (node) {
            if (pathName == null || (pathName = pathName.trim()).length() == 0) {
                NodeList childs = element.getChildNodes();
                ArrayList<Element> results = new ArrayList<Element>();
                int len = childs.getLength();
                for (int n = 0; n < len; ++n) {
                    try {
                        Node node2 = childs.item(n);
                        if (!(node2 instanceof Element)) continue;
                        results.add((Element)node2);
                        continue;
                    }
                    catch (Exception e) {
                        log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                    }
                }
                elements = results.toArray(new Element[0]);
            } else if (element instanceof Node) {
                String[] propNames = XMLProperties.parsePropertyName(null, pathName);
                elements = XMLProperties.getChildrenElement(element, propNames, false);
            } else {
                elements = null;
            }
        }
        return new PropertiesNodeList(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NodeList getChildNodes(Node element, String pathName, boolean isForEdit) {
        Node[] elements;
        if (pathName == null || (pathName = pathName.trim()).length() == 0) {
            Node node = element;
            synchronized (node) {
                NodeList childs = element.getChildNodes();
                ArrayList<Node> results = new ArrayList<Node>();
                int len = childs.getLength();
                for (int n = 0; n < len; ++n) {
                    try {
                        Node node2 = childs.item(n);
                        if (!(node2 instanceof Node)) continue;
                        results.add(node2);
                        continue;
                    }
                    catch (Exception e) {
                        log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                    }
                }
                elements = results.toArray(new Node[0]);
            }
        } else if (element instanceof Node) {
            String[] propNames = XMLProperties.parsePropertyName(null, pathName);
            elements = XMLProperties.getChildrenElement(element, propNames, false);
        } else {
            elements = null;
        }
        return new PropertiesNodeList(isForEdit ? this.toProxyNode(elements) : elements);
    }

    private final Element toProxyNode(Element element) {
        if (!Proxy.isProxyClass(element.getClass())) {
            NodeChangeHandler handler = new NodeChangeHandler(element, this);
            return (Element)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{Element.class, Node.class}, (InvocationHandler)handler);
        }
        return element;
    }

    private final Node toProxyNode(Node element) {
        if (!Proxy.isProxyClass(element.getClass())) {
            NodeChangeHandler handler = new NodeChangeHandler(element, this);
            return (Element)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{Node.class, Node.class}, (InvocationHandler)handler);
        }
        return element;
    }

    private Element[] toProxyNode(Element[] elements) {
        int nLen = elements.length;
        for (int n = 0; n < nLen; ++n) {
            elements[n] = this.toProxyNode(elements[n]);
        }
        return elements;
    }

    private Node[] toProxyNode(Node[] elements) {
        int nLen = elements.length;
        for (int n = 0; n < nLen; ++n) {
            elements[n] = this.toProxyNode(elements[n]);
        }
        return elements;
    }

    protected NodeList toProxyNode(NodeList nodelist) {
        int size = nodelist.getLength();
        Node[] elements = new Node[size];
        for (int n = 0; n < size; ++n) {
            try {
                Node node = nodelist.item(n);
                if (node instanceof Element) {
                    elements[n] = this.toProxyNode((Element)node);
                    continue;
                }
                elements[n] = node;
                continue;
            }
            catch (Exception e) {
                log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{}", new Object[]{n, e.getMessage(), e});
            }
        }
        return new PropertiesNodeList(elements);
    }

    public static final String getText(Node node) {
        return XMLProperties.getText(node, true);
    }

    public static final String getText(Node element, String subElementName, boolean isAllowEmpty) {
        NodeList nodes = XMLProperties.getChildNodes(element, subElementName);
        if (nodes != null && nodes.getLength() > 0) {
            return XMLProperties.getText(nodes.item(0), isAllowEmpty);
        }
        return isAllowEmpty ? "" : null;
    }

    public static final String getText(Node element, boolean isAllowEmpty) {
        String res = null;
        if (element != null) {
            if (element instanceof Text) {
                res = element.getNodeValue();
            } else {
                StringBuffer buf = new StringBuffer();
                boolean hasData = false;
                if (element != null) {
                    NodeList childrens = element.getChildNodes();
                    int nLen = childrens.getLength();
                    for (int n = 0; n < nLen; ++n) {
                        try {
                            Node node = childrens.item(n);
                            if (!(node instanceof Text)) continue;
                            buf.append(node.getNodeValue());
                            hasData = true;
                            continue;
                        }
                        catch (Exception e) {
                            log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                        }
                    }
                }
                if (hasData) {
                    res = buf.toString();
                }
            }
        }
        return res != null && res.length() > 0 ? res : (isAllowEmpty ? "" : null);
    }

    public static final boolean getTextBool(Node objElement, String strSubElement, boolean bDef) {
        return StringUtils.toBool(XMLProperties.getText(objElement, strSubElement, false), bDef);
    }

    public static final boolean getTextBool(Node element, boolean defVal) {
        return StringUtils.toBool(XMLProperties.getText(element, false), defVal);
    }

    public static final double getTextDouble(Node objElement, String strSubElement, double fDef) {
        return StringUtils.toDouble(XMLProperties.getText(objElement, strSubElement, false), fDef);
    }

    public static final double getTextDouble(Node element, double defVal) {
        return StringUtils.toDouble(XMLProperties.getText(element, false), defVal);
    }

    public static final int getTextInt(Node objElement, String strSubElement, int nDef) {
        return StringUtils.toInt(XMLProperties.getText(objElement, strSubElement, false), nDef);
    }

    public static final int getTextInt(Node element, int defVal) {
        return StringUtils.toInt(XMLProperties.getText(element, false), defVal);
    }

    public static final long getTextLong(Node objElement, String strSubElement, long lDef) {
        return StringUtils.toLong(XMLProperties.getText(objElement, strSubElement, false), lDef);
    }

    public static final long getTextLong(Node element, long defVal) {
        return StringUtils.toLong(XMLProperties.getText(element, false), defVal);
    }

    public static String toValidElementName(String strName) {
        int nLen;
        if (strName != null && (nLen = strName.length()) > 0) {
            boolean bFlag = false;
            for (int n = 0; n < nLen; ++n) {
                char ch = strName.charAt(n);
                if (ch >= '0' && ch <= '9') continue;
                bFlag = true;
                break;
            }
            if (!bFlag) {
                return '_' + strName;
            }
            return strName;
        }
        return "_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setText(Node element, String value) {
        if (element != null) {
            XMLProperties xml = null;
            boolean hasData = false;
            Node node = element;
            synchronized (node) {
                InvocationHandler ih;
                NodeList childrens = element.getChildNodes();
                if (Proxy.isProxyClass(element.getClass()) && (ih = Proxy.getInvocationHandler(element)) instanceof NodeChangeHandler) {
                    xml = ((NodeChangeHandler)ih).getXMLProperties();
                }
                int len = childrens.getLength();
                for (int n = 0; n < len; ++n) {
                    try {
                        Node node2 = childrens.item(n);
                        if (!(node2 instanceof Text)) continue;
                        if (!hasData) {
                            if (xml != null && !Proxy.isProxyClass(node2.getClass())) {
                                NodeChangeHandler handler = new NodeChangeHandler(node2, xml);
                                node2 = (Node)Proxy.newProxyInstance(node2.getClass().getClassLoader(), new Class[]{Node.class}, (InvocationHandler)handler);
                            }
                            node2.setNodeValue(value != null ? value : "");
                            hasData = true;
                            continue;
                        }
                        if (node2.getNodeValue().length() <= 0) continue;
                        node2.setNodeValue("");
                        continue;
                    }
                    catch (Exception e) {
                        log.info("\u83b7\u53d6\u8282\u70b9\u7b2c{}\u4e2a\u5b50\u5143\u7d20\u5931\u8d25\uff1a{} \u8282\u70b9\u6570\u636e\uff1a{}", new Object[]{n, e.getMessage(), XMLProperties.toString(element), e});
                    }
                }
                if (!hasData) {
                    Text objText = element.getOwnerDocument().createTextNode(value != null ? value : "");
                    element.appendChild(objText);
                }
            }
        }
    }

    public static final void setChildText(Node objElement, String strSubElement, String strValue) {
        Node objSubNode = XMLProperties.getChildNode(objElement, strSubElement);
        if (objSubNode == null && objElement instanceof Element) {
            String[] arrayPropName = XMLProperties.parsePropertyName(null, strSubElement);
            XMLProperties.getChildrenElement((Element)objElement, arrayPropName, true);
            objSubNode = XMLProperties.getChildNode(objElement, strSubElement);
        }
        XMLProperties.setText(objSubNode, strValue);
    }

    public static final void addElemenText(Document objDoc, Element objElement, String strSubElementName, String strValue) {
        Element objSub = objDoc.createElement(strSubElementName);
        Text objTxt = objDoc.createTextNode(strValue != null ? strValue : "");
        objSub.appendChild(objTxt);
        objElement.appendChild(objSub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream stream, EntityResolver resolver, String resourcePath) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (resolver != null) {
                builder.setEntityResolver(resolver);
            }
            this.m_docXML = resourcePath == null ? builder.parse(stream) : builder.parse(stream, resourcePath);
            this.m_strFileName = null;
            this.m_isDoc = true;
            this.m_isFile = false;
            this.m_isChange = false;
            this.m_isAutoBackup = false;
            boolean bl = true;
            return bl;
        }
        catch (ParserConfigurationException e) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6" + this.m_objFileDoc.getAbsolutePath() + " \u89e3\u6790\u914d\u7f6e\u9519\u8bef\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6" + (this.m_objFileDoc != null ? this.m_objFileDoc.getAbsolutePath() : "") + " \u8bfb\u53d6\u9519\u8bef\uff1a" + e.getMessage());
        }
        catch (SAXException e) {
            log.error("XML\u6570\u636e\u6d41\u683c\u5f0f\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public boolean load(byte[] datas) {
        try {
            this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(datas));
            this.m_isDoc = true;
        }
        catch (Exception e) {
            System.err.println("\u4ece\u8f93\u5165\u6d41\u5bfc\u5165\u5931\u8d25 Error creating XML parser.");
            log.error("\u4ece\u8f93\u5165\u6d41\u5bfc\u5165\u5f02\u5e38\uff1a{}\uff0c\u539f\u59cb\u6570\u636e\uff1a\r\n{}", new Object[]{e.getMessage(), new String(datas), e});
            return false;
        }
        this.m_isFile = false;
        return true;
    }

    public boolean load(String strIn, String strDefaultEncoding) {
        if (strIn != null && strIn.length() > 0) {
            Object strEncoding = strDefaultEncoding == null ? Util.NativeCharSet : (strDefaultEncoding == null || strDefaultEncoding.length() == 0 || "ISO8859_1".equals(strDefaultEncoding) ? null : strDefaultEncoding);
            try {
                return this.load(strEncoding != null ? strIn.getBytes((String)strEncoding) : strIn.getBytes());
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u7f16\u7801\u9519\u8bef\uff1a{}", strEncoding);
                return false;
            }
        }
        this.m_isFile = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadXMLFile() {
        FileInputStream objStream = null;
        FileLock objLock = null;
        try {
            objStream = new FileInputStream(this.m_objFileDoc);
            FileChannel objChannel = objStream.getChannel();
            while ((objLock = objChannel.tryLock(0L, Long.MAX_VALUE, true)) == null || !objLock.isValid()) {
                log.info("\u8bfbXML\u6587\u4ef6\u65f6\u6709\u5176\u4ed6\u7ebf\u7a0b\uff0c\u7b49\u5f85\u534a\u79d2:" + this.m_objFileDoc.getAbsolutePath());
                Thread.sleep(500L);
            }
            this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(objStream);
            this.m_isDoc = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6 " + this.m_objFileDoc.getAbsolutePath() + " \u65e0\u6cd5\u6b63\u786e\u88c5\u8f7d\u3002", (Throwable)e);
        }
        finally {
            if (objStream != null) {
                try {
                    objStream.close();
                }
                catch (Exception exception) {}
            }
            if (objLock != null) {
                try {
                    objLock.release();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public String getDefaultPath() {
        return this.m_defaultPath;
    }

    public Document getDocument() {
        return this.m_docXML;
    }

    public void setDocument(Document objDoc) {
        if (objDoc != null) {
            this.m_docXML = objDoc;
            this.m_isDoc = true;
            this.m_isFile = false;
        } else {
            log.error("\u6307\u5b9a\u7684XML\u6587\u6863\u4e3a\u7a7a\uff01", (Throwable)new Exception("\u6307\u5b9a\u7684XML\u6587\u6863\u4e3a\u7a7a\uff01"));
        }
    }

    public final NodeList getElements(String namePath) {
        return this.getElements(namePath, false);
    }

    public static boolean checkNode(Node node) {
        return !"#text".equals(node.getNodeName());
    }

    public NodeList getElements(String namePath, boolean isForEdit) {
        if (namePath == null || namePath.length() == 0) {
            NodeList nodes = this.m_docXML.getDocumentElement().getChildNodes();
            ArrayList<Node> items = new ArrayList<Node>(nodes.getLength());
            int len = nodes.getLength();
            for (int n = 0; n < len; ++n) {
                try {
                    Node node = nodes.item(n);
                    if (!XMLProperties.checkNode(node)) continue;
                    items.add(node);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u6dfb\u52a0\u7b2c{}\u4e2a\u5143\u7d20\u5f02\u5e38\uff1a{}", (Object)n, (Object)e.getMessage());
                }
            }
            return new PropertiesNodeList(isForEdit ? this.toProxyNode(items.toArray(new Node[0])) : items.toArray(new Node[0]));
        }
        String pathName = namePath.startsWith(".") ? (this.m_defaultPath != null && this.m_defaultPath.length() > 0 ? (namePath.startsWith(".@") ? this.m_defaultPath + namePath.substring(1) : this.m_defaultPath + namePath) : namePath.substring(1)) : namePath;
        if (this.m_docXML == null) {
            log.error("XML\u5c5e\u6027\u6587\u4ef6\u672a\u88c5\u8f7d\uff01");
            return new PropertiesNodeList();
        }
        String[] propNames = XMLProperties.parsePropertyName(this.m_defaultPath, pathName);
        Node[] elements = XMLProperties.getChildrenElement(this.m_docXML.getDocumentElement(), propNames, false);
        return new PropertiesNodeList(isForEdit ? this.toProxyNode(elements) : elements);
    }

    public void setDefaultPath(String strDefaultPath) {
        this.m_defaultPath = strDefaultPath != null && strDefaultPath.endsWith(".") ? strDefaultPath.substring(0, strDefaultPath.length() - 2) : strDefaultPath;
    }

    public boolean isLoad() {
        return this.m_isDoc;
    }

    protected boolean isFile() {
        return this.m_isFile;
    }

    public boolean exists() {
        return this.m_objFileDoc != null && this.m_objFileDoc.exists();
    }

    public boolean loadResource(String strFileName) {
        return this.loadResource(strFileName, false);
    }

    public boolean loadResource(String strFileName, boolean bForce) {
        File objFile = null;
        try {
            objFile = new File(strFileName);
            this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(objFile);
            this.m_objFileDoc = objFile;
            this.m_isDoc = true;
            this.m_strFileName = this.m_objFileDoc.getAbsolutePath();
            this.m_propertyCache.clear();
            this.m_attributeCache.clear();
            return true;
        }
        catch (Exception e) {
            System.err.println("XML\u5c5e\u6027\u6587\u4ef6 " + strFileName + " \u9519\u8bef\uff01\u65e0\u6cd5\u6b63\u786e\u88c5\u8f7d\u3002");
            log.error("XML\u5c5e\u6027\u6587\u4ef6 " + strFileName + " \u65e0\u6cd5\u6b63\u786e\u88c5\u8f7d\u3002", (Throwable)e);
            if (bForce) {
                this.m_isDoc = false;
                this.m_objFileDoc = objFile;
                if (this.m_objFileDoc != null) {
                    this.m_strFileName = this.m_objFileDoc.getAbsolutePath();
                }
            }
            return false;
        }
    }

    public boolean loadResource(String strIn, String strDefaultEncoding) {
        if (strIn != null && strIn.length() > 0) {
            try {
                this.m_docXML = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(strIn.getBytes()));
                this.m_isDoc = true;
                this.m_propertyCache.clear();
                this.m_attributeCache.clear();
                return true;
            }
            catch (Exception e) {
                System.err.println("\u4ece\u5b57\u7b26\u4e32\u5bfc\u5165\u5931\u8d25 Error creating XML parser.");
                log.error("\u4ece\u5b57\u7b26\u4e32\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public String getURI() {
        if (this.m_objFileDoc != null) {
            return this.m_objFileDoc.toURI().toString();
        }
        if (this.m_docXML != null) {
            return this.m_docXML.getDocumentURI();
        }
        return "";
    }

    public boolean isAutoBackup() {
        return this.m_isAutoBackup;
    }

    public void setAutoBackup(boolean bAutoBackup) {
        this.m_isAutoBackup = bAutoBackup;
    }

    public boolean setBackupExt(String strBackupExtTimeFormater) {
        this.m_backupExtFormater = new SimpleDateFormat("." + strBackupExtTimeFormater, Globals.getLocale());
        return true;
    }

    public static String elementToXmlString(Element objElement) {
        TransformerFactory objFactory = TransformerFactory.newInstance();
        Transformer objTransformer = null;
        try {
            objTransformer = objFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.warn("\u8f6c\u6362\u65f6\u914d\u7f6e\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        StringWriter objWriter = new StringWriter();
        objTransformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            objTransformer.transform(new DOMSource(objElement), new StreamResult(objWriter));
        }
        catch (TransformerException e) {
            log.warn("\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        return objWriter.toString();
    }

    public String toString() {
        if (this.m_docXML.getDocumentElement() != null) {
            StringWriter objWriter = new StringWriter();
            try {
                Transformer objFormer = TransformerFactory.newInstance().newTransformer();
                DOMSource objSource = new DOMSource(this.m_docXML);
                StreamResult objResult = new StreamResult(objWriter);
                objFormer.setOutputProperty("indent", "yes");
                objFormer.transform(objSource, objResult);
                objWriter.close();
                return objWriter.toString();
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        return super.toString();
    }

    public static String toString(Node node) {
        if (node != null) {
            StringWriter sw = new StringWriter();
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.setOutputProperty("indent", "yes");
                t.transform(new DOMSource(node), new StreamResult(sw));
            }
            catch (TransformerException te) {
                log.error("nodeToString Transformer Exception:{}", (Object)te.getMessage());
            }
            return sw.toString();
        }
        return "null";
    }

    public static void main(String[] args) {
        String strAttrName = "id";
        XMLProperties propXML = null;
        StringList lstAttr = null;
        char chSplit = '%';
        HashMap<Long, String> mapData = new HashMap<Long, String>();
        String strValue2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><data>   <name>\u540d\u79f0</name>\r\n   <name id=\"2\">\u540d\u79f0id=2</name>\r\n   <name1>\u6d4b\u8bd5\u7684name1</name1>\r\n   <nametest><mydata>\u540d\u79f02</mydata></nametest>\r\n   <name1>\r\n     <name2 attr=\"attrValue1\">\r\n          <name3>This is Data 1.</name3>\r\n     </name2>\r\n     <name2 attr=\"attrValue2\" id=\"2\">\r\n          <name3>This is Data 2.</name3>\r\n     </name2>     <name2>\r\n          <name4>This is Data 4.</name4>\r\n     </name2>\r\n     <name2>\r\n          <name5>This is Data 5.</name5>\r\n     </name2>\r\n   </name1>\r\n</data>";
        propXML = new XMLProperties(strValue2, "GBK");
        log.info(strValue2 + "\r\nname :" + propXML.getProperty("name"));
        log.info("name id=2 :" + propXML.getProperty("name@id=2"));
        log.info("nametest.mydata :" + propXML.getProperty("nametest.mydata"));
        log.info("\r\nname1.name2@attr=attrValue1.name3 (\u6b63\u786e\u503c\uff1aThis is Data 1.):" + propXML.getProperty("name1.name2@attr=attrValue1.name3"));
        log.info("\r\nname1.name2@attr=attrValue2.name3 (\u6b63\u786e\u503c\uff1aThis is Data 2.):" + propXML.getProperty("name1.name2@attr=attrValue2.name3"));
        log.info("\r\nname1.name2.name4 (\u6b63\u786e\u503c\uff1aThis is Data 4.):" + propXML.getProperty("name1.name2.name4"));
        log.info("\r\nname1.name2.name5 (\u6b63\u786e\u503c\uff1aThis is Data 5.):" + propXML.getProperty("name1.name2.name5"));
        log.info("\r\nname all properties (\u6b63\u786e\u503c\uff1a\u540d\u79f0 \u540d\u79f0id=2): " + propXML.getAllProperty("name"));
        log.info("\r\nname.id attribute (\u6b63\u786e\u503c\uff1a2): " + propXML.getAttribute("name.id", true));
        log.info("\r\nname1.name2 all \"attr\" attribute (\u6b63\u786e\u503c\uff1aattrValue1 attrValue2 null null): " + propXML.getAllAttribute("name1.name2", "attr"));
        log.info("\r\nname1.name2@id=2 all \"attr\" attribute (\u6b63\u786e\u503c\uff1aattrValue2): " + propXML.getAllAttribute("name1.name2@id=2", "attr"));
        log.info("\r\nname1.name2@attr=* findPropertyName (\u6b63\u786e\u503c\uff1aname1.name2@attr=attrValue1 name1.name2@attr=attrValue2): " + propXML.findPropertyName("name1.name2@attr=*2"));
        propXML = new XMLProperties("E://1890.xml");
        propXML.setAttribute("test", "testAttribute");
        propXML.save();
        File objFile = new File("E:\\test");
        String strFile = objFile.getAbsolutePath();
        log.info(strFile + "\u662f\u5426\u5b58\u5728\uff1a" + objFile.exists());
        new FileOperation().copyFile(strFile + BACKUP_FILE_EXT, strFile);
        log.info(strFile + "\u662f\u5426\u5b58\u5728\uff1a" + objFile.exists());
        objFile.delete();
        mapData.put(new Long(1L), "\u7b2c\u4e00\u6761\u8bb0\u5f55");
        mapData.put(new Long(2L), "\u7b2c\u4e8c\u6761\u8bb0\u5f55");
        mapData.put(new Long(3L), "\u7b2c\u4e09\u6761\u8bb0\u5f55");
        Iterator iterData = mapData.keySet().iterator();
        while (iterData.hasNext()) {
            Long objKey = (Long)iterData.next();
            if (objKey != 2L) continue;
            iterData.remove();
        }
        log.info("\u5927\u5c0f\uff1a" + mapData.size());
        for (String strValue2 : mapData.values()) {
            if (!strValue2.equals("\u7b2c\u4e09\u6761\u8bb0\u5f55")) continue;
            iterData.remove();
        }
        log.info("\u5927\u5c0f\uff1a" + mapData.size());
        strFile = "E:\\PTHL\\counter-news.xml";
        System.out.print("\u6d4b\u8bd5\u591a\u7ebf\u7a0b...");
        new Thread(){

            public void run() {
                System.out.println("\u5f00\u59cb\u5904\u7406");
                String strTestFile = "E:\\PTHL\\test\\xml\\counter-news.xml";
                XMLProperties bojPropXML = new XMLProperties(strTestFile);
                String strTestPath = "page@name=index.area@name=left";
                String strTestValue = String.valueOf(System.currentTimeMillis());
                bojPropXML.setProperty(strTestPath, strTestValue);
                boolean bResult = bojPropXML.save();
                System.out.println("\u5904\u7406\u5b8c\u6210" + bResult);
            }
        }.start();
        try {
            Thread.sleep(3500L);
            System.exit(0);
            return;
        }
        catch (Exception objKey) {
            int i;
            strFile = "1000.xml";
            String strPath = "page@name=index.area";
            propXML = new XMLProperties("test\\" + strFile);
            propXML.setProperty("test.key1.key2", "myValue");
            System.out.println("save:" + propXML.save());
            propXML = new XMLProperties(strFile, true, "yyyy-MM-dd");
            lstAttr = propXML.getAllAttribute(strPath, strAttrName);
            strValue2 = "123%id%%id%4567";
            System.out.println("Value:" + strValue2 + "\tNewValue:" + strValue2.replaceAll(String.valueOf(chSplit) + "id" + String.valueOf(chSplit), "A"));
            System.out.println("\u4f4d\u7f6e:" + strValue2.indexOf(chSplit));
            System.out.println("size:" + lstAttr.size());
            for (int n = 0; n < lstAttr.size(); ++n) {
                System.out.println("Attribute " + strAttrName + (n + 1) + SPLIT_VALUE + (String)lstAttr.get(n));
            }
            strPath = "page@name=index.area@id=6.channel.label";
            strPath = "page.path";
            strValue2 = propXML.getProperty(strPath);
            System.out.println("Value=" + strValue2);
            propXML.setProperty("test.key1.key2", "myValue");
            propXML.setProperty("test.key1.key2", "myValue2233");
            System.out.println("delete:" + propXML.deleteProperty("test.key1.key2@name=2"));
            System.out.println("save:" + propXML.save());
            XMLProperties xmlModel = new XMLProperties("Certificate.xml");
            XMLProperties xmlStandard = new XMLProperties("Standard.xml");
            StringList allAttrList = xmlStandard.getAllAttribute("certificate.contents.content", "name");
            ArrayList<String> allPropList = new ArrayList<String>();
            for (i = 0; i < allAttrList.size(); ++i) {
                String para = "certificate.contents.content@name=" + (String)allAttrList.get(i);
                allPropList.add(xmlStandard.getProperty(para));
            }
            for (i = 0; i < allAttrList.size(); ++i) {
                xmlModel.setAttribute("certificate@id=19.name", "\u6d4b\u8bd5");
                xmlModel.setAttribute("certificate@id=19.contents.content@name=" + (String)allAttrList.get(i) + ".hidden", "0");
                xmlModel.setProperty("certificate@id=19.contents.content@name=" + (String)allAttrList.get(i), (String)allPropList.get(i));
            }
            xmlModel.save();
            return;
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        Class<?> c = runtime.getClass();
        try {
            Method m = c.getMethod("addShutdownHook", Thread.class);
            ShutdownThread objThread = new ShutdownThread();
            objThread.setThreadInfo();
            m.invoke((Object)runtime, objThread);
        }
        catch (NoSuchMethodException m) {
        }
        catch (IllegalArgumentException m) {
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u5173\u95ed\u76d1\u63a7\u7ebf\u7a0b\u65f6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public static class PropertiesNodeList
    implements NodeList {
        Node[] m_arrayData;

        public PropertiesNodeList() {
            this.m_arrayData = null;
        }

        public PropertiesNodeList(Element[] arrayData) {
            this.m_arrayData = arrayData;
        }

        public PropertiesNodeList(Node[] arrayData) {
            this.m_arrayData = arrayData;
        }

        public int getLength() {
            if (this.m_arrayData != null) {
                return this.m_arrayData.length;
            }
            return 0;
        }

        public Node item(int nIndex) {
            if (this.m_arrayData != null && nIndex < this.m_arrayData.length) {
                return this.m_arrayData[nIndex];
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            int len = this.m_arrayData.length;
            for (int n = 0; n < len; ++n) {
                if (n > 0) {
                    buf.append(",\r\n\r\n");
                }
                buf.append(XMLProperties.toString(this.m_arrayData[n]));
            }
            buf.append(']');
            return buf.toString();
        }
    }

    private static class ShutdownThread
    extends Thread {
        private void setThreadInfo() {
            try {
                this.setPriority(5);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setName("XML\u5c5e\u6027\u5904\u7406\u5bf9\u8c61\u5173\u95ed\u7ebf\u7a0b");
        }

        public void run() {
            try {
                long lCount = 0L;
                while (g_tasks.size() > 0) {
                    ShutdownThread.sleep(10L);
                    if (++lCount % 500L != 0L) continue;
                    log.info("XML\u5c5e\u6027\u5904\u7406\u7b49\u5f85" + g_tasks.size() + "\u4e2a\u6587\u4ef6\u5173\u95ed\u5df2\u5c1d\u8bd5\u6b21\u6570" + lCount);
                }
            }
            catch (Exception e) {
                log.error("\u7b49\u5f85XML\u5c5e\u6027\u5904\u7406\u5bf9\u8c61\u5173\u95ed\u65f6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static class NodeChangeHandler
    implements InvocationHandler {
        private static final Set<String> g_changeMethod = new HashSet<String>();
        private static final Set<String> g_inheritMethod;
        private Object targetObject;
        private XMLProperties m_xmlProperties;

        public NodeChangeHandler(Object targetObject, XMLProperties xmlProperties) {
            this.targetObject = targetObject;
            this.m_xmlProperties = xmlProperties;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke(this.targetObject, args);
            String methodName = method.getName();
            if (g_changeMethod.contains(methodName)) {
                this.m_xmlProperties.m_propertyCache.clear();
                this.m_xmlProperties.m_isChange = true;
            } else if (g_inheritMethod.contains(methodName)) {
                NodeList childNodes = (NodeList)result;
                return this.m_xmlProperties.toProxyNode(childNodes);
            }
            return result;
        }

        public XMLProperties getXMLProperties() {
            return this.m_xmlProperties;
        }

        static {
            g_changeMethod.add("appendChild");
            g_changeMethod.add("setAttribute");
            g_changeMethod.add("setNodeValue");
            g_changeMethod.add("removeChild");
            g_changeMethod.add("replaceChild");
            g_inheritMethod = new HashSet<String>();
            g_inheritMethod.add("getChildNodes");
        }
    }
}

