/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.model.util.Globals;
import com.hynnet.util.SystemNotifyInterface;
import com.hynnet.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemNotifyUtils {
    private static final Logger log = LoggerFactory.getLogger(SystemNotifyUtils.class);
    private static SystemNotifyInterface g_processer;
    private static String g_ip;

    public static final void sendSystemErrorMessage(String serviceName, String msg, boolean force) {
        if (g_processer == null) {
            try {
                Class<?> cls;
                String className = Globals.getProperty("notifyProcesser");
                if (className == null || className.length() == 0) {
                    className = "com.hynnet.wx.util.WeiXinSystemNotify";
                }
                if (SystemNotifyInterface.class.isAssignableFrom(cls = Class.forName(className))) {
                    g_processer = (SystemNotifyInterface)cls.newInstance();
                } else {
                    log.error("{} \u4e0d\u662f SystemNotifyInterface \u5b9e\u4f8b", (Object)className);
                }
            }
            catch (Throwable e) {
                log.debug("\u521b\u5efa\u7cfb\u7edf\u901a\u77e5\u5904\u7406\u5668\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        if (g_processer != null) {
            g_processer.sendSystemErrorMessage(String.format("%s - %s", serviceName, g_ip), msg, force);
        }
    }

    static {
        g_ip = Util.getAllIP()[0];
    }
}

