/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.FixTimeType;
import com.hynnet.util.Util;
import com.jivesoftware.oro.text.perl.Perl5Util;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils {
    protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.util.StringUtils");
    public static final int FILL_TYPE_LEFT = 0;
    public static final int FILL_TYPE_RIGHT = 1;
    public static final int FILL_TYPE_LEFT_AND_RIGHT = 2;
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static String PREFIX = "\\u";
    private static byte[] g_initLock = new byte[0];
    private static final String[] g_stringToDateFormats = new String[]{"yyyy-M-d H:m:s.S", "yyyy-M-d H:m:s", "yyyy-M-d H:m", "yyyy-M-d H", "yyyy-M-d", "yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2", "yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206", "yyyy\u5e74M\u6708d\u65e5 H\u65f6", "yyyy\u5e74M\u6708d\u65e5", "EEE MMM dd HH:mm:ss zzz yyyy", "M/d/yyyy H:m:s.S", "M/d/yyyy HH:mm:ss", "M/d/yyyy HH:mm", "M/d/yyyy"};
    private static final int[] g_stringToDateFixFormatLens = new int[]{24, 23, 19, 14, 10, 8, 7, 6};
    private static final String[] g_stringToDateFixFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyyMMddHHmmss", "yyyy-MM-dd", "yyyyMMdd", "yyyyMd", "yyyyMd"};
    private static final String[] g_stringToDateFormatWithLocales = new String[]{"EEE MMM dd HH:mm:ss zzz yyyy"};
    private static final char[] g_chineseNumbers = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final byte[] NUMBER_LETTER_64 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 95};
    private static final int fillchar = 61;
    private static final String cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String[] commonWords = new String[]{"a", "and", "as", "at", "be", "do", "i", "if", "in", "is", "it", "so", "the", "to"};
    private static final String[] TIME_KEY_FIND = new String[]{"W", "D", "H", "\u5c0f\u65f6", "\u5206\u949f", "S", "\u79d2\u949f", "\u6beb\u79d2"};
    private static final String[] TIME_KEY_REPLACE = new String[]{"\u5468", "\u65e5", "\u65f6", "\u65f6", "\u5206", "\u79d2", "\u79d2", "\u6beb"};
    private static final String[] FLOW_KEY_FIND = new String[]{"TB", "GB", "MB", "KB", "BYTE"};
    private static final String[] FLOW_KEY_REPLACE = new String[]{"T", "G", "M", "K", "B"};
    private static Map<String, String> g_commonWordsMap = null;
    private static Random g_randGen = null;
    private static char[] g_numbersAndLetters = null;
    private static Perl5Util g_perl5Util = null;
    private static final char[] g_zeroArray = "0000000000000000".toCharArray();
    private static final char[] g_digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static MessageDigest digest = null;

    public static final String replace(String toReplace, String find, String replaceTo) {
        if (toReplace == null) {
            return null;
        }
        int n = 0;
        if ((n = toReplace.indexOf(find, n)) >= 0) {
            char[] toReplaceChars = toReplace.toCharArray();
            char[] replaceToChars = replaceTo.toCharArray();
            int len = find.length();
            StringBuffer buf = new StringBuffer(toReplaceChars.length + replaceToChars.length);
            buf.append(toReplaceChars, 0, n).append(replaceToChars);
            int i = n += len;
            while ((n = toReplace.indexOf(find, n)) > 0) {
                buf.append(toReplaceChars, i, n - i).append(replaceToChars);
                i = n += len;
            }
            len = toReplaceChars.length - i;
            if (len > 0) {
                buf.append(toReplaceChars, i, len);
            }
            return buf.toString();
        }
        return toReplace;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString, int[] retCount) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            int counter = 0;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            retCount[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String line, String oldString, String newString, int[] retCount) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            int counter = 0;
            ++counter;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            retCount[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String in, String[] oldStrings, String[] newStrings) {
        return StringUtils.replace(in, oldStrings, newStrings, null, null);
    }

    public static final String replace(String in, String[] oldStrings, String[] newStrings, boolean[] isIgnoreCase) {
        return StringUtils.replace(in, oldStrings, newStrings, isIgnoreCase, null);
    }

    public static final String replace(String in, String[] oldStrings, String[] newStrings, boolean[] isIgnoreCase, int[] retCount) {
        boolean[] arrayMatchIgnoreCase;
        int n;
        if (oldStrings == null || oldStrings.length == 0 || newStrings == null || newStrings.length == 0) {
            return in;
        }
        int nNumSrc = 0;
        for (n = 0; n < oldStrings.length && newStrings.length >= n; ++n) {
            if (oldStrings[n] == null || oldStrings[n].length() <= 0) continue;
            ++nNumSrc;
        }
        if (nNumSrc == 0) {
            return in;
        }
        char[][] arrayMatchKey = new char[nNumSrc][];
        String[] arrayReplace = new String[nNumSrc];
        int nCount = 0;
        for (n = 0; n < nNumSrc; ++n) {
            while (oldStrings[nCount] == null || oldStrings[nCount].length() == 0) {
                ++nCount;
            }
            arrayMatchKey[n] = oldStrings[nCount].toCharArray();
            if (newStrings[nCount] != null && newStrings[nCount].length() > 0) {
                arrayReplace[n] = newStrings[nCount];
            }
            ++nCount;
        }
        char[] arrayVal = in.toCharArray();
        if (isIgnoreCase != null && nNumSrc == oldStrings.length && nNumSrc == isIgnoreCase.length) {
            arrayMatchIgnoreCase = isIgnoreCase;
        } else {
            arrayMatchIgnoreCase = new boolean[nNumSrc];
            for (n = 0; n < nNumSrc; ++n) {
                arrayMatchIgnoreCase[n] = isIgnoreCase != null && n < isIgnoreCase.length ? isIgnoreCase[n] : false;
            }
        }
        int[] arrayMatchIndex = new int[nNumSrc];
        int[] arrayCount = new int[nNumSrc];
        nCount = 0;
        for (n = 0; n < arrayMatchIndex.length; ++n) {
            arrayMatchIndex[n] = 0;
        }
        for (n = 0; n < arrayCount.length; ++n) {
            arrayCount[n] = 0;
        }
        StringBuffer sbufResult = new StringBuffer(in.length() + 100);
        StringBuffer sbufMatchData = new StringBuffer();
        for (n = 0; n < arrayVal.length; ++n) {
            int i;
            boolean bHasMatch = false;
            int nMatch = -1;
            char chCur = arrayVal[n];
            for (i = 0; i < arrayMatchKey.length; ++i) {
                boolean bMatch;
                boolean bl = bMatch = chCur == arrayMatchKey[i][arrayMatchIndex[i]];
                if (!bMatch && arrayMatchIgnoreCase[i]) {
                    if (chCur >= 'A' && chCur <= 'Z') {
                        if (chCur + 32 == arrayMatchKey[i][arrayMatchIndex[i]]) {
                            bMatch = true;
                        }
                    } else if (chCur >= 'a' && chCur <= 'z' && chCur - 32 == arrayMatchKey[i][arrayMatchIndex[i]]) {
                        bMatch = true;
                    }
                }
                if (bMatch) {
                    bHasMatch = true;
                    int n2 = i;
                    arrayMatchIndex[n2] = arrayMatchIndex[n2] + 1;
                    if (arrayMatchIndex[i] < arrayMatchKey[i].length) continue;
                    nMatch = i;
                    break;
                }
                arrayMatchIndex[i] = 0;
            }
            if (nMatch >= 0) {
                int n3 = nMatch;
                arrayCount[n3] = arrayCount[n3] + 1;
                ++nCount;
                if (arrayReplace[nMatch] != null) {
                    sbufResult.append(arrayReplace[nMatch]);
                }
                sbufMatchData.delete(0, sbufMatchData.length());
                for (i = 0; i < arrayMatchIndex.length; ++i) {
                    arrayMatchIndex[i] = 0;
                }
                continue;
            }
            if (bHasMatch) {
                sbufMatchData.append(chCur);
                continue;
            }
            sbufResult.append(sbufMatchData);
            sbufMatchData.delete(0, sbufMatchData.length());
            sbufResult.append(chCur);
        }
        if (retCount != null) {
            if (retCount.length == 1) {
                retCount[0] = nCount;
            } else {
                for (n = 0; n < retCount.length && n < arrayCount.length; ++n) {
                    retCount[n] = arrayCount[n];
                }
            }
        }
        if (nCount > 0) {
            if (sbufMatchData.length() > 0) {
                return sbufResult.append(sbufMatchData).toString();
            }
            return sbufResult.toString();
        }
        return in;
    }

    public static final String escapeHTMLTags(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch != '>') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(GT_ENCODE);
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final synchronized String hash(String data) {
        if (data == null) {
            return "";
        }
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("Failed to load the MD5 MessageDigest. it will be unable to function normally.");
                nsae.printStackTrace();
            }
        }
        digest.update(data.getBytes());
        return StringUtils.encodeHex(digest.digest());
    }

    public static final String delParameterFromQueryString(String queryString, String parameterName) {
        char ch;
        String findKey = parameterName + '=';
        int len = findKey.length();
        int indexStart = queryString.indexOf(findKey);
        while (indexStart == 0 || indexStart > 0 && ((ch = queryString.charAt(indexStart - 1)) == '&' || ch == '?')) {
            int indexEnd = queryString.indexOf(38, indexStart + len);
            queryString = indexStart == 0 ? (indexEnd > 0 ? queryString.substring(indexEnd + 1) : "") : (indexEnd > 0 ? queryString.substring(0, indexStart) + queryString.substring(indexEnd + 1) : queryString.substring(0, indexStart));
            int srcLen = queryString.length();
            if (srcLen > 0 && queryString.charAt(srcLen - 1) == '?') {
                queryString = queryString.substring(0, srcLen - 1);
            }
            indexStart = queryString.indexOf(findKey, indexStart);
        }
        return queryString;
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final byte[] decodeHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCount = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringUtils.hexCharToByte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (byte)(newByte | StringUtils.hexCharToByte(chars[i + 1]));
            ++byteCount;
        }
        return bytes;
    }

    public static String encodeJsUnicode(String str) {
        StringBuilder sb = new StringBuilder(str.length() * 3);
        for (char c : str.toCharArray()) {
            if (c < '\u0100') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            sb.append(Character.forDigit(c >>> 12 & 0xF, 16));
            sb.append(Character.forDigit(c >>> 8 & 0xF, 16));
            sb.append(Character.forDigit(c >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(c & 0xF, 16));
        }
        return sb.toString();
    }

    public static String decodeJsUnicode(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        for (int n = 0; n < chars.length; ++n) {
            char c = chars[n];
            if (c == '\\' && chars[n + 1] == 'u') {
                char cc = '\u0000';
                for (int j = 0; j < 4; ++j) {
                    char ch = Character.toLowerCase(chars[n + 2 + j]);
                    if (!('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f')) {
                        cc = '\u0000';
                        break;
                    }
                    cc = (char)(cc | Character.digit(ch, 16) << (3 - j) * 4);
                }
                if (cc > '\u0000') {
                    n += 5;
                    sb.append(cc);
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final byte hexCharToByte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static final String encodeBase64(String data) {
        return StringUtils.encodeBase64(data.getBytes());
    }

    public static final String encodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer((len / 3 + 1) * 4);
        for (int i = 0; i < len; ++i) {
            int c = data[i] >> 2 & 0x3F;
            ret.append(cvt.charAt(c));
            c = data[i] << 4 & 0x3F;
            if (++i < len) {
                c |= data[i] >> 4 & 0xF;
            }
            ret.append(cvt.charAt(c));
            if (i < len) {
                c = data[i] << 2 & 0x3F;
                if (++i < len) {
                    c |= data[i] >> 6 & 3;
                }
                ret.append(cvt.charAt(c));
            } else {
                ++i;
                ret.append('=');
            }
            if (i < len) {
                c = data[i] & 0x3F;
                ret.append(cvt.charAt(c));
                continue;
            }
            ret.append('=');
        }
        return ret.toString();
    }

    public static final String decodeBase64(String data) {
        return StringUtils.decodeBase64(data.getBytes());
    }

    public static final String decodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer(len * 3 / 4);
        for (int i = 0; i < len; ++i) {
            int c = cvt.indexOf(data[i]);
            int c1 = cvt.indexOf(data[++i]);
            c = c << 2 | c1 >> 4 & 3;
            ret.append((char)c);
            if (++i < len) {
                c = data[i];
                if (61 == c) break;
                c = cvt.indexOf((char)c);
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.append((char)c1);
            }
            if (++i >= len) continue;
            c1 = data[i];
            if (61 == c1) break;
            c1 = cvt.indexOf((char)c1);
            c = c << 6 & 0xC0 | c1;
            ret.append((char)c);
        }
        return ret.toString();
    }

    public static final String[] toLowerCaseWordArray(String text) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        ArrayList<String> wordList = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int nStart = 0;
        int end = boundary.next();
        while (end != -1) {
            String strTmp = text.substring(nStart, end).trim();
            strTmp = StringUtils.replace(strTmp, "+", "");
            strTmp = StringUtils.replace(strTmp, "/", "");
            strTmp = StringUtils.replace(strTmp, "\\", "");
            strTmp = StringUtils.replace(strTmp, "#", "");
            strTmp = StringUtils.replace(strTmp, "*", "");
            strTmp = StringUtils.replace(strTmp, ")", "");
            strTmp = StringUtils.replace(strTmp, "(", "");
            if ((strTmp = StringUtils.replace(strTmp, "&", "")).length() > 0) {
                wordList.add(strTmp);
            }
            nStart = end;
            end = boundary.next();
        }
        return wordList.toArray(new String[wordList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final String[] removeCommonWords(String[] words) {
        if (g_commonWordsMap == null) {
            byte[] byArray = g_initLock;
            // MONITORENTER : g_initLock
            if (g_commonWordsMap == null) {
                g_commonWordsMap = new HashMap<String, String>();
                for (int i = 0; i < commonWords.length; ++i) {
                    g_commonWordsMap.put(commonWords[i], commonWords[i]);
                }
            }
            // MONITOREXIT : byArray
        }
        ArrayList<String> results = new ArrayList<String>(words.length);
        int i = 0;
        while (i < words.length) {
            if (!g_commonWordsMap.containsKey(words[i])) {
                results.add(words[i]);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        if (g_randGen == null) {
            byte[] byArray = g_initLock;
            // MONITORENTER : g_initLock
            if (g_randGen == null) {
                g_randGen = new Random();
                g_numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            }
            // MONITOREXIT : byArray
        }
        char[] randBuffer = new char[length];
        int i = 0;
        while (i < randBuffer.length) {
            randBuffer[i] = g_numbersAndLetters[g_randGen.nextInt(71)];
            ++i;
        }
        return new String(randBuffer);
    }

    public static final String chopAtWord(String string, int length) {
        int i;
        if (string == null) {
            return string;
        }
        char[] charArray = string.toCharArray();
        int sLength = string.length();
        if (length < sLength) {
            sLength = length;
        }
        for (i = 0; i < sLength - 1; ++i) {
            if (charArray[i] == '\r' && charArray[i + 1] == '\n') {
                return string.substring(0, i + 1);
            }
            if (charArray[i] != '\n') continue;
            return string.substring(0, i);
        }
        if (charArray[sLength - 1] == '\n') {
            return string.substring(0, sLength - 1);
        }
        if (string.length() < length) {
            return string;
        }
        for (i = length - 1; i > 0; --i) {
            if (charArray[i] != ' ') continue;
            return string.substring(0, i).trim();
        }
        return string.substring(0, length);
    }

    public static final String highlightWords(String string, String[] words, String startHighlight, String endHighlight) {
        if (string == null || words == null || startHighlight == null || endHighlight == null) {
            return null;
        }
        StringBuffer sbufRegexp = new StringBuffer();
        if (g_perl5Util == null) {
            g_perl5Util = new Perl5Util();
        }
        for (int x = 0; x < words.length; ++x) {
            words[x] = g_perl5Util.substitute("s#(\\||/)#\\$1#g", words[x]);
            if (sbufRegexp.length() > 0) {
                sbufRegexp.append("|");
            }
            sbufRegexp.append(words[x]);
        }
        startHighlight = g_perl5Util.substitute("s#\\/#\\\\/#g", startHighlight);
        endHighlight = g_perl5Util.substitute("s#\\/#\\\\/#g", endHighlight);
        sbufRegexp.insert(0, "s/\\b(");
        sbufRegexp.append(")\\b/");
        sbufRegexp.append(startHighlight);
        sbufRegexp.append("$1");
        sbufRegexp.append(endHighlight);
        sbufRegexp.append("/igm");
        return g_perl5Util.substitute(sbufRegexp.toString(), string);
    }

    public static final String escapeForJSON(Object in) {
        return in == null ? "" : StringUtils.escapeForJSON(in.toString());
    }

    public static final String escapeForJSON(String in) {
        return StringUtils.replace(in, new String[]{"\"", "\\", "/", "\b", "\f", "\n", "\r", "\t"}, new String[]{"\\\"", "\\\\", "\\/'", "\\b", "\\f", "\\n", "\\r", "\\t"}, null, null);
    }

    public static final String escapeForXML(Object in) {
        return in == null ? "" : StringUtils.escapeForXML(in.toString());
    }

    public static final String escapeForXML(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch != '\"') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(QUOTE_ENCODE);
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final String unescapeFromXML(String string) {
        string = StringUtils.replace(string, "&lt;", "<");
        string = StringUtils.replace(string, "&gt;", ">");
        string = StringUtils.replace(string, "&quot;", "\"");
        return StringUtils.replace(string, "&amp;", "&");
    }

    public static final String zeroPadString(String string, int length) {
        StringBuffer buf = new StringBuffer(length);
        buf.append(g_zeroArray, 0, length - string.length()).append(string);
        return buf.toString();
    }

    public static java.util.Date addDate(String time, char type, int cycle) {
        return StringUtils.addDate(StringUtils.toDate(time), type, cycle);
    }

    public static java.util.Date addDate(java.util.Date date, char type, int cycle) {
        if (date != null) {
            int calField;
            switch (type) {
                case '\u0001': 
                case 'Y': 
                case 'y': {
                    calField = 1;
                    break;
                }
                case '\u0002': 
                case 'M': 
                case 'm': {
                    calField = 2;
                    break;
                }
                case '\u0003': 
                case '\u0004': 
                case 'W': 
                case 'w': {
                    return new java.util.Date(date.getTime() + (long)cycle * 604800000L);
                }
                default: {
                    return new java.util.Date(date.getTime() + (long)cycle * 86400000L);
                }
                case '\n': 
                case 'H': 
                case 'h': {
                    return new java.util.Date(date.getTime() + (long)cycle * 3600000L);
                }
                case '\f': 
                case 'N': 
                case 'n': {
                    return new java.util.Date(date.getTime() + (long)cycle * 60000L);
                }
                case '\r': {
                    return new java.util.Date(date.getTime() + (long)cycle * 1000L);
                }
                case '\u000e': {
                    return new java.util.Date(date.getTime() + (long)cycle);
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(calField, cycle);
            return cal.getTime();
        }
        return null;
    }

    public static final String dateToMillis(java.util.Date date) {
        return StringUtils.zeroPadString(Long.toString(date.getTime()), 15);
    }

    public static final long strToNumber(String val, long defVal, String radix) {
        if (val != null && !val.equals("")) {
            String[] stringArray;
            if (radix != null && radix.length() > 0) {
                stringArray = radix.split(",|;|\uff0c|\uff1b");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "10";
                stringArray = stringArray2;
                stringArray2[1] = "16";
            }
            String[] radices = stringArray;
            int nLen = radices.length;
            for (int n = 0; n < nLen; ++n) {
                int curRadix;
                try {
                    curRadix = Integer.parseInt(radices[n].trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    return Long.parseLong(val.trim(), curRadix);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defVal;
    }

    public static final int strToNumber(String val, int defVal, String radix) {
        if (val != null && !val.equals("")) {
            String[] stringArray;
            if (radix != null && radix.length() > 0) {
                stringArray = radix.split(",|;|\uff0c|\uff1b");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "10";
                stringArray = stringArray2;
                stringArray2[1] = "16";
            }
            String[] radices = stringArray;
            int nLen = radices.length;
            for (int n = 0; n < nLen; ++n) {
                int curRadix;
                try {
                    curRadix = Integer.parseInt(radices[n].trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                try {
                    return Integer.parseInt(val.trim(), curRadix);
                }
                catch (NumberFormatException e) {
                    System.err.println("\u5b57\u7b26\u4e32\uff1a" + val + "\u8f6c\u6574\u578b\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        return defVal;
    }

    public static final String timeFormat(long time, String timeFormat) {
        SimpleDateFormat formater = new SimpleDateFormat(timeFormat == null || timeFormat.length() == 0 ? "yyyy-MM-dd HH:mm:ss" : timeFormat);
        return formater.format(new java.util.Date(time));
    }

    public static final String timeFormat(java.util.Date time, String timeFormat) {
        if (time != null) {
            SimpleDateFormat formater = new SimpleDateFormat(timeFormat == null || timeFormat.length() == 0 ? "yyyy-MM-dd HH:mm:ss" : timeFormat);
            return formater.format(time);
        }
        return "";
    }

    public static final String timeToStr(long time) {
        long week = time / 604800000L;
        long day = time % 604800000L / 86400000L;
        long hour = time % 86400000L / 3600000L;
        long minutes = time % 3600000L / 60000L;
        long second = time % 60000L / 1000L;
        long milSecond = time % 1000L;
        StringBuffer sbuf = new StringBuffer();
        if (week > 0L) {
            sbuf.append(week).append('\u5468');
        }
        if (day > 0L) {
            sbuf.append(day).append('\u5929');
        }
        if (hour > 0L) {
            sbuf.append(hour).append("\u5c0f\u65f6");
        }
        if (minutes > 0L) {
            sbuf.append(minutes).append("\u5206\u949f");
        }
        if (second > 0L) {
            sbuf.append(second).append('\u79d2');
        }
        if (milSecond > 0L) {
            sbuf.append(milSecond).append("\u6beb\u79d2");
        }
        return sbuf.toString();
    }

    public static final long strToTime(String str) {
        long curTime;
        long time = 0L;
        str = StringUtils.replace(str.toUpperCase().trim(), TIME_KEY_FIND, TIME_KEY_REPLACE);
        int lastIndex = 0;
        int curIndex = str.indexOf(21608);
        if (curIndex >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * 604800000L;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(26085)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * 86400000L;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(26102)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * 3600000L;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(20998)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * 60000L;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(31186)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * 1000L;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(27627)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime;
            lastIndex = curIndex + 1;
        } else if (curIndex < 0 && lastIndex < str.length()) {
            curTime = StringUtils.toLong(str.substring(lastIndex).trim(), 0L);
            time += curTime;
        }
        return time;
    }

    public static final long strToFlow(String str, long scale) {
        long curTime;
        long time = 0L;
        if (scale <= 0L) {
            scale = 1024L;
        }
        str = StringUtils.replace(str.toUpperCase().trim(), FLOW_KEY_FIND, FLOW_KEY_REPLACE);
        int lastIndex = 0;
        int curIndex = str.indexOf(84);
        if (curIndex >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * scale * scale * scale * scale;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(71)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * scale * scale * scale;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(77)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * scale * scale;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(75)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime * scale;
            lastIndex = curIndex + 1;
        }
        if ((curIndex = str.indexOf(66)) >= lastIndex) {
            curTime = StringUtils.toLong(str.substring(lastIndex, curIndex).trim(), 0L);
            time += curTime;
            lastIndex = curIndex + 1;
        } else if (curIndex < 0 && lastIndex < str.length()) {
            curTime = StringUtils.toLong(str.substring(lastIndex).trim(), 0L);
            time += curTime;
        }
        return time;
    }

    public static boolean toBool(String value, boolean defVal) {
        if (value == null || (value = value.trim()).length() == 0) {
            return defVal;
        }
        if (value.compareToIgnoreCase("true") == 0 || value.compareTo("1") == 0 || value.compareToIgnoreCase("Y") == 0 || value.compareToIgnoreCase("enable") == 0) {
            return true;
        }
        if (value.compareToIgnoreCase("false") == 0 || value.compareTo("0") == 0 || value.compareToIgnoreCase("N") == 0 || value.compareToIgnoreCase("disable") == 0) {
            return false;
        }
        return defVal;
    }

    public static double toDouble(String value, double defVal) {
        try {
            if (value != null && value.length() > 0) {
                return Double.parseDouble(value.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defVal;
    }

    public static float toFloat(String val, float def) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int toInt(String value, int def) {
        try {
            if (value != null && (value = value.trim()).length() > 0) {
                int dotIndex = value.indexOf(46);
                return dotIndex > 0 ? Integer.parseInt(value.substring(0, dotIndex)) : Integer.parseInt(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public static long toLong(String value, long defVal) {
        try {
            if (value != null && (value = value.trim()).length() > 0) {
                int dotIndex = value.indexOf(46);
                return dotIndex > 0 ? Long.parseLong(value.substring(0, dotIndex)) : Long.parseLong(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defVal;
    }

    public static final java.util.Date toDate(Object val) {
        if (val instanceof java.util.Date) {
            return (java.util.Date)val;
        }
        if (val instanceof Date) {
            Date date = (Date)val;
            new java.util.Date(date.getTime());
        } else if (val != null) {
            return StringUtils.toDate(val.toString());
        }
        return null;
    }

    public static final java.util.Date toDate(String source) {
        int n;
        if (source == null || (source = source.trim()).length() == 0) {
            return null;
        }
        char timeZoneChar = (source = StringUtils.replace(source, new String[]{"\uff1a", "\u3000"}, new String[]{":", " "})).charAt(source.length() - 1);
        boolean isGMT = timeZoneChar == 'Z' || timeZoneChar == 'z';
        for (n = 0; n < g_stringToDateFixFormatLens.length; ++n) {
            if (g_stringToDateFixFormatLens[n] != source.length()) continue;
            try {
                SimpleDateFormat formater = new SimpleDateFormat(g_stringToDateFixFormats[n]);
                if (isGMT) {
                    formater.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
                return formater.parse(source.trim());
            }
            catch (Exception exception) {
                break;
            }
        }
        for (n = 0; n < g_stringToDateFormats.length; ++n) {
            try {
                SimpleDateFormat formater = new SimpleDateFormat(g_stringToDateFormats[n]);
                return formater.parse(source.trim());
            }
            catch (Exception exception) {
                continue;
            }
        }
        for (n = 0; n < g_stringToDateFormatWithLocales.length; ++n) {
            try {
                SimpleDateFormat formater = new SimpleDateFormat(g_stringToDateFormatWithLocales[n], Locale.CHINESE);
                return formater.parse(source.trim());
            }
            catch (Exception exception) {
                try {
                    SimpleDateFormat formater = new SimpleDateFormat(g_stringToDateFormatWithLocales[n], Locale.US);
                    return formater.parse(source.trim());
                }
                catch (Exception exception2) {
                    continue;
                }
            }
        }
        return null;
    }

    public static final java.util.Date toDate(String source, String format, FixTimeType fixTime) {
        if (source != null && (source = source.trim()).length() > 0) {
            java.util.Date time;
            if (format == null || (format = format.trim()).length() == 0) {
                time = StringUtils.toDate(source);
            } else {
                char timeZoneChar = source.charAt(source.length() - 1);
                boolean isGMT = timeZoneChar == 'Z' || timeZoneChar == 'z';
                SimpleDateFormat formater = new SimpleDateFormat(format);
                if (isGMT) {
                    formater.setTimeZone(TimeZone.getTimeZone("GMT"));
                }
                try {
                    time = formater.parse(source.trim());
                }
                catch (ParseException e) {
                    log.debug("\u5b57\u7b26\u4e32\uff1a{} \u6309\u683c\u5f0f\uff1a{} \u8f6c\u6362\u4e3a\u65e5\u671f\u5931\u8d25\uff1a{}", new Object[]{source, format, e.getMessage()});
                    return null;
                }
            }
            if (fixTime != null) {
                return fixTime.fix(time);
            }
            return time;
        }
        return null;
    }

    public static final long toDateLong(String src) {
        java.util.Date date = StringUtils.toDate(src);
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static final String toString(Object val) {
        if (val == null) {
            return "";
        }
        if (val.getClass().getSimpleName().equals("BasicDBObject")) {
            return val.toString();
        }
        if (val.getClass().isArray()) {
            Object[] lst = Util.toArray(val);
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('[');
            int size = lst.length;
            for (int n = 0; n < size; ++n) {
                Object obj = lst[n];
                if (n > 0) {
                    sbuf.append(", ");
                }
                if (obj instanceof String) {
                    sbuf.append('\"').append(obj).append('\"');
                    continue;
                }
                if (obj instanceof Byte) {
                    sbuf.append(StringUtils.byteToUnsignedString((Byte)obj, 4));
                    continue;
                }
                sbuf.append(StringUtils.toString(obj));
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        if (val instanceof Collection) {
            Collection lst = (Collection)val;
            int n = 0;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('[');
            for (Object item : lst) {
                if (n > 0) {
                    sbuf.append(", ");
                }
                if (item instanceof String) {
                    sbuf.append('\"').append(item).append('\"');
                } else if (item instanceof Byte) {
                    sbuf.append(StringUtils.byteToUnsignedString((Byte)item, 4));
                } else {
                    sbuf.append(StringUtils.toString(item));
                }
                ++n;
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        if (val instanceof Enumeration) {
            Enumeration enu = (Enumeration)val;
            int n = 0;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('[');
            while (enu.hasMoreElements()) {
                Object item = enu.nextElement();
                if (n > 0) {
                    sbuf.append(", ");
                }
                if (item instanceof String) {
                    sbuf.append('\"').append(item).append('\"');
                } else if (item instanceof Byte) {
                    sbuf.append(StringUtils.byteToUnsignedString((Byte)item, 4));
                } else {
                    sbuf.append(StringUtils.toString(item));
                }
                ++n;
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        if (val instanceof List) {
            List lst = (List)val;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('[');
            int size = lst.size();
            for (int n = 0; n < size; ++n) {
                Object obj = lst.get(n);
                if (n > 0) {
                    sbuf.append(", ");
                }
                if (obj instanceof String) {
                    sbuf.append('\"').append(obj).append('\"');
                    continue;
                }
                if (obj instanceof Byte) {
                    sbuf.append(StringUtils.byteToUnsignedString((Byte)obj, 4));
                    continue;
                }
                sbuf.append(StringUtils.toString(obj));
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            int n = 0;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('{');
            for (Object key : map.keySet()) {
                Object item = map.get(key);
                if (n > 0) {
                    sbuf.append(", ");
                }
                if (key instanceof String) {
                    sbuf.append('\"').append(key).append('\"');
                } else {
                    sbuf.append(StringUtils.toString(key));
                }
                sbuf.append('=');
                if (item instanceof String) {
                    sbuf.append('\"').append(item).append('\"');
                } else if (item instanceof Byte) {
                    sbuf.append(StringUtils.byteToUnsignedString((Byte)item, 4));
                } else {
                    sbuf.append(StringUtils.toString(item));
                }
                ++n;
            }
            sbuf.append('}');
            return sbuf.toString();
        }
        if (val instanceof Date) {
            Date dt = (Date)val;
            return StringUtils.timeFormat(dt.getTime(), "yyyy-MM-dd HH:mm:ss.S");
        }
        if (val instanceof java.util.Date) {
            return StringUtils.timeFormat((java.util.Date)val, "yyyy-MM-dd HH:mm:ss.S");
        }
        if (val instanceof Byte) {
            return StringUtils.byteToUnsignedString((Byte)val, 4);
        }
        if (val instanceof Number) {
            return new BigDecimal(((Number)val).doubleValue()).toPlainString();
        }
        if (val instanceof Cookie) {
            Cookie cok = (Cookie)val;
            return String.format("%s:%s", cok.getName(), cok.getValue());
        }
        return String.valueOf(val);
    }

    public static final boolean isContainNotAscii(String in) {
        if (in == null) {
            return false;
        }
        for (int n = 0; n < in.length(); ++n) {
            char ch = in.charAt(n);
            char[] chars = new char[]{ch};
            byte[] uniCode = new String(chars).getBytes();
            if (uniCode[0] < 128 && uniCode[0] > 0) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEmpty(String in) {
        return in == null || in.trim().length() == 0 || in.trim().equalsIgnoreCase("null");
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static final boolean isTrue(String val) {
        return "1".equals(val) || "y".equalsIgnoreCase(val) || "true".equalsIgnoreCase(val) || "enable".equalsIgnoreCase(val);
    }

    public static final boolean isFalse(String val) {
        return "0".equals(val) || "n".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val) || "disable".equalsIgnoreCase(val);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int n = 0; n < sz; ++n) {
            if (Character.isDigit(cs.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static final String native2Ascii(String in) {
        char[] chars = in.toCharArray();
        StringBuffer sbuf = new StringBuffer();
        for (int n = 0; n < chars.length; ++n) {
            sbuf.append(StringUtils.char2Ascii(chars[n]));
        }
        return sbuf.toString();
    }

    public static final String numberToStr(double val, int scale) {
        return StringUtils.numberToStr(val, scale, ',');
    }

    public static final String numberToStr(double val, int scale, char delimiter) {
        StringBuffer sbuf = new StringBuffer();
        if (scale < 0) {
            scale = 0;
        }
        StringBuffer format = new StringBuffer(scale + 3);
        format.append('0');
        if (scale > 0) {
            format.append('.');
            for (int n = 0; n < scale; ++n) {
                format.append('0');
            }
        }
        sbuf.append(new DecimalFormat(format.toString()).format(val));
        int dotIndex = sbuf.indexOf(".");
        if (dotIndex < 0) {
            dotIndex = sbuf.length();
        } else if (dotIndex == sbuf.length() - 2 && sbuf.charAt(sbuf.length() - 1) == '0') {
            sbuf.delete(dotIndex, sbuf.length());
        }
        if (sbuf.length() > dotIndex + 2) {
            sbuf.delete(dotIndex + scale + 1, sbuf.length());
        }
        if (delimiter != '\u0000') {
            int comma = dotIndex / 3 - 1;
            int m = dotIndex % 3;
            if (m > 0 && (val > 0.0 || m > 1)) {
                ++comma;
            }
            for (int n = 1; n <= comma; ++n) {
                sbuf.insert(dotIndex - n * 3, delimiter);
            }
        }
        return sbuf.toString();
    }

    public static final String numberToStr(double val, int scale, String language) {
        String value;
        int dotIndex;
        StringBuffer sbuf = new StringBuffer(StringUtils.numberToStr(new Double(val).longValue(), language));
        if (scale > 0 && (dotIndex = (value = new BigDecimal(val).toPlainString()).indexOf(46)) > 0) {
            char curChar;
            sbuf.append('\u70b9');
            for (int n = dotIndex + 1; scale > 0 && n < value.length(); ++n, --scale) {
                int nNum = value.charAt(n) - 48;
                sbuf.append(g_chineseNumbers[nNum]);
            }
            while ((curChar = sbuf.charAt(sbuf.length() - 1)) == g_chineseNumbers[0] || curChar == '\u70b9') {
                sbuf.deleteCharAt(sbuf.length() - 1);
            }
        }
        return sbuf.toString();
    }

    public static final String numberToStr(long val) {
        StringBuffer result = new StringBuffer();
        result.append(new BigDecimal(val).toPlainString());
        int len = result.length();
        int comma = len / 3 - 1;
        int m = len % 3;
        if (m > 0 && (val > 0L || m > 1)) {
            ++comma;
        }
        for (int n = 1; n <= comma; ++n) {
            result.insert(len - n * 3, ',');
        }
        return result.toString();
    }

    public static final String numberToStr(long val, int minLen) {
        return StringUtils.numberToStr(val, minLen, '0', 0);
    }

    public static final String numberToStr(long val, int minLen, char fillChar) {
        return StringUtils.numberToStr(val, minLen, fillChar, 0);
    }

    public static final String numberToStr(long val, int minLen, char fillChar, int fillType) {
        StringBuffer sbuf = new StringBuffer();
        boolean isFillLeft = true;
        sbuf.append(new BigDecimal(val).toPlainString());
        while (sbuf.length() < minLen) {
            switch (fillType) {
                case 0: {
                    sbuf.insert(0, fillChar);
                    break;
                }
                case 1: {
                    sbuf.append(fillChar);
                    break;
                }
                case 2: {
                    if (isFillLeft) {
                        sbuf.insert(0, fillChar);
                    } else {
                        sbuf.append(fillChar);
                    }
                    isFillLeft = !isFillLeft;
                }
            }
        }
        return sbuf.toString();
    }

    public static final String numberToStr(long val, String language) {
        StringBuffer sbuf = new StringBuffer();
        long input = Math.abs(val);
        long curVal = input / 100000000L;
        if (curVal > 0L) {
            if (curVal >= 10L) {
                sbuf.append(curVal);
            } else {
                sbuf.append(g_chineseNumbers[(int)curVal]);
            }
            sbuf.append('\u4ebf');
        }
        boolean isWant = false;
        curVal = input % 100000000L / 10000000L;
        if (curVal > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]).append('\u5343');
            isWant = true;
        }
        if ((curVal = input % 10000000L / 1000000L) > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]).append('\u767e');
            isWant = true;
        } else if (input % 100000000L / 10000000L > 0L && input % 1000000L / 100000L > 0L) {
            sbuf.append(g_chineseNumbers[0]);
        }
        curVal = input % 1000000L / 100000L;
        if (curVal > 0L) {
            if (curVal != 1L || sbuf.length() > 0) {
                sbuf.append(g_chineseNumbers[(int)curVal]);
            }
            sbuf.append('\u5341');
            isWant = true;
        } else if ((input % 100000000L / 10000000L > 0L || input % 10000000L / 1000000L > 0L) && input % 100000L / 10000L > 0L) {
            sbuf.append(g_chineseNumbers[0]);
        }
        curVal = input % 100000L / 10000L;
        if (curVal > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]);
            isWant = true;
        }
        if (isWant) {
            sbuf.append('\u4e07');
        }
        if ((curVal = input % 10000L / 1000L) > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]).append('\u5343');
        }
        if ((curVal = input % 1000L / 100L) > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]).append('\u767e');
        } else if (input % 10000L / 1000L > 0L && input % 100L / 10L > 0L) {
            sbuf.append(g_chineseNumbers[0]);
        }
        curVal = input % 100L / 10L;
        if (curVal > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]).append('\u5341');
        } else if ((input % 10000L / 1000L > 0L || input % 1000L / 100L > 0L) && input % 10L > 0L) {
            sbuf.append(g_chineseNumbers[0]);
        }
        curVal = input % 10L;
        if (curVal > 0L) {
            sbuf.append(g_chineseNumbers[(int)curVal]);
        }
        if (val < 0L) {
            sbuf.insert(0, '\u8d1f');
        }
        return sbuf.toString();
    }

    private static final String char2Ascii(char ch) {
        if (ch > '\u00ff') {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(PREFIX);
            int code = ch >> 8;
            String curVal = Integer.toHexString(code);
            if (curVal.length() == 1) {
                sbuf.append('0');
            }
            sbuf.append(curVal);
            code = ch & 0xFF;
            curVal = Integer.toHexString(code);
            if (curVal.length() == 1) {
                sbuf.append('0');
            }
            sbuf.append(curVal);
            return sbuf.toString();
        }
        return Character.toString(ch);
    }

    public static final String ascii2Native(String in) {
        return StringUtils.ascii2Native(in, null);
    }

    public static final String ascii2Native(String in, String encoding) {
        StringBuffer sbuf = new StringBuffer();
        int begin = 0;
        int index = in.indexOf(PREFIX);
        while (index != -1) {
            sbuf.append(in.substring(begin, index));
            try {
                char ch;
                String strNum = in.substring(index, index + 6).toLowerCase();
                boolean isNum = true;
                for (int n = 0; n < strNum.length(); ++n) {
                    ch = strNum.charAt(n);
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') continue;
                    isNum = false;
                    break;
                }
                if (isNum) {
                    ch = StringUtils.ascii2Char(strNum);
                    if (encoding == null) {
                        sbuf.append(ch);
                    } else {
                        try {
                            sbuf.append(new String(String.valueOf(ch).getBytes(), encoding));
                        }
                        catch (Exception n) {}
                    }
                } else {
                    sbuf.append(in.substring(index, index + 6));
                }
            }
            catch (NumberFormatException eNum) {
                sbuf.append(in.substring(index, index + 6));
                System.err.println("\u6570\u5b57\u8f6c\u6362\u5931\u8d25\u4e0d\u80fd\u628a\"" + in + "\"\u8f6c\u4e3a\u672c\u5730\u4ee3\u7801\u3002");
            }
            catch (Exception e) {
                sbuf.append(in.substring(index, index + 6));
                System.err.println("\u8f6c\u6362\"" + in + "\"\u4e3a\u672c\u5730\u4ee3\u7801\u65f6\u5f02\u5e38\u3002");
                e.printStackTrace();
            }
            begin = index + 6;
            index = in.indexOf(PREFIX, begin);
        }
        sbuf.append(in.substring(begin));
        return sbuf.toString();
    }

    private static final char ascii2Char(String strIn) {
        if (strIn.length() != 6) {
            throw new IllegalArgumentException("Ascii string of a native character must be 6 character.");
        }
        if (!PREFIX.equals(strIn.substring(0, 2))) {
            throw new IllegalArgumentException("Ascii string of a native character must start with \"\\u\".");
        }
        String strTmp = strIn.substring(2, 4);
        int nCode = Integer.parseInt(strTmp.trim(), 16) << 8;
        strTmp = strIn.substring(4, 6);
        return (char)(nCode += Integer.parseInt(strTmp.trim(), 16));
    }

    public static String normalizePath(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private static void encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = NUMBER_LETTER_64[inBuff >>> 18];
                destination[destOffset + 1] = NUMBER_LETTER_64[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = NUMBER_LETTER_64[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = NUMBER_LETTER_64[inBuff & 0x3F];
                break;
            }
            case 2: {
                destination[destOffset] = NUMBER_LETTER_64[inBuff >>> 18];
                destination[destOffset + 1] = NUMBER_LETTER_64[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = NUMBER_LETTER_64[inBuff >>> 6 & 0x3F];
                break;
            }
            case 1: {
                destination[destOffset] = NUMBER_LETTER_64[inBuff >>> 18];
                destination[destOffset + 1] = NUMBER_LETTER_64[inBuff >>> 12 & 0x3F];
                break;
            }
        }
    }

    public static String toNumberLetterString(byte[] bytes) {
        int len;
        if (bytes != null && (len = bytes.length) > 0) {
            int len2 = len * 8;
            int count = len2 / 6 + (len2 % 6 > 0 ? 1 : 0);
            byte[] buffer = new byte[count];
            int d = 0;
            int e = 0;
            len2 = len - 2;
            while (d < len2) {
                StringUtils.encode3to4(bytes, d, 3, buffer, e);
                d += 3;
                e += 4;
            }
            if (d < len) {
                StringUtils.encode3to4(bytes, d, len - d, buffer, e);
                e += 4;
            }
            return new String(buffer);
        }
        return "";
    }

    public static boolean hasNoASCII(String strIn) {
        if (strIn != null && strIn.length() > 0) {
            for (int n = 0; n < strIn.length(); ++n) {
                char nCh = strIn.charAt(n);
                if (nCh >= ' ' && nCh < '\u007f') continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String strData = "<test \r\nTest/>\r";
        long lData = System.currentTimeMillis() + 25806550L;
        System.out.println("Long: " + lData + "Hex: " + Long.toHexString(lData) + (lData == StringUtils.strToNumber(Long.toHexString(lData), -1L, "16") ? "\u76f8\u7b49" : "\u4e0d\u540c:" + StringUtils.strToNumber(Long.toHexString(lData), -1L, "16")) + (lData > System.currentTimeMillis() ? " \u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u503c\uff1a" + System.currentTimeMillis() + "Hex: " + Long.toHexString(412904800L) : " \u6709\u95ee\u9898\uff01") + " \u6700\u5927\u503c\uff1a" + Long.toHexString(Long.MAX_VALUE));
        System.out.println("numberToStr(100)\t=" + StringUtils.numberToStr(100L));
        System.out.println("numberToStr(1000)\t=" + StringUtils.numberToStr(1000L));
        System.out.println("numberToStr(10000)\t=" + StringUtils.numberToStr(10000L));
        System.out.println("numberToStr(100000)\t=" + StringUtils.numberToStr(100000L));
        System.out.println("numberToStr(1000000)\t=" + StringUtils.numberToStr(1000000L));
        System.out.println("numberToStr(100.0)\t=" + StringUtils.numberToStr(100.00111, 2));
        System.out.println("numberToStr(1000)\t=" + StringUtils.numberToStr(6787L, 2));
        System.out.println("numberToStr(10000)\t=" + StringUtils.numberToStr(10000.33, 2));
        System.out.println("numberToStr(100000)\t=" + StringUtils.numberToStr(100000.456, 2));
        System.out.println("numberToStr(1000000)\t=" + StringUtils.numberToStr(1000000.7891, 3));
        System.out.println("numberToStr(100)\t=" + StringUtils.numberToStr(100L, "cn"));
        System.out.println("numberToStr(1000)\t=" + StringUtils.numberToStr(1000L, "cn"));
        System.out.println("numberToStr(10000)\t=" + StringUtils.numberToStr(10000L, "cn"));
        System.out.println("numberToStr(100000)\t=" + StringUtils.numberToStr(100000L, "cn"));
        System.out.println("numberToStr(1000000)\t=" + StringUtils.numberToStr(1000000L, "cn"));
        System.out.println("numberToStr(10000000)\t=" + StringUtils.numberToStr(10000000L, "cn"));
        System.out.println("numberToStr(100000000)\t=" + StringUtils.numberToStr(100000000L, "cn"));
        System.out.println("numberToStr(1000000000)\t=" + StringUtils.numberToStr(1000000000L, "cn"));
        System.out.println("numberToStr(10000000000)\t=" + StringUtils.numberToStr(1410065408L, "cn"));
        System.out.println("numberToStr(100000000000)\t=" + StringUtils.numberToStr(1215752192L, "cn"));
        System.out.println("numberToStr(100.0)\t=" + StringUtils.numberToStr(100.00111, 2, "cn"));
        System.out.println("numberToStr(1000)\t=" + StringUtils.numberToStr(6787.0, 2, "cn"));
        System.out.println("numberToStr(10000)\t=" + StringUtils.numberToStr(10000.33, 2, "cn"));
        System.out.println("numberToStr(100000)\t=" + StringUtils.numberToStr(100000.456, 2, "cn"));
        System.out.println("numberToStr(1000000)\t=" + StringUtils.numberToStr(1000000.7891, 3, "cn"));
        System.out.println("strData=" + strData + "\r\nescapeHTMLTags=" + StringUtils.escapeHTMLTags(strData));
        System.out.println("escapeForXML=" + StringUtils.escapeForXML(strData));
        lData = System.currentTimeMillis();
        System.out.println("lData=" + lData);
        strData = new SimpleDateFormat("yyyy-M-d H:m:s").format(new java.util.Date(lData));
        System.out.println("String: " + strData);
        strData = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").format(new java.util.Date(lData));
        System.out.println("String: " + strData);
        lData = StringUtils.toDateLong(strData);
        System.out.println("lData=" + lData);
        strData = "20060215";
        lData = StringUtils.toDateLong(strData);
        System.out.println("\u539f\u59cb\u65e5\u671f\uff1a" + strData + " lData=" + lData);
        strData = new SimpleDateFormat("yyyy-M-d H:m:s.S").format(new java.util.Date(lData));
        System.out.println("String: " + strData);
    }

    public static String byteToUnsignedString(byte by, int shift) {
        char[] buf = new char[8];
        int charPos = 8;
        int radix = 1 << shift;
        int mask = radix - 1;
        int i = by & 0xFF;
        int min = 8 / shift + (8 % shift > 0 ? 1 : 0);
        do {
            buf[--charPos] = g_digits[i & mask];
        } while ((i >>>= shift) != 0);
        while (8 - charPos < min) {
            buf[--charPos] = 48;
        }
        return new String(buf, charPos, 8 - charPos);
    }

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (Exception e) {
            log.error("{}\u8f6c\u4e3a\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a{}", new Object[]{StringUtils.toString(bytes), e.getMessage(), e});
            return null;
        }
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, "UTF-8");
    }

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u83b7\u53d6\u5b57\u7b26\u4e32\uff1a{} \u5b57\u8282\u5f02\u5e38\uff1a{}", new Object[]{string, e.getMessage(), e});
            return null;
        }
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, Charset.forName("UTF-8"));
    }
}

