/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringList
implements List<String>,
Cloneable,
Serializable {
    public static final long serialVersionUID = 2L;
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.util.StringList");
    private String[] m_arrayElements;
    private int m_nCapacity;
    private int m_nSize;
    private byte[] m_objLock = new byte[0];

    public StringList() {
        this(5);
    }

    public StringList(List<?> lstData) {
        if (lstData == null || lstData.size() == 0) {
            this.m_nSize = 0;
            this.m_nCapacity = 10;
            this.m_arrayElements = new String[this.m_nCapacity];
        } else {
            this.m_nSize = lstData.size();
            this.m_nCapacity = this.m_nSize + 10;
            this.m_arrayElements = new String[this.m_nCapacity];
            for (int n = 0; n < this.m_nSize; ++n) {
                this.m_arrayElements[n] = lstData.get(n).toString();
            }
        }
    }

    public StringList(Set<?> datas) {
        if (datas == null || datas.size() == 0) {
            this.m_nSize = 0;
            this.m_nCapacity = 10;
            this.m_arrayElements = new String[this.m_nCapacity];
        } else {
            Iterator<?> iterData = datas.iterator();
            this.m_nSize = datas.size();
            this.m_nCapacity = this.m_nSize + 10;
            this.m_arrayElements = new String[this.m_nCapacity];
            int n = 0;
            while (iterData.hasNext()) {
                this.m_arrayElements[n] = iterData.next().toString();
                ++n;
            }
        }
    }

    public StringList(String[] arrayData) {
        if (arrayData == null || arrayData.length == 0) {
            this.m_nSize = 0;
            this.m_nCapacity = 5;
            this.m_arrayElements = new String[this.m_nCapacity];
        } else {
            this.m_nSize = arrayData.length;
            this.m_nCapacity = this.m_nSize + 10;
            this.m_arrayElements = new String[this.m_nCapacity];
            System.arraycopy(arrayData, 0, this.m_arrayElements, 0, arrayData.length);
        }
    }

    public StringList(int nInitialCapacity) {
        this.m_nSize = 0;
        this.m_nCapacity = nInitialCapacity > 5 ? nInitialCapacity + 1 : 5;
        this.m_arrayElements = new String[this.m_nCapacity];
    }

    public Object clone() {
        Object objResult;
        try {
            objResult = super.clone();
            if (objResult instanceof StringList) {
                StringList lstNewData = (StringList)objResult;
                lstNewData.m_nSize = this.m_nSize;
                lstNewData.m_nCapacity = this.m_nCapacity;
                lstNewData.m_arrayElements = (String[])this.m_arrayElements.clone();
            }
        }
        catch (Exception e) {
            StringList lstNewData = new StringList(this.m_nCapacity - 1);
            lstNewData.m_nSize = this.m_nSize;
            lstNewData.m_nCapacity = this.m_nCapacity;
            System.arraycopy(this.m_arrayElements, 0, lstNewData.m_arrayElements, 0, this.m_arrayElements.length);
            return lstNewData;
        }
        return objResult;
    }

    @Override
    public boolean equals(Object objList) {
        if (this == objList) {
            return true;
        }
        if (objList instanceof StringList) {
            StringList objAnother = (StringList)objList;
            if (this.size() == objAnother.size()) {
                for (int n = 0; n < this.size(); ++n) {
                    if (objAnother.get(n).equals(this.get(n))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void ensureCapacity(int nMinCapacity) {
        if (nMinCapacity <= this.m_nCapacity) return;
        String[] arrayNewElements = new String[nMinCapacity];
        System.arraycopy(this.m_arrayElements, 0, arrayNewElements, 0, this.m_nSize);
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.m_nCapacity = nMinCapacity;
            this.m_arrayElements = arrayNewElements;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(String strValue) {
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.m_arrayElements[this.m_nSize] = strValue;
            ++this.m_nSize;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.m_nSize == this.m_nCapacity) {
                this.ensureCapacity(this.m_nCapacity * 2);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfNotContains(String value) {
        if (value != null) {
            for (int n = 0; n < this.m_nSize; ++n) {
                if (!value.equals(this.m_arrayElements[n])) continue;
                return false;
            }
        }
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.m_arrayElements[this.m_nSize] = value;
            ++this.m_nSize;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            if (this.m_nSize == this.m_nCapacity) {
                this.ensureCapacity(this.m_nCapacity * 2);
            }
            return true;
        }
    }

    public StringList append(String strValue) {
        this.add(strValue);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringList append(StringBuffer sbufValue) {
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.m_arrayElements[this.m_nSize] = sbufValue.toString();
            ++this.m_nSize;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.m_nSize == this.m_nCapacity) {
                this.ensureCapacity(this.m_nCapacity * 2);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringList add(String[] arrayValue) {
        if (arrayValue == null || arrayValue.length <= 0) return this;
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.ensureCapacity(this.m_nSize + arrayValue.length + 1);
            System.arraycopy(arrayValue, 0, this.m_arrayElements, 0, arrayValue.length);
            this.m_nSize += arrayValue.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringList add(StringList lstValue) {
        if (lstValue == null || lstValue.m_nSize <= 0) return this;
        byte[] byArray = this.m_objLock;
        synchronized (this.m_objLock) {
            this.ensureCapacity(this.m_nSize + lstValue.m_nSize + 1);
            System.arraycopy(lstValue.m_arrayElements, 0, this.m_arrayElements, this.m_nSize, lstValue.m_nSize);
            this.m_nSize += lstValue.m_nSize;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    @Override
    public void clear() {
        this.m_nSize = 0;
    }

    public String getString(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_nSize) {
            throw new IndexOutOfBoundsException("Index " + nIndex + " not valid.");
        }
        return this.m_arrayElements[nIndex];
    }

    @Override
    public final String get(int nIndex) {
        return this.getString(nIndex);
    }

    @Override
    public String set(int nIndex, String strData) {
        if (nIndex < 0 || nIndex >= this.m_nSize) {
            throw new IndexOutOfBoundsException("Index " + nIndex + " not valid.");
        }
        String previously = this.m_arrayElements[nIndex];
        this.m_arrayElements[nIndex] = strData;
        return previously;
    }

    @Override
    public String remove(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_nSize) {
            return null;
        }
        String previously = this.m_arrayElements[nIndex];
        for (int i = nIndex + 1; i < this.m_nSize; ++i) {
            this.m_arrayElements[i - 1] = this.m_arrayElements[i];
        }
        --this.m_nSize;
        return previously;
    }

    public boolean remove(String strData) {
        for (int i = 0; i < this.m_nSize; ++i) {
            if (!this.m_arrayElements[i].equals(strData)) continue;
            for (int j = i + 1; j < this.m_nSize; ++j) {
                this.m_arrayElements[j - 1] = this.m_arrayElements[j];
            }
            --this.m_nSize;
            return true;
        }
        return false;
    }

    @Override
    public final int size() {
        return this.m_nSize;
    }

    public String[] toStringArray() {
        int size = this.m_nSize;
        String[] newElements = new String[size];
        for (int i = 0; i < size; ++i) {
            newElements[i] = this.m_arrayElements[i];
        }
        return newElements;
    }

    @Override
    public final Object[] toArray() {
        return this.toStringArray();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('[');
        for (int i = 0; i < this.m_nSize; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            if (this.m_arrayElements[i] == null) {
                sbuf.append("null");
                continue;
            }
            sbuf.append('\"').append(this.m_arrayElements[i]).append('\"');
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public void sort() {
        this.sort(false);
    }

    public void sort(boolean bDesc) {
        StringList.sort(this.m_arrayElements, this.m_nSize, bDesc);
    }

    public static String[] sort(String[] arrayStr) {
        return StringList.sort(arrayStr, false);
    }

    public static String[] sort(String[] arrayStr, boolean bDesc) {
        if (arrayStr != null) {
            return StringList.sort(arrayStr, arrayStr.length, bDesc);
        }
        return null;
    }

    public static String[] sort(String[] arrayStr, int nSize, boolean bDesc) {
        if (arrayStr == null || arrayStr.length == 0) {
            return arrayStr;
        }
        String strTemp = arrayStr[0];
        if (nSize > arrayStr.length) {
            nSize = arrayStr.length;
        }
        if (!bDesc) {
            for (int i = 0; i < nSize - 1; ++i) {
                for (int j = i + 1; j < nSize; ++j) {
                    if (arrayStr[i].compareTo(arrayStr[j]) <= 0) continue;
                    strTemp = arrayStr[i];
                    arrayStr[i] = arrayStr[j];
                    arrayStr[j] = strTemp;
                }
            }
        } else {
            for (int i = 0; i < nSize - 1; ++i) {
                for (int j = i + 1; j < nSize; ++j) {
                    if (arrayStr[i].compareTo(arrayStr[j]) >= 0) continue;
                    strTemp = arrayStr[i];
                    arrayStr[i] = arrayStr[j];
                    arrayStr[j] = strTemp;
                }
            }
        }
        return arrayStr;
    }

    public boolean containsValue(String strData) {
        return this.contains(strData);
    }

    public boolean contains(String str) {
        if (str != null) {
            for (int n = 0; n < this.m_nSize; ++n) {
                if (!str.equals(this.m_arrayElements[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String strData, boolean bIgnoreCase) {
        if (strData != null) {
            for (int n = 0; n < this.m_nSize; ++n) {
                if (!(bIgnoreCase ? strData.equalsIgnoreCase(this.m_arrayElements[n]) : strData.equals(this.m_arrayElements[n]))) continue;
                return true;
            }
        }
        return false;
    }

    public void insert(int nIndex, String strValue) {
        if (nIndex >= 0) {
            if (nIndex >= this.m_nSize) {
                this.add(strValue);
            } else {
                for (int n = this.m_nSize; n > nIndex; --n) {
                    this.m_arrayElements[n] = this.m_arrayElements[n - 1];
                }
                this.m_arrayElements[nIndex] = strValue;
                ++this.m_nSize;
                if (this.m_nSize == this.m_nCapacity) {
                    this.ensureCapacity(this.m_nCapacity * 2);
                }
            }
        } else {
            log.error("\u8c03\u7528insert\u9519\u8bef\uff01\u6307\u5b9a\u7684\u4f4d\u7f6e\u4e3a" + nIndex);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public void add(int nIndex, String strElement) {
        if (nIndex > this.m_nSize || nIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + nIndex + ", Size: " + this.m_nSize);
        }
        this.ensureCapacity(this.m_nSize + 2);
        System.arraycopy(this.m_arrayElements, nIndex, this.m_arrayElements, nIndex + 1, this.m_nSize - nIndex);
        this.m_arrayElements[nIndex] = strElement;
        ++this.m_nSize;
    }

    @Override
    public boolean addAll(Collection c) {
        String[] a = c.toArray(new String[0]);
        int numNew = a.length;
        this.ensureCapacity(this.m_nSize + numNew + 1);
        System.arraycopy(a, 0, this.m_arrayElements, this.m_nSize, numNew);
        this.m_nSize += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        if (index > this.m_nSize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_nSize);
        }
        String[] a = c.toArray(new String[0]);
        int numNew = a.length;
        this.ensureCapacity(this.m_nSize + numNew + 1);
        int numMoved = this.m_nSize - index;
        if (numMoved > 0) {
            System.arraycopy(this.m_arrayElements, index, this.m_arrayElements, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.m_arrayElements, index, numNew);
        this.m_nSize += numNew;
        return numNew != 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.contains((String)o);
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int n = 0; n < this.m_nSize; ++n) {
            if ((o != null || this.m_arrayElements[n] != null) && !this.m_arrayElements[n].equals((String)o)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public Iterator<String> iterator() {
        return new ListItr(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int n = this.m_nSize - 1; n >= 0; --n) {
            if ((o != null || this.m_arrayElements[n] != null) && !this.m_arrayElements[n].equals((String)o)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public final ListIterator<String> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public final boolean remove(Object o) {
        return this.remove((String)o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        StringList lstResult = new StringList(this.m_nSize);
        for (int n = 0; n < this.m_nSize; ++n) {
            if (!c.contains(this.m_arrayElements[n])) {
                lstResult.add(this.m_arrayElements[n]);
                continue;
            }
            modified = true;
        }
        if (modified) {
            this.m_arrayElements = lstResult.m_arrayElements;
            this.m_nCapacity = lstResult.m_nCapacity;
            this.m_nSize = lstResult.m_nSize;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        StringList lstResult = new StringList(this.m_nSize);
        for (int n = 0; n < this.m_nSize; ++n) {
            if (c.contains(this.m_arrayElements[n])) {
                lstResult.add(this.m_arrayElements[n]);
                continue;
            }
            modified = true;
        }
        if (modified) {
            this.m_arrayElements = lstResult.m_arrayElements;
            this.m_nCapacity = lstResult.m_nCapacity;
            this.m_nSize = lstResult.m_nSize;
        }
        return modified;
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.m_nSize) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        StringList lstResult = new StringList(toIndex - fromIndex);
        System.arraycopy(this.m_arrayElements, fromIndex, lstResult.m_arrayElements, 0, toIndex - fromIndex);
        lstResult.m_nSize = toIndex - fromIndex;
        return lstResult;
    }

    @Override
    public final Object[] toArray(Object[] a) {
        return this.toStringArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<String> {
        private int m_nCursor = 0;
        private int m_nLastRet = -1;

        ListItr(int index) {
            this.m_nCursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.m_nCursor != 0;
        }

        @Override
        public String previous() {
            try {
                int i = this.m_nCursor - 1;
                String previous = StringList.this.get(i);
                this.m_nLastRet = this.m_nCursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.m_nCursor;
        }

        @Override
        public int previousIndex() {
            return this.m_nCursor - 1;
        }

        @Override
        public void set(String o) {
            if (this.m_nLastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                StringList.this.set(this.m_nLastRet, o);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(String o) {
            try {
                StringList.this.add(this.m_nCursor++, o);
                this.m_nLastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_nCursor != StringList.this.size();
        }

        @Override
        public String next() {
            try {
                String next = StringList.this.get(this.m_nCursor);
                this.m_nLastRet = this.m_nCursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.m_nLastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                StringList.this.remove(this.m_nLastRet);
                if (this.m_nLastRet < this.m_nCursor) {
                    --this.m_nCursor;
                }
                this.m_nLastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

