/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import com.hynnet.util.RefreshChecker;
import com.hynnet.util.RefreshTask;
import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.RefreshThread");
    private Hashtable m_lstTask = new Hashtable();
    private byte[] m_objSyncTask = new byte[0];
    private final long m_lInterval = 2000L;
    private long m_lRefreshInterval = 300L;
    private long m_lGetAllLinkInterval = 100L;
    private String m_strErrorMessage;
    private RefreshTask m_objCurrentTask;
    private long m_lProcTotal = 0L;
    private long m_lStartTime;
    private long m_lProcTotalTime = 0L;
    private boolean m_bCompleteAll = true;
    private FJTaskRunnerGroup m_objExecutor;
    private FJTaskRunnerGroup m_objSearchExecutor;
    private int m_nPoolSize;
    private int m_nSearchPoolSize;
    private byte[] m_objSyncCurTask = new byte[0];
    private RefreshChecker m_objChecker;
    private RefreshThread m_objParent;
    private List m_lstSubThread;
    private boolean m_bAutoEndThread = false;
    static int m_nCount = 1;
    static HashMap m_mapRuningGetAllLinkThread = new HashMap();

    public RefreshThread(int nPoolSize) {
        this(nPoolSize, 20, null, -1L, -1L);
    }

    public RefreshThread(int nPoolSize, RefreshChecker objChecker, long lSearchInterval) {
        this(nPoolSize, 20, objChecker, -1L, lSearchInterval);
    }

    public RefreshThread(int nPoolSize, int nSearchPoolSize, RefreshChecker objChecker, long lRefreshInterval, long lSearchInterval) {
        if (lRefreshInterval > 0L) {
            this.m_lRefreshInterval = lRefreshInterval;
        }
        if (lSearchInterval > 0L) {
            this.m_lGetAllLinkInterval = lSearchInterval;
        }
        this.m_nPoolSize = nPoolSize < 0 ? 1 : nPoolSize;
        this.m_nSearchPoolSize = nSearchPoolSize <= 0 ? 20 : nSearchPoolSize;
        this.m_objChecker = objChecker;
        this.setThreadInfo();
        if (this.m_nPoolSize > 0) {
            this.m_objExecutor = new FJTaskRunnerGroup(this.m_nPoolSize);
            this.m_objSearchExecutor = new FJTaskRunnerGroup(this.m_nSearchPoolSize);
            this.start();
        } else {
            log.info("\u6ca1\u6709\u542f\u52a8\u4efb\u4f55\u9759\u6001\u5904\u7406\u7ebf\u7a0b\uff01");
        }
    }

    public RefreshThread(int nPoolSize, int nSearchPoolSize, RefreshThread objParent, Hashtable lstTask, long lSearchInterval) {
        if (lSearchInterval > 0L) {
            this.m_lGetAllLinkInterval = lSearchInterval;
        }
        this.m_nPoolSize = nPoolSize <= 0 ? 1 : nPoolSize;
        if (this.m_nPoolSize > 0) {
            this.m_nSearchPoolSize = nSearchPoolSize <= 0 ? 20 : nSearchPoolSize;
            this.m_objExecutor = new FJTaskRunnerGroup(this.m_nPoolSize);
            this.m_objSearchExecutor = new FJTaskRunnerGroup(this.m_nSearchPoolSize);
        }
        if (objParent != null) {
            this.m_objChecker = objParent.m_objChecker;
            this.m_objParent = objParent;
        } else {
            this.m_strErrorMessage = "\u521b\u5efa\u9759\u6001\u9875\u9762\u5237\u65b0\u5b50\u8fdb\u7a0b\u65f6\u6ca1\u6709\u4f20\u9012\u7236\u7ea7\u8fdb\u7a0b\u5bf9\u8c61\u3002";
            log.error(this.m_strErrorMessage);
        }
        this.m_lstTask = lstTask;
        this.m_bAutoEndThread = true;
        this.setThreadInfo();
        if (this.m_nPoolSize > 0) {
            this.start();
        } else {
            log.info("\u6ca1\u6709\u542f\u52a8\u4efb\u4f55\u9759\u6001\u5904\u7406\u7ebf\u7a0b\uff01");
        }
    }

    public String getErrorMessage() {
        return this.m_strErrorMessage;
    }

    public boolean refreshURL(String strURL) {
        return this.refreshURL(strURL, strURL);
    }

    public boolean refreshURL(String strURL, String strKey) {
        return this.refreshURL(strURL, strKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean refreshURL(String strURL, String strKey, boolean bCheckTask) {
        int nResult;
        if (this.m_nPoolSize <= 0) {
            return true;
        }
        if (strKey == null || strKey.length() == 0) {
            strKey = strURL;
        }
        if ((bCheckTask || this.isCompleteAll() || this.m_lstTask.size() > 2147483547) && (nResult = this.removeCompleteTask(null)) > 0) {
            log.info("\u6e05\u7406\u4e86" + nResult + "\u4e2a\u5237\u65b0\u4efb\u52a1");
        }
        if (strURL == null || strURL.length() == 0) {
            return false;
        }
        RefreshThread objThread = this;
        while (objThread.m_objParent != null) {
            objThread = objThread.m_objParent;
        }
        RefreshTask objResult = objThread.getRunningRefreshTask(strKey);
        if (objResult != null) {
            if (!objResult.isComplete() || !bCheckTask) return true;
            byte[] byArray = this.m_objSyncTask;
            synchronized (this.m_objSyncTask) {
                objResult.setComplete(false);
                objResult.setError(false);
                if (this.m_lstTask.containsKey(strKey)) return true;
                this.m_lstTask.put(strKey, objResult);
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return true;
            }
        }
        byte[] byArray = this.m_objSyncTask;
        synchronized (this.m_objSyncTask) {
            this.m_lstTask.put(strKey, new RefreshTask(strURL));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefreshTask getRefreshTask(String strURL) {
        RefreshTask objResult;
        this.m_strErrorMessage = null;
        if (strURL != null && strURL.length() > 0) {
            objResult = (RefreshTask)this.m_lstTask.get(strURL);
            if (objResult == null) {
                if (this.m_lstSubThread != null && this.m_lstSubThread.size() > 0) {
                    for (int n = 0; n < this.m_lstSubThread.size() && (objResult = ((RefreshThread)this.m_lstSubThread.get(n)).getRefreshTask(strURL)) == null; ++n) {
                    }
                }
                if (objResult == null) {
                    this.m_strErrorMessage = "\u5237\u65b0\u4efb\u52a1\u4e0d\u5b58\u5728\u3002";
                }
            } else if (objResult.isComplete() && this.m_bCompleteAll) {
                byte[] byArray = this.m_objSyncTask;
                synchronized (this.m_objSyncTask) {
                    this.m_lstTask.remove(strURL);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                }
            } else {
                this.m_strErrorMessage = "\u4efb\u52a1\u672a\u5b8c\u6210\u3002";
            }
        } else {
            this.m_strErrorMessage = "\u9875\u9762\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002";
            return null;
        }
        return objResult;
    }

    public RefreshTask getCurrentRefreshTask() {
        return this.m_objCurrentTask;
    }

    public int getRefreshTaskSize() {
        int nSize = 0;
        Collection lstValue = this.m_lstTask.values();
        if (lstValue != null && lstValue.size() > 0) {
            RefreshTask[] arrayTask = lstValue.toArray(new RefreshTask[0]);
            for (int n = 0; n < arrayTask.length; ++n) {
                try {
                    if (arrayTask[n] == null || arrayTask[n].isComplete()) continue;
                    ++nSize;
                    continue;
                }
                catch (Exception e) {
                    log.error("\u8ba1\u7b97\u5237\u65b0\u4efb\u52a1\u5f02\u5e38\u3002", (Throwable)e);
                }
            }
        }
        return nSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Hashtable getAllRefreshTask() {
        Hashtable<String, RefreshTask> lstResult = new Hashtable<String, RefreshTask>();
        Set lstKey = this.m_lstTask.keySet();
        String[] arrayKey = lstKey.toArray(new String[0]);
        this.m_strErrorMessage = null;
        int n = 0;
        while (n < arrayKey.length) {
            RefreshTask objTask = (RefreshTask)this.m_lstTask.get(arrayKey[n]);
            if (objTask != null) {
                if (objTask.isComplete()) {
                    byte[] byArray = this.m_objSyncTask;
                    // MONITORENTER : this.m_objSyncTask
                    this.m_lstTask.remove(arrayKey[n]);
                    // MONITOREXIT : byArray
                }
                lstResult.put(arrayKey[n], objTask);
            }
            ++n;
        }
        return lstResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSearchURL() {
        StringList lstResult = new StringList(m_mapRuningGetAllLinkThread.size());
        HashMap hashMap = m_mapRuningGetAllLinkThread;
        synchronized (hashMap) {
            Set lstKey = m_mapRuningGetAllLinkThread.keySet();
            Iterator iterKey = lstKey.iterator();
            while (iterKey.hasNext()) {
                lstResult.add((String)iterKey.next());
            }
        }
        return lstResult.toStringArray();
    }

    public int getSearchLinkNum(String strURL) {
        GetAllLinkThread objResult = (GetAllLinkThread)((Object)m_mapRuningGetAllLinkThread.get(strURL));
        if (objResult == null) {
            return -1;
        }
        return objResult.getSearchLinkNum();
    }

    public long getSearchStartTime(String strURL) {
        GetAllLinkThread objResult = (GetAllLinkThread)((Object)m_mapRuningGetAllLinkThread.get(strURL));
        if (objResult == null) {
            return -1L;
        }
        return objResult.getSearchStartTime();
    }

    public boolean isSearchComplete(String strURL) {
        GetAllLinkThread objResult = (GetAllLinkThread)((Object)m_mapRuningGetAllLinkThread.get(strURL));
        if (objResult == null) {
            return true;
        }
        return objResult.isComplete();
    }

    public String getSearchCurrentURL(String strURL) {
        GetAllLinkThread objResult = (GetAllLinkThread)((Object)m_mapRuningGetAllLinkThread.get(strURL));
        if (objResult == null) {
            return "";
        }
        return objResult.getSearchCurrentURL();
    }

    public long getProcTotal() {
        return this.m_lProcTotal;
    }

    public long getProcTotalTime() {
        return this.m_lProcTotalTime;
    }

    public int getTotalRunningThread() {
        if (this.m_nPoolSize > 1) {
            return this.m_objExecutor.getActiveCount();
        }
        return this.m_nPoolSize;
    }

    public HashMap getTaskDomain() {
        HashMap<String, Long> mapDomain = new HashMap<String, Long>();
        Enumeration enuKeys = this.m_lstTask.keys();
        while (enuKeys.hasMoreElements()) {
            RefreshTask objTask;
            String strTaskKey = (String)enuKeys.nextElement();
            if (strTaskKey == null || (objTask = (RefreshTask)this.m_lstTask.get(strTaskKey)) == null || objTask.isComplete()) continue;
            String strDomain = this.getURLDomain(strTaskKey);
            Long objNum = (Long)mapDomain.get(strDomain);
            objNum = objNum == null ? new Long(1L) : new Long(objNum + 1L);
            mapDomain.put(strDomain, objNum);
        }
        return mapDomain;
    }

    public RefreshThread[] getSubRefreshThread() {
        if (this.m_lstSubThread != null) {
            return this.m_lstSubThread.toArray(new RefreshThread[0]);
        }
        return new RefreshThread[0];
    }

    public RefreshThread getSubRefreshThread(int nIndex) {
        if (this.m_lstSubThread != null && nIndex >= 0 && nIndex < this.m_lstSubThread.size()) {
            return (RefreshThread)this.m_lstSubThread.get(nIndex);
        }
        return null;
    }

    private List getAllSubRefreshThread() {
        ArrayList<RefreshThread> lstThread = new ArrayList<RefreshThread>();
        if (this.m_lstSubThread != null) {
            for (int n = 0; n < this.m_lstSubThread.size(); ++n) {
                RefreshThread objThread = (RefreshThread)this.m_lstSubThread.get(n);
                lstThread.add(objThread);
                lstThread.addAll(objThread.getAllSubRefreshThread());
            }
        }
        return lstThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int moveTaskToSubThread(String strDomain, int nPoolSize, int nSearchPoolSize) {
        if (strDomain == null) {
            return 0;
        }
        strDomain = strDomain.trim().toLowerCase();
        if (nPoolSize <= 0) {
            nPoolSize = this.m_nPoolSize;
        }
        if (nSearchPoolSize <= 0) {
            nSearchPoolSize = this.m_nSearchPoolSize;
        }
        Hashtable<String, RefreshTask> mapSubTask = new Hashtable<String, RefreshTask>();
        Enumeration enuKeys = this.m_lstTask.keys();
        while (enuKeys.hasMoreElements()) {
            RefreshTask objTask;
            String strTaskKey = (String)enuKeys.nextElement();
            if (strTaskKey == null || (objTask = (RefreshTask)this.m_lstTask.get(strTaskKey)) == null || objTask.isComplete() || objTask.isRunning()) continue;
            String strCurDomain = this.getURLDomain(strTaskKey);
            if (strDomain.length() != 0 && !strDomain.equals(strCurDomain)) continue;
            byte[] byArray = this.m_objSyncTask;
            // MONITORENTER : this.m_objSyncTask
            this.m_lstTask.remove(strTaskKey);
            // MONITOREXIT : byArray
            mapSubTask.put(strTaskKey, objTask);
        }
        if (mapSubTask.size() <= 0) return mapSubTask.size();
        RefreshThread refreshThread = this;
        // MONITORENTER : refreshThread
        if (this.m_lstSubThread == null) {
            this.m_lstSubThread = new ArrayList();
        }
        this.m_lstSubThread.add(new RefreshThread(nPoolSize, nSearchPoolSize, this, mapSubTask, this.m_lGetAllLinkInterval));
        // MONITOREXIT : refreshThread
        return mapSubTask.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int moveTaskToParentThread(String strDomain) {
        if (this.m_objParent == null) {
            this.m_strErrorMessage = "\u6ca1\u6709\u7236\u7ea7\u8fdb\u7a0b\u3002";
            return 0;
        }
        Hashtable<String, RefreshTask> mapTask = new Hashtable<String, RefreshTask>();
        Enumeration enuKeys = this.m_lstTask.keys();
        while (true) {
            RefreshTask objTask;
            if (!enuKeys.hasMoreElements()) {
                if (mapTask.size() <= 0) return mapTask.size();
                byte[] byArray = this.m_objParent.m_objSyncTask;
                // MONITORENTER : this.m_objParent.m_objSyncTask
                this.m_objParent.m_lstTask.putAll(mapTask);
                this.m_objParent.start();
                // MONITOREXIT : byArray
                return mapTask.size();
            }
            String strTaskKey = (String)enuKeys.nextElement();
            if (strTaskKey == null || (objTask = (RefreshTask)this.m_lstTask.get(strTaskKey)) == null || objTask.isComplete() || objTask.isRunning()) continue;
            String strCurDomain = this.getURLDomain(strTaskKey);
            if (strDomain.length() != 0 && !strDomain.equals(strCurDomain)) continue;
            byte[] byArray = this.m_objSyncTask;
            // MONITORENTER : this.m_objSyncTask
            this.m_lstTask.remove(strTaskKey);
            // MONITOREXIT : byArray
            mapTask.put(strTaskKey, objTask);
        }
    }

    private String FixURL(String strURL, String strFromURL) {
        if (strURL == null || strURL.trim().toLowerCase().startsWith("mailto:")) {
            return "";
        }
        int nPosFromScheme = strFromURL.indexOf("://");
        if (nPosFromScheme <= 0) {
            log.error("\u4fee\u6539\u8fde\u63a5\u539f\u59cb\u5730\u5740\u4e0d\u5305\u542b:// \uff1a" + strFromURL);
            return "";
        }
        int nPosScheme = strURL.indexOf("://");
        if (nPosScheme > 0) {
            String strFromServerName;
            String strServerName;
            int nPosSlash = strURL.indexOf(47, nPosScheme + 3);
            if (nPosSlash > 0) {
                int nPosColon = strURL.indexOf(58, nPosScheme + 3);
                if (nPosColon > 0 && nPosColon < nPosSlash) {
                    nPosSlash = nPosColon;
                }
                strServerName = strURL.substring(nPosScheme + 3, nPosSlash).toLowerCase();
            } else {
                strServerName = strURL.substring(nPosScheme + 3).trim().toLowerCase();
            }
            int nPosFromSlash = strFromURL.indexOf(47, nPosFromScheme + 3);
            if (nPosFromSlash > 0) {
                int nPosFromColon = strFromURL.indexOf(58, nPosFromScheme + 3);
                if (nPosFromColon > 0 && nPosFromColon < nPosFromSlash) {
                    nPosFromSlash = nPosFromColon;
                }
                strFromServerName = strFromURL.substring(nPosFromScheme + 3, nPosFromSlash).toLowerCase();
            } else {
                strFromServerName = strFromURL.substring(nPosFromScheme + 3).trim().toLowerCase();
            }
            if (strFromServerName.startsWith("www.")) {
                strFromServerName = strFromServerName.substring(4);
            }
            if (strServerName.equals(strFromServerName) || strServerName.equals("www." + strFromServerName)) {
                return strURL;
            }
            return "";
        }
        int nPosFromSlash = strFromURL.indexOf(47, nPosFromScheme + 3);
        if (strURL.startsWith("/")) {
            if (nPosFromSlash > 0) {
                String strFromPrePath = strFromURL.substring(nPosFromSlash);
                if (strURL.length() > strFromPrePath.length() && strURL.endsWith(strFromPrePath)) {
                    log.info("\u53d1\u73b0\u8fde\u63a5" + strURL + "\u548c\u6765\u6e90" + strFromURL + "\u7c7b\u4f3c\u3002");
                    return "";
                }
                return strFromURL.substring(0, nPosFromSlash) + strURL;
            }
            return strFromURL + strURL;
        }
        if (nPosFromSlash < 0) {
            return strFromURL + "/" + strURL;
        }
        int nPosFromQueMask = strFromURL.indexOf(63, nPosFromSlash);
        nPosFromSlash = nPosFromQueMask > 0 ? strFromURL.lastIndexOf(47, nPosFromQueMask) : strFromURL.lastIndexOf(47);
        if (!strURL.startsWith("../")) {
            return strFromURL.substring(0, nPosFromSlash + 1) + strURL;
        }
        String strFromPrePath = strFromURL.substring(0, nPosFromSlash);
        String strURLPath = strURL;
        while (strURLPath.startsWith("../")) {
            strURLPath = strURLPath.substring(3);
            while (strURLPath.startsWith("/")) {
                strURLPath = strURLPath.substring(1);
            }
            nPosFromSlash = strFromPrePath.lastIndexOf(47);
            if (nPosFromSlash <= 0) continue;
            strFromPrePath = strFromPrePath.substring(0, nPosFromSlash);
        }
        return strFromPrePath + "/" + strURLPath;
    }

    private Hashtable getPageAllLink(String strURL) {
        Hashtable<String, String> mapAllLink = new Hashtable<String, String>();
        try {
            String strHtmlText;
            if (this.m_objChecker == null || !this.m_objChecker.isSupportLocalRefresh()) {
                URL objUrl = new URL(strURL);
                strHtmlText = Util.getString((Reader)new InputStreamReader(objUrl.openStream()));
            } else {
                strHtmlText = this.m_objChecker.getLocalOriginalData(strURL);
            }
            Source objHtmlSrc = new Source((CharSequence)strHtmlText);
            strURL = this.deleteURLParameter(strURL);
            List lstStartTags = objHtmlSrc.getAllStartTags();
            for (StartTag objStartTag : lstStartTags) {
                Attributes objAttributes = objStartTag.getAttributes();
                if (objAttributes == null) continue;
                String strLinkURL = objAttributes.getValue("href");
                if (strLinkURL == null || strLinkURL.length() == 0) {
                    strLinkURL = objAttributes.getValue("src");
                    if (strLinkURL != null && strLinkURL.length() != 0) continue;
                    strLinkURL = objAttributes.getValue("background");
                }
                if (strLinkURL == null || strLinkURL.length() == 0 || (strLinkURL = this.FixURL(strLinkURL, strURL)).length() <= 0 || this.m_objChecker != null && !this.m_objChecker.isValid(strLinkURL) || mapAllLink.containsKey(strLinkURL)) continue;
                mapAllLink.put(strLinkURL, strLinkURL);
            }
        }
        catch (IOException eIO) {
            log.error("\u9012\u5f52\u9875\u9762\u8fde\u63a5\u5f02\u5e38\u3002" + strURL + " Error:" + eIO.getMessage(), (Throwable)eIO);
        }
        catch (Exception e) {
            log.error("\u9012\u5f52\u9875\u9762\u65f6\u5f02\u5e38\u3002" + strURL, (Throwable)e);
        }
        return mapAllLink;
    }

    private String deleteURLParameter(String strURL) {
        int nPos = -2;
        try {
            nPos = strURL.indexOf("file_reloadall=1");
            if (nPos > 0 && (strURL.charAt(nPos - 1) == '&' || strURL.charAt(nPos - 1) == '?')) {
                strURL = strURL.charAt(nPos - 1) == '&' ? StringUtils.replace(strURL, "&file_reloadall=1", "") : (strURL.length() >= nPos + "file_reloadall".length() + 2 ? StringUtils.replace(strURL, strURL.substring(nPos, nPos + "file_reloadall".length() + 3), "") : StringUtils.replace(strURL, "?file_reloadall=1", ""));
            }
            if ((nPos = strURL.indexOf("file_reloadone=1")) > 0 && (strURL.charAt(nPos - 1) == '&' || strURL.charAt(nPos - 1) == '?')) {
                strURL = strURL.charAt(nPos - 1) == '&' ? StringUtils.replace(strURL, "&file_reloadone=1", "") : (strURL.length() >= nPos + "file_reloadone".length() + 2 ? StringUtils.replace(strURL, strURL.substring(nPos, nPos + "file_reloadone".length() + 3), "") : StringUtils.replace(strURL, "?file_reloadone=1", ""));
            }
            if ((nPos = strURL.indexOf("file_reload=1")) > 0 && (strURL.charAt(nPos - 1) == '&' || strURL.charAt(nPos - 1) == '?')) {
                strURL = strURL.charAt(nPos - 1) == '&' ? StringUtils.replace(strURL, "&file_reload=1", "") : (strURL.length() > nPos + "file_reload".length() + 2 ? StringUtils.replace(strURL, strURL.substring(nPos, nPos + "file_reload".length() + 3), "") : StringUtils.replace(strURL, "?file_reload=1", ""));
            }
            if ((nPos = strURL.indexOf("file_test=1")) > 0 && (strURL.charAt(nPos - 1) == '&' || strURL.charAt(nPos - 1) == '?')) {
                strURL = strURL.charAt(nPos - 1) == '&' ? StringUtils.replace(strURL, "&file_test=1", "") : (strURL.length() > nPos + "file_test".length() + 2 ? StringUtils.replace(strURL, strURL.substring(nPos, nPos + "file_test".length() + 3), "") : StringUtils.replace(strURL, "?file_test=1", ""));
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u53c2\u6570\u5f02\u5e38\uff1a" + strURL + " nPos=" + nPos, (Throwable)e);
        }
        return strURL;
    }

    private boolean refresh(RefreshTask objTask) {
        boolean bResult;
        try {
            StringBuffer sbufMsg = new StringBuffer();
            objTask.setRunning(true);
            objTask.setStartTime(System.currentTimeMillis());
            String strURL = objTask.getURL();
            int nPos = strURL.indexOf("file_reloadall=1");
            if (nPos > 0 && (strURL.charAt(nPos - 1) == '&' || strURL.charAt(nPos - 1) == '?')) {
                GetAllLinkThread objRecursionThread = this.createGetAllLinkThread(strURL = this.deleteURLParameter(strURL), this.m_lGetAllLinkInterval);
                if (objRecursionThread != null) {
                    this.m_objSearchExecutor.executeTask((FJTask)objRecursionThread);
                } else {
                    sbufMsg.append("\u524d\u4e00\u4e2a\u5206\u6790\u8fdb\u7a0b\u672a\u5b8c\u6210\u3002");
                }
                strURL = strURL.indexOf(63) > 0 ? strURL + "&" + "file_reloadone" + "=1" : strURL + "?" + "file_reloadone" + "=1";
            }
            if (this.m_objChecker == null || !this.m_objChecker.isSupportLocalRefresh()) {
                URL objUrl = new URL(strURL);
                objUrl.getContent();
            } else if (strURL.indexOf("file_reload=1") > 0 || strURL.indexOf("file_reloadone=1") > 0 || this.m_objChecker.isFileNotExists(strURL)) {
                objTask.setError(!this.m_objChecker.localRefresh(strURL, sbufMsg));
                objTask.setErrorMessage(sbufMsg.toString());
            }
            bResult = true;
        }
        catch (MalformedURLException eurl) {
            objTask.setErrorMessage("\u5730\u5740\u4e0d\u5408\u6cd5\uff1a" + eurl.getMessage());
            objTask.setError(true);
            log.debug("\u5730\u5740\u4e0d\u5408\u6cd5\u3002", (Throwable)eurl);
            bResult = false;
        }
        catch (IOException eio) {
            objTask.setErrorMessage("\u5237\u65b0\u9875\u9762\u9519\u8bef\uff1a" + eio.getMessage());
            objTask.setError(true);
            log.debug("\u5237\u65b0\u9875\u9762\u9519\u8bef\u3002", (Throwable)eio);
            bResult = false;
        }
        catch (Exception e) {
            objTask.setErrorMessage("\u5237\u65b0\u9875\u9762\u5f02\u5e38\uff1a" + e.getMessage());
            objTask.setError(true);
            log.error("\u5237\u65b0\u9875\u9762\u5f02\u5e38\uff1a" + this.m_objCurrentTask.getURL(), (Throwable)e);
            bResult = false;
        }
        objTask.setCompleteTime(System.currentTimeMillis());
        objTask.setComplete(true);
        objTask.setRunning(false);
        return bResult;
    }

    private String getURLDomain(String strURL) {
        String strDomain;
        if (strURL == null) {
            return "";
        }
        int nStart = strURL.indexOf("://");
        if (nStart < 0) {
            return "";
        }
        int nEnd = strURL.indexOf(58, nStart += 3);
        if (nEnd < 0 && (nEnd = strURL.indexOf(47, nStart)) < 0) {
            nEnd = strURL.length();
        }
        if ((strDomain = strURL.substring(nStart, nEnd).trim().toLowerCase()).startsWith("www.")) {
            return strDomain.substring(4);
        }
        return strDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int removeCompleteTask(String strDomain) {
        int nResult = 0;
        Enumeration enuKeys = this.m_lstTask.keys();
        while (enuKeys.hasMoreElements()) {
            RefreshTask objResult;
            String strTaskKey = (String)enuKeys.nextElement();
            if (strDomain != null && !strDomain.equals(this.getURLDomain(strTaskKey)) || !(objResult = (RefreshTask)this.m_lstTask.get(strTaskKey)).isComplete()) continue;
            byte[] byArray = this.m_objSyncTask;
            // MONITORENTER : this.m_objSyncTask
            this.m_lstTask.remove(strTaskKey);
            // MONITOREXIT : byArray
            ++nResult;
        }
        if (this.m_lstSubThread == null) return nResult;
        if (this.m_lstSubThread.size() <= 0) return nResult;
        int n = 0;
        while (n < this.m_lstSubThread.size()) {
            nResult += ((RefreshThread)this.m_lstSubThread.get(n)).removeCompleteTask(strDomain);
            ++n;
        }
        return nResult;
    }

    private RefreshTask getRunningRefreshTask(String strKey) {
        RefreshTask objResult = (RefreshTask)this.m_lstTask.get(strKey);
        if (objResult == null && this.m_lstSubThread != null && this.m_lstSubThread.size() > 0) {
            for (int n = 0; n < this.m_lstSubThread.size() && (objResult = ((RefreshThread)this.m_lstSubThread.get(n)).getRunningRefreshTask(strKey)) == null; ++n) {
            }
        }
        return objResult;
    }

    private List getAllRefreshTask(String strDomain) {
        ArrayList<RefreshTask> lstResult = new ArrayList<RefreshTask>();
        Enumeration enuKeys = this.m_lstTask.keys();
        while (enuKeys.hasMoreElements()) {
            String strTaskKey = (String)enuKeys.nextElement();
            if (!strDomain.equals(this.getURLDomain(strTaskKey))) continue;
            lstResult.add((RefreshTask)this.m_lstTask.get(strTaskKey));
        }
        if (this.m_lstSubThread != null && this.m_lstSubThread.size() > 0) {
            for (int n = 0; n < this.m_lstSubThread.size(); ++n) {
                lstResult.addAll(((RefreshThread)this.m_lstSubThread.get(n)).getAllRefreshTask(strDomain));
            }
        }
        return lstResult;
    }

    private boolean isCompleteAll() {
        if (!this.m_bCompleteAll) {
            return false;
        }
        if (this.m_lstSubThread != null && this.m_lstSubThread.size() > 0) {
            for (int n = 0; n < this.m_lstSubThread.size(); ++n) {
                if (((RefreshThread)this.m_lstSubThread.get(n)).isCompleteAll()) continue;
                return false;
            }
        }
        return true;
    }

    protected void finalize() throws Throwable {
        log.debug("Refresh Thread End!");
        System.err.println("\u5237\u65b0\u9875\u9762\u7ebf\u7a0b\u7ed3\u675f\uff01");
        this.interrupt();
        this.m_objExecutor.interruptAll();
        super.finalize();
    }

    protected boolean isSubRefreshThreadComplete() {
        if (this.m_lstSubThread == null || this.m_lstSubThread.size() == 0) {
            return true;
        }
        for (int n = 0; n < this.m_lstSubThread.size(); ++n) {
            RefreshThread objSubThread = (RefreshThread)this.m_lstSubThread.get(n);
            if (objSubThread == null) continue;
            if (!objSubThread.isInterrupted()) {
                return false;
            }
            if (objSubThread.isSubRefreshThreadComplete()) continue;
            return false;
        }
        return true;
    }

    private void setThreadInfo() {
        try {
            this.setPriority(5);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.m_bAutoEndThread) {
            this.setName("\u5237\u65b0\u7f51\u5740\u7ebf\u7a0b" + (this.m_objChecker != null ? this.m_objChecker.getCheckerName() : "") + " " + this.m_nPoolSize + "/" + this.m_nSearchPoolSize);
        } else {
            String strDomain = this.m_lstTask.size() > 0 ? this.getURLDomain((String)this.m_lstTask.keys().nextElement()) : " \u4efb\u52a1\u6570" + String.valueOf(this.m_lstTask.size());
            this.setName("\u5237\u65b0\u7f51\u5740\u7ebf\u7a0b" + strDomain + (this.m_objChecker != null ? this.m_objChecker.getCheckerName() : "") + " " + this.m_nPoolSize + "/" + this.m_nSearchPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            block35: {
                try lbl-1000:
                // 3 sources

                {
                    while (!this.isInterrupted()) {
                        lstValue = this.m_lstTask.values();
                        bRefreshURL = false;
                        if (lstValue != null && lstValue.size() > 0) {
                            strLastServer = null;
                            objTempTask = null;
                            arrayTask = lstValue.toArray(new RefreshTask[0]);
                            nLastIndex = 0;
                            for (n = 0; n < arrayTask.length; ++n) {
                                if (arrayTask[n] == null || arrayTask[n].getServerName().equalsIgnoreCase(strLastServer)) {
                                    i = nLastIndex;
                                    objTempTask = arrayTask[i];
                                    while (objTempTask == null || objTempTask.isComplete() || objTempTask.isRunning() || objTempTask.getServerName().equals(strLastServer)) {
                                        if (++i >= arrayTask.length) {
                                            i = n + 1;
                                            if (i >= arrayTask.length) {
                                                i = n;
                                                break;
                                            }
                                            if (nLastIndex < n) {
                                                i = nLastIndex = n;
                                                break;
                                            }
                                        }
                                        objTempTask = arrayTask[i];
                                        if (i != nLastIndex) continue;
                                        i = n;
                                        break;
                                    }
                                    if (n != i) {
                                        arrayTask[i] = arrayTask[n];
                                        arrayTask[n] = objTempTask;
                                    }
                                }
                                if (arrayTask[n] == null || arrayTask[n].isComplete() || arrayTask[n].isRunning()) continue;
                                RefreshThread.log.info("\u5237\u65b0\uff1a" + arrayTask[n].getURL());
                                bRefreshURL = true;
                                if (this.m_bCompleteAll) {
                                    i = this;
                                    synchronized (i) {
                                        this.m_lProcTotal = 0L;
                                        this.m_lProcTotalTime = 0L;
                                    }
                                    this.m_lStartTime = System.currentTimeMillis();
                                    this.m_bCompleteAll = false;
                                }
                                if (this.m_nPoolSize > 1) {
                                    arrayTask[n].setRunning(true);
                                    this.m_objExecutor.executeTask((FJTask)new RefreshThreadTask(this, arrayTask[n]));
                                    while (this.m_objExecutor.getActiveCount() >= this.m_nPoolSize) {
                                        RefreshThread.sleep(this.m_nPoolSize * 100);
                                    }
                                } else {
                                    this.m_objCurrentTask = arrayTask[n];
                                    this.refresh(this.m_objCurrentTask);
                                    ++this.m_lProcTotal;
                                    this.m_lProcTotalTime = System.currentTimeMillis() - this.m_lStartTime;
                                }
                                RefreshThread.sleep(this.m_lRefreshInterval);
                            }
                        }
                        break block35;
                    }
                    break;
                }
                catch (InterruptedException eInterrupted) {
                    RefreshThread.log.info("\u5730\u5740\u5237\u65b0\u7ebf\u7a0b\u88ab\u4e2d\u65ad\u3002");
                }
                return;
            }
            if (this.m_objExecutor.getActiveCount() > 0) {
                bRefreshURL = true;
            }
            if (!bRefreshURL) {
                this.m_bCompleteAll = true;
                if (this.m_objParent != null) {
                    objThread = this;
                    while (objThread.m_objParent != null) {
                        objThread = objThread.m_objParent;
                    }
                    lstThread = objThread.getAllSubRefreshThread();
                    lstThread.add(0, objThread);
                    lstDomain = new StringList(this.m_lstTask.size());
                    enuKeys = this.m_lstTask.keys();
                    while (enuKeys.hasMoreElements()) {
                        strTaskKey = (String)enuKeys.nextElement();
                        strDomain = this.getURLDomain(strTaskKey);
                        if (lstDomain.contains(strDomain)) continue;
                        lstDomain.add(strDomain);
                    }
                    for (n = 0; n < lstDomain.size(); ++n) {
                        strDomain = lstDomain.getString(n);
                        for (i = 0; i < lstThread.size() && !((RefreshThread)lstThread.get(i)).getTaskDomain().containsKey(strDomain); ++i) {
                        }
                        if (i < lstThread.size()) continue;
                        nResult = objThread.removeCompleteTask(strDomain);
                        RefreshThread.log.info(strDomain + "\u5904\u7406\u5b8c\u6210\u6e05\u7406" + nResult + "\u5237\u65b0\u4efb\u52a1");
                    }
                }
                if (this.m_bAutoEndThread) {
                    this.interrupt();
                    break;
                }
            }
            try {
                RefreshThread.sleep(this.m_lInterval);
            }
            catch (InterruptedException objThread) {
                ** GOTO lbl-1000
            }
            catch (Exception e) {
                RefreshThread.log.error("\u5237\u65b0\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38\u3002", (Throwable)e);
                System.err.println("\u5237\u65b0\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38\u3002");
                ** GOTO lbl-1000
            }
        }
        if (this.m_objParent != null && this.m_objParent.m_lstSubThread != null && this.isSubRefreshThreadComplete()) {
            RefreshThread.log.error("\u5237\u65b0\u5b8c\u6210\uff01" + this.getName());
            lstValue = this.m_objParent;
            synchronized (lstValue) {
                for (n = 0; n < this.m_objParent.m_lstSubThread.size(); ++n) {
                    if (this != (RefreshThread)this.m_objParent.m_lstSubThread.get(n)) continue;
                    this.m_objParent.m_lstSubThread.remove(n);
                    break;
                }
            }
        }
        if (this.m_bCompleteAll == false) return;
        if (this.m_objParent == null) return;
        lstValue = this.m_objParent.m_objSyncTask;
        synchronized (this.m_objParent.m_objSyncTask) {
            this.m_objParent.m_lstTask.putAll(this.m_lstTask);
            // ** MonitorExit[lstValue] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentRefreshTask(RefreshTask objCurrentTask) {
        byte[] byArray = this.m_objSyncCurTask;
        synchronized (this.m_objSyncCurTask) {
            this.m_objCurrentTask = objCurrentTask;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProcTotal() {
        RefreshThread refreshThread = this;
        synchronized (refreshThread) {
            ++this.m_lProcTotal;
            this.m_lProcTotalTime = System.currentTimeMillis() - this.m_lStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetAllLinkThread createGetAllLinkThread(String strURL, long lInterval) {
        GetAllLinkThread objResult;
        if (m_mapRuningGetAllLinkThread.containsKey(strURL)) {
            return null;
        }
        HashMap hashMap = m_mapRuningGetAllLinkThread;
        synchronized (hashMap) {
            objResult = new GetAllLinkThread(strURL, lInterval);
            m_mapRuningGetAllLinkThread.put(objResult.getURL(), objResult);
        }
        return objResult;
    }

    private class GetAllLinkThread
    extends FJTask {
        private String m_strURL;
        private String m_strCurrentURL;
        private Hashtable m_mapAllLink;
        private long m_lGetAllLinkStartTime;
        private long m_lSleepTime = 100L;

        public GetAllLinkThread(String strURL, long lInterval) {
            this.m_strURL = RefreshThread.this.deleteURLParameter(strURL);
            if (lInterval > 10L) {
                this.m_lSleepTime = lInterval;
            }
            this.setThreadInfo();
        }

        public String getURL() {
            return this.m_strURL;
        }

        public void setURL(String strURL) {
            this.m_strURL = RefreshThread.this.deleteURLParameter(strURL);
            this.setThreadInfo();
        }

        public int getSearchLinkNum() {
            if (this.m_mapAllLink != null) {
                return this.m_mapAllLink.size();
            }
            return -1;
        }

        public long getSearchStartTime() {
            return this.m_lGetAllLinkStartTime;
        }

        public boolean isComplete() {
            return this.isDone();
        }

        public String getSearchCurrentURL() {
            return this.m_strCurrentURL;
        }

        private void setThreadInfo() {
            try {
                this.getFJTaskRunner().setName("\u83b7\u53d6\u6240\u6709\u8fde\u63a5\u7ebf\u7a0b" + (RefreshThread.this.m_objChecker != null ? RefreshThread.this.m_objChecker.getCheckerName() : "") + " " + (this.m_mapAllLink != null ? "\u5730\u5740\u6570" + String.valueOf(this.m_mapAllLink.size()) + " " : "") + RefreshThread.this.m_nPoolSize + "/" + RefreshThread.this.m_nSearchPoolSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void getAllLink(String strURL, Map mapAllLink) {
            try {
                String strHtmlText;
                URL objUrl;
                this.m_strCurrentURL = strURL;
                if (RefreshThread.this.m_objChecker == null || !RefreshThread.this.m_objChecker.isSupportLocalRefresh()) {
                    objUrl = new URL(strURL);
                    strHtmlText = Util.getString((Reader)new InputStreamReader(objUrl.openStream()));
                } else {
                    strHtmlText = RefreshThread.this.m_objChecker.getLocalOriginalData(strURL);
                }
                if (strHtmlText == null) {
                    log.error("\u5206\u6790\u9875\u9762" + strURL + "\u65f6\u8fd4\u56de\u7684html\u6570\u636e\u4e3a\u7a7a\uff01\u91cd\u8bd5\u4e00\u6b21\uff01" + (mapAllLink != null ? "\u5df2\u627e\u5230\u7684\u8fde\u63a5\u6709" + mapAllLink.size() : ""));
                    if (RefreshThread.this.m_objChecker == null || !RefreshThread.this.m_objChecker.isSupportLocalRefresh()) {
                        objUrl = new URL(strURL);
                        strHtmlText = Util.getString((Reader)new InputStreamReader(objUrl.openStream()));
                    } else {
                        strHtmlText = RefreshThread.this.m_objChecker.getLocalOriginalData(strURL);
                    }
                    if (strHtmlText == null) {
                        return;
                    }
                }
                Source objHtmlSrc = new Source((CharSequence)strHtmlText);
                strURL = RefreshThread.this.deleteURLParameter(strURL);
                List lstStartTags = objHtmlSrc.getAllStartTags();
                for (StartTag objStartTag : lstStartTags) {
                    StringBuffer sbufNewURL;
                    Attributes objAttributes = objStartTag.getAttributes();
                    if (objAttributes == null) continue;
                    String strLinkURL = objAttributes.getValue("href");
                    if (strLinkURL == null || strLinkURL.length() == 0) {
                        strLinkURL = objAttributes.getValue("src");
                        if (strLinkURL != null && strLinkURL.length() != 0) continue;
                        strLinkURL = objAttributes.getValue("background");
                    }
                    if (strLinkURL == null || strLinkURL.length() == 0 || (strLinkURL = RefreshThread.this.FixURL(strLinkURL, strURL)).length() <= 0 || RefreshThread.this.m_objChecker != null && !RefreshThread.this.m_objChecker.isValid(strLinkURL) || mapAllLink.containsKey(strLinkURL)) continue;
                    mapAllLink.put(strLinkURL, strLinkURL);
                    int nSize = mapAllLink.size();
                    if (nSize % 100 == 0) {
                        log.info("\u603b\u6570" + nSize);
                    }
                    if ((sbufNewURL = new StringBuffer(strLinkURL)).indexOf("file_test=1") < 0) {
                        if (strLinkURL.indexOf(63) < 0) {
                            sbufNewURL.append('?');
                        } else {
                            sbufNewURL.append('&');
                        }
                        sbufNewURL.append("file_test").append("=1");
                    }
                    if (mapAllLink.containsKey(strLinkURL = sbufNewURL.toString())) continue;
                    mapAllLink.put(strLinkURL, strLinkURL);
                    Thread.sleep(this.m_lSleepTime);
                    this.getAllLink(strLinkURL, mapAllLink);
                    if (m_nCount % 20 == 0) {
                        m_nCount = 1;
                        RefreshThread.this.m_lProcTotalTime = System.currentTimeMillis() - RefreshThread.this.m_lStartTime;
                        this.setThreadInfo();
                        continue;
                    }
                    ++m_nCount;
                }
            }
            catch (IOException eIO) {
                log.error("\u9012\u5f52\u9875\u9762\u8fde\u63a5\u5f02\u5e38\u3002" + strURL + " Error:" + eIO.getMessage(), (Throwable)eIO);
            }
            catch (Exception e) {
                log.error("\u9012\u5f52\u9875\u9762\u65f6\u5f02\u5e38\u3002" + strURL, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Serializable sbufRefreshURL;
                this.m_lGetAllLinkStartTime = System.currentTimeMillis();
                this.m_mapAllLink = new Hashtable();
                this.m_mapAllLink.put(this.m_strURL, this.m_strURL);
                String strURL = this.m_strURL.indexOf(63) > 0 ? this.m_strURL + "&" + "file_test" + "=1" : this.m_strURL + "?" + "file_test" + "=1";
                this.getAllLink(strURL, this.m_mapAllLink);
                log.info("\u9012\u5f52\u5386\u65f6" + StringUtils.timeToStr(System.currentTimeMillis() - this.m_lGetAllLinkStartTime) + "\u9875\u9762\u603b\u6570" + this.m_mapAllLink.size() + "\u5730\u5740" + strURL);
                try {
                    this.getFJTaskRunner().setName("\u83b7\u53d6\u6240\u6709\u8fde\u63a5\u7ebf\u7a0b" + (RefreshThread.this.m_objChecker != null ? RefreshThread.this.m_objChecker.getCheckerName() : "") + "\u9012\u5f52\u5386\u65f6" + StringUtils.timeToStr(System.currentTimeMillis() - this.m_lGetAllLinkStartTime) + "\u9875\u9762\u603b\u6570" + this.m_mapAllLink.size() + " " + RefreshThread.this.m_nPoolSize + "/" + RefreshThread.this.m_nSearchPoolSize);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Enumeration enuKeys = this.m_mapAllLink.keys();
                while (enuKeys.hasMoreElements()) {
                    sbufRefreshURL = new StringBuffer(RefreshThread.this.deleteURLParameter((String)enuKeys.nextElement()));
                    if (((StringBuffer)sbufRefreshURL).indexOf("?") <= 0) {
                        ((StringBuffer)sbufRefreshURL).append('?');
                    } else {
                        ((StringBuffer)sbufRefreshURL).append('&');
                    }
                    ((StringBuffer)sbufRefreshURL).append("file_reloadone").append("=1");
                    RefreshThread.this.refreshURL(((StringBuffer)sbufRefreshURL).toString(), ((StringBuffer)sbufRefreshURL).toString(), false);
                }
                RefreshThread.this.m_lProcTotalTime = System.currentTimeMillis() - RefreshThread.this.m_lStartTime;
                sbufRefreshURL = m_mapRuningGetAllLinkThread;
                synchronized (sbufRefreshURL) {
                    m_mapRuningGetAllLinkThread.remove(this.m_strURL);
                }
            }
            catch (Exception ex) {
                log.error("\u5206\u6790\u7ebf\u7a0b\u8fd0\u884c\u5f02\u5e38\uff01", (Throwable)ex);
            }
        }
    }

    private class RefreshThreadTask
    extends FJTask {
        private RefreshThread m_objThread;
        private RefreshTask m_objCurrentTask;

        public RefreshThreadTask(RefreshThread objThread, RefreshTask objCurrentTask) {
            this.m_objThread = objThread;
            this.m_objCurrentTask = objCurrentTask;
            this.setThreadInfo();
        }

        private void setThreadInfo() {
            try {
                this.getFJTaskRunner().setName("\u5237\u65b0\u4efb\u52a1\u7ebf\u7a0b" + (RefreshThread.this.m_objChecker != null ? RefreshThread.this.m_objChecker.getCheckerName() : "") + " " + RefreshThread.this.m_nPoolSize + "/" + RefreshThread.this.m_nSearchPoolSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            this.m_objThread.setCurrentRefreshTask(this.m_objCurrentTask);
            RefreshThread.this.refresh(this.m_objCurrentTask);
            this.m_objThread.addProcTotal();
        }
    }
}

