/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.model.util.Globals;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RefreshTask {
    private boolean m_bIsComplete = false;
    private boolean m_bIsRunning = false;
    private boolean m_bError = false;
    private String m_strErrorMessage;
    private String m_strURL;
    private String m_strServerName;
    private long m_lAddTime;
    private long m_lStartTime;
    private long m_lCompleteTime;
    private static final SimpleDateFormat m_dateFormatter = new SimpleDateFormat("yyyy\u5e74 MMMM dd a h:m:s", Globals.getLocale());

    public RefreshTask(String strURL) {
        this.m_strURL = strURL;
        this.m_lAddTime = System.currentTimeMillis();
        int nIndex = strURL.indexOf("://");
        if (nIndex > 0) {
            int nIndexSlash = strURL.indexOf(47, nIndex + 3);
            this.m_strServerName = nIndexSlash > 0 ? strURL.substring(nIndex + 3, nIndexSlash) : strURL.substring(nIndex + 3);
            nIndexSlash = this.m_strServerName.indexOf(58);
            if (nIndexSlash > 0) {
                this.m_strServerName = this.m_strServerName.substring(0, nIndexSlash);
            }
        } else {
            this.m_strServerName = "";
        }
    }

    public boolean hasError() {
        return this.m_bError;
    }

    public boolean isComplete() {
        return this.m_bIsComplete;
    }

    public boolean isRunning() {
        return this.m_bIsRunning;
    }

    public String getErrorMessage() {
        if (this.m_strErrorMessage != null) {
            return this.m_strErrorMessage;
        }
        return "";
    }

    public String getURL() {
        return this.m_strURL;
    }

    public String getServerName() {
        return this.m_strServerName;
    }

    public void setError(boolean bError) {
        this.m_bError = bError;
    }

    public void setComplete(boolean bIsComplete) {
        this.m_bIsComplete = bIsComplete;
        if (bIsComplete) {
            this.m_bIsRunning = false;
        }
    }

    public void setRunning(boolean bIsRunning) {
        this.m_bIsRunning = bIsRunning;
    }

    public void setErrorMessage(String strErrorMessage) {
        this.m_strErrorMessage = strErrorMessage;
    }

    public String getAddTime() {
        return m_dateFormatter.format(new Date(this.m_lAddTime));
    }

    public String getAddTime(String strFormat) {
        SimpleDateFormat objFormatter = new SimpleDateFormat(strFormat, Globals.getLocale());
        return objFormatter.format(new Date(this.m_lAddTime));
    }

    public String getStartTime() {
        return m_dateFormatter.format(new Date(this.m_lStartTime));
    }

    public String getStartTime(String strFormat) {
        SimpleDateFormat objFormatter = new SimpleDateFormat(strFormat, Globals.getLocale());
        return objFormatter.format(new Date(this.m_lStartTime));
    }

    public String getCompleteTime() {
        return m_dateFormatter.format(new Date(this.m_lCompleteTime));
    }

    public String getCompleteTime(String strFormat) {
        SimpleDateFormat objFormatter = new SimpleDateFormat(strFormat, Globals.getLocale());
        return objFormatter.format(new Date(this.m_lCompleteTime));
    }

    public void setStartTime(long lTime) {
        this.m_lStartTime = lTime;
    }

    public void setCompleteTime(long lTime) {
        this.m_lCompleteTime = lTime;
    }
}

