/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.PropertiesManager");
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 2;
    private static final int REVISION_VERSION = 1;
    private static Hashtable g_mapManagerCache = new Hashtable();
    private static byte[] g_objManagercacheLock = new byte[0];
    private PropertyManager m_mapManager = null;
    private static byte[] g_objManagerLock = new byte[0];
    public String m_strPropsName = "/setting.properties";
    private Properties m_objProperties = null;
    private byte[] m_objPropertiesLock = new byte[0];
    private String m_strResourceURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getProperty(String strName) {
        if (this.m_mapManager != null) return this.m_mapManager.getProp(strName);
        byte[] byArray = g_objManagerLock;
        synchronized (g_objManagerLock) {
            if (this.m_mapManager != null) return this.m_mapManager.getProp(strName);
            this.m_mapManager = new PropertyManager(this.m_strPropsName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_mapManager.getProp(strName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public double getPropertyDouble(String strName, double fDefaultValue) {
        String strValue;
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        if ((strValue = this.m_mapManager.getProp(strName)) == null) {
            return fDefaultValue;
        }
        try {
            return Double.parseDouble(strValue);
        }
        catch (Exception exception) {
            return fDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean getPropertyBoolean(String strName, boolean bDefaultValue) {
        String strValue;
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        if ((strValue = this.m_mapManager.getProp(strName)) == null) {
            return bDefaultValue;
        }
        try {
            if (strValue.compareToIgnoreCase("true") == 0) return true;
            if (strValue.compareTo("1") != 0) return false;
            return true;
        }
        catch (Exception exception) {
            return bDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int getPropertyInt(String strName, int nDefaultValue) {
        String strValue;
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        if ((strValue = this.m_mapManager.getProp(strName)) == null) {
            return nDefaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (Exception exception) {
            return nDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long getPropertyLong(String strName, long lDefaultValue) {
        String strValue;
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        if ((strValue = this.m_mapManager.getProp(strName)) == null) {
            return lDefaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (Exception exception) {
            return lDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setProperty(String strName, String strValue) {
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        this.m_mapManager.setProp(strName, strValue);
    }

    public void setProperty(String strName, double fValue) {
        this.setProperty(strName, String.valueOf(fValue));
    }

    public void setProperty(String strName, boolean bValue) {
        this.setProperty(strName, String.valueOf(bValue));
    }

    public void setProperty(String strName, int nValue) {
        this.setProperty(strName, String.valueOf(nValue));
    }

    public void setProperty(String strName, long lValue) {
        this.setProperty(strName, String.valueOf(lValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void deleteProperty(String strName) {
        if (this.m_mapManager == null) {
            byte[] byArray = g_objManagerLock;
            // MONITORENTER : g_objManagerLock
            if (this.m_mapManager == null) {
                this.m_mapManager = new PropertyManager(this.m_strPropsName);
            }
            // MONITOREXIT : byArray
        }
        this.m_mapManager.deleteProp(strName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration propertyNames() {
        if (this.m_mapManager != null) return this.m_mapManager.propNames();
        byte[] byArray = g_objManagerLock;
        synchronized (g_objManagerLock) {
            if (this.m_mapManager != null) return this.m_mapManager.propNames();
            this.m_mapManager = new PropertyManager(this.m_strPropsName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_mapManager.propNames();
        }
    }

    public String[] propertyNamesArray() {
        return this.propertyNamesArray(false);
    }

    public String[] propertyNamesArray(boolean bDESC) {
        Enumeration emu = this.propertyNames();
        LinkedList<String> listName = new LinkedList<String>();
        if (emu == null) {
            return new String[0];
        }
        while (emu.hasMoreElements()) {
            String strName = (String)emu.nextElement();
            if (strName == null) continue;
            listName.add(strName);
        }
        Object[] arrayNames = new String[listName.size()];
        for (int i = 0; i < arrayNames.length; ++i) {
            arrayNames[i] = (String)listName.get(i);
        }
        Arrays.sort(arrayNames);
        if (bDESC) {
            String[] arrayNew = new String[arrayNames.length];
            int n = 0;
            int j = arrayNew.length - 1;
            while (n < arrayNew.length) {
                arrayNew[n] = arrayNames[j];
                ++n;
                --j;
            }
            return arrayNew;
        }
        return arrayNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean propertyFileIsReadable() {
        if (this.m_mapManager != null) return this.m_mapManager.propFileIsReadable();
        byte[] byArray = g_objManagerLock;
        synchronized (g_objManagerLock) {
            if (this.m_mapManager != null) return this.m_mapManager.propFileIsReadable();
            this.m_mapManager = new PropertyManager(this.m_strPropsName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_mapManager.propFileIsReadable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean propertyFileIsWritable() {
        if (this.m_mapManager != null) return this.m_mapManager.propFileIsWritable();
        byte[] byArray = g_objManagerLock;
        synchronized (g_objManagerLock) {
            if (this.m_mapManager != null) return this.m_mapManager.propFileIsWritable();
            this.m_mapManager = new PropertyManager(this.m_strPropsName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_mapManager.propFileIsWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean propertyFileExists() {
        if (this.m_mapManager != null) return this.m_mapManager.propFileExists();
        byte[] byArray = g_objManagerLock;
        synchronized (g_objManagerLock) {
            if (this.m_mapManager != null) return this.m_mapManager.propFileExists();
            this.m_mapManager = new PropertyManager(this.m_strPropsName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_mapManager.propFileExists();
        }
    }

    public String getPropertyManagerVersion() {
        return "1.2.1";
    }

    public int getPropertyManagerVersionMajor() {
        return 1;
    }

    public int getPropertyManagerVersionMinor() {
        return 2;
    }

    public int getPropertyManagerVersionRevision() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PropertyManager(String strResourceURI) {
        Enumeration<?> emuProp;
        this.m_strResourceURI = strResourceURI;
        this.m_strPropsName = strResourceURI;
        if (g_mapManagerCache.containsKey(strResourceURI)) {
            this.m_mapManager = (PropertyManager)g_mapManagerCache.get(strResourceURI);
            this.m_objProperties = this.m_mapManager.m_objProperties;
            return;
        }
        this.loadProps();
        if (this.m_objProperties == null || (emuProp = this.m_objProperties.propertyNames()) == null || !emuProp.hasMoreElements()) return;
        byte[] byArray = g_objManagercacheLock;
        synchronized (g_objManagercacheLock) {
            g_mapManagerCache.put(strResourceURI, this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadResource(String strResourceURI) {
        Enumeration<?> emuProp;
        this.m_strResourceURI = strResourceURI;
        this.m_strPropsName = strResourceURI;
        if (g_mapManagerCache.containsKey(strResourceURI)) {
            this.m_mapManager = (PropertyManager)g_mapManagerCache.get(strResourceURI);
            this.m_objProperties = this.m_mapManager.m_objProperties;
            return true;
        }
        this.loadProps();
        if (this.m_objProperties == null || (emuProp = this.m_objProperties.propertyNames()) == null || !emuProp.hasMoreElements()) return true;
        byte[] byArray = g_objManagercacheLock;
        synchronized (g_objManagercacheLock) {
            g_mapManagerCache.put(strResourceURI, this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected String getProp(String strName) {
        String property;
        if (this.m_objProperties == null) {
            byte[] byArray = this.m_objPropertiesLock;
            // MONITORENTER : this.m_objPropertiesLock
            if (this.m_objProperties == null) {
                this.loadProps();
            }
            // MONITOREXIT : byArray
        }
        if ((property = this.m_objProperties.getProperty(strName)) != null) return property.trim();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProp(String strName, String strValue) {
        byte[] byArray = this.m_objPropertiesLock;
        synchronized (this.m_objPropertiesLock) {
            if (this.m_objProperties == null) {
                this.loadProps();
            }
            this.m_objProperties.setProperty(strName, strValue);
            this.saveProps();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteProp(String strName) {
        byte[] byArray = this.m_objPropertiesLock;
        synchronized (this.m_objPropertiesLock) {
            if (this.m_objProperties == null) {
                this.loadProps();
            }
            this.m_objProperties.remove(strName);
            this.saveProps();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Enumeration propNames() {
        if (this.m_objProperties != null) return this.m_objProperties.propertyNames();
        byte[] byArray = this.m_objPropertiesLock;
        synchronized (this.m_objPropertiesLock) {
            if (this.m_objProperties != null) return this.m_objProperties.propertyNames();
            this.loadProps();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_objProperties.propertyNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        InputStream objIn = null;
        this.m_objProperties = new Properties();
        try {
            objIn = Util.getResourceAsStream(this.m_strResourceURI, this.getClass());
            if (objIn == null) {
                String strMsg = "\u8d44\u6e90 " + this.m_strResourceURI + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5728classpath\u641c\u7d22\u8def\u5f84\u4e2d\u3002";
                System.err.println(strMsg);
                log.error(strMsg);
                return;
            }
            this.m_objProperties.load(objIn);
            if (!this.propFileExists()) {
                log.debug("Property:" + this.m_strResourceURI + " can't save.");
            }
        }
        catch (Exception e) {
            String strMsg = "Error reading PropertyManager properties in PropertyManager.loadProps() resourceURI: " + this.m_strResourceURI + " " + e.getMessage();
            System.err.println(strMsg);
            log.error(strMsg, (Throwable)e);
        }
        finally {
            try {
                objIn.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProps() {
        String path = this.m_objProperties.getProperty("path").trim();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            this.m_objProperties.store(out, "PropertyManager.properties -- " + new Date());
        }
        catch (Exception ioe) {
            System.err.println("There was an error writing PropertyManager.properties to " + path + ". Ensure that the path exists and that the PropertyManager process has permission to write to it -- " + ioe);
            ioe.printStackTrace();
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean propFileIsReadable() {
        try {
            InputStream objIn = Util.getResourceAsStream(this.m_strResourceURI, this.getClass());
            objIn.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean propFileExists() {
        String path = this.getProp("path");
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.isFile();
    }

    public boolean propFileIsWritable() {
        String path = this.getProp("path");
        File file = new File(path);
        if (file.isFile()) {
            return file.canWrite();
        }
        return false;
    }
}

