/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtil.class);
    private static boolean g_native_lib_loaded = false;
    private static boolean g_native_lib_init_pending = true;
    private static int g_pid = -1;
    private List<ProcessInfo> m_allProcess;

    private static native String emuProcess(String var0);

    private static native boolean killProcessById(long var0);

    private static native boolean killProcessById(long var0, boolean var2);

    private static native int getProcessId();

    public ProcessUtil() {
        if (g_native_lib_init_pending) {
            ProcessUtil._initNativeLibrary();
        }
    }

    private static final synchronized void _initNativeLibrary() {
        if (!g_native_lib_init_pending) {
            return;
        }
        File libFile = Util.getNativeLibraryFile("dllinuxj");
        try {
            try {
                if (libFile != null) {
                    System.load(libFile.getAbsolutePath());
                }
            }
            catch (UnsatisfiedLinkError e) {
                System.loadLibrary("dllinuxj");
            }
            g_native_lib_loaded = true;
        }
        catch (SecurityException e) {
        }
        catch (UnsatisfiedLinkError e) {
            log.error("\u52a0\u8f7d\u8fdb\u7a0b\u5904\u7406\u5e93\u5931\u8d25\uff01{}", (Object)e.getMessage());
        }
        g_native_lib_init_pending = false;
    }

    public final List<ProcessInfo> list(String processNameKey) {
        this.m_allProcess = new ArrayList<ProcessInfo>();
        if (g_native_lib_loaded) {
            return this.listByNative(processNameKey != null && processNameKey.length() > 0 ? processNameKey : null);
        }
        return this.listByCommand(processNameKey != null && processNameKey.length() > 0 ? processNameKey : null);
    }

    private List<ProcessInfo> listByNative(String processNameKey) {
        try {
            String result = ProcessUtil.emuProcess(processNameKey);
            if (result != null && result.length() > 0) {
                for (String line : result.split("\n")) {
                    String[] args = line.split(",");
                    if (args.length < 5) continue;
                    this.m_allProcess.add(new ProcessInfo(args[0], args[1], args[2], args[3], args[4]));
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            g_native_lib_loaded = false;
            return this.listByCommand(processNameKey);
        }
        return this.m_allProcess;
    }

    private List<ProcessInfo> listByCommand(String processNameKey) {
        String cmd = Util.isWindows() ? "tasklist /v" : "ps -ef" + (processNameKey != null ? " | grep " + processNameKey : "");
        String cmdResult = Util.execCmd(cmd);
        int index = cmdResult.indexOf(58);
        if (index > 0) {
            String[] result = cmdResult.substring(0, index);
            if ("false".equalsIgnoreCase((String)result)) {
                log.error("\u67e5\u627e\u8fdb\u7a0b\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff1a{}", (Object)cmdResult.substring(index + 1));
                return this.m_allProcess;
            }
            cmdResult = cmdResult.substring(index + 1);
        }
        if (Util.isWindows()) {
            if (processNameKey != null) {
                processNameKey = processNameKey.trim().toLowerCase();
            }
            for (String line : cmdResult.split("\n")) {
                String val;
                if (line.length() <= 0) continue;
                String[] args = line.trim().split(" ");
                ArrayList<String> lstArg = new ArrayList<String>();
                for (String arg : args) {
                    if ((arg = arg.trim()).length() <= 0) continue;
                    lstArg.add(arg);
                }
                args = lstArg.toArray(new String[0]);
                if (args.length < 9 || line.charAt(0) == '=' || "PID".equalsIgnoreCase(args[1])) continue;
                StringBuffer sbufUserName = new StringBuffer();
                StringBuffer sbufProcessName = new StringBuffer();
                long processId = -1L;
                int len = args.length;
                for (index = 0; index < len; ++index) {
                    val = args[index];
                    if (val.length() == 0) continue;
                    if (index > 0 && processId < 0L) {
                        try {
                            processId = Long.parseLong(val);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (processId >= 0L) break;
                    if (sbufProcessName.length() > 0) {
                        sbufProcessName.append(' ');
                    }
                    sbufProcessName.append(val);
                }
                if (processNameKey != null && sbufProcessName.toString().toLowerCase().indexOf(processNameKey) < 0) continue;
                index += 6;
                while (index < len && (val = args[index]).indexOf(58) <= 0) {
                    if (sbufUserName.length() > 0) {
                        sbufUserName.append(' ');
                    }
                    sbufUserName.append(val);
                    ++index;
                }
                this.m_allProcess.add(new ProcessInfo(sbufUserName.toString(), String.valueOf(processId), "-1", sbufProcessName.toString(), null));
            }
        } else {
            StringBuffer param = new StringBuffer();
            for (String line : cmdResult.split("\n")) {
                if (line.length() <= 0) continue;
                String[] args = line.trim().split(" ");
                ArrayList<String> lstArg = new ArrayList<String>();
                for (String arg : args) {
                    if ((arg = arg.trim()).length() <= 0) continue;
                    lstArg.add(arg);
                }
                args = lstArg.toArray(new String[0]);
                if (args.length < 8 || "grep".equals(args[7]) || line.indexOf(" sh -c " + cmd) > 0) continue;
                param.delete(0, param.length());
                for (int n = 8; n < args.length; ++n) {
                    if (n > 8) {
                        param.append(' ');
                    }
                    param.append(args[n]);
                }
                this.m_allProcess.add(new ProcessInfo(args[0], args[1], args[2], args[7], param.toString()));
            }
        }
        return this.m_allProcess;
    }

    public static final boolean killProcess(long processId) {
        return ProcessUtil.killProcess(processId, false);
    }

    public static boolean killProcess(long processId, boolean force) {
        String cmdResult;
        int index;
        if (g_native_lib_init_pending) {
            ProcessUtil._initNativeLibrary();
        }
        if (g_native_lib_loaded) {
            try {
                return ProcessUtil.killProcessById(processId, force);
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    return ProcessUtil.killProcessById(processId);
                }
                catch (UnsatisfiedLinkError ex) {
                    g_native_lib_loaded = false;
                }
            }
        }
        if ((index = (cmdResult = Util.isWindows() ? Util.execCmd("taskkill " + (force ? "/F " : "") + "/PID " + processId) : Util.execCmd("kill " + (force ? "-9 " : "") + processId)).indexOf(58)) > 0) {
            String result = cmdResult.substring(0, index);
            if ("false".equalsIgnoreCase(result)) {
                log.error("\u505c\u6b62\u8fdb\u7a0b\u547d\u4ee4\u6267\u884c\u5931\u8d25\uff1a{}", (Object)cmdResult.substring(index + 1));
                return false;
            }
            return true;
        }
        return false;
    }

    public static final int getPid() {
        if (g_pid < 0) {
            if (g_native_lib_init_pending) {
                if (log.isTraceEnabled()) {
                    log.trace("\u52a0\u8f7d\u672c\u5730\u5e93");
                }
                ProcessUtil._initNativeLibrary();
            }
            try {
                if (g_native_lib_loaded) {
                    g_pid = ProcessUtil.getProcessId();
                } else {
                    log.info("\u65e0\u6cd5\u4ece{}\u52a0\u8f7d\u672c\u5730\u52a0\u901f\u5e93", (Object)System.getProperty("java.library.path"));
                    g_pid = Util.toInteger(Util.getPidName().split("@")[0], -1);
                }
            }
            catch (UnsatisfiedLinkError e) {
                log.info("\u4ece{}\u52a0\u8f7d\u7684\u672c\u5730\u52a0\u901f\u5e93\u4e0d\u652f\u6301", (Object)System.getProperty("java.library.path"));
                g_pid = Util.toInteger(Util.getPidName().split("@")[0], -1);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5f53\u524d\u8fdb\u7a0b\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                g_pid = Util.toInteger(Util.getPidName().split("@")[0], -1);
            }
        }
        return g_pid;
    }

    public static class ProcessInfo {
        private String m_userName;
        private long m_processId;
        private long m_parentId;
        private String m_processName;
        private String m_processArgs;

        public ProcessInfo(String userName, String processId, String parentId, String processName, String processArgs) {
            this.m_userName = userName;
            try {
                this.m_processId = Long.parseLong(processId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.m_parentId = Long.parseLong(parentId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_processName = processName;
            this.m_processArgs = processArgs != null ? processArgs : "";
        }

        public String getUserName() {
            return this.m_userName;
        }

        public long getProcessId() {
            return this.m_processId;
        }

        public long getParentId() {
            return this.m_parentId;
        }

        public String getProcessName() {
            return this.m_processName;
        }

        public String getProcessArgs() {
            return this.m_processArgs;
        }
    }
}

