/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.PropertyManager;
import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import com.oreilly.servlet.MultipartRequest;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamUtils {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.ParamUtils");
    private Hashtable m_mapParameter = null;
    private char m_cSplit = (char)58;
    private static String g_strCharacterEncoding = "UTF-8";

    public ParamUtils() {
    }

    public ParamUtils(char cSplit) {
        this.m_cSplit = cSplit;
    }

    private static boolean setCharSet() {
        PropertyManager objPropManager = new PropertyManager("/com/hynnet/setting.properties");
        String strCharset = objPropManager.getProperty("InputCharSet");
        if (strCharset == null || strCharset.length() == 0) {
            strCharset = objPropManager.getProperty("InputCharset");
        }
        if (strCharset == null || strCharset.length() == 0) {
            return false;
        }
        g_strCharacterEncoding = strCharset.trim().toUpperCase();
        log.debug("inputCharset=" + g_strCharacterEncoding);
        return true;
    }

    private static final boolean adjustInputCharset(HttpServletRequest request) {
        String strUserAgent = request.getHeader("User-Agent");
        if (strUserAgent != null && strUserAgent.toLowerCase().indexOf("msie") < 0) {
            try {
                if (!g_strCharacterEncoding.equalsIgnoreCase(request.getCharacterEncoding())) {
                    request.setCharacterEncoding(g_strCharacterEncoding);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u6574Firefox\u8bf7\u6c42\u65f6\u7684\u7f16\u7801\u5f02\u5e38\u3002");
            }
        }
        return false;
    }

    public static final String getCurrentURL(HttpServletRequest request) {
        try {
            String strURI = request.getRequestURI();
            String strQuery = request.getQueryString();
            if (strQuery != null) {
                strURI = strURI + '?' + strQuery;
            }
            URL reconstructedURL = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), strURI);
            return reconstructedURL.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String getParameter(HttpServletRequest request, String name) {
        return ParamUtils.getParameter(request, name, true);
    }

    public static final String[] getStringParameter(HttpServletRequest request, String name) {
        return ParamUtils.getStringParameter(request, name, true);
    }

    public static final String[] getParameters(HttpServletRequest request, String name) {
        return ParamUtils.getStringParameter(request, name, true);
    }

    public static final String getParameter(HttpServletRequest request, String strName, boolean bEmptyStringsOK) {
        ParamUtils.adjustInputCharset(request);
        String strResult = request.getParameter(strName);
        if (strResult != null) {
            if (strResult.equals("") && !bEmptyStringsOK) {
                return null;
            }
            return strResult.trim();
        }
        if (bEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public static final String[] getStringParameter(HttpServletRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = request.getParameterValues(name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            for (int n = 0; n < arrayPar.length; ++n) {
                arrayPar[n] = arrayPar[n].trim();
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(name);
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr.trim()};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            arrayPar = new String[]{};
            return arrayPar;
        }
        return null;
    }

    public static final String[] getParameters(HttpServletRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = request.getParameterValues(name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String strPar = request.getParameter(name);
        if (strPar != null) {
            if (strPar.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{strPar};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public static final boolean getBooleanParameter(HttpServletRequest request, String name) {
        return ParamUtils.getBooleanParameter(request, name, true);
    }

    public static final boolean getBooleanParameter(HttpServletRequest request, String name, boolean defaultVal) {
        String temp = request.getParameter(name);
        if ("true".equals(temp) || "on".equals(temp) || "1".equals(temp)) {
            return true;
        }
        if ("false".equals(temp) || "off".equals(temp) || "0".equals(temp)) {
            return false;
        }
        return defaultVal;
    }

    public static final boolean[] getBooleanParameters(HttpServletRequest request, String name, boolean defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final int getIntParameter(HttpServletRequest request, String strName, int nDefaultNum) {
        String strVal = request.getParameter(strName);
        if (strVal != null && !strVal.equals("")) {
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nDefaultNum;
    }

    public static final int getIntParameter(HttpServletRequest request, String strName, int lDefaultNum, String strRadix) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            return StringUtils.strToNumber(strVal, lDefaultNum, strRadix);
        }
        log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        return lDefaultNum;
    }

    public static final int[] getIntParameters(HttpServletRequest request, String name, int defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final double getDoubleParameter(HttpServletRequest request, String name, double dbDefault) {
        String strVal = request.getParameter(name);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = dbDefault;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dbVal;
        }
        return dbDefault;
    }

    public static final double[] getDoubleParameters(HttpServletRequest request, String name, double defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final double getDoubleAttribute(HttpServletRequest request, String strName, double dbDefault) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr instanceof double[]) {
            double[] arrayResult = (double[])objAttr;
            if (arrayResult.length > 0) {
                return arrayResult[0];
            }
            return dbDefault;
        }
        if (objAttr instanceof Double[]) {
            Double[] arrayData = (Double[])objAttr;
            double[] arrayResult = new double[arrayData.length];
            for (int n = 0; n < arrayData.length; ++n) {
                arrayResult[n] = arrayData[n] != null ? arrayData[n] : dbDefault;
            }
            if (arrayResult.length > 0) {
                return arrayResult[0];
            }
            return dbDefault;
        }
        if (objAttr instanceof String[]) {
            String[] arrayVal = (String[])objAttr;
            if (arrayVal.length > 0) {
                return Double.parseDouble(arrayVal[0]);
            }
            return dbDefault;
        }
        String strVal = (String)request.getAttribute(strName);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = dbDefault;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dbVal;
        }
        return dbDefault;
    }

    public static final double[] getDoubleAttributes(HttpServletRequest request, String strName, double dbDefault) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr instanceof double[]) {
            return (double[])objAttr;
        }
        if (objAttr instanceof Double[]) {
            Double[] arrayData = (Double[])objAttr;
            double[] arrayResult = new double[arrayData.length];
            for (int n = 0; n < arrayData.length; ++n) {
                arrayResult[n] = arrayData[n] != null ? arrayData[n] : dbDefault;
            }
            return arrayResult;
        }
        if (objAttr instanceof String[]) {
            String[] arrayVal = (String[])objAttr;
            double[] arrayResult = new double[arrayVal.length];
            for (int n = 0; n < arrayVal.length; ++n) {
                arrayResult[n] = arrayVal[n] != null ? Double.parseDouble(arrayVal[0]) : dbDefault;
            }
            return arrayResult;
        }
        String strVal = (String)request.getAttribute(strName);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = dbDefault;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new double[]{dbVal};
        }
        return new double[]{dbDefault};
    }

    public static final float getFloatParameter(HttpServletRequest request, String name, float defaultNum) {
        String temp = request.getParameter(name);
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public static final float[] getFloatParameters(HttpServletRequest request, String name, float defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new float[0];
        }
        float[] values = new float[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Float.parseFloat(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final long getLongParameter(HttpServletRequest request, String strName, long lDefaultNum) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            if (strVal != null && !strVal.equals("")) {
                try {
                    return Long.parseLong(strVal);
                }
                catch (Exception exception) {}
            }
        } else {
            log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        }
        return lDefaultNum;
    }

    public static final long getLongParameter(HttpServletRequest request, String strName, long lDefaultNum, String strRadix) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            return StringUtils.strToNumber(strVal, lDefaultNum, strRadix);
        }
        log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        return lDefaultNum;
    }

    public static final long[] getLongParameters(HttpServletRequest request, String name, long defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final long[] getLongParameters(HttpServletRequest request, String strName, boolean bEmptyOK) {
        if (request != null) {
            String[] arrayParamValue = request.getParameterValues(strName);
            if (arrayParamValue != null && arrayParamValue.length >= 1) {
                int i;
                int nSize = arrayParamValue.length;
                long[] arrayValue = new long[nSize];
                int j = 0;
                for (i = 0; i < arrayParamValue.length; ++i) {
                    try {
                        arrayValue[j] = Long.parseLong(arrayParamValue[i]);
                        ++j;
                        continue;
                    }
                    catch (Exception e) {
                        --nSize;
                    }
                }
                if (nSize < arrayValue.length) {
                    if (nSize <= 0) {
                        if (bEmptyOK) {
                            return new long[0];
                        }
                        return null;
                    }
                    long[] result = new long[nSize];
                    for (i = 0; i < nSize; ++i) {
                        result[i] = arrayValue[i];
                    }
                    return result;
                }
                return arrayValue;
            }
        } else {
            log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        }
        if (bEmptyOK) {
            return new long[0];
        }
        return null;
    }

    public static final String getParameter(MultipartRequest request, String name) {
        return ParamUtils.getParameter(request, name, true);
    }

    public static final String[] getStringParameter(MultipartRequest request, String name) {
        return ParamUtils.getStringParameter(request, name, true);
    }

    public static final String[] getParameters(MultipartRequest request, String name) {
        return ParamUtils.getStringParameter(request, name, true);
    }

    public static final String getParameter(MultipartRequest request, String name, boolean emptyStringsOK) {
        String temp = request.getParameter(name);
        if (temp != null) {
            if (temp.equals("") && !emptyStringsOK) {
                return null;
            }
            return temp.trim();
        }
        if (emptyStringsOK) {
            return "";
        }
        return null;
    }

    public static final String[] getStringParameter(MultipartRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = request.getParameterValues(name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            for (int n = 0; n < arrayPar.length; ++n) {
                arrayPar[n] = arrayPar[n].trim();
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(name);
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr.trim()};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            arrayPar = new String[]{};
            return arrayPar;
        }
        return null;
    }

    public static final String[] getParameters(MultipartRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = request.getParameterValues(name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(name);
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public static final boolean getBooleanParameter(MultipartRequest request, String name) {
        return ParamUtils.getBooleanParameter(request, name, true);
    }

    public static final boolean getBooleanParameter(MultipartRequest request, String name, boolean defaultVal) {
        String strValue = request.getParameter(name);
        if ("true".equals(strValue) || "on".equals(strValue) || "1".equals(strValue)) {
            return true;
        }
        if ("false".equals(strValue) || "off".equals(strValue) || "0".equals(strValue)) {
            return false;
        }
        return defaultVal;
    }

    public static final boolean[] getBooleanParameters(MultipartRequest request, String name, boolean defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final int getIntParameter(MultipartRequest request, String strName, int nDefaultNum) {
        String strVal = request.getParameter(strName);
        if (strVal != null && !strVal.equals("")) {
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nDefaultNum;
    }

    public static final int getIntParameter(MultipartRequest request, String strName, int nDefaultNum, String strRadix) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            return StringUtils.strToNumber(strVal, nDefaultNum, strRadix);
        }
        log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        return nDefaultNum;
    }

    public static final int[] getIntParameters(MultipartRequest request, String name, int defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final double getDoubleParameter(MultipartRequest request, String name, double defaultNum) {
        String temp = request.getParameter(name);
        if (temp != null && !temp.equals("")) {
            double num = defaultNum;
            try {
                num = Double.parseDouble(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public static final double[] getDoubleParameters(MultipartRequest request, String name, double defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final float getFloatParameter(MultipartRequest request, String name, float defaultNum) {
        String temp = request.getParameter(name);
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public static final float[] getFloatParameters(MultipartRequest request, String name, float defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new float[0];
        }
        float[] values = new float[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Float.parseFloat(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final long getLongParameter(MultipartRequest request, String strName, long lDefaultNum) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            if (strVal != null && !strVal.equals("")) {
                try {
                    return Long.parseLong(strVal);
                }
                catch (Exception exception) {}
            }
        } else {
            log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        }
        return lDefaultNum;
    }

    public static final long getLongParameter(MultipartRequest request, String strName, long lDefaultNum, String strRadix) {
        if (request != null) {
            String strVal = request.getParameter(strName);
            return StringUtils.strToNumber(strVal, lDefaultNum, strRadix);
        }
        log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        return lDefaultNum;
    }

    public static final long[] getLongParameters(MultipartRequest request, String name, long defaultNum) {
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public static final long[] getLongParameters(MultipartRequest request, String name, boolean emptyOK) {
        int i;
        String[] paramValues = request.getParameterValues(name);
        if (paramValues == null) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        if (paramValues.length < 1) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        int size = paramValues.length;
        long[] values = new long[size];
        int j = 0;
        for (i = 0; i < paramValues.length; ++i) {
            try {
                values[j] = Long.parseLong(paramValues[i]);
                ++j;
                continue;
            }
            catch (Exception e) {
                --size;
            }
        }
        if (size < values.length) {
            if (size <= 0) {
                if (emptyOK) {
                    return new long[0];
                }
                return null;
            }
            long[] result = new long[size];
            for (i = 0; i < size; ++i) {
                result[i] = values[i];
            }
            return result;
        }
        return values;
    }

    private final String getRealParamterName(HttpServletRequest request, String strName) {
        if (this.m_mapParameter == null) {
            this.m_mapParameter = new Hashtable();
            Enumeration objEnu = request.getParameterNames();
            while (objEnu.hasMoreElements()) {
                String strCurName = (String)objEnu.nextElement();
                int nIndex = strCurName.indexOf(this.m_cSplit);
                if (nIndex >= 0) {
                    String strKey = strCurName.substring(nIndex + 1);
                    if (!this.m_mapParameter.contains(strKey)) {
                        this.m_mapParameter.put(strKey, strCurName);
                        continue;
                    }
                    this.m_mapParameter.put(strKey, (String)this.m_mapParameter.get(strKey) + "&" + strCurName);
                    continue;
                }
                this.m_mapParameter.put(strCurName, strCurName);
            }
        }
        if (!this.m_mapParameter.containsKey(strName)) {
            return "";
        }
        return (String)this.m_mapParameter.get(strName);
    }

    private final String getRealParamterName(MultipartRequest request, String strName) {
        if (this.m_mapParameter == null) {
            this.m_mapParameter = new Hashtable();
            Enumeration objEnu = request.getParameterNames();
            while (objEnu.hasMoreElements()) {
                String strCurName = (String)objEnu.nextElement();
                int nIndex = strCurName.indexOf(this.m_cSplit);
                if (nIndex >= 0) {
                    String strKey = strCurName.substring(nIndex + 1);
                    if (!this.m_mapParameter.contains(strKey)) {
                        this.m_mapParameter.put(strKey, strCurName);
                        continue;
                    }
                    this.m_mapParameter.put(strKey, (String)this.m_mapParameter.get(strKey) + "&" + strCurName);
                    continue;
                }
                this.m_mapParameter.put(strCurName, strCurName);
            }
        }
        if (!this.m_mapParameter.contains(strName)) {
            return "";
        }
        return (String)this.m_mapParameter.get(strName);
    }

    private final String getRealParamterNameOne(HttpServletRequest request, String strName) {
        String strValue = this.getRealParamterName(request, strName);
        int nIndex = strValue.indexOf(38);
        if (nIndex >= 0) {
            return strValue.substring(0, nIndex);
        }
        return strValue;
    }

    private final String getRealParamterNameOne(MultipartRequest request, String strName) {
        String strValue = this.getRealParamterName(request, strName);
        int nIndex = strValue.indexOf(38);
        if (nIndex >= 0) {
            return strValue.substring(0, nIndex);
        }
        return strValue;
    }

    private final String[] getParameterValuesEndsWith(HttpServletRequest request, String strName) {
        String strParameter = this.getRealParamterName(request, strName);
        String[] arrayName = strParameter.split("&");
        StringList lstValue = new StringList(this.m_mapParameter.size() / 2);
        for (int n = 0; n < arrayName.length; ++n) {
            String[] arrayValue = request.getParameterValues(arrayName[n]);
            for (int i = 0; i < arrayValue.length; ++i) {
                lstValue.add(arrayValue[i]);
            }
        }
        return lstValue.toStringArray();
    }

    private final String[] getParameterValuesEndsWith(MultipartRequest request, String strName) {
        String strParameter = this.getRealParamterName(request, strName);
        String[] arrayName = strParameter.split("&");
        StringList lstValue = new StringList(this.m_mapParameter.size() / 2);
        for (int n = 0; n < arrayName.length; ++n) {
            String[] arrayValue = request.getParameterValues(arrayName[n]);
            for (int i = 0; i < arrayValue.length; ++i) {
                lstValue.add(arrayValue[i]);
            }
        }
        return lstValue.toStringArray();
    }

    public final String getParameterEndsWith(HttpServletRequest request, String name) {
        return this.getParameterEndsWith(request, name, true);
    }

    public final String[] getStringParameterEndsWith(HttpServletRequest request, String name) {
        return this.getStringParameterEndsWith(request, name, true);
    }

    public final String[] getParametersEndsWith(HttpServletRequest request, String name) {
        return this.getStringParameterEndsWith(request, name, true);
    }

    public final String getParameterEndsWith(HttpServletRequest request, String name, boolean emptyStringsOK) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null) {
            if (temp.equals("") && !emptyStringsOK) {
                return null;
            }
            return temp.trim();
        }
        if (emptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getStringParameterEndsWith(HttpServletRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = this.getParameterValuesEndsWith(request, name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            for (int n = 0; n < arrayPar.length; ++n) {
                arrayPar[n] = arrayPar[n].trim();
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(this.getRealParamterNameOne(request, name));
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr.trim()};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            arrayPar = new String[]{};
            return arrayPar;
        }
        return null;
    }

    public final String[] getParametersEndsWith(HttpServletRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = this.getParameterValuesEndsWith(request, name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(this.getRealParamterNameOne(request, name));
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public final boolean getBooleanParameterEndsWith(HttpServletRequest request, String name) {
        return this.getBooleanParameterEndsWith(request, name, true);
    }

    public final boolean getBooleanParameterEndsWith(HttpServletRequest request, String name, boolean defaultVal) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if ("true".equals(temp) || "on".equals(temp) || "1".equals(temp)) {
            return true;
        }
        if ("false".equals(temp) || "off".equals(temp) || "0".equals(temp)) {
            return false;
        }
        return defaultVal;
    }

    public final boolean[] getBooleanParametersEndsWith(HttpServletRequest request, String name, boolean defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final int getIntParameterEndsWith(HttpServletRequest request, String name, int defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            int num = defaultNum;
            try {
                num = Integer.parseInt(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final int[] getIntParametersEndsWith(HttpServletRequest request, String name, int defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final double getDoubleParameterEndsWith(HttpServletRequest request, String name, double defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            double num = defaultNum;
            try {
                num = Double.parseDouble(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final double[] getDoubleParametersEndsWith(HttpServletRequest request, String name, double defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final float getFloatParameterEndsWith(HttpServletRequest request, String name, float defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final float[] getFloatParametersEndsWith(HttpServletRequest request, String name, float defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new float[0];
        }
        float[] values = new float[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Float.parseFloat(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final long getLongParameterEndsWith(HttpServletRequest request, String name, long defaultNum) {
        String strValue = request.getParameter(this.getRealParamterNameOne(request, name));
        if (strValue != null && !strValue.equals("")) {
            long lNumber = defaultNum;
            try {
                lNumber = Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lNumber;
        }
        return defaultNum;
    }

    public final long[] getLongParametersEndsWith(HttpServletRequest request, String name, long defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final long[] getLongParametersEndsWith(HttpServletRequest request, String name, boolean emptyOK) {
        int i;
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        if (paramValues.length < 1) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        int size = paramValues.length;
        long[] values = new long[size];
        int j = 0;
        for (i = 0; i < paramValues.length; ++i) {
            try {
                values[j] = Long.parseLong(paramValues[i]);
                ++j;
                continue;
            }
            catch (Exception e) {
                --size;
            }
        }
        if (size < values.length) {
            if (size <= 0) {
                if (emptyOK) {
                    return new long[0];
                }
                return null;
            }
            long[] result = new long[size];
            for (i = 0; i < size; ++i) {
                result[i] = values[i];
            }
            return result;
        }
        return values;
    }

    public final String getParameterEndsWith(MultipartRequest request, String name) {
        return this.getParameterEndsWith(request, name, true);
    }

    public final String[] getStringParameterEndsWith(MultipartRequest request, String name) {
        return this.getStringParameterEndsWith(request, name, true);
    }

    public final String[] getParametersEndsWith(MultipartRequest request, String name) {
        return this.getStringParameterEndsWith(request, name, true);
    }

    public final String getParameterEndsWith(MultipartRequest request, String name, boolean emptyStringsOK) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null) {
            if (temp.equals("") && !emptyStringsOK) {
                return null;
            }
            return temp.trim();
        }
        if (emptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getStringParameterEndsWith(MultipartRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = this.getParameterValuesEndsWith(request, name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            for (int n = 0; n < arrayPar.length; ++n) {
                arrayPar[n] = arrayPar[n].trim();
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(this.getRealParamterNameOne(request, name));
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr.trim()};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            arrayPar = new String[]{};
            return arrayPar;
        }
        return null;
    }

    public final String[] getParametersEndsWith(MultipartRequest request, String name, boolean bEmptyStringsOK) {
        String[] arrayPar = this.getParameterValuesEndsWith(request, name);
        if (arrayPar != null) {
            if (!bEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !bEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String tempstr = request.getParameter(this.getRealParamterNameOne(request, name));
        if (tempstr != null) {
            if (tempstr.equals("") && !bEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr};
            return arrayPar;
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public final boolean getBooleanParameterEndsWith(MultipartRequest request, String name) {
        return this.getBooleanParameterEndsWith(request, name, true);
    }

    public final boolean getBooleanParameterEndsWith(MultipartRequest request, String name, boolean defaultVal) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if ("true".equals(temp) || "on".equals(temp) || "1".equals(temp)) {
            return true;
        }
        if ("false".equals(temp) || "off".equals(temp) || "0".equals(temp)) {
            return false;
        }
        return defaultVal;
    }

    public final boolean[] getBooleanParametersEndsWith(MultipartRequest request, String name, boolean defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final int getIntParameterEndsWith(MultipartRequest request, String name, int defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            int num = defaultNum;
            try {
                num = Integer.parseInt(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final int[] getIntParametersEndsWith(MultipartRequest request, String name, int defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final double getDoubleParameterEndsWith(MultipartRequest request, String name, double defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            double num = defaultNum;
            try {
                num = Double.parseDouble(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final double[] getDoubleParametersEndsWith(MultipartRequest request, String name, double defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final float getFloatParameterEndsWith(MultipartRequest request, String name, float defaultNum) {
        String temp = request.getParameter(this.getRealParamterNameOne(request, name));
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final float[] getFloatParametersEndsWith(MultipartRequest request, String name, float defaultNum) {
        String[] arrayValues = this.getParameterValuesEndsWith(request, name);
        if (arrayValues == null) {
            return null;
        }
        if (arrayValues.length < 1) {
            return new float[0];
        }
        float[] arrayResult = new float[arrayValues.length];
        for (int i = 0; i < arrayValues.length; ++i) {
            try {
                arrayResult[i] = Float.parseFloat(arrayValues[i]);
                continue;
            }
            catch (Exception e) {
                arrayResult[i] = defaultNum;
            }
        }
        return arrayResult;
    }

    public final long getLongParameterEndsWith(MultipartRequest request, String name, long defaultNum) {
        String objValue = request.getParameter(this.getRealParamterNameOne(request, name));
        if (objValue != null && !objValue.equals("")) {
            long lNum = defaultNum;
            try {
                lNum = Long.parseLong(objValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lNum;
        }
        return defaultNum;
    }

    public final long[] getLongParametersEndsWith(MultipartRequest request, String name, long defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final long[] getLongParametersEndsWith(MultipartRequest request, String name, boolean emptyOK) {
        int i;
        String[] paramValues = this.getParameterValuesEndsWith(request, name);
        if (paramValues == null) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        if (paramValues.length < 1) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        int size = paramValues.length;
        long[] values = new long[size];
        int j = 0;
        for (i = 0; i < paramValues.length; ++i) {
            try {
                values[j] = Long.parseLong(paramValues[i]);
                ++j;
                continue;
            }
            catch (Exception e) {
                --size;
            }
        }
        if (size < values.length) {
            if (size <= 0) {
                if (emptyOK) {
                    return new long[0];
                }
                return null;
            }
            long[] result = new long[size];
            for (i = 0; i < size; ++i) {
                result[i] = values[i];
            }
            return result;
        }
        return values;
    }

    public static final String getParameter(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getParameter((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getParameter((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public static final String[] getStringParameter(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getStringParameter((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getStringParameter((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public static final String[] getParameters(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getStringParameter((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getStringParameter((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public static final String getParameter(Object objRequest, String name, boolean emptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getParameter((HttpServletRequest)objRequest, name, emptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getParameter((MultipartRequest)objRequest, name, emptyStringsOK);
        }
        return null;
    }

    public static final String[] getStringParameter(Object objRequest, String name, boolean bEmptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getStringParameter((HttpServletRequest)objRequest, name, bEmptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getStringParameter((MultipartRequest)objRequest, name, bEmptyStringsOK);
        }
        return null;
    }

    public static final String[] getParameters(Object objRequest, String name, boolean bEmptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getParameters((HttpServletRequest)objRequest, name, bEmptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getParameters((MultipartRequest)objRequest, name, bEmptyStringsOK);
        }
        return null;
    }

    public static final boolean getBooleanParameter(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getBooleanParameter((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getBooleanParameter((MultipartRequest)objRequest, name, true);
        }
        return false;
    }

    public static final boolean getBooleanParameter(Object objRequest, String name, boolean defaultVal) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getBooleanParameter((HttpServletRequest)objRequest, name, defaultVal);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getBooleanParameter((MultipartRequest)objRequest, name, defaultVal);
        }
        return defaultVal;
    }

    public static final boolean[] getBooleanParameters(Object objRequest, String name, boolean defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getBooleanParameters((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getBooleanParameters((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public static final int getIntParameter(Object objRequest, String name, int defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getIntParameter((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getIntParameter((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public static final int[] getIntParameters(Object objRequest, String name, int defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getIntParameters((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getIntParameters((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public static final double getDoubleParameter(Object objRequest, String name, double defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getDoubleParameter((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getDoubleParameter((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public static final double[] getDoubleParameters(Object objRequest, String name, double defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getDoubleParameters((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getDoubleParameters((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public static final float getFloatParameter(Object objRequest, String name, float defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getFloatParameter((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getFloatParameter((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public static final float[] getFloatParameters(Object objRequest, String name, float defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getFloatParameters((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getFloatParameters((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public static final long getLongParameter(Object objRequest, String strName, long lDefaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getLongParameter((HttpServletRequest)objRequest, strName, lDefaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getLongParameter((MultipartRequest)objRequest, strName, lDefaultNum);
        }
        return lDefaultNum;
    }

    public static final long[] getLongParameters(Object objRequest, String name, long defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getLongParameters((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getLongParameters((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public static final long[] getLongParameters(Object objRequest, String name, boolean emptyOK) {
        if (objRequest instanceof HttpServletRequest) {
            return ParamUtils.getLongParameters((HttpServletRequest)objRequest, name, emptyOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return ParamUtils.getLongParameters((MultipartRequest)objRequest, name, emptyOK);
        }
        return null;
    }

    private final String getRealParamterName(Object objRequest, String strName) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getRealParamterName((HttpServletRequest)objRequest, strName);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getRealParamterName((MultipartRequest)objRequest, strName);
        }
        return null;
    }

    private final String getRealParamterNameOne(Object objRequest, String strName) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getRealParamterNameOne((HttpServletRequest)objRequest, strName);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getRealParamterNameOne((MultipartRequest)objRequest, strName);
        }
        return null;
    }

    private final String[] getParameterValuesEndsWith(Object objRequest, String strName) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getParameterValuesEndsWith((HttpServletRequest)objRequest, strName);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getParameterValuesEndsWith((MultipartRequest)objRequest, strName);
        }
        return null;
    }

    public final String getParameterEndsWith(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getParameterEndsWith((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getParameterEndsWith((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public final String[] getStringParameterEndsWith(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getStringParameterEndsWith((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getStringParameterEndsWith((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public final String[] getParametersEndsWith(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getStringParameterEndsWith((HttpServletRequest)objRequest, name, true);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getStringParameterEndsWith((MultipartRequest)objRequest, name, true);
        }
        return null;
    }

    public final String getParameterEndsWith(Object objRequest, String name, boolean emptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getParameterEndsWith((HttpServletRequest)objRequest, name, emptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getParameterEndsWith((MultipartRequest)objRequest, name, emptyStringsOK);
        }
        return null;
    }

    public final String[] getStringParameterEndsWith(Object objRequest, String name, boolean bEmptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getStringParameterEndsWith((HttpServletRequest)objRequest, name, bEmptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getStringParameterEndsWith((MultipartRequest)objRequest, name, bEmptyStringsOK);
        }
        return null;
    }

    public final String[] getParametersEndsWith(Object objRequest, String name, boolean bEmptyStringsOK) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getParametersEndsWith((HttpServletRequest)objRequest, name, bEmptyStringsOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getParametersEndsWith((MultipartRequest)objRequest, name, bEmptyStringsOK);
        }
        return null;
    }

    public final boolean getBooleanParameterEndsWith(Object objRequest, String name) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getBooleanParameterEndsWith((HttpServletRequest)objRequest, name);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getBooleanParameterEndsWith((MultipartRequest)objRequest, name);
        }
        return false;
    }

    public final boolean getBooleanParameterEndsWith(Object objRequest, String name, boolean defaultVal) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getBooleanParameterEndsWith((HttpServletRequest)objRequest, name, defaultVal);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getBooleanParameterEndsWith((MultipartRequest)objRequest, name, defaultVal);
        }
        return defaultVal;
    }

    public final boolean[] getBooleanParametersEndsWith(Object objRequest, String name, boolean defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getBooleanParametersEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getBooleanParametersEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public final int getIntParameterEndsWith(Object objRequest, String name, int defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getIntParameterEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getIntParameterEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public final int[] getIntParametersEndsWith(Object objRequest, String name, int defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getIntParametersEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getIntParametersEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public final double getDoubleParameterEndsWith(Object objRequest, String name, double defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getDoubleParameterEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getDoubleParameterEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public final double[] getDoubleParametersEndsWith(Object objRequest, String name, double defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getDoubleParametersEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getDoubleParametersEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public final float getFloatParameterEndsWith(Object objRequest, String name, float defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getFloatParameterEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getFloatParameterEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public final float[] getFloatParametersEndsWith(Object objRequest, String name, float defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getFloatParametersEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getFloatParametersEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public final long getLongParameterEndsWith(Object objRequest, String name, long defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getLongParameterEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getLongParameterEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return defaultNum;
    }

    public final long[] getLongParametersEndsWith(Object objRequest, String name, long defaultNum) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getLongParametersEndsWith((HttpServletRequest)objRequest, name, defaultNum);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getLongParametersEndsWith((MultipartRequest)objRequest, name, defaultNum);
        }
        return null;
    }

    public final long[] getLongParametersEndsWith(Object objRequest, String name, boolean emptyOK) {
        if (objRequest instanceof HttpServletRequest) {
            return this.getLongParametersEndsWith((HttpServletRequest)objRequest, name, emptyOK);
        }
        if (objRequest instanceof MultipartRequest) {
            return this.getLongParametersEndsWith((MultipartRequest)objRequest, name, emptyOK);
        }
        return null;
    }

    public static final String getAttribute(HttpServletRequest request, String strName) {
        return ParamUtils.getAttribute(request, strName, true);
    }

    public static final String[] getStringAttribute(HttpServletRequest request, String strName) {
        return ParamUtils.getStringAttribute(request, strName, true);
    }

    public static final String getAttribute(HttpServletRequest request, String strName, boolean bEmptyStringsOK) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                return (String)objAttr;
            }
            if (objAttr instanceof int[]) {
                int[] arrayValues = (int[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof long[]) {
                long[] arrayValues = (long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof boolean[]) {
                boolean[] arrayValues = (boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer[]) {
                Integer[] arrayValues = (Integer[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Long[]) {
                Long[] arrayValues = (Long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Boolean[]) {
                Boolean[] arrayValues = (Boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer) {
                Integer objValue = (Integer)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Long) {
                Long objValue = (Long)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Boolean) {
                Boolean objValue = (Boolean)objAttr;
                return objValue.toString();
            }
            return objAttr.toString();
        }
        if (bEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public static final String[] getStringAttribute(HttpServletRequest request, String strName, boolean bEmptyStringsOK) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr != null) {
            if (objAttr instanceof String[]) {
                if (((String[])objAttr).length <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                return (String[])objAttr;
            }
            if (objAttr instanceof String) {
                String[] arrayAttr = new String[1];
                if (((String)objAttr).equals("") && !bEmptyStringsOK) {
                    return null;
                }
                arrayAttr[0] = (String)objAttr;
                return arrayAttr;
            }
            if (objAttr instanceof int[]) {
                int[] arrayValues = (int[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof long[]) {
                long[] arrayValues = (long[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof boolean[]) {
                boolean[] arrayValues = (boolean[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Integer[]) {
                Integer[] arrayValues = (Integer[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Integer) {
                String[] arrayResult = new String[]{String.valueOf((Integer)objAttr)};
                return arrayResult;
            }
            if (objAttr instanceof Long[]) {
                Long[] arrayValues = (Long[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Long) {
                String[] arrayResult = new String[]{String.valueOf((Long)objAttr)};
                return arrayResult;
            }
            if (objAttr instanceof Boolean[]) {
                Boolean[] arrayValues = (Boolean[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Boolean) {
                String[] arrayResult = new String[]{String.valueOf((Boolean)objAttr)};
                return arrayResult;
            }
            String[] arrayAttr = new String[1];
            log.error("\u5c5e\u6027 " + strName + " \u7684\u7c7b\u578b\u4e0d\u662f\u5b57\u7b26\u4e32\u6570\u7ec4\u3002");
            arrayAttr[0] = objAttr.toString();
            return arrayAttr;
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public static final boolean getBooleanAttribute(HttpServletRequest request, String strName) {
        return ParamUtils.getBooleanAttribute(request, strName, false);
    }

    public static final boolean getBooleanAttribute(HttpServletRequest request, String strName, boolean bDefValue) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr instanceof String) {
            if ("true".equals(objAttr) || "on".equals(objAttr) || "1".equals(objAttr)) {
                return true;
            }
            if ("false".equals(objAttr) || "off".equals(objAttr) || "0".equals(objAttr)) {
                return false;
            }
        } else {
            if (objAttr instanceof Boolean) {
                return (Boolean)objAttr;
            }
            if (objAttr instanceof boolean[]) {
                if (((boolean[])objAttr).length > 0) {
                    return ((boolean[])objAttr)[0];
                }
            } else if (objAttr instanceof Boolean[]) {
                if (((Boolean[])objAttr).length > 0) {
                    return ((Boolean[])objAttr)[0];
                }
            } else if (objAttr instanceof Integer) {
                if ((Integer)objAttr == 1) {
                    return true;
                }
                if ((Integer)objAttr == 0) {
                    return false;
                }
            } else if (objAttr instanceof Long) {
                if ((Integer)objAttr == 1) {
                    return true;
                }
                if ((Integer)objAttr == 0) {
                    return false;
                }
            } else if (objAttr != null) {
                log.error("\u5c5e\u6027 " + strName + " \u7684\u7c7b\u578b\u4e0d\u6b63\u786e" + strName);
            }
        }
        return bDefValue;
    }

    public static final boolean[] getBooleanAttributes(HttpServletRequest request, String name, boolean defaultNum) {
        Object objAttr = request.getAttribute(name);
        if (objAttr == null) {
            return null;
        }
        if (objAttr instanceof String[]) {
            if (((String[])objAttr).length < 1) {
                return new boolean[0];
            }
            boolean[] arrayValues = new boolean[((String[])objAttr).length];
            for (int i = 0; i < arrayValues.length; ++i) {
                try {
                    arrayValues[i] = Boolean.getBoolean(((String[])objAttr)[i]);
                    continue;
                }
                catch (Exception e) {
                    arrayValues[i] = defaultNum;
                }
            }
            return arrayValues;
        }
        if (objAttr instanceof boolean[]) {
            return (boolean[])objAttr;
        }
        if (objAttr instanceof Boolean[]) {
            boolean[] arrayValues = new boolean[((Boolean[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Boolean[])objAttr)[n];
            }
            return arrayValues;
        }
        if (objAttr instanceof Boolean) {
            boolean[] arrayValues = new boolean[]{(Boolean)objAttr};
            return arrayValues;
        }
        if (objAttr instanceof Integer[]) {
            boolean[] arrayValues = new boolean[((Integer[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Integer[])objAttr)[n] != 0;
            }
            return arrayValues;
        }
        if (objAttr instanceof Long[]) {
            boolean[] arrayValues = new boolean[((Long[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Long[])objAttr)[n].intValue() != 0;
            }
            return arrayValues;
        }
        boolean[] arrayValues = new boolean[1];
        log.error("\u719f\u6089 " + name + " \u7684\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + objAttr);
        arrayValues[0] = defaultNum;
        return arrayValues;
    }

    public static final int getIntAttribute(HttpServletRequest request, String strName, int nDefaultNum) {
        Object objAttr = request.getAttribute(strName);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                try {
                    if (((String)objAttr).length() > 0) {
                        return Integer.parseInt((String)objAttr);
                    }
                }
                catch (Exception exception) {}
            } else {
                if (objAttr instanceof Integer) {
                    return (Integer)objAttr;
                }
                if (objAttr instanceof Long) {
                    return ((Long)objAttr).intValue();
                }
                if (objAttr instanceof int[]) {
                    if (((int[])objAttr).length > 0) {
                        return ((int[])objAttr)[0];
                    }
                } else if (objAttr instanceof long[] && ((long[])objAttr).length > 0) {
                    return (int)((long[])objAttr)[0];
                }
            }
        }
        return nDefaultNum;
    }

    public static final long getLongAttribute(HttpServletRequest request, String strName, long lDefaultNum) {
        if (request != null) {
            Object objAttr = request.getAttribute(strName);
            if (objAttr != null) {
                if (objAttr instanceof String) {
                    long lNum = lDefaultNum;
                    try {
                        if (((String)objAttr).length() > 0) {
                            lNum = Long.parseLong((String)objAttr);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return lNum;
                }
                if (objAttr instanceof Integer) {
                    return ((Integer)objAttr).longValue();
                }
                if (objAttr instanceof Long) {
                    return (Long)objAttr;
                }
                if (objAttr instanceof int[]) {
                    if (((int[])objAttr).length > 0) {
                        return ((int[])objAttr)[0];
                    }
                } else if (objAttr instanceof long[] && ((long[])objAttr).length > 0) {
                    return ((long[])objAttr)[0];
                }
            }
        } else {
            log.error("\u53d1\u73b0\u8bf7\u6c42\u4e3a\u7a7a\uff01", (Throwable)new Exception());
        }
        return lDefaultNum;
    }

    public static final String getSessionAttribute(HttpServletRequest request, String name) {
        return ParamUtils.getSessionAttribute(request, name, true);
    }

    public static final String[] getStringSessionAttribute(HttpServletRequest request, String name) {
        return ParamUtils.getStringSessionAttribute(request, name, true);
    }

    public static final String getSessionAttribute(HttpServletRequest request, String strName, boolean bEmptyStringsOK) {
        HttpSession objSession = request.getSession(false);
        if (objSession == null) {
            return bEmptyStringsOK ? "" : null;
        }
        Object objAttr = objSession.getAttribute(strName);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                return (String)objAttr;
            }
            if (objAttr instanceof int[]) {
                int[] arrayValues = (int[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof long[]) {
                long[] arrayValues = (long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof boolean[]) {
                boolean[] arrayValues = (boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer[]) {
                Integer[] arrayValues = (Integer[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Long[]) {
                Long[] arrayValues = (Long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Boolean[]) {
                Boolean[] arrayValues = (Boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer) {
                Integer objValue = (Integer)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Long) {
                Long objValue = (Long)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Boolean) {
                Boolean objValue = (Boolean)objAttr;
                return objValue.toString();
            }
            log.error("Session\u7684" + strName + "\u5c5e\u6027\u7c7b\u578b\u4e0d\u6b63\u786e" + objAttr);
            return objAttr.toString();
        }
        if (bEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public static final String[] getStringSessionAttribute(HttpServletRequest request, String strName, boolean bEmptyStringsOK) {
        HttpSession objSession = request.getSession(false);
        if (objSession == null) {
            return bEmptyStringsOK ? new String[]{} : null;
        }
        Object objAttr = objSession.getAttribute(strName);
        if (objAttr != null) {
            if (objAttr instanceof String[]) {
                if (((String[])objAttr).length <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                return (String[])objAttr;
            }
            if (objAttr instanceof String) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                String[] arrayValues = new String[]{(String)objAttr};
                return arrayValues;
            }
            if (objAttr instanceof Integer) {
                String[] arrayValues = new String[]{((Integer)objAttr).toString()};
                return arrayValues;
            }
            if (objAttr instanceof Long) {
                String[] arrayValues = new String[]{((Long)objAttr).toString()};
                return arrayValues;
            }
            if (objAttr instanceof Boolean) {
                String[] arrayValues = new String[]{((Boolean)objAttr).toString()};
                return arrayValues;
            }
            if (objAttr instanceof int[]) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                String[] arrayValues = new String[((int[])objAttr).length];
                for (int n = 0; n < arrayValues.length; ++n) {
                    arrayValues[n] = String.valueOf(((int[])objAttr)[n]);
                }
                return arrayValues;
            }
            if (objAttr instanceof long[]) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                String[] arrayValues = new String[((long[])objAttr).length];
                for (int n = 0; n < arrayValues.length; ++n) {
                    arrayValues[n] = String.valueOf(((long[])objAttr)[n]);
                }
                return arrayValues;
            }
            if (objAttr instanceof boolean[]) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                String[] arrayValues = new String[((boolean[])objAttr).length];
                for (int n = 0; n < arrayValues.length; ++n) {
                    arrayValues[n] = String.valueOf(((boolean[])objAttr)[n]);
                }
                return arrayValues;
            }
            if (objAttr instanceof Integer[]) {
                if (((String)objAttr).length() <= 0 && !bEmptyStringsOK) {
                    return null;
                }
                String[] arrayValues = new String[((Integer[])objAttr).length];
                for (int n = 0; n < arrayValues.length; ++n) {
                    arrayValues[n] = String.valueOf(((Integer[])objAttr)[n]);
                }
                return arrayValues;
            }
        }
        if (bEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public static final boolean getBooleanSessionAttribute(HttpServletRequest request, String name) {
        String strValue = ParamUtils.getSessionAttribute(request, name);
        if ("true".equals(strValue) || "on".equals(strValue) || "1".equals(strValue)) {
            return true;
        }
        if ("false".equals(strValue) || "off".equals(strValue) || "0".equals(strValue)) {
            return false;
        }
        return false;
    }

    public static final boolean[] getBooleanSessionAttribute(HttpServletRequest request, String strName, boolean bDefault) {
        HttpSession objSession = request.getSession(false);
        if (objSession == null) {
            return null;
        }
        Object objAttr = objSession.getAttribute(strName);
        if (objAttr instanceof boolean[]) {
            return (boolean[])objAttr;
        }
        String[] arrayValues = ParamUtils.getStringSessionAttribute(request, strName, false);
        if (arrayValues == null) {
            return null;
        }
        if (arrayValues.length < 1) {
            return new boolean[0];
        }
        boolean[] arrayResult = new boolean[arrayValues.length];
        for (int i = 0; i < arrayValues.length; ++i) {
            try {
                arrayResult[i] = Boolean.getBoolean(arrayValues[i]);
                continue;
            }
            catch (Exception e) {
                arrayResult[i] = bDefault;
            }
        }
        return arrayResult;
    }

    public static final int getIntSessionAttribute(HttpServletRequest request, String name, int defaultNum) {
        String strValue = ParamUtils.getSessionAttribute(request, name);
        if (strValue != null && strValue.length() > 0) {
            int nNum = defaultNum;
            try {
                nNum = Integer.parseInt(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return nNum;
        }
        return defaultNum;
    }

    public static final long getLongSessionAttribute(HttpServletRequest request, String name, long defaultNum) {
        String strValue = ParamUtils.getSessionAttribute(request, name);
        if (strValue != null && !strValue.equals("")) {
            long num = defaultNum;
            try {
                num = Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    static {
        ParamUtils.setCharSet();
    }
}

