/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.PageInfo;
import com.hynnet.util.PageInfoCondition;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageInfoSessionMaker {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.util.PageInfoSessionMaker");
    private HttpSession m_session;
    private String m_sessionName;
    private int m_pageSize;
    private int m_currentPage;
    private PageInfoCondition m_condition;

    protected abstract void addCondition(PageInfoCondition var1);

    protected abstract PageInfo createPageInfo(PageInfoCondition var1) throws Exception;

    public PageInfoSessionMaker(HttpSession session, String sessionName, int pageSize, int currentPage, PageInfoCondition condition) {
        this.m_session = session;
        this.m_sessionName = sessionName;
        this.m_pageSize = pageSize;
        this.m_currentPage = currentPage;
        if (condition != null) {
            this.m_condition = (PageInfoCondition)condition.clone();
        }
    }

    public final PageInfo getPageInfo() {
        PageInfo pageInfo;
        PageInfoCondition condition = this.getPageInfoCondition();
        this.addCondition(condition);
        PageInfo pageInfo2 = pageInfo = this.m_session != null ? (PageInfo)this.m_session.getAttribute(this.m_sessionName) : null;
        if (pageInfo == null || pageInfo.isConditionChanged(condition)) {
            try {
                pageInfo = this.createPageInfo(condition);
                if (this.m_session != null) {
                    this.m_session.setAttribute(this.m_sessionName, (Object)pageInfo);
                }
            }
            catch (Exception e) {
                log.warn("\u521b\u5efa\u5206\u9875\u5bf9\u8c61\u5f02\u5e38\uff1a" + e, (Throwable)e);
            }
        }
        pageInfo.setPageSize(this.m_pageSize);
        pageInfo.setCurrentPage(this.m_currentPage);
        return pageInfo;
    }

    public final int getPageSize() {
        return this.m_pageSize;
    }

    public final PageInfoCondition getPageInfoCondition() {
        if (this.m_condition == null) {
            this.m_condition = new PageInfoCondition();
        }
        return this.m_condition;
    }

    public final int getCurrentPage() {
        return this.m_currentPage;
    }
}

