/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.ChineseComparator;
import com.hynnet.util.LongList;
import com.hynnet.util.PageInfoCondition;
import com.hynnet.util.StringList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.util.PageInfo");
    public static int DEFAULT_PAGESIZE = 10;
    public static int DEFAULT_TOTAL_LIST_PAGE = 10;
    private int m_currentPage = 1;
    private int m_pageSize = DEFAULT_PAGESIZE;
    private int m_total = 0;
    private int m_totalPage = 0;
    private int m_pageDataFrom;
    private int m_pageDataTo;
    private long m_dataFrom = 0L;
    private long m_dataTo = 0L;
    private int m_totalListPage = DEFAULT_TOTAL_LIST_PAGE;
    private boolean m_hasNextPage = false;
    private boolean m_hasPreviousPage = false;
    private PageInfoCondition m_condition;
    private List<Object> m_datas;
    private LongList m_longIds = null;
    private StringList m_stringIds = null;
    private Class m_clsType = null;
    private String m_property;
    private boolean m_isOrderAsc;
    private Object m_caller = null;
    private Method m_method = null;

    public PageInfo() {
        this((PageInfoCondition)null);
    }

    public PageInfo(PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
    }

    public PageInfo(List datas, PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
        if (datas != null) {
            if (datas.size() > 0) {
                this.m_clsType = datas.get(0).getClass();
            }
            this.m_datas = new ArrayList<Object>();
            this.m_datas.addAll(datas);
            this.m_total = this.m_datas.size();
            this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
            this.m_pageDataFrom = 1;
            this.m_pageDataTo = this.m_totalPage;
            this.m_dataFrom = 0L;
            this.m_dataTo = datas.size() - 1;
            this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
            this.m_hasPreviousPage = false;
        }
    }

    public PageInfo(List datas) {
        this(datas, null);
    }

    public PageInfo(List datas, int pageSize, int currentPage, PageInfoCondition condition) {
        this(datas, pageSize, currentPage, -1L, -1L, -1L, condition);
    }

    public PageInfo(List datas, int pageSize, int currentPage) {
        this(datas, pageSize, currentPage, -1L, -1L, -1L, null);
    }

    public PageInfo(List datas, int pageSize, int currentPage, long total, PageInfoCondition condition) {
        this(datas, pageSize, currentPage, total, -1L, -1L, condition);
    }

    public PageInfo(List datas, int pageSize, int currentPage, long total) {
        this(datas, pageSize, currentPage, total, -1L, -1L, null);
    }

    public PageInfo(List datas, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo, PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
        if (datas != null) {
            if (datas.size() > 0) {
                this.m_clsType = datas.get(0).getClass();
            }
            this.m_datas = new ArrayList<Object>();
            this.m_datas.addAll(datas);
            if (pageSize > 0) {
                this.m_pageSize = pageSize;
            }
            this.m_total = this.m_datas.size();
            if (dataIndexTo > 0L && total <= 0L) {
                total = dataIndexTo + 1L;
            }
            if (total > (long)this.m_total) {
                this.m_total = (int)total;
            }
            this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
            if (currentPage <= this.m_totalPage && currentPage >= 1) {
                this.m_currentPage = currentPage;
            }
            if (total > (long)this.m_datas.size()) {
                if (dataIndexFrom >= 0L) {
                    this.m_dataFrom = dataIndexFrom;
                } else {
                    dataIndexFrom = this.m_dataFrom = (long)((this.m_currentPage - 1) * this.m_pageSize);
                }
                this.m_dataTo = dataIndexTo > 0L && dataIndexTo - dataIndexFrom + 1L < (long)this.m_datas.size() ? dataIndexTo : this.m_dataFrom + (long)this.m_datas.size() - 1L;
                this.m_pageDataFrom = this.m_dataFrom % (long)this.m_pageSize == 0L ? (int)(this.m_dataFrom / (long)this.m_pageSize) + 1 : (int)(this.m_dataFrom / (long)this.m_pageSize) + 2;
                this.m_pageDataTo = this.m_pageDataFrom + (this.m_datas.size() / this.m_pageSize - 1);
                if (this.m_datas.size() % this.m_pageSize > 0) {
                    ++this.m_pageDataTo;
                }
            } else {
                this.m_pageDataFrom = 1;
                this.m_pageDataTo = this.m_totalPage;
                this.m_dataFrom = 0L;
                this.m_dataTo = this.m_datas.size() - 1;
            }
            this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
            this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
        }
    }

    public PageInfo(List datas, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo) {
        this(datas, pageSize, currentPage, total, dataIndexFrom, dataIndexTo, null);
    }

    public PageInfo(LongList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, PageInfoCondition condition) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, -1L, -1L, condition);
    }

    public PageInfo(LongList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, -1L, -1L, null);
    }

    public PageInfo(LongList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo, PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
        if (ids == null || caller == null || funName == null || funName.trim().length() == 0 || dataCls == null) {
            log.error("ID\u5217\u8868\u3001\u8c03\u7528\u5bf9\u8c61\u3001\u51fd\u6570\u540d\u3001\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        try {
            this.m_caller = caller;
            try {
                this.m_method = caller.getClass().getMethod(funName, Long.TYPE);
            }
            catch (Exception ex) {
                this.m_method = caller.getClass().getMethod(funName, Long.class);
            }
            this.m_clsType = dataCls;
        }
        catch (Exception e) {
            log.error("\u6784\u9020\u5206\u9875\u5bf9\u8c61\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        if (pageSize > 0) {
            this.m_pageSize = pageSize;
        }
        this.m_longIds = (LongList)ids.clone();
        this.m_datas = new ArrayList<Object>();
        this.m_total = ids.size();
        if (dataIndexTo > 0L && dataIndexTo > total) {
            total = dataIndexTo + 1L;
        }
        if (total > (long)this.m_total) {
            this.m_total = (int)total;
        }
        this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
        if (currentPage <= this.m_totalPage && currentPage >= 1) {
            this.m_currentPage = currentPage;
        }
        if (total > (long)ids.size()) {
            this.m_pageDataFrom = this.m_currentPage;
            this.m_pageDataTo = this.m_currentPage + (ids.size() / this.m_pageSize - 1);
            if (ids.size() % this.m_pageSize > 0) {
                ++this.m_pageDataTo;
            }
            this.m_dataFrom = dataIndexFrom >= 0L ? dataIndexFrom : (long)((this.m_pageDataFrom - 1) * this.m_pageSize);
            this.m_dataTo = dataIndexTo > 0L && dataIndexTo - dataIndexFrom + 1L < (long)ids.size() ? dataIndexTo : this.m_dataFrom + (long)ids.size() - 1L;
        } else {
            this.m_pageDataFrom = 1;
            this.m_pageDataTo = this.m_totalPage;
            this.m_dataFrom = 0L;
            this.m_dataTo = ids.size() - 1;
        }
        this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
        this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
    }

    public PageInfo(LongList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, dataIndexFrom, dataIndexTo, null);
    }

    public PageInfo(StringList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, -1L, -1L, -1L, null);
    }

    public PageInfo(StringList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, PageInfoCondition condition) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, -1L, -1L, condition);
    }

    public PageInfo(StringList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, -1L, -1L, null);
    }

    public PageInfo(StringList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo, PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
        if (ids == null || caller == null || funName == null || funName.trim().length() == 0 || dataCls == null) {
            log.error("ID\u5217\u8868\u3001\u8c03\u7528\u5bf9\u8c61\u3001\u51fd\u6570\u540d\u3001\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        try {
            this.m_caller = caller;
            this.m_method = caller.getClass().getMethod(funName, String.class);
            this.m_clsType = dataCls;
        }
        catch (Exception e) {
            log.error("\u6784\u9020\u5206\u9875\u5bf9\u8c61\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        if (pageSize > 0) {
            this.m_pageSize = pageSize;
        }
        this.m_stringIds = (StringList)ids.clone();
        this.m_datas = new ArrayList<Object>();
        this.m_total = ids.size();
        if (dataIndexTo > 0L && dataIndexTo > total) {
            total = dataIndexTo + 1L;
        }
        if (total > (long)this.m_total) {
            this.m_total = (int)total;
        }
        this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
        if (currentPage <= this.m_totalPage && currentPage >= 1) {
            this.m_currentPage = currentPage;
        }
        if (total > (long)ids.size()) {
            this.m_pageDataFrom = this.m_currentPage;
            this.m_pageDataTo = this.m_currentPage + (ids.size() / this.m_pageSize - 1);
            if (ids.size() % this.m_pageSize > 0) {
                ++this.m_pageDataTo;
            }
            this.m_dataFrom = dataIndexFrom >= 0L ? dataIndexFrom : (long)((this.m_pageDataFrom - 1) * this.m_pageSize);
            this.m_dataTo = dataIndexTo > 0L && dataIndexTo - dataIndexFrom + 1L < (long)ids.size() ? dataIndexTo : this.m_dataFrom + (long)ids.size() - 1L;
        } else {
            this.m_pageDataFrom = 1;
            this.m_pageDataTo = this.m_totalPage;
            this.m_dataFrom = 0L;
            this.m_dataTo = ids.size() - 1;
        }
        this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
        this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
    }

    public PageInfo(StringList ids, Object caller, String funName, Class dataCls, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo) {
        this(ids, caller, funName, dataCls, pageSize, currentPage, total, dataIndexFrom, dataIndexTo, null);
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage) {
        this(datas, pageSize, currentPage, (long)datas.length, -1L, -1L, null);
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage, PageInfoCondition condition) {
        this(datas, pageSize, currentPage, (long)datas.length, -1L, -1L, condition);
    }

    public PageInfo(Object[] datas, PageInfoCondition condition) {
        this(datas, DEFAULT_PAGESIZE, 1, (long)datas.length, -1L, -1L, condition);
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage, long total) {
        this(datas, pageSize, currentPage, total, -1L, -1L, null);
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage, long total, PageInfoCondition condition) {
        this(datas, pageSize, currentPage, total, -1L, -1L, condition);
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo, PageInfoCondition condition) {
        this.m_condition = condition != null ? (PageInfoCondition)condition.clone() : new PageInfoCondition();
        if (datas != null) {
            Class<?> cl = datas.getClass();
            if (cl.isArray()) {
                this.m_clsType = cl.getComponentType();
            }
            this.m_datas = new ArrayList<Object>();
            for (int n = 0; n < datas.length; ++n) {
                this.m_datas.add(datas[n]);
            }
            if (pageSize > 0) {
                this.m_pageSize = pageSize;
            }
            this.m_total = this.m_datas.size();
            if (dataIndexTo > 0L && dataIndexTo > total) {
                total = dataIndexTo + 1L;
            }
            if (total > (long)this.m_total) {
                this.m_total = (int)total;
            }
            this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
            if (currentPage <= this.m_totalPage && currentPage >= 1) {
                this.m_currentPage = currentPage;
            }
            if (total > (long)this.m_datas.size()) {
                this.m_pageDataFrom = this.m_currentPage;
                this.m_pageDataTo = this.m_currentPage + (this.m_datas.size() / this.m_pageSize - 1);
                if (this.m_datas.size() % this.m_pageSize > 0) {
                    ++this.m_pageDataTo;
                }
                this.m_dataFrom = dataIndexFrom >= 0L ? dataIndexFrom : (long)((this.m_pageDataFrom - 1) * this.m_pageSize);
                this.m_dataTo = dataIndexTo > 0L && dataIndexTo - dataIndexFrom + 1L < (long)this.m_datas.size() ? dataIndexTo : this.m_dataFrom + (long)this.m_datas.size() - 1L;
            } else {
                this.m_pageDataFrom = 1;
                this.m_pageDataTo = this.m_totalPage;
                this.m_dataFrom = 0L;
                this.m_dataTo = this.m_datas.size() - 1;
            }
            this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
            this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
        }
    }

    public PageInfo(Object[] datas, int pageSize, int currentPage, long total, long dataIndexFrom, long dataIndexTo) {
        this(datas, pageSize, currentPage, total, dataIndexFrom, dataIndexTo, null);
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= this.m_totalPage && currentPage >= 1) {
            this.m_currentPage = currentPage;
            this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
            this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
        }
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            pageSize = this.getTotal();
        }
        if (pageSize >= 1) {
            this.m_pageSize = pageSize;
            this.m_totalPage = this.m_total % this.m_pageSize == 0 ? this.m_total / this.m_pageSize : this.m_total / this.m_pageSize + 1;
            if (this.m_currentPage > this.m_totalPage) {
                this.m_currentPage = this.m_totalPage > 0 ? this.m_totalPage : 1;
            }
            this.m_hasNextPage = this.m_currentPage < this.m_totalPage;
            this.m_hasPreviousPage = this.m_currentPage > 1 && this.m_totalPage > 1;
        }
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public int getTotalPage() {
        return this.m_totalPage;
    }

    public void setTotalListPage(int totalListPage) {
        this.m_totalListPage = totalListPage;
    }

    public int getTotalListPage() {
        return this.m_totalListPage;
    }

    public LongList getListPages() {
        int total;
        LongList pageNos = new LongList();
        long start = this.m_currentPage - this.m_totalListPage / 2;
        if (start <= 0L) {
            start = 1L;
            total = this.m_totalListPage;
        } else {
            total = this.m_totalListPage + 1 - this.m_totalListPage % 2;
        }
        for (int n = 0; n < total && start <= (long)this.m_totalPage; ++n, ++start) {
            pageNos.add(start);
        }
        return pageNos;
    }

    public LongList getPreviousListPages() {
        int total;
        LongList pageNos = new LongList();
        long start = this.m_currentPage - this.m_totalListPage / 2;
        if (start <= 0L) {
            start = 1L;
            total = this.m_totalListPage;
        } else if (this.m_currentPage > this.m_totalPage - this.m_totalListPage / 2) {
            start = this.m_totalPage - this.m_totalListPage + 1;
            total = this.m_totalListPage - 1;
        } else {
            total = this.m_totalListPage + 1 - this.m_totalListPage % 2;
        }
        for (int n = 0; n < total && start < (long)this.m_currentPage; ++n, ++start) {
            pageNos.add(start);
        }
        return pageNos;
    }

    public LongList getNextListPages() {
        LongList pageNos = new LongList();
        long start = this.m_currentPage - this.m_totalListPage / 2;
        int total = this.m_currentPage <= 1 ? this.m_totalListPage - 1 : (this.m_currentPage <= this.m_totalListPage / 2 ? this.m_totalListPage - this.m_currentPage : (start <= 0L ? this.m_totalListPage : this.m_totalListPage / 2));
        start = this.m_currentPage + 1;
        for (int n = 0; n < total && start <= (long)this.m_totalPage; ++n, ++start) {
            pageNos.add(start);
        }
        return pageNos;
    }

    public boolean isHasNextPage() {
        return this.m_hasNextPage;
    }

    public boolean isHasPreviousPage() {
        return this.m_hasPreviousPage;
    }

    public boolean hasData() {
        return this.hasData(this.m_currentPage, this.m_pageSize);
    }

    public boolean hasData(int pageNo, int pageSize) {
        if ((long)((pageNo - 1) * pageSize) < this.m_dataFrom) {
            return false;
        }
        if ((long)(pageNo * pageSize - 1) > this.m_dataTo) {
            return pageNo * pageSize > this.m_total && this.m_dataTo >= (long)(this.m_total - 1);
        }
        return true;
    }

    public void addData(Object newData) {
        if (this.m_longIds != null && newData instanceof Long) {
            if (this.m_dataTo - this.m_dataFrom + 1L >= (long)this.m_longIds.size()) {
                this.m_longIds.add((long)((Long)newData));
            } else {
                this.m_longIds.set((int)(this.m_dataTo - this.m_dataFrom + 1L), (long)((Long)newData));
            }
            if ((long)(this.m_total - 1) == this.m_dataTo) {
                ++this.m_total;
            }
            ++this.m_dataTo;
            this.setPageSize(this.m_pageSize);
        } else if (this.m_stringIds != null && newData instanceof String) {
            if (this.m_dataTo - this.m_dataFrom + 1L >= (long)this.m_stringIds.size()) {
                this.m_stringIds.add((String)newData);
            } else {
                this.m_stringIds.set((int)(this.m_dataTo - this.m_dataFrom + 1L), (String)newData);
            }
            if ((long)(this.m_total - 1) == this.m_dataTo) {
                ++this.m_total;
            }
            ++this.m_dataTo;
            this.setPageSize(this.m_pageSize);
        } else if (this.m_datas != null && newData != null && !this.m_datas.contains(newData)) {
            if (this.m_dataTo - this.m_dataFrom + 1L >= (long)this.m_datas.size()) {
                this.m_datas.add(newData);
            } else {
                this.m_datas.set((int)(this.m_dataTo - this.m_dataFrom + 1L), newData);
            }
            if ((long)(this.m_total - 1) == this.m_dataTo) {
                ++this.m_total;
            }
            ++this.m_dataTo;
            this.setPageSize(this.m_pageSize);
        }
    }

    public void remove(Object data) {
        int index;
        if (this.m_datas != null && data != null && (index = this.m_datas.indexOf(data)) >= 0) {
            this.m_datas.remove(index);
            if ((long)(this.m_total - 1) == this.m_dataTo) {
                --this.m_total;
            }
            --this.m_dataTo;
            this.setPageSize(this.m_pageSize);
        }
    }

    public void setData(List datas) {
        if (datas != null) {
            this.m_datas = new ArrayList<Object>();
            this.m_datas.addAll(datas);
            this.m_total = this.m_datas.size();
            this.setPageSize(this.m_pageSize);
            this.m_pageDataFrom = 1;
            this.m_pageDataTo = 1 + (this.m_datas.size() / this.m_pageSize - 1);
            if (this.m_datas.size() % this.m_pageSize > 0) {
                ++this.m_pageDataTo;
            }
            this.m_dataFrom = 0L;
            this.m_dataTo = this.m_total - 1;
        }
    }

    public Object get(int index) {
        if (index < this.m_datas.size()) {
            return this.m_datas.get(index);
        }
        Object result = null;
        Object[] values = new Object[1];
        if (this.m_longIds != null && index < this.m_longIds.size()) {
            values[0] = new Long(this.m_longIds.get(index));
        } else if (this.m_stringIds != null && index < this.m_stringIds.size()) {
            values[0] = new Long(this.m_stringIds.getString(index));
        } else {
            return null;
        }
        try {
            result = this.m_method.invoke(this.m_caller, values);
            if (index == this.m_datas.size()) {
                this.m_datas.add(result);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8c61\uff1a{}\u5f02\u5e38\uff1a{}", new Object[]{values[0], e.getMessage(), e});
        }
        return result;
    }

    public List getDatas() {
        return this.getDatas(this.m_currentPage);
    }

    public List getDatas(int pageNo) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.m_datas != null && pageNo > 0 && pageNo >= this.m_pageDataFrom && pageNo <= this.m_pageDataTo) {
            int current = (pageNo - 1) * this.m_pageSize;
            int size = current + this.m_pageSize > this.m_total ? this.m_total - current : this.m_pageSize;
            Object[] datas = this.getDatas(current, size);
            for (int n = 0; n < datas.length; ++n) {
                res.add(datas[n]);
            }
            return res;
        }
        if (pageNo > 0 && (pageNo < this.m_pageDataFrom || pageNo > this.m_pageDataTo && this.m_pageDataTo > 0)) {
            String msg = String.format("\u83b7\u53d6\u8d85\u51fa\u8bbf\u95ee\u7684\u9875\u6570\u636e\uff1a%s\u6570\u636e\u4ece%s\u5230%s \u8bf7\u7a0b\u5e8f\u5458\u68c0\u67e5\u7a0b\u5e8f\u9519\u8bef\uff01", pageNo, this.m_pageDataFrom, this.m_pageDataTo);
            log.error(msg, (Throwable)new Exception(msg));
        }
        return res;
    }

    public Object[] getDataArray() {
        return this.getDataArray(this.m_currentPage);
    }

    public <T> T[] getDataArray(Class<T> cls) {
        return this.getDataArray(this.m_currentPage, cls);
    }

    public Object[] getDataArray(int pageNo) {
        return this.getDataArray(this.m_currentPage, this.m_clsType);
    }

    public <T> T[] getDataArray(int pageNo, Class<T> cls) {
        if (this.m_datas != null && pageNo > 0 && pageNo <= this.m_totalPage) {
            int current = (pageNo - 1) * this.m_pageSize;
            int size = this.m_total - current < this.m_pageSize ? this.m_total - current : this.m_pageSize;
            T[] datas = this.getDatas(current, size, cls);
            return datas;
        }
        if (this.m_clsType == null && cls != null) {
            return (Object[])Array.newInstance(cls, 0);
        }
        return this.m_clsType != null ? (Object[])Array.newInstance(this.m_clsType, 0) : (Object[])null;
    }

    public int getDataFrom() {
        if (this.m_total > 0) {
            return (this.m_currentPage - 1) * this.m_pageSize + 1;
        }
        return 0;
    }

    public int getDataTo() {
        if (this.m_total > 0) {
            int index = this.m_currentPage * this.m_pageSize;
            return index > this.m_total ? this.m_total : index;
        }
        return 0;
    }

    public void sort(String property, boolean isOrderAsc) {
        if (this.m_dataTo < (long)(this.m_total - 1)) {
            log.error("\u5206\u9875\u5bf9\u8c61\u6ca1\u6709\u52a0\u8f7d\u6240\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u6392\u5e8f\u64cd\u4f5c\u3002");
            return;
        }
        Collections.sort(this.m_datas, new PageInfoComparator(property, isOrderAsc));
    }

    public List getAllDataList() {
        this.getAllDataFromID();
        return this.m_datas;
    }

    public ArrayList getAllDatas() {
        if (this.m_datas != null) {
            this.getAllDataFromID();
            return new ArrayList<Object>(this.m_datas);
        }
        return new ArrayList();
    }

    public Object[] getAllDataArray() {
        this.getAllDataFromID();
        if (this.m_datas != null) {
            if (this.m_clsType != null) {
                Object[] objs = (Object[])Array.newInstance(this.m_clsType, this.m_datas.size());
                return this.m_datas.toArray(objs);
            }
            return this.m_datas.toArray();
        }
        return new Object[0];
    }

    public int getTotal() {
        return this.m_total;
    }

    public int getNextPageNum() {
        if (this.m_currentPage < this.m_totalPage) {
            return this.m_currentPage + 1;
        }
        return this.m_totalPage;
    }

    public int getPreviousPageNum() {
        if (this.m_currentPage > 1) {
            return this.m_currentPage - 1;
        }
        return 1;
    }

    public int getBeginPageNum() {
        return 1;
    }

    public int getEndPageNum() {
        return this.m_totalPage;
    }

    public boolean setCondition(String condition) {
        if (condition != null) {
            this.m_condition.clear();
            this.m_condition.add(condition);
            return true;
        }
        return false;
    }

    public boolean setCondition(String[] conditions) {
        if (conditions != null) {
            for (int n = 0; n < conditions.length; ++n) {
                this.m_condition.add(conditions[n]);
            }
            return true;
        }
        return false;
    }

    public boolean isConditionChanged(PageInfoCondition condition) {
        if (condition != null) {
            return !condition.equals(this.m_condition);
        }
        return true;
    }

    public boolean isConditionChanged(String condition) {
        PageInfoCondition pageCondition = new PageInfoCondition(condition);
        return !this.m_condition.equals(pageCondition);
    }

    public boolean isConditionChanged(String[] conditions) {
        if (conditions == null) {
            return true;
        }
        PageInfoCondition condition = new PageInfoCondition(conditions);
        return !this.m_condition.equals(condition);
    }

    public boolean isConditionChanged(String[] conditions, boolean isSameOrder) {
        return this.isConditionChanged(conditions);
    }

    public boolean isConditionChangedIgnoreCase(PageInfoCondition condition) {
        if (condition != null) {
            return !condition.equalsIgnoreCase(this.m_condition);
        }
        return true;
    }

    public boolean isConditionChangedIgnoreCase(String condition) {
        PageInfoCondition pageCondition = new PageInfoCondition(condition);
        return !this.m_condition.equalsIgnoreCase(pageCondition);
    }

    public boolean isConditionChangedIgnoreCase(String[] conditions) {
        PageInfoCondition condition = new PageInfoCondition(conditions);
        return !this.m_condition.equalsIgnoreCase(condition);
    }

    public boolean isConditionChangedIgnoreCase(String[] conditions, boolean isSameOrder) {
        return this.isConditionChangedIgnoreCase(conditions);
    }

    public PageInfoCondition getCondition() {
        return (PageInfoCondition)this.m_condition.clone();
    }

    public void setCondition(PageInfoCondition condition) {
        if (condition != null) {
            this.m_condition = (PageInfoCondition)condition.clone();
        }
    }

    private void getAllDataFromID() {
        if (this.m_longIds != null && this.m_datas != null && this.m_datas.size() < this.m_longIds.size()) {
            long startTime = System.currentTimeMillis();
            Object[] values = new Object[1];
            try {
                for (int n = this.m_datas.size(); n < this.m_longIds.size(); ++n) {
                    values[0] = new Long(this.m_longIds.get(n));
                    this.m_datas.add(this.m_method.invoke(this.m_caller, values));
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5bf9\u8c61\uff1a{}\u5f02\u5e38\uff1a{}", new Object[]{values[0], e.getMessage(), e});
            }
            if (startTime > 600000L) {
                log.info("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5386\u65f6\uff1a{}", (Object)startTime);
            }
        } else if (this.m_stringIds != null && this.m_datas != null && this.m_datas.size() < this.m_stringIds.size()) {
            long startTime = System.currentTimeMillis();
            Object[] values = new Object[1];
            try {
                for (int n = this.m_datas.size(); n < this.m_longIds.size(); ++n) {
                    values[0] = this.m_stringIds.get(n);
                    this.m_datas.add(this.m_method.invoke(this.m_caller, values));
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5bf9\u8c61\uff1a{}\u5f02\u5e38\uff1a{}", new Object[]{values[0], e.getMessage(), e});
            }
            startTime = System.currentTimeMillis() - startTime;
            if (startTime > 600000L) {
                log.info("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u5386\u65f6\uff1a{}", (Object)startTime);
            }
        }
    }

    private Object[] getDatas(int startIndex, int size) {
        return this.getDatas(startIndex, size, this.m_clsType);
    }

    private <T> T[] getDatas(int startIndex, int size, Class<T> cls) {
        if (this.m_clsType == null) {
            log.error("\u5206\u9875\u5bf9\u8c61\u6784\u9020\u65f6\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u6216\u6570\u636e\u7c7b\u578b\uff01");
            return (Object[])Array.newInstance(cls, 0);
        }
        if ((long)startIndex < this.m_dataFrom) {
            log.error("\u9700\u8981\u4ece\u7b2c{}\u6761\u6570\u636e\u5f00\u59cb\u83b7\u53d6\uff0c\u4f46\u5206\u9875\u5bf9\u8c61\u53ea\u52a0\u8f7d\u4e86\u7b2c{}\u6761\u4ee5\u540e\u7684\u6570\u636e\u3002", (Object)startIndex, (Object)this.m_dataFrom);
            return (Object[])Array.newInstance(this.m_clsType, 0);
        }
        if ((long)(startIndex + size - 1) > this.m_dataTo) {
            log.error("\u9700\u8981\u83b7\u53d6\u5230\u7b2c{}\u6761\u6570\u636e\uff0c\u4f46\u5206\u9875\u5bf9\u8c61\u53ea\u52a0\u8f7d\u5230\u7b2c{}\u6761\u6570\u636e", (Object)(startIndex + size - 1), (Object)this.m_dataTo);
            return (Object[])Array.newInstance(this.m_clsType, 0);
        }
        Object[] datas = (Object[])Array.newInstance(this.m_clsType, size);
        int n = 0;
        while (n < size && (long)startIndex - this.m_dataFrom < (long)this.m_datas.size()) {
            datas[n] = this.m_datas.get(startIndex - (int)this.m_dataFrom);
            ++n;
            ++startIndex;
        }
        if (n < size) {
            boolean needAddData;
            Object[] values = new Object[1];
            boolean bl = needAddData = this.m_datas.size() == startIndex;
            if (this.m_longIds != null) {
                try {
                    while (n < size) {
                        values[0] = new Long(this.m_longIds.get(startIndex - (int)this.m_dataFrom));
                        try {
                            datas[n] = this.m_method.invoke(this.m_caller, values);
                        }
                        catch (ArrayStoreException eStore) {
                            log.error("\u521b\u5efaID\u4e3a{}\u7684\u5bf9\u8c61\u65f6\u53d1\u73b0\u51fd\u6570\u8fd4\u56de\u7684\u7c7b\u578b\u9519\u8bef\uff1a{}", new Object[]{values[0], eStore.getMessage(), eStore});
                            datas[n] = this.m_clsType.newInstance();
                        }
                        catch (Exception ex) {
                            log.error("\u521b\u5efaID\u4e3a{}\u7684\u5bf9\u8c61\u5f02\u5e38\uff1a{}", new Object[]{values[0], ex.getMessage(), ex});
                            datas[n] = this.m_clsType.newInstance();
                        }
                        if (needAddData) {
                            this.m_datas.add(datas[n]);
                        }
                        ++n;
                        ++startIndex;
                    }
                }
                catch (IndexOutOfBoundsException eIndex) {
                    log.error("\u6570\u636eID\u5217\u8868\u4e2d\u4e0d\u5305\u542b\u7b2c{}\u4e2a\u6570\u636e\uff0c\u7814\u53d1\u4eba\u5458\u8981\u4fdd\u8bc1\u7a0b\u5e8f\u83b7\u53d6\u6b64\u6570\u636e\u524d\u628a\u6570\u636eID\u52a0\u5165\u5206\u9875\u5bf9\u8c61\uff1a{}", new Object[]{startIndex, eIndex.getMessage(), eIndex});
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5bf9\u8c61{}\u5f02\u5e38\uff1a{}", new Object[]{values[0], e.getMessage(), e});
                }
            } else if (this.m_stringIds != null) {
                try {
                    while (n < size) {
                        values[0] = this.m_stringIds.get(startIndex - (int)this.m_dataFrom);
                        try {
                            datas[n] = this.m_method.invoke(this.m_caller, values);
                        }
                        catch (Exception ex) {
                            log.error("\u521b\u5efaID\u4e3a{}\u7684\u5bf9\u8c61\u5f02\u5e38\uff1a{}", new Object[]{values[0], ex.getMessage(), ex});
                            datas[n] = this.m_clsType.newInstance();
                        }
                        if (needAddData) {
                            this.m_datas.add(datas[n]);
                        }
                        ++n;
                        ++startIndex;
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u5bf9\u8c61{}\u5f02\u5e38\uff1a{}", new Object[]{values[0], e.getMessage(), e});
                }
            } else {
                log.error("\u83b7\u53d6{}\u6570\u636e\u65f6\u53d1\u73b0\u6570\u636e\u4e0d\u591f\uff01\u5f53\u524d\u4f4d\u7f6e\uff1a{}", new Object[]{size, n, new Exception("\u6570\u636e\u4e0d\u6b63\u786e")});
                Object[] arrayNew = (Object[])Array.newInstance(this.m_clsType, n);
                System.arraycopy(datas, 0, arrayNew, 0, n);
            }
        }
        return datas;
    }

    public String getSortProperty() {
        return this.m_property;
    }

    public boolean isSortAsc() {
        return this.m_isOrderAsc;
    }

    public static void main(String[] arrayArg) {
        String[] conditions1 = new String[]{"1468", "3a", null, null, null, null, "null null null00", "null null null00"};
        String[] conditions2 = new String[]{"1468", "3A", null, null, null, null, "null null null00", "null null null00"};
        String[] conditions3 = new String[]{"1468", "3a", null, null, null, null, "null null null00", "null null null00"};
        PageInfo page = new PageInfo();
        page.setCondition(conditions1);
        log.debug("isChanged={}", (Object)page.isConditionChanged(conditions2));
        log.debug("isNoCaseChaged={}", (Object)page.isConditionChangedIgnoreCase(conditions2));
        log.debug("isChaged={}", (Object)page.isConditionChanged(conditions3));
    }

    private class PageInfoComparator
    implements Comparator {
        public PageInfoComparator(String property, boolean isOrderAsc) {
            if (property != null && property.length() > 0) {
                char firstChar = property.charAt(0);
                String fristStr = String.valueOf(firstChar).toUpperCase();
                PageInfo.this.m_property = String.format("get%s%s", fristStr, property.substring(1));
                PageInfo.this.m_isOrderAsc = isOrderAsc;
            }
        }

        public int compare(Object o1, Object o2) {
            try {
                long result = 0L;
                Class<?> cls1 = o1.getClass();
                Method method1 = cls1.getMethod(PageInfo.this.m_property, null);
                Object retobj1 = method1.invoke(o1, (Object[])null);
                Class<?> cls2 = o2.getClass();
                Method method2 = cls2.getMethod(PageInfo.this.m_property, null);
                Object retobj2 = method2.invoke(o2, (Object[])null);
                String className = retobj1.getClass().getName();
                if (retobj1.getClass().isArray()) {
                    result = 0L;
                } else if (className.equals("java.lang.String")) {
                    result = PageInfo.this.m_isOrderAsc ? (long)new ChineseComparator((String)retobj1).compareTo((String)retobj2) : (long)new ChineseComparator((String)retobj2).compareTo((String)retobj1);
                } else if (className.equals("java.lang.Long") || className.equals("long")) {
                    long value1 = (Long)retobj1;
                    long value2 = (Long)retobj2;
                    result = PageInfo.this.m_isOrderAsc ? value1 - value2 : value2 - value1;
                } else if (className.equals("int") || className.equals("java.lang.Integer")) {
                    int value1 = (Integer)retobj1;
                    int value2 = (Integer)retobj2;
                    result = PageInfo.this.m_isOrderAsc ? (long)(value1 - value2) : (long)(value2 - value1);
                } else if (className.equals("boolean") || className.equals("java.lang.Boolean")) {
                    int intVal2;
                    boolean value1 = (Boolean)retobj1;
                    boolean value2 = (Boolean)retobj2;
                    int intVal1 = value1 ? 1 : 0;
                    int n = intVal2 = value2 ? 1 : 0;
                    result = PageInfo.this.m_isOrderAsc ? (long)(intVal1 - intVal2) : (long)(intVal2 - intVal1);
                } else {
                    result = 0L;
                }
                if (result >= Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (result <= Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                int res = (int)result;
                return res;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

