/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.model.util.Globals;
import com.oreilly.servlet.MultipartRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartHttpServletRequest
implements HttpServletRequest {
    private static Logger log = LoggerFactory.getLogger(MultipartHttpServletRequest.class);
    public static final String HEADER_NAME_REQUEST_URI = "request-uri";
    public static final String CURRENT_REQUEST_ID = "CS_ri";
    private MultipartRequest m_multiRequest;
    private HttpServletRequest m_request;
    private String m_contextRealPath;
    private String m_requestIdLogInfo;

    public static String delCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            String val = cookie.getValue();
            cookie.setValue(null);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return val;
        }
        return null;
    }

    public static String getCookie(HttpServletRequest request, String name) {
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Cookie[] cookies = request.getCookies();
        Cookie newCookie = null;
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            newCookie = cookie;
            break;
        }
        if (newCookie == null) {
            newCookie = new Cookie(name, value);
        }
        newCookie.setPath("/");
        newCookie.setHttpOnly(true);
        response.addCookie(newCookie);
    }

    public MultipartHttpServletRequest(MultipartRequest multiRequest, HttpServletRequest request) {
        this.m_multiRequest = multiRequest;
        this.m_request = request;
    }

    public static final String getRequestIdLogInfo(HttpServletRequest request) {
        if (request instanceof MultipartHttpServletRequest) {
            return ((MultipartHttpServletRequest)request).getRequestIdLogInfo();
        }
        Integer reqId = (Integer)request.getAttribute(CURRENT_REQUEST_ID);
        if (reqId != null) {
            return String.format("%s\t", reqId);
        }
        return "";
    }

    public final String getRequestIdLogInfo() {
        Integer reqId;
        if (this.m_requestIdLogInfo == null && (reqId = (Integer)this.getAttribute(CURRENT_REQUEST_ID)) != null) {
            this.m_requestIdLogInfo = String.format("%s\t", reqId);
        }
        return this.m_requestIdLogInfo != null ? this.m_requestIdLogInfo : "";
    }

    public String getAuthType() {
        return this.m_request.getAuthType();
    }

    public String getContextRealPath() {
        if (this.m_contextRealPath == null) {
            String str = this.getHeader(HEADER_NAME_REQUEST_URI);
            if (str != null) {
                int index;
                String uri = this.m_request.getRequestURI();
                if (log.isTraceEnabled()) {
                    log.trace("{}uri1\uff1a{} url2:{} contextPath:{}", new Object[]{this.getRequestIdLogInfo(), str, uri, this.m_request.getContextPath()});
                }
                if ((index = str.indexOf(63)) > 0) {
                    str = str.substring(0, index);
                }
                if (!str.equals(uri)) {
                    String contextPath = this.m_request.getContextPath();
                    int len = contextPath.length();
                    index = str.indexOf(uri.substring(len), 1);
                    if (index < 0) {
                        int slash = 0;
                        index = uri.indexOf(47, len);
                        while (index > 0) {
                            ++slash;
                            index = uri.indexOf(47, index + 1);
                        }
                        index = str.lastIndexOf(47);
                        while (index > 0 && slash > 0) {
                            --slash;
                            index = str.lastIndexOf(47, index - 1);
                        }
                        if (index < 0) {
                            index = str.indexOf(47, 1);
                        }
                    }
                    this.m_contextRealPath = str.substring(0, index);
                }
            }
            if (this.m_contextRealPath == null) {
                this.m_contextRealPath = this.m_request.getContextPath();
            }
        }
        return this.m_contextRealPath;
    }

    public String getContextPath() {
        return this.getContextRealPath();
    }

    public String getCookie(String name) {
        return MultipartHttpServletRequest.getCookie(this, name);
    }

    public Cookie[] getCookies() {
        return this.m_request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.m_request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.m_request.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.m_request.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.m_request.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.m_request.getIntHeader(name);
    }

    public String getMethod() {
        return this.m_request.getMethod();
    }

    public String getPathInfo() {
        return this.m_request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.m_request.getPathTranslated();
    }

    public String getQueryString() {
        return this.m_request.getQueryString();
    }

    public String getRemoteUser() {
        return this.m_request.getRemoteUser();
    }

    public String getRequestURI() {
        String strQuery;
        boolean needsParameter;
        StringBuffer uri = new StringBuffer();
        String str = this.getHeader(HEADER_NAME_REQUEST_URI);
        if (str != null && str.length() > 0) {
            uri.append(str);
            needsParameter = "POST".equalsIgnoreCase(this.getMethod());
        } else {
            uri.append(this.m_request.getRequestURI());
            needsParameter = true;
        }
        if (needsParameter && (strQuery = this.getQueryString()) != null) {
            uri.append(uri.indexOf("?") > 0 ? (char)'&' : '?').append(strQuery);
        }
        return uri.toString();
    }

    public StringBuffer getRequestURL() {
        String uri = this.getRequestURI();
        try {
            int port = this.getServerPort();
            URL reconstructedURL = new URL(this.getScheme(), this.getServerName(), port == 80 || port == 443 ? -1 : port, uri);
            return new StringBuffer(reconstructedURL.toString());
        }
        catch (Exception e) {
            return new StringBuffer(uri);
        }
    }

    public String getRequestedSessionId() {
        return this.m_request.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.m_request.getServletPath();
    }

    public HttpSession getSession() {
        return this.m_request.getSession(false);
    }

    public HttpSession getSession(boolean isCreate) {
        return this.m_request.getSession(isCreate);
    }

    public Principal getUserPrincipal() {
        return this.m_request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.m_request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        return this.m_request.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this.m_request.isUserInRole(role);
    }

    public Object getAttribute(String name) {
        return this.m_request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.m_request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.m_request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.m_request.getContentLength();
    }

    public String getContentType() {
        return this.m_request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.m_request.getInputStream();
    }

    public String getLocalAddr() {
        return this.m_request.getLocalAddr();
    }

    public String getLocalName() {
        return this.m_request.getLocalName();
    }

    public int getLocalPort() {
        return this.m_request.getLocalPort();
    }

    public Locale getLocale() {
        return this.m_request.getLocale();
    }

    public Enumeration getLocales() {
        return this.m_request.getLocales();
    }

    public String getParameter(String name) {
        return this.m_multiRequest != null ? this.m_multiRequest.getParameter(name) : (this.m_request != null ? this.m_request.getParameter(name) : null);
    }

    public Map getParameterMap() {
        if (this.m_multiRequest != null) {
            Hashtable<String, String[]> mapPar = new Hashtable<String, String[]>();
            Enumeration enuName = this.m_multiRequest.getParameterNames();
            while (enuName.hasMoreElements()) {
                String strName = enuName.nextElement().toString();
                mapPar.put(strName, this.m_multiRequest.getParameterValues(strName));
            }
            return mapPar;
        }
        return this.m_request.getParameterMap();
    }

    public Enumeration getParameterNames() {
        return this.m_multiRequest != null ? this.m_multiRequest.getParameterNames() : this.m_request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.m_multiRequest != null ? this.m_multiRequest.getParameterValues(name) : this.m_request.getParameterValues(name);
    }

    public String getProtocol() {
        return this.m_request.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        return this.m_request.getReader();
    }

    public String getRealPath(String path) {
        return this.m_request.getRealPath(path);
    }

    public String getRemoteAddr() {
        return MultipartHttpServletRequest.getRemoteAddr(this.m_request);
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip;
        String headerName = Globals.getProperty("realipHeaderName");
        if (headerName != null && headerName.length() > 0 && (ip = request.getHeader(headerName)) != null && ip.length() > 0) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.m_request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.m_request.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.m_request.getRequestDispatcher(path);
    }

    public String getScheme() {
        int index;
        String origin = this.m_request.getHeader("Origin");
        if (origin != null && (index = origin.indexOf("://")) > 0) {
            if (log.isTraceEnabled()) {
                log.trace("{}Scheme:{} Origin: {}", new Object[]{this.getRequestIdLogInfo(), this.m_request.getScheme(), origin});
            }
            return origin.substring(0, index).toLowerCase();
        }
        origin = this.m_request.getHeader("Referer");
        if (origin != null && (index = origin.indexOf("://")) > 0) {
            String scheme = origin.substring(0, index);
            int slash = origin.indexOf(47, index + 3);
            if (slash > index && origin.substring(index + 3, slash).equalsIgnoreCase(this.m_request.getServerName())) {
                return scheme.toLowerCase();
            }
        }
        return this.m_request.getScheme();
    }

    public String getServerName() {
        return this.m_request.getServerName();
    }

    public int getServerPort() {
        return this.m_request.getServerPort();
    }

    public boolean isSecure() {
        return this.m_request.isSecure();
    }

    public void removeAttribute(String name) {
        this.m_request.removeAttribute(name);
    }

    public void setAttribute(String name, Object data) {
        this.m_request.setAttribute(name, data);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.m_request.setCharacterEncoding(encoding);
    }

    public MultipartRequest getMultipartRequest() {
        return this.m_multiRequest;
    }

    public HttpServletRequest getRequest() {
        return this.m_request;
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return this.m_request.authenticate(arg0);
    }

    public Part getPart(String arg0) throws IOException, IllegalStateException, ServletException {
        return this.m_request.getPart(arg0);
    }

    public Collection getParts() throws IOException, IllegalStateException, ServletException {
        return this.m_request.getParts();
    }

    public void login(String arg0, String arg1) throws ServletException {
        this.m_request.login(arg0, arg1);
    }

    public void logout() throws ServletException {
        this.m_request.logout();
    }

    public AsyncContext getAsyncContext() {
        return this.m_request.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.m_request.getDispatcherType();
    }

    public ServletContext getServletContext() {
        return this.m_request.getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.m_request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.m_request.isAsyncSupported();
    }

    public AsyncContext startAsync() {
        return this.m_request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) {
        return this.m_request.startAsync(arg0, arg1);
    }

    public long getContentLengthLong() {
        return this.m_request.getContentLengthLong();
    }

    public String changeSessionId() {
        return this.m_request.changeSessionId();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return (T)this.m_request.upgrade(arg0);
    }
}

