/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongList
implements List<Long>,
Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.util.LongList");
    long[] m_arrayElements;
    int m_nCapacity;
    int m_size;

    public LongList() {
        this(50);
    }

    public LongList(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 50;
        }
        this.m_size = 0;
        this.m_nCapacity = initialCapacity + 1;
        this.m_arrayElements = new long[this.m_nCapacity];
    }

    public LongList(int[] datas) {
        if (datas == null || datas.length <= 0) {
            this.m_size = 0;
            this.m_nCapacity = 50;
            this.m_arrayElements = new long[this.m_nCapacity];
        } else {
            this.m_size = datas.length;
            this.m_nCapacity = this.m_size + 10;
            this.m_arrayElements = new long[this.m_nCapacity];
            for (int n = 0; n < this.m_size; ++n) {
                this.m_arrayElements[n] = datas[n];
            }
        }
    }

    public LongList(long[] datas) {
        if (datas == null || datas.length <= 0) {
            this.m_size = 0;
            this.m_nCapacity = 50;
            this.m_arrayElements = new long[this.m_nCapacity];
        } else {
            this.m_size = datas.length;
            this.m_nCapacity = this.m_size + 10;
            this.m_arrayElements = new long[this.m_nCapacity];
            System.arraycopy(datas, 0, this.m_arrayElements, 0, datas.length);
        }
    }

    public LongList(Object[] arrayData) {
        if (arrayData == null || arrayData.length <= 0) {
            this.m_size = 0;
            this.m_nCapacity = 50;
            this.m_arrayElements = new long[this.m_nCapacity];
        } else {
            this.m_nCapacity = this.m_size + 10;
            this.m_arrayElements = new long[this.m_nCapacity];
            this.m_size = 0;
            int nLen = arrayData.length;
            for (int n = 0; n < nLen; ++n) {
                long lData;
                if (arrayData[n] instanceof Long) {
                    lData = (Long)arrayData[n];
                } else if (arrayData[n] instanceof Integer) {
                    lData = ((Integer)arrayData[n]).longValue();
                } else {
                    log.error("\u53d1\u73b0\u6784\u9020\u65f6\u7684\u5bf9\u8c61\u4e0d\u662fLong\u7c7b\u578b\uff1a" + arrayData[n].getClass());
                    continue;
                }
                this.m_arrayElements[this.m_size] = lData;
                ++this.m_size;
            }
        }
    }

    private static final long toLong(Object objVal, long lDefault) {
        if (objVal instanceof Long) {
            return (Long)objVal;
        }
        if (objVal instanceof Integer) {
            return ((Integer)objVal).longValue();
        }
        if (objVal instanceof Float) {
            return ((Float)objVal).longValue();
        }
        if (objVal instanceof Double) {
            return ((Double)objVal).longValue();
        }
        if (objVal instanceof String) {
            try {
                return Long.parseLong(objVal.toString());
            }
            catch (Exception e) {
                log.error("\u5bf9\u8c61\u975e\u6570\u5b57\uff1a" + objVal);
            }
        } else {
            log.error("\u5bf9\u8c61\u4e0d\u652f\u6301\uff1a" + objVal);
        }
        return lDefault;
    }

    public Object clone() {
        Object objResult;
        try {
            objResult = super.clone();
            if (objResult instanceof LongList) {
                LongList lstNewData = (LongList)objResult;
                lstNewData.m_size = this.m_size;
                lstNewData.m_nCapacity = this.m_nCapacity;
                lstNewData.m_arrayElements = (long[])this.m_arrayElements.clone();
            }
        }
        catch (Exception e) {
            LongList lstNewData = new LongList(this.m_nCapacity - 1);
            lstNewData.m_size = this.m_size;
            lstNewData.m_nCapacity = this.m_nCapacity;
            System.arraycopy(this.m_arrayElements, 0, lstNewData.m_arrayElements, 0, this.m_arrayElements.length);
            return lstNewData;
        }
        return objResult;
    }

    public void add(long lValue) {
        this.m_arrayElements[this.m_size] = lValue;
        ++this.m_size;
        if (this.m_size == this.m_nCapacity) {
            this.m_nCapacity *= 2;
            long[] arrayNewElement = new long[this.m_nCapacity];
            System.arraycopy(this.m_arrayElements, 0, arrayNewElement, 0, this.m_size);
            this.m_arrayElements = arrayNewElement;
        }
    }

    public boolean addObject(Object objValue) {
        this.m_arrayElements[this.m_size] = LongList.toLong(objValue, -1L);
        ++this.m_size;
        if (this.m_size == this.m_nCapacity) {
            this.m_nCapacity *= 2;
            long[] arrayNewElement = new long[this.m_nCapacity];
            System.arraycopy(this.m_arrayElements, 0, arrayNewElement, 0, this.m_size);
            this.m_arrayElements = arrayNewElement;
        }
        return true;
    }

    public void add(long[] arrayVal) {
        if (arrayVal == null || arrayVal.length == 0) {
            return;
        }
        if (this.m_size + arrayVal.length >= this.m_nCapacity) {
            this.m_nCapacity = this.m_size + arrayVal.length + 50;
            long[] arrayNewElement = new long[this.m_nCapacity];
            System.arraycopy(this.m_arrayElements, 0, arrayNewElement, 0, this.m_size);
            System.arraycopy(arrayVal, 0, arrayNewElement, this.m_size, arrayVal.length);
            this.m_arrayElements = arrayNewElement;
        } else {
            System.arraycopy(arrayVal, 0, this.m_arrayElements, this.m_size, arrayVal.length);
        }
        this.m_size += arrayVal.length;
    }

    public void add(Object[] arrayVal) {
        if (arrayVal == null || arrayVal.length == 0) {
            return;
        }
        if (this.m_size + arrayVal.length >= this.m_nCapacity) {
            int n;
            this.m_nCapacity = this.m_size + arrayVal.length + 50;
            long[] arrayNewElement = new long[this.m_nCapacity];
            int len = this.m_arrayElements.length;
            for (n = 0; n < len; ++n) {
                arrayNewElement[n] = LongList.toLong(this.m_arrayElements[n], -1L);
            }
            int nLen = arrayVal.length;
            for (n = 0; n < nLen; ++n) {
                arrayNewElement[this.m_size + n] = LongList.toLong(arrayVal[n], -1L);
            }
            this.m_arrayElements = arrayNewElement;
        } else {
            int len = arrayVal.length;
            for (int n = 0; n < len; ++n) {
                this.m_arrayElements[this.m_size + n] = LongList.toLong(arrayVal[n], -1L);
            }
        }
        this.m_size += arrayVal.length;
    }

    @Override
    public Long get(int index) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index " + index + " not valid.");
        }
        return this.m_arrayElements[index];
    }

    public long getLong(int index) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index " + index + " not valid.");
        }
        return this.m_arrayElements[index];
    }

    @Override
    public long set(int index, long element) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index " + index + " not valid.");
        }
        long previously = this.m_arrayElements[index];
        this.m_arrayElements[index] = element;
        return previously;
    }

    @Override
    public Long remove(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_size) {
            throw new IndexOutOfBoundsException("Index " + nIndex + " not valid.");
        }
        long previously = this.m_arrayElements[nIndex];
        for (int i = nIndex + 1; i < this.m_size; ++i) {
            this.m_arrayElements[i - 1] = this.m_arrayElements[i];
        }
        --this.m_size;
        return previously;
    }

    public boolean remove(long lData) {
        for (int i = 0; i < this.m_size; ++i) {
            if (this.m_arrayElements[i] != lData) continue;
            for (int j = i + 1; j < this.m_size; ++j) {
                this.m_arrayElements[j - 1] = this.m_arrayElements[j];
            }
            --this.m_size;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    public Long[] toArray() {
        int nSize = this.m_size;
        Long[] arrayNewElement = new Long[nSize];
        for (int n = 0; n < nSize; ++n) {
            arrayNewElement[n] = this.m_arrayElements[n];
        }
        return arrayNewElement;
    }

    public long[] toLongArray() {
        int nSize = this.m_size;
        long[] arrayNewElement = new long[nSize];
        for (int n = 0; n < nSize; ++n) {
            arrayNewElement[n] = this.m_arrayElements[n];
        }
        return arrayNewElement;
    }

    public Object[] toObjectArray() {
        int nSize = this.m_size;
        Object[] arrayNewElement = new Object[nSize];
        for (int n = 0; n < nSize; ++n) {
            arrayNewElement[n] = new Long(this.m_arrayElements[n]);
        }
        return arrayNewElement;
    }

    public int[] toIntArray() {
        int nSize = this.m_size;
        int[] arrayResult = new int[nSize];
        for (int n = 0; n < nSize; ++n) {
            arrayResult[n] = (int)this.m_arrayElements[n];
        }
        return arrayResult;
    }

    public String[] toStringArray() {
        int nSize = this.m_size;
        String[] arrayNewElement = new String[nSize];
        for (int i = 0; i < nSize; ++i) {
            arrayNewElement[i] = String.valueOf(this.m_arrayElements[i]);
        }
        return arrayNewElement;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_size; ++i) {
            buf.append(this.m_arrayElements[i]).append(" ");
        }
        return buf.toString();
    }

    public void empty() {
        this.m_size = 0;
    }

    @Override
    public void clear() {
        this.m_size = 0;
    }

    public boolean contains(int val) {
        for (int n = 0; n < this.m_size; ++n) {
            if (this.m_arrayElements[n] != (long)val) continue;
            return true;
        }
        return false;
    }

    public boolean contains(long val) {
        for (int n = 0; n < this.m_size; ++n) {
            if (this.m_arrayElements[n] != val) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size <= 0;
    }

    @Override
    public boolean contains(Object o) {
        long val = LongList.toLong(o, -1L);
        int nSize = this.m_size;
        for (int n = 0; n < nSize; ++n) {
            if (this.m_arrayElements[n] != val) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Long> iterator() {
        return new ListItr(0);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Class<?> cls = a.getClass().getComponentType();
        if (cls == String.class) {
            return this.toStringArray();
        }
        return this.toArray();
    }

    @Override
    public boolean add(Long e) {
        if (e == null) {
            return false;
        }
        this.add((long)e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(LongList.toLong(o, -1L));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object val : c) {
            if (this.contains(val)) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        for (Long l : c) {
            if (this.add(l)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        Iterator<? extends Long> iter = c.iterator();
        int n = 0;
        while (iter.hasNext()) {
            Long val = iter.next();
            if (n < index) {
                ++n;
                continue;
            }
            if (this.add(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object val : c) {
            if (this.remove(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (int n = 0; n < this.m_size; ++n) {
            Iterator<?> iter = c.iterator();
            boolean exists = false;
            while (iter.hasNext()) {
                Object val = iter.next();
                if (this.m_arrayElements[n] != LongList.toLong(val, -1L)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            for (int i = n + 1; i < this.m_size; ++i) {
                i = 1;
                this.m_arrayElements[1] = this.m_arrayElements[i];
            }
            --this.m_size;
        }
        return true;
    }

    @Override
    public Long set(int index, Long element) {
        if (index >= 0 && index < this.m_size && element != null) {
            Long val = this.m_arrayElements[index];
            this.m_arrayElements[index] = element;
            return val;
        }
        return null;
    }

    @Override
    public void add(int index, Long element) {
        if (index >= 0 && element != null) {
            if (this.m_size == this.m_nCapacity) {
                this.m_nCapacity *= 2;
                long[] arrayNewElement = new long[this.m_nCapacity];
                System.arraycopy(this.m_arrayElements, 0, arrayNewElement, 0, this.m_size);
                this.m_arrayElements = arrayNewElement;
            }
            if (index < this.m_size) {
                for (int n = index; n < this.m_size; ++n) {
                    this.m_arrayElements[n + 1] = this.m_arrayElements[n];
                }
            }
            this.m_arrayElements[this.m_size] = element;
            ++this.m_size;
        }
    }

    @Override
    public int indexOf(Object o) {
        if (o != null) {
            long val = LongList.toLong(o, -1L);
            for (int n = 0; n < this.m_size; ++n) {
                if (this.m_arrayElements[n] != val) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o != null) {
            long val = LongList.toLong(o, -1L);
            for (int n = this.m_size - 1; n >= 0; --n) {
                if (this.m_arrayElements[n] != val) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<Long> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Long> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<Long> subList(int fromIndex, int toIndex) {
        if (fromIndex >= 0 && toIndex <= this.m_size) {
            LongList vals = new LongList(toIndex - fromIndex);
            for (int n = fromIndex; n < toIndex; ++n) {
                vals.add(this.m_arrayElements[n]);
            }
            return vals;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<Long> {
        private int m_nCursor = 0;
        private int m_nLastRet = -1;

        ListItr(int index) {
            this.m_nCursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.m_nCursor != 0;
        }

        @Override
        public Long previous() {
            try {
                int i = this.m_nCursor - 1;
                Long previous = LongList.this.get(i);
                this.m_nLastRet = this.m_nCursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.m_nCursor;
        }

        @Override
        public int previousIndex() {
            return this.m_nCursor - 1;
        }

        @Override
        public void set(Long o) {
            if (this.m_nLastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                LongList.this.set(this.m_nLastRet, o);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(Long o) {
            try {
                LongList.this.add(this.m_nCursor++, o);
                this.m_nLastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_nCursor != LongList.this.size();
        }

        @Override
        public Long next() {
            try {
                Long next = LongList.this.get(this.m_nCursor);
                this.m_nLastRet = this.m_nCursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.m_nLastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                LongList.this.remove(this.m_nLastRet);
                if (this.m_nLastRet < this.m_nCursor) {
                    --this.m_nCursor;
                }
                this.m_nLastRet = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

