/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.LinkedListNode;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private LinkedListNode<E> m_head = new LinkedListNode<Object>(null, null, null);
    private LinkedListNode<E> m_last = this.m_head;
    private int m_size = 0;

    public LinkedList() {
        this.m_head.m_previous = this.m_head;
        this.m_head.m_next = this.m_head.m_previous;
    }

    public LinkedListNode<E> first() {
        LinkedListNode objNode = this.m_head.m_next;
        if (objNode == this.m_head) {
            return null;
        }
        return objNode;
    }

    public LinkedListNode<E> last() {
        if (this.m_last == this.m_head) {
            return null;
        }
        return this.m_last;
    }

    public synchronized LinkedListNode<E> addFirst(LinkedListNode<E> node) {
        if (node != null) {
            node.m_next = this.m_head.m_next;
            node.m_previous = this.m_head;
            node.m_previous.m_next = node;
            node.m_next.m_previous = node;
            ++this.m_size;
        }
        return node;
    }

    public synchronized LinkedListNode<E> addFirst(E object) {
        LinkedListNode<E> node = new LinkedListNode<E>(object, this.m_head.m_next, this.m_head);
        this.m_head.m_next = node;
        ++this.m_size;
        return node;
    }

    public synchronized LinkedListNode<E> addLast(LinkedListNode<E> node) {
        if (node != null) {
            node.m_next = null;
            node.m_previous = this.m_last;
            this.m_last = node;
            ++this.m_size;
        }
        return node;
    }

    public synchronized LinkedListNode<E> addLast(E object) {
        LinkedListNode<E> node = new LinkedListNode<E>(object, null, this.m_last);
        this.m_last.m_next = node;
        this.m_last = node;
        ++this.m_size;
        return node;
    }

    public synchronized LinkedListNode<E> linkAfter(E e, LinkedListNode<E> succ) {
        if (succ != null) {
            LinkedListNode next = succ.m_next;
            LinkedListNode<E> newNode = new LinkedListNode<E>(e, next, succ);
            succ.m_next = newNode;
            if (next != null) {
                next.m_previous = newNode;
            }
            ++this.m_size;
            return newNode;
        }
        return null;
    }

    public synchronized LinkedListNode<E> linkBefore(E e, LinkedListNode<E> succ) {
        if (succ != null) {
            LinkedListNode pred = succ.m_previous;
            LinkedListNode<E> newNode = new LinkedListNode<E>(e, succ, pred);
            succ.m_previous = newNode;
            if (pred != null) {
                pred.m_next = newNode;
            }
            ++this.m_size;
            return newNode;
        }
        return null;
    }

    public synchronized E unlink(LinkedListNode<E> x) {
        if (x != null) {
            E element = x.getObject();
            LinkedListNode next = x.m_next;
            LinkedListNode prev = x.m_previous;
            if (prev != null) {
                prev.m_next = next;
                x.m_previous = null;
            }
            if (next != null) {
                next.m_previous = prev;
                x.m_next = null;
            }
            if (x == this.m_last) {
                this.m_last = prev;
            }
            --this.m_size;
            return element;
        }
        return null;
    }

    public E pop() {
        return this.unlink(this.first());
    }

    public final boolean isInvalidNode(LinkedListNode<E> node) {
        return node == null || node == this.m_head;
    }

    public synchronized void clear() {
        LinkedListNode<E> node = this.last();
        while (node != null) {
            this.unlink(node);
            node = this.last();
        }
        this.m_head.m_previous = this.m_head;
        this.m_head.m_next = this.m_head.m_previous;
    }

    public int size() {
        return this.m_size;
    }

    public String toString() {
        LinkedListNode objNode = this.m_head.m_next;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("size=").append(this.m_size).append(' ');
        while (objNode != this.m_head) {
            sbuf.append(objNode.toString()).append(", ");
            objNode = objNode.m_next;
        }
        return sbuf.toString();
    }
}

