/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExcel {
    private static final Logger log = LoggerFactory.getLogger(ImportExcel.class);
    private int m_totalRows = 0;
    private int m_totalCells = 0;
    private String m_errorMessage;
    private Workbook m_workBook;
    private Sheet m_sheet;

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    public ImportExcel() {
    }

    public ImportExcel(String fileName) {
        this.m_workBook = this.open(fileName);
    }

    public int getTotalRows() {
        return this.m_totalRows;
    }

    public int getTotalCells() {
        return this.m_totalCells;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public boolean validateExcel(String filePath) {
        if (filePath == null || !ImportExcel.isExcel2003(filePath) && !ImportExcel.isExcel2007(filePath)) {
            this.m_errorMessage = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            this.m_errorMessage = "\u6587\u4ef6\u4e0d\u5b58\u5728";
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook open(String filePath) {
        InputStream is = null;
        XSSFWorkbook wb = null;
        try {
            if (!this.validateExcel(filePath)) {
                log.error(this.m_errorMessage);
                Workbook workbook = null;
                return workbook;
            }
            File file = null;
            boolean isExcel2003 = true;
            if (ImportExcel.isExcel2007(filePath)) {
                isExcel2003 = false;
            }
            file = new File(filePath);
            is = new FileInputStream(file);
            if (isExcel2003) {
                try {
                    wb = new HSSFWorkbook(is);
                }
                catch (OfficeXmlFileException e) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        is = new FileInputStream(file);
                        wb = new XSSFWorkbook(is);
                    }
                    catch (Exception e1) {
                        log.error("Excel 2007+\u64cd\u4f5c\u5f02\u5e38\uff1a{}", (Object)e1.getMessage());
                    }
                }
            } else {
                wb = new XSSFWorkbook(is);
            }
            is.close();
            is = null;
        }
        catch (Exception ex) {
            log.error("Excel \u64cd\u4f5c\u5f02\u5e38\uff1a{}", (Object)ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return wb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setSheet(int sheetIndex) {
        if (this.m_workBook == null) {
            this.m_errorMessage = "\u9700\u8981\u6784\u9020\u5bf9\u8c61\u65f6\u63d0\u4f9b\u6587\u4ef6\u8def\u5f84";
            return false;
        }
        this.m_sheet = this.m_workBook.getSheetAt(sheetIndex);
        if (this.m_sheet == null) {
            this.m_errorMessage = String.format("\u4e0d\u5b58\u5728\u8868%s", sheetIndex);
            return false;
        }
        this.m_totalRows = this.m_sheet.getPhysicalNumberOfRows();
        this.m_totalCells = this.m_totalRows > 0 ? this.m_sheet.getRow(0).getPhysicalNumberOfCells() : 0;
        return true;
    }

    public List<List<String>> read(String filePath) {
        Workbook wb = this.open(filePath);
        return wb != null ? this.read(wb) : new ArrayList();
    }

    private List<List<String>> read(Workbook wb) {
        return this.read(wb, 0);
    }

    private List<List<String>> read(Workbook wb, int sheetIndex) {
        ArrayList<List<String>> dataLst = new ArrayList<List<String>>();
        Sheet sheet = wb.getSheetAt(sheetIndex);
        if (sheet == null) {
            this.m_totalRows = -1;
            return null;
        }
        this.m_totalRows = sheet.getPhysicalNumberOfRows();
        if (this.m_totalRows >= 1 && sheet.getRow(0) != null) {
            this.m_totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        for (int r = 0; r < this.m_totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            ArrayList<String> rowLst = new ArrayList<String>();
            for (int c = 0; c < this.getTotalCells(); ++c) {
                Cell cell = row.getCell(c);
                rowLst.add(ImportExcel.getCellValue(cell));
            }
            dataLst.add(rowLst);
        }
        return dataLst;
    }

    private static final String getCellValue(Cell cell) {
        String cellValue;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    cellValue = StringUtils.toString(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 4: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 2: {
                    cellValue = cell.getCellFormula();
                    break;
                }
                case 3: {
                    cellValue = "";
                    break;
                }
                case 5: {
                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                    break;
                }
                default: {
                    log.info("\u672a\u77e5\u5355\u5143\u683c\u7c7b\u578b\uff1a{}", (Object)cell.getCellType());
                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    public List<List<String>> read(int sheetIndex) {
        if (this.m_workBook == null) {
            return null;
        }
        return this.read(this.m_workBook, sheetIndex);
    }

    public String[] read(int sheetIndex, int rowIndex) {
        Row row;
        Sheet sheet;
        if (this.m_workBook == null || (sheet = this.m_workBook.getSheetAt(sheetIndex)) == null) {
            this.m_totalRows = -1;
            return null;
        }
        this.m_totalRows = sheet.getPhysicalNumberOfRows();
        if (this.m_totalRows > rowIndex && rowIndex >= 0 && (row = sheet.getRow(rowIndex)) != null) {
            this.m_totalCells = row.getPhysicalNumberOfCells();
            String[] ret = new String[this.m_totalCells];
            for (int n = 0; n < this.m_totalCells; ++n) {
                Cell cell = row.getCell(n);
                ret[n] = ImportExcel.getCellValue(cell);
            }
            return ret;
        }
        return null;
    }

    public String[] getCellVals(int rowIndex) {
        if (this.m_sheet == null) {
            return null;
        }
        Row row = this.m_sheet.getRow(rowIndex);
        if (row != null) {
            String[] ret = new String[this.m_totalCells];
            for (int n = 0; n < this.m_totalCells; ++n) {
                Cell cell = row.getCell(n);
                ret[n] = ImportExcel.getCellValue(cell);
            }
            return ret;
        }
        return null;
    }

    public String getCellValue(int rowIndex, int cellIndex) {
        return ImportExcel.getCellValue(this.getCell(rowIndex, cellIndex));
    }

    public Cell getCell(int rowIndex, int cellIndex) {
        if (this.m_sheet == null) {
            return null;
        }
        Row row = this.m_sheet.getRow(rowIndex);
        if (row != null) {
            return row.getCell(cellIndex);
        }
        return null;
    }

    public List<List<String>> read(int sheetIndex, int[] cellIndexes) {
        Sheet sheet;
        if (this.m_workBook == null || (sheet = this.m_workBook.getSheetAt(sheetIndex)) == null) {
            this.m_totalRows = -1;
            return null;
        }
        boolean isAll = cellIndexes == null || cellIndexes.length == 0;
        this.m_totalRows = sheet.getPhysicalNumberOfRows();
        ArrayList<List<String>> datas = new ArrayList<List<String>>(this.m_totalRows);
        for (int n = 0; n < this.m_totalRows; ++n) {
            Row row = sheet.getRow(n);
            this.m_totalCells = row.getPhysicalNumberOfCells();
            ArrayList<String> curRow = new ArrayList<String>(!isAll ? cellIndexes.length : this.m_totalCells);
            if (isAll) {
                for (int i = 0; i < this.m_totalCells; ++i) {
                    Cell cell = row.getCell(i);
                    curRow.add(ImportExcel.getCellValue(cell));
                }
            } else {
                for (int index : cellIndexes) {
                    if (index < this.m_totalCells) {
                        Cell cell = row.getCell(index);
                        curRow.add(ImportExcel.getCellValue(cell));
                        continue;
                    }
                    curRow.add("");
                    log.info("\u4e0d\u5b58\u5728\u7b2c{}\u884c{}\u5217", (Object)n, (Object)index);
                }
            }
            datas.add(curRow);
        }
        return datas;
    }

    public String getSheetName(int sheetIndex) {
        if (this.m_workBook == null) {
            return null;
        }
        return this.m_workBook.getSheetName(sheetIndex);
    }

    public int getNumberOfSheets() {
        if (this.m_workBook == null) {
            return 0;
        }
        return this.m_workBook.getNumberOfSheets();
    }
}

