/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Base64;
import com.hynnet.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPLocalizer {
    protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.IPLocalizer");
    private static boolean native_lib_init_pending = true;

    private static native String LookupAddress(String var0);

    private static native void reload();

    public static String[] search(String strIP) {
        String[] arrayResult = new String[2];
        if (native_lib_init_pending) {
            try {
                System.loadLibrary("dllinuxj");
                native_lib_init_pending = false;
            }
            catch (UnsatisfiedLinkError e2) {
                e2.printStackTrace();
                System.err.println("\u4e0d\u80fd\u521d\u59cb\u5316IP\u5730\u5740\u5b9a\u4f4d\u3002");
            }
        }
        try {
            arrayResult[0] = IPLocalizer.LookupAddress(strIP);
        }
        catch (UnsatisfiedLinkError e2) {
            log.error("IP\u5730\u5740\u5b9a\u4f4d\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error("IP\u5730\u5740\u5b9a\u4f4d\u5f02\u5e38\u3002");
        }
        arrayResult[1] = "";
        if (arrayResult[0] == null || arrayResult[0].length() <= 0) {
            try {
                log.error("\u65e0\u6cd5\u5b9a\u4f4dIP\u3002");
                return IPLocalizer.search(strIP);
            }
            catch (NoClassDefFoundError e) {
                log.error("\u627e\u4e0d\u5230\u7c7b\uff1a{}", (Throwable)e);
            }
            catch (Exception e) {
                log.error("IP\u5b9a\u4f4d\u5f02\u5e38\uff1a{}", (Object)e, (Object)e);
            }
        }
        return arrayResult;
    }

    public static boolean reloadData() {
        if (native_lib_init_pending) {
            try {
                System.loadLibrary("dllinuxj");
                native_lib_init_pending = false;
            }
            catch (UnsatisfiedLinkError e2) {
                e2.printStackTrace();
                System.err.println("\u4e0d\u80fd\u521d\u59cb\u5316IP\u5730\u5740\u5b9a\u4f4d\u3002");
            }
        }
        try {
            IPLocalizer.reload();
            return true;
        }
        catch (UnsatisfiedLinkError e2) {
            log.error("\u91cd\u65b0\u88c5\u8f7dIP\u5730\u5740\u5b9a\u4f4d\u6570\u636e\u5f02\u5e38\uff01");
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u88c5\u8f7dIP\u5730\u5740\u5b9a\u4f4d\u6570\u636e\u5f02\u5e38\u3002");
        }
        return false;
    }

    public static void main(String[] args) {
        int n;
        String[] arrayAllIP = Util.getAllIP();
        StringBuffer sbuf = new StringBuffer();
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            sbuf.append((char)n);
        }
        for (n = 0; n < arrayAllIP.length; ++n) {
            System.out.println("IP:" + arrayAllIP[n] + " = " + Base64.encodeBytes(arrayAllIP[n].getBytes()));
        }
        if (args.length > 1 && args[1].indexOf("debug") >= 0) {
            System.loadLibrary("dllinuxj");
            System.out.println(IPLocalizer.LookupAddress(args[0]));
        } else if (args.length > 0) {
            String[] location = IPLocalizer.search(args[0]);
            log.debug("IP:" + args[0] + " \u6240\u5728\u5730\uff1a" + location[0] + location[1]);
        }
    }
}

