/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.IPAddress;
import com.hynnet.util.StringList;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;

public class IPAddressGroup
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    private IPAddress[] m_ipAddresses;
    private int m_totalIp;
    private boolean m_isSorted;

    public IPAddressGroup() {
        this.m_totalIp = 0;
        this.m_isSorted = true;
    }

    public IPAddressGroup(String ipList) {
        if (ipList != null && (ipList = ipList.trim()).length() > 0) {
            String[] ips = ipList.split(",|;| |\uff0c|\uff1b");
            this.m_ipAddresses = new IPAddress[ips.length];
            this.m_totalIp = 0;
            for (int n = 0; n < ips.length; ++n) {
                IPAddress objAddress = IPAddress.get(ips[n]);
                if (objAddress == null) continue;
                this.m_ipAddresses[this.m_totalIp++] = objAddress;
            }
            if (this.m_totalIp == this.m_ipAddresses.length) {
                Arrays.sort(this.m_ipAddresses);
                this.m_isSorted = true;
            }
        } else {
            this.m_totalIp = 0;
        }
    }

    public IPAddressGroup(StringList ips) {
        if (ips != null && ips.size() > 0) {
            this.m_ipAddresses = new IPAddress[ips.size()];
            this.m_totalIp = 0;
            for (int n = 0; n < ips.size(); ++n) {
                IPAddress address = IPAddress.get(ips.getString(n));
                if (address == null) continue;
                this.m_ipAddresses[this.m_totalIp++] = address;
            }
            if (this.m_totalIp == this.m_ipAddresses.length) {
                Arrays.sort(this.m_ipAddresses);
                this.m_isSorted = true;
            }
        } else {
            this.m_totalIp = 0;
        }
    }

    public synchronized Object clone() {
        IPAddressGroup objNew = new IPAddressGroup();
        if (this.m_totalIp > 0) {
            objNew.m_ipAddresses = new IPAddress[this.m_totalIp];
            System.arraycopy(this.m_ipAddresses, 0, objNew.m_ipAddresses, 0, this.m_totalIp);
            objNew.m_totalIp = this.m_totalIp;
            objNew.m_isSorted = this.m_isSorted;
        }
        return objNew;
    }

    public final IPAddressGroup put(String ip) {
        IPAddress objIPAddress = IPAddress.get(ip);
        if (objIPAddress != null) {
            return this.put(objIPAddress);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IPAddressGroup put(IPAddress ipAddress) {
        if (ipAddress.getFamily() == 3) return this;
        if (this.m_ipAddresses == null) {
            this.m_ipAddresses = new IPAddress[10];
        }
        IPAddress[] iPAddressArray = this.m_ipAddresses;
        synchronized (this.m_ipAddresses) {
            if (this.m_totalIp == this.m_ipAddresses.length) {
                IPAddress[] arrayIPAddress = new IPAddress[this.m_ipAddresses.length + 10];
                System.arraycopy(this.m_ipAddresses, 0, arrayIPAddress, 0, this.m_totalIp);
                this.m_ipAddresses = arrayIPAddress;
            }
            this.m_ipAddresses[this.m_totalIp++] = ipAddress;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IPAddressGroup put(IPAddressGroup ipAddressGroup) {
        if (ipAddressGroup == null || ipAddressGroup.size() <= 0) return this;
        if (this.m_ipAddresses == null) {
            this.m_ipAddresses = new IPAddress[10];
        }
        IPAddress[] iPAddressArray = this.m_ipAddresses;
        synchronized (this.m_ipAddresses) {
            if (this.m_totalIp + ipAddressGroup.size() < this.m_ipAddresses.length) {
                IPAddress[] arrayIPAddress = new IPAddress[this.m_totalIp + ipAddressGroup.size()];
                System.arraycopy(this.m_ipAddresses, 0, arrayIPAddress, 0, this.m_totalIp);
                this.m_ipAddresses = arrayIPAddress;
            }
            for (int n = 0; n < ipAddressGroup.size(); ++n) {
                this.m_ipAddresses[this.m_totalIp + n] = ipAddressGroup.get(n);
            }
            this.m_totalIp += ipAddressGroup.size();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    public final IPAddress remove(String ip) {
        IPAddress ipAddress = IPAddress.get(ip);
        if (ipAddress != null) {
            return this.remove(ipAddress);
        }
        return null;
    }

    public final IPAddress remove(IPAddress ipAddress) {
        if (this.m_ipAddresses != null && ipAddress != null) {
            for (int n = 0; n < this.m_totalIp; ++n) {
                if (!ipAddress.equals(this.m_ipAddresses[n])) continue;
                IPAddress ip = this.m_ipAddresses[n];
                for (int i = n; i < this.m_totalIp - 1; ++i) {
                    this.m_ipAddresses[i] = this.m_ipAddresses[i + 1];
                }
                --this.m_totalIp;
                return ip;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IPAddress remove(int index) {
        if (this.m_ipAddresses != null && index < this.m_totalIp) {
            IPAddress[] iPAddressArray = this.m_ipAddresses;
            synchronized (this.m_ipAddresses) {
                IPAddress addr = this.m_ipAddresses[index];
                for (int n = index; n < this.m_totalIp - 1; ++n) {
                    this.m_ipAddresses[n] = this.m_ipAddresses[n + 1];
                }
                --this.m_totalIp;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return addr;
            }
        }
        return null;
    }

    public void clear() {
        this.m_totalIp = 0;
    }

    public final IPAddress get(int index) {
        if (index >= 0 && index < this.m_totalIp) {
            return this.m_ipAddresses[index];
        }
        return null;
    }

    public final int size() {
        return this.m_totalIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final synchronized void sort() {
        if (this.m_ipAddresses != null) {
            IPAddress[] iPAddressArray = this.m_ipAddresses;
            // MONITORENTER : this.m_ipAddresses
            if (this.m_totalIp != this.m_ipAddresses.length) {
                IPAddress[] ipAddresses = new IPAddress[this.m_totalIp];
                System.arraycopy(this.m_ipAddresses, 0, ipAddresses, 0, this.m_totalIp);
                this.m_ipAddresses = ipAddresses;
            }
            Arrays.sort(this.m_ipAddresses);
            // MONITOREXIT : iPAddressArray
        }
        this.m_isSorted = true;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < this.m_totalIp; ++n) {
            if (n > 0) {
                sb.append(',');
            }
            sb.append(this.m_ipAddresses[n].toString());
        }
        return sb.toString();
    }

    public final boolean isAllowIP(String currentIp) {
        return this.isAllowIP(IPAddress.get(currentIp), (IPAddress)null);
    }

    public final boolean isAllowIP(String currentIp, String oldIp) {
        return this.isAllowIP(IPAddress.get(currentIp), IPAddress.get(oldIp));
    }

    public final boolean isAllowIP(String currentIp, IPAddress oldIp) {
        return this.isAllowIP(IPAddress.get(currentIp), oldIp);
    }

    public final boolean isAllowIP(IPAddress currentIp, IPAddress oldIp) {
        if (currentIp != null && currentIp.m_family != 3) {
            if (oldIp != null) {
                if (currentIp.isMatch(oldIp)) {
                    return true;
                }
                if (oldIp.m_family != 3 && currentIp.m_family == oldIp.m_family) {
                    byte nOld;
                    int nCurrent;
                    int index;
                    int last = currentIp.m_ipAddressBytes.length - 1;
                    for (index = 0; index < last && currentIp.m_ipAddressBytes[index] == oldIp.m_ipAddressBytes[index]; ++index) {
                    }
                    if (index >= last && (nCurrent = currentIp.m_ipAddressBytes[last]) >= ((nOld = oldIp.m_ipAddressBytes[last]) - 10 > 0 ? nOld - 10 : 1) && nCurrent <= (nOld + 10 < 255 ? nOld + 10 : 254)) {
                        return true;
                    }
                }
            }
            if (this.m_ipAddresses != null && this.m_totalIp > 0) {
                if (!this.m_isSorted) {
                    this.sort();
                }
                for (int n = 0; n < this.m_totalIp; ++n) {
                    if (!this.m_ipAddresses[n].isMatch(currentIp)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isMatch(InetAddress address) {
        return this.isMatch(new IPAddress(address));
    }

    public final boolean isMatch(IPAddress address) {
        if (this.m_ipAddresses != null) {
            if (!this.m_isSorted) {
                this.sort();
            }
            for (int n = 0; n < this.m_totalIp; ++n) {
                if (!this.m_ipAddresses[n].isMatch(address)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public final boolean isMatch(String address) {
        return this.isMatch(new IPAddress(address));
    }

    public static void main(String[] args) {
        IPAddressGroup obj = new IPAddressGroup();
        HashMap<IPAddress, String> mapIP = new HashMap<IPAddress, String>();
        mapIP.put(IPAddress.get("172.16.16.8"), "1");
        mapIP.put(IPAddress.get("172.16.16.9"), "2");
        if (mapIP.containsKey(IPAddress.get("172.16.16.9"))) {
            System.out.println("value=" + mapIP.get(IPAddress.get("172.16.16.9")) + " isMatch=" + IPAddress.get("172.16.16.9").isMatch("172.16.16.9"));
        }
        obj.put("0:0:0:0:0:0:0:1");
        obj.put("0:0:0:0:0:0:0:1%1");
        obj.put("192.168.0.1");
        obj.put("172.16.16.*");
        System.out.println("IPAddressGroup: " + obj.toString());
        obj.sort();
        System.out.println("IPAddressGroup: " + obj.toString() + "\r\nisAllowIP=" + obj.isAllowIP("172.16.16.8") + ", " + obj.isAllowIP("172.16.17.9", "172.16.17.9") + ", " + obj.isAllowIP("172.16.17.9"));
        obj = new IPAddressGroup("192.168.0.2,192.168.0.1,172.16.16;172.16. ;192.168.0");
        System.out.println("IPAddressGroup: " + obj.toString() + "\r\nisAllowIP=" + obj.isAllowIP("172.16.16.8") + ", " + obj.isAllowIP("192.168.0.2", "172.16.17.9"));
    }
}

