/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddress
implements Comparable<Object>,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;
    private static final int IPv4_INADDRSZ = 4;
    private static final int IPv6_INADDRSZ = 16;
    public static final int IPInvalid = 3;
    private static final int INT16SZ = 2;
    protected int m_family;
    byte[] m_ipAddressBytes;
    private int m_ipv4addressVal;

    public IPAddress() {
        this.m_family = 3;
        this.m_ipv4addressVal = 0;
    }

    public IPAddress(String ip) {
        if (ip != null && ip.length() > 0) {
            byte[] newdst;
            char ch;
            int i;
            int[] ipv4AddressVals = new int[1];
            if (ip.charAt(0) == '/' && (i = ip.lastIndexOf(58)) > 0) {
                ip = ip.substring(1, i);
            }
            char[] srcb = ip.toCharArray();
            i = 0;
            while (i < srcb.length) {
                if ((ch = srcb[i++]) == '.') {
                    this.m_family = 1;
                    break;
                }
                if (ch != ':') continue;
                this.m_family = 2;
                break;
            }
            if (i >= srcb.length) {
                this.m_family = 3;
                return;
            }
            if (this.m_family == 1) {
                this.m_ipAddressBytes = IPAddress.textToNumericFormat(srcb, ipv4AddressVals);
                this.m_ipv4addressVal = ipv4AddressVals[0];
                return;
            }
            int j = 0;
            byte[] dst = new byte[16];
            int colonp = -1;
            i = 0;
            if (srcb[i] == ':' && srcb[++i] != ':') {
                this.m_family = 3;
                return;
            }
            int curtok = i;
            boolean saw_xdigit = false;
            int val = 0;
            while (i < srcb.length) {
                byte[] v4addr;
                int chval;
                if ((chval = Character.digit(ch = srcb[i++], 16)) != -1) {
                    val <<= 4;
                    if ((val |= chval) > 65535) break;
                    saw_xdigit = true;
                    continue;
                }
                if (ch == ':') {
                    curtok = i;
                    if (!saw_xdigit) {
                        if (colonp != -1) break;
                        colonp = j;
                        continue;
                    }
                    if (i == srcb.length || j + 2 > 16) break;
                    dst[j++] = (byte)(val >> 8 & 0xFF);
                    dst[j++] = (byte)(val & 0xFF);
                    saw_xdigit = false;
                    val = 0;
                    continue;
                }
                if (ch != '.' || j + 4 > 16 || (v4addr = IPAddress.textToNumericFormat(ip.substring(curtok).toCharArray(), ipv4AddressVals)) == null) break;
                this.m_family = 1;
                this.m_ipAddressBytes = v4addr;
                this.m_ipv4addressVal = ipv4AddressVals[0];
                return;
            }
            for (i = j; i < 16; ++i) {
                dst[i] = -1;
            }
            if (saw_xdigit && j + 2 <= 16) {
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
            }
            if (colonp != -1) {
                int n = j - colonp;
                if (j != 16) {
                    for (i = 1; i <= n; ++i) {
                        dst[16 - i] = dst[colonp + n - i];
                        dst[colonp + n - i] = 0;
                    }
                    j = 16;
                }
            }
            if ((newdst = IPAddress.convertFromIPv4MappedAddress(dst, ipv4AddressVals)) != null) {
                this.m_family = 1;
                this.m_ipAddressBytes = newdst;
                this.m_ipv4addressVal = ipv4AddressVals[0];
                return;
            }
            this.m_ipAddressBytes = dst;
            this.m_ipv4addressVal = 0;
            return;
        }
        this.m_family = 3;
    }

    public IPAddress(byte[] addr) {
        if (addr != null) {
            this.m_ipAddressBytes = (byte[])addr.clone();
            if (addr.length == 4) {
                int n;
                this.m_family = 1;
                for (n = 0; n < 4 && this.m_ipAddressBytes[n] != -1; ++n) {
                }
                if (n < 4) {
                    this.m_ipv4addressVal = 0;
                } else {
                    this.m_ipv4addressVal = this.m_ipAddressBytes[3] & 0xFF;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[2] << 8 & 0xFF00;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[1] << 16 & 0xFF0000;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[0] << 24 & 0xFF000000;
                }
                return;
            }
            if (addr.length == 16) {
                this.m_family = 2;
                this.m_ipv4addressVal = 0;
                return;
            }
        }
        this.m_family = 3;
        this.m_ipv4addressVal = 0;
    }

    public IPAddress(InetAddress addr) {
        byte[] arrayAddr;
        if (addr != null && (arrayAddr = addr.getAddress()) != null) {
            this.m_ipAddressBytes = (byte[])arrayAddr.clone();
            if (arrayAddr.length == 4) {
                int n;
                this.m_family = 1;
                for (n = 0; n < 4 && this.m_ipAddressBytes[n] != -1; ++n) {
                }
                if (n < 4) {
                    this.m_ipv4addressVal = 0;
                } else {
                    this.m_ipv4addressVal = this.m_ipAddressBytes[3] & 0xFF;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[2] << 8 & 0xFF00;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[1] << 16 & 0xFF0000;
                    this.m_ipv4addressVal |= this.m_ipAddressBytes[0] << 24 & 0xFF000000;
                }
                return;
            }
            if (arrayAddr.length == 16) {
                this.m_family = 2;
                this.m_ipv4addressVal = 0;
                return;
            }
        }
        this.m_family = 3;
        this.m_ipv4addressVal = 0;
    }

    public int hashCode() {
        if (this.m_ipAddressBytes != null) {
            int hash = 0;
            int n = 0;
            while (n < this.m_ipAddressBytes.length) {
                int component = 0;
                for (int i = 0; i < 4 && n < this.m_ipAddressBytes.length; ++i, ++n) {
                    component = (component << 8) + this.m_ipAddressBytes[n];
                }
                hash += component;
            }
            return hash;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return this.m_family == 3;
        }
        if (obj instanceof String || obj instanceof SocketAddress) {
            obj = IPAddress.get(obj.toString());
        }
        if (obj instanceof IPAddress) {
            IPAddress objAddr = (IPAddress)obj;
            if (this.m_family != objAddr.m_family) {
                return false;
            }
            if (this.m_family == 3) {
                return true;
            }
            for (int n = 0; n < this.m_ipAddressBytes.length; ++n) {
                if (this.m_ipAddressBytes[n] == objAddr.m_ipAddressBytes[n]) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof InetAddress) {
            byte[] arrayAddress = ((Inet6Address)obj).getAddress();
            for (int n = 0; n < this.m_ipAddressBytes.length; ++n) {
                if (n >= arrayAddress.length) {
                    return false;
                }
                if (this.m_ipAddressBytes[n] == arrayAddress[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof IPAddress) {
            return this.compareTo((IPAddress)obj);
        }
        if (obj instanceof InetAddress) {
            return this.compareTo(new IPAddress((InetAddress)obj));
        }
        if (obj instanceof String) {
            return this.compareTo(new IPAddress((String)obj));
        }
        return -1;
    }

    @Override
    public int compareTo(IPAddress anotherIp) {
        if (anotherIp == null) {
            return -1;
        }
        if (this.m_family != anotherIp.m_family) {
            return this.m_family - anotherIp.m_family;
        }
        return this.hashCode() - anotherIp.hashCode();
    }

    public final String getHostAddress() {
        if (this.m_ipAddressBytes != null) {
            switch (this.m_family) {
                case 1: {
                    return (this.m_ipAddressBytes[0] & 0xFF) + "." + (this.m_ipAddressBytes[1] & 0xFF) + "." + (this.m_ipAddressBytes[2] & 0xFF) + "." + (this.m_ipAddressBytes[3] & 0xFF);
                }
                case 2: {
                    StringBuffer sb = new StringBuffer(39);
                    for (int n = 0; n < 8; ++n) {
                        sb.append(Integer.toHexString(this.m_ipAddressBytes[n << 1] << 8 & 0xFF00 | this.m_ipAddressBytes[(n << 1) + 1] & 0xFF));
                        if (n >= 7) continue;
                        sb.append(':');
                    }
                    return sb.toString();
                }
            }
        }
        return "";
    }

    public final String toString() {
        return this.getHostAddress();
    }

    public final InetAddress getInetAddress() {
        switch (this.m_family) {
            case 1: 
            case 2: {
                try {
                    return InetAddress.getByAddress(this.m_ipAddressBytes);
                }
                catch (UnknownHostException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static final IPAddress get(String ip) {
        IPAddress objAddress = new IPAddress(ip);
        if (objAddress.m_family != 3) {
            return objAddress;
        }
        return null;
    }

    public final int getFamily() {
        return this.m_family;
    }

    public final boolean isMatch(InetAddress address) {
        return this.isMatch(new IPAddress(address));
    }

    public final boolean isMatch(IPAddress address) {
        if (address != null) {
            if (this.m_family != address.m_family || this.m_family == 3) {
                return false;
            }
            if (this.m_ipv4addressVal != 0) {
                return address.m_ipv4addressVal == this.m_ipv4addressVal;
            }
            for (int n = 0; n < this.m_ipAddressBytes.length; ++n) {
                if (this.m_ipAddressBytes[n] == -1) {
                    return true;
                }
                if (this.m_ipAddressBytes[n] == address.m_ipAddressBytes[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isMatch(String address) {
        return this.isMatch(new IPAddress(address));
    }

    private static final byte[] textToNumericFormat(char[] srcb, int[] addressVals) {
        int i = 0;
        int cur = 0;
        boolean saw_digit = false;
        byte[] dst = new byte[4];
        int octets = 0;
        while (i < srcb.length) {
            char ch;
            if (Character.isDigit(ch = srcb[i++])) {
                int sum = (dst[cur] & 0xFF) * 10 + (Character.digit(ch, 10) & 0xFF);
                if (sum > 255) break;
                dst[cur] = (byte)(sum & 0xFF);
                if (saw_digit) continue;
                if (++octets > 4) break;
                saw_digit = true;
                continue;
            }
            if (ch != '.' || !saw_digit || octets == 4) break;
            dst[++cur] = 0;
            saw_digit = false;
        }
        if (octets < 4) {
            while (octets < 4) {
                dst[octets] = -1;
                ++octets;
            }
            if (addressVals != null && addressVals.length > 0) {
                addressVals[0] = 0;
            }
        } else if (addressVals != null && addressVals.length > 0) {
            addressVals[0] = dst[3] & 0xFF;
            addressVals[0] = addressVals[0] | dst[2] << 8 & 0xFF00;
            addressVals[0] = addressVals[0] | dst[1] << 16 & 0xFF0000;
            addressVals[0] = addressVals[0] | dst[0] << 24 & 0xFF000000;
        }
        return dst;
    }

    private static final boolean isIPv4MappedAddress(byte[] addr) {
        if (addr.length < 16) {
            return false;
        }
        return addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1;
    }

    private static final byte[] convertFromIPv4MappedAddress(byte[] addr, int[] addressVals) {
        if (IPAddress.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            if (addressVals != null && addressVals.length > 0) {
                int n;
                for (n = 0; n < 4 && newAddr[n] != -1; ++n) {
                }
                if (n >= 4) {
                    addressVals[0] = newAddr[3] & 0xFF;
                    addressVals[0] = addressVals[0] | newAddr[2] << 8 & 0xFF00;
                    addressVals[0] = addressVals[0] | newAddr[1] << 16 & 0xFF0000;
                    addressVals[0] = addressVals[0] | newAddr[0] << 24 & 0xFF000000;
                } else {
                    addressVals[0] = 0;
                }
            }
            return newAddr;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

