/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.HtmlUtils");

    public static final StringBuffer getHtmlData(String strHtmlFilePath) {
        return HtmlUtils.getHtmlData(strHtmlFilePath, "GBK", false, true);
    }

    public static final StringBuffer getHtmlData(String strHtmlFilePath, boolean bDeleteBodyTag) {
        return HtmlUtils.getHtmlData(strHtmlFilePath, "GBK", bDeleteBodyTag, true);
    }

    public static final StringBuffer getHtmlData(String strHtmlFilePath, String strEncoding, boolean bDeleteBodyTag, boolean bDeleteSpace) {
        StringBuffer bufResult = new StringBuffer();
        try {
            File objFile = null;
            FileInputStream objHtmlInputa = null;
            FileInputStream objHtmlInputb = null;
            InputStreamReader objInRead = null;
            BufferedReader objBufRead = null;
            Source objHtmlSrc = null;
            String strIn = "";
            int nStart = 0;
            int nEnd = 0;
            objFile = new File(strHtmlFilePath);
            if (objFile.isFile()) {
                objHtmlInputa = new FileInputStream(objFile);
                objHtmlInputb = new FileInputStream(objFile);
                objHtmlSrc = new Source((InputStream)objHtmlInputb);
                if (bDeleteBodyTag) {
                    List linkStartTags = objHtmlSrc.getAllStartTags("body");
                    for (StartTag objStartTag : linkStartTags) {
                        nStart = objStartTag.getBegin();
                        nEnd = objStartTag.getEnd();
                    }
                }
                objInRead = new InputStreamReader((InputStream)objHtmlInputa, strEncoding);
                objBufRead = new BufferedReader(objInRead);
                while ((strIn = objBufRead.readLine()) != null) {
                    if (bDeleteSpace) {
                        strIn = strIn.trim();
                    }
                    if (strIn.length() <= 0) continue;
                    bufResult.append(strIn).append("\r\n");
                }
                if (bDeleteBodyTag) {
                    bufResult.replace(nStart, nEnd, "<body>");
                }
                objBufRead.close();
                objInRead.close();
                ((InputStream)objHtmlInputa).close();
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6" + strHtmlFilePath + "\u7684\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
        }
        return bufResult;
    }
}

