/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.LinkedList;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.net.www.protocol.http.HttpURLConnection;

public class GetURL
implements Serializable {
    public String strErrorMsg = "";
    public String strProxyName = "";
    public int iProxyPort = 80;
    public String strReferer = null;
    public String strUserAgent = "Mozilla/4.07 [zh-cn] (Win98; I)";
    public String strCookie = null;
    public String strHeader = "";
    public String strHost;
    public int iPort;
    private Socket objSocket = null;
    private BufferedReader input = null;
    private PrintStream output = null;
    private int iType = 0;
    private int iRetry = 0;
    public int iMaxRetry = 10;
    public String strFirstLocation = null;
    public String strLastLocation = null;

    public String getURL(String strURL) {
        return this.getURL("GET", strURL, null);
    }

    public String getURL(String strURL, String strData) {
        return this.getURL("GET", strURL, strData);
    }

    public String getURL(String Action, String strURL, String strData) {
        if (strURL == null || "".equals(strURL)) {
            return "";
        }
        if (!this.connectURL(Action, strURL, strData)) {
            this.strErrorMsg = "\u4e0d\u80fd\u8fde\u63a5\u670d\u52a1\u5668";
            return "";
        }
        String strResult = "";
        String strReply = "";
        try {
            while ((strReply = this.input.readLine()) != null) {
                strResult = strResult + strReply + "\r\n";
            }
        }
        catch (Exception e) {
            this.strErrorMsg = this.strErrorMsg + e.getMessage();
        }
        this.disconnectURL(this.objSocket, this.input, this.output);
        strReply = this.getHeader("Location");
        if (strReply.length() > 1 && this.iRetry < this.iMaxRetry) {
            ++this.iRetry;
            if ((strReply = this.getNextLocation(strURL, strReply)) != null && !"".equals(strReply)) {
                return this.getURL(Action, strReply, null);
            }
        }
        return strResult;
    }

    public String postURL(String strURL, String strData) {
        return this.getURL("POST", strURL, strData);
    }

    public boolean savePostURL(String strURL, String strData, String strFileName) {
        return this.saveGetURL("POST", strURL, strData, strFileName);
    }

    public boolean savePostURL(String strURL, String strData, String strFileName, boolean bAppend) {
        return this.saveGetURL("POST", strURL, strData, strFileName, bAppend);
    }

    public boolean saveGetURL(String strURL, String strFileName) {
        return this.saveGetURL("GET", strURL, null, strFileName);
    }

    public boolean saveGetURL(String strURL, String strFileName, boolean bAppend) {
        return this.saveGetURL("GET", strURL, null, strFileName, bAppend);
    }

    public boolean saveGetURL(String strURL, String strData, String strFileName) {
        return this.saveGetURL("GET", strURL, strData, strFileName);
    }

    public boolean saveGetURL(String strURL, String strData, String strFileName, boolean bAppend) {
        return this.saveGetURL("GET", strURL, strData, strFileName, bAppend);
    }

    public boolean saveGetURL(String Action, String strURL, String strData, String strFileName) {
        return this.saveGetURL(Action, strURL, strData, strFileName, false);
    }

    public boolean saveGetURL(String Action, String strURL, String strData, String strFileName, boolean bAppend) {
        FileWriter objFile;
        if (strURL == null || "".equals(strURL)) {
            return false;
        }
        try {
            objFile = bAppend ? new FileWriter(strFileName, true) : new FileWriter(strFileName);
        }
        catch (Exception e) {
            this.strErrorMsg = "\u521b\u5efa\u6587\u4ef6\u51fa\u9519";
            return false;
        }
        if (!this.connectURL(Action, strURL, strData)) {
            this.strErrorMsg = this.strErrorMsg + "\u4e0d\u80fd\u8fde\u63a5\u670d\u52a1\u5668";
            return false;
        }
        String strReply = "";
        try {
            while ((strReply = this.input.readLine()) != null) {
                strReply = strReply + "\r\n";
                objFile.write(strReply, 0, strReply.length());
            }
            objFile.close();
        }
        catch (Exception e) {
            this.strErrorMsg = this.strErrorMsg + e.getMessage();
            e.printStackTrace();
        }
        this.disconnectURL(this.objSocket, this.input, this.output);
        strReply = this.getHeader("Location");
        if (strReply.length() > 1 && this.iRetry < this.iMaxRetry) {
            ++this.iRetry;
            if ((strReply = this.getNextLocation(strURL, strReply)) != null && !"".equals(strReply)) {
                return this.saveGetURL(Action, strReply, null, strFileName, bAppend);
            }
        }
        return true;
    }

    private boolean connectURL(String Action, String strURL, String strData) {
        try {
            String strSendData = this.getSendData(Action, strURL, strData);
            if (strSendData == null || "".equals(strSendData)) {
                this.strErrorMsg = "\u4ea7\u751f\u6570\u636e\u9519\u8bef\uff1a" + this.strErrorMsg;
                return false;
            }
            switch (this.iType) {
                case 0: 
                case 1: {
                    this.objSocket = this.strProxyName != null && !"".equals(this.strProxyName) ? new Socket(this.strProxyName, this.iProxyPort) : new Socket(this.strHost, this.iPort);
                    this.input = new BufferedReader(new InputStreamReader(this.objSocket.getInputStream()));
                    this.output = new PrintStream(this.objSocket.getOutputStream());
                    break;
                }
                case 2: {
                    SSLSocket sslSocket;
                    SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    if (this.strProxyName != null && !"".equals(this.strProxyName)) {
                        this.objSocket = new Socket(this.strProxyName, this.iProxyPort);
                        this.doTunnelHandshake(this.objSocket, this.strHost, this.iPort);
                        sslSocket = (SSLSocket)factory.createSocket(this.objSocket, this.strHost, this.iPort, true);
                        sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                            public void handshakeCompleted(HandshakeCompletedEvent event) {
                                System.out.println("Handshake finished!");
                                System.out.println("\t CipherSuite:" + event.getCipherSuite());
                                System.out.println("\t SessionId " + event.getSession());
                                System.out.println("\t PeerHost " + event.getSession().getPeerHost());
                            }
                        });
                    } else {
                        sslSocket = (SSLSocket)factory.createSocket(this.strHost, this.iPort);
                    }
                    sslSocket.startHandshake();
                    this.input = new BufferedReader(new InputStreamReader(sslSocket.getInputStream()));
                    this.output = new PrintStream(sslSocket.getOutputStream());
                }
            }
            this.output.print(strSendData);
            String strReply = "";
            this.strHeader = "";
            while ((strReply = this.input.readLine()) != null && !"".equals(strReply)) {
                this.strHeader = this.strHeader + strReply + "\r\n";
            }
            String[] newCookies = this.getAllHeader("Set-Cookie");
            if (newCookies.length > 0) {
                if (this.strCookie == null || this.strCookie.trim().length() <= 0) {
                    this.strCookie = "";
                }
                for (int i = 0; i < newCookies.length; ++i) {
                    int iPos = newCookies[i].indexOf(59);
                    if (iPos <= 0) continue;
                    String strCookieData = newCookies[i].substring(0, iPos);
                    iPos = (strCookieData = strCookieData.trim()).indexOf(61);
                    if (iPos == strCookieData.length() - 1) continue;
                    if (this.strCookie.length() > 0) {
                        this.strCookie = this.strCookie + "; ";
                    }
                    this.strCookie = this.strCookie + strCookieData;
                }
            }
        }
        catch (Exception e) {
            this.strErrorMsg = this.strErrorMsg + e.getMessage();
            return false;
        }
        return true;
    }

    private boolean disconnectURL(Socket objSocket, BufferedReader input, PrintStream output) {
        try {
            input.close();
            output.flush();
            output.close();
            objSocket.close();
        }
        catch (Exception e) {
            this.strErrorMsg = this.strErrorMsg + e.getMessage();
            return false;
        }
        return true;
    }

    private String getSendData(String Action, String strURL, String strData) {
        String strSendData;
        try {
            int iPos3;
            strSendData = "";
            if (Action == null || "".equals(Action)) {
                Action = "GET";
            }
            Action = Action.toUpperCase();
            int iPos = strURL.indexOf("://");
            if (iPos <= 0) {
                this.strErrorMsg = "\u6ca1\u6709\u6307\u5b9a\u534f\u8bae\u3002";
                return strSendData;
            }
            String strProtocol = strURL.substring(0, iPos);
            this.iType = "http".equals(strProtocol) ? 1 : ("https".equals(strProtocol) ? 2 : 0);
            switch (this.iType) {
                case 1: {
                    this.iPort = 80;
                    break;
                }
                case 2: {
                    this.iPort = 443;
                    break;
                }
                default: {
                    this.strErrorMsg = "\u534f\u8bae\u4e0d\u652f\u6301" + strProtocol;
                    return strSendData;
                }
            }
            int iPos2 = strURL.indexOf(47, iPos += 3);
            if (iPos2 <= 0) {
                iPos2 = strURL.length();
            }
            if ((iPos3 = strURL.indexOf(58, iPos)) < iPos2 && iPos3 > 0) {
                this.strHost = strURL.substring(iPos, iPos3);
                strProtocol = strURL.substring(iPos3 + 1, iPos2);
                this.iPort = Integer.parseInt(strProtocol);
            } else {
                this.strHost = strURL.substring(iPos, iPos2);
            }
            String strPath = strURL.substring(iPos2);
            if (strPath == null || "".equals(strPath)) {
                strPath = "/";
            }
            this.strErrorMsg = this.strErrorMsg + "Host: " + this.strHost + ":" + this.iPort + " strPath=" + strPath + "\r\n";
            strSendData = Action.trim() + " ";
            strSendData = this.strProxyName != null && !"".equals(this.strProxyName) ? strSendData + strURL.trim() : strSendData + strPath.trim();
            if (strData != null && !"".equals(strData) && "GET".equals(Action)) {
                strSendData = strSendData + "?" + strData;
            }
            strSendData = strSendData + " HTTP/1.0\r\nAccept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\r\n";
            if (this.strReferer != null && !"".equals(this.strReferer)) {
                strSendData = strSendData + "Referer: " + this.strReferer + "\r\n";
            }
            strSendData = strSendData + "Accept-Language: zh-cn\r\n";
            strSendData = strSendData + "Content-Type: application/x-www-form-urlencoded\r\n";
            strSendData = strSendData + "Accept-Encoding: gzip, deflate\r\n";
            if (this.strUserAgent != null && !"".equals(this.strUserAgent)) {
                strSendData = strSendData + "User-Agent: " + this.strUserAgent + "\r\n";
            }
            strSendData = strSendData + "Host: " + this.strHost;
            if (this.iPort != 80) {
                strSendData = strSendData + ":" + String.valueOf(this.iPort);
            }
            strSendData = strSendData + "\r\n";
            if (strData != null && !"".equals(strData) && "POST".equals(Action)) {
                strSendData = strSendData + "Content-Length: " + strData.length() + "\r\n";
            }
            if (this.strProxyName != null && !"".equals(this.strProxyName)) {
                strSendData = strSendData + "Proxy-Connection: Keep-Alive\r\n";
                strSendData = strSendData + "Pragma: No-Cache\r\n";
            }
            if (this.strCookie != null && !"".equals(this.strCookie)) {
                strSendData = strSendData + "Cookie: " + this.strCookie + "\r\n";
            }
            strSendData = strSendData + "\r\n";
            if (strData != null && !"".equals(strData) && "POST".equals(Action)) {
                strSendData = strSendData + strData;
            }
            strSendData = strSendData + "\r\n";
        }
        catch (Exception e) {
            this.strErrorMsg = this.strErrorMsg + e.getMessage();
            strSendData = "";
        }
        return strSendData;
    }

    public String getHeader(String strHeaderName) {
        int iPos2;
        String strResult = "";
        int iPos = this.strHeader.indexOf(strHeaderName);
        if (iPos >= 0 && (iPos2 = this.strHeader.indexOf("\r\n", iPos += strHeaderName.length() + 2)) > 0) {
            strResult = this.strHeader.substring(iPos, iPos2);
        }
        return strResult;
    }

    public String[] getAllHeader(String strHeaderName) {
        LinkedList<String> listResult = new LinkedList<String>();
        int iPos1 = 0;
        int iNameLen = strHeaderName.length() + 2;
        strHeaderName = strHeaderName + ":";
        while (iPos1 >= 0) {
            if ((iPos1 = this.strHeader.indexOf(strHeaderName, iPos1)) < 0) continue;
            int iPos2 = this.strHeader.indexOf("\r\n", iPos1 += iNameLen);
            if (iPos2 <= 0) break;
            listResult.add(this.strHeader.substring(iPos1, iPos2).trim());
            iPos1 = iPos2 + 2;
        }
        if (listResult.size() <= 0) {
            return new String[0];
        }
        String[] Result = new String[listResult.size()];
        for (int i = 0; i < Result.length; ++i) {
            Result[i] = (String)listResult.get(i);
        }
        return Result;
    }

    private String getNextLocation(String strURL, String strLocation) {
        String strResult;
        if (strLocation == null || strLocation.length() <= 0) {
            strResult = "";
        } else {
            String strNewURL = strLocation.trim();
            if (strNewURL.length() <= 0) {
                return "";
            }
            String strPro = strNewURL.substring(0, 8);
            if ((strPro = strPro.toLowerCase()).equals("https://")) {
                this.iType = 2;
                if (this.strFirstLocation == null) {
                    this.strFirstLocation = strNewURL;
                }
                this.strLastLocation = strNewURL;
                return strNewURL;
            }
            strPro = strPro.substring(0, 7);
            if ((strPro = strPro.toLowerCase()).equals("http://")) {
                this.iType = 1;
                if (this.strFirstLocation == null) {
                    this.strFirstLocation = strNewURL;
                }
                this.strLastLocation = strNewURL;
                return strNewURL;
            }
            switch (this.iType) {
                case 0: 
                case 1: {
                    strResult = "http://";
                    break;
                }
                case 2: {
                    strResult = "https://";
                    break;
                }
                default: {
                    strResult = "http://";
                }
            }
            strResult = strResult + this.strHost + ":" + this.iPort;
            if (strNewURL.charAt(0) == '/') {
                strResult = strResult + strNewURL;
            } else {
                int iPos = strURL.lastIndexOf(47);
                if (iPos > 0) {
                    int iPos2 = strURL.lastIndexOf(47, iPos - 1);
                    if (iPos2 >= 0) {
                        strResult = strResult + strURL.indexOf(iPos2, iPos + 1) + strNewURL;
                    }
                    strResult = strResult + "/" + strNewURL;
                } else {
                    strResult = strResult + "/" + strNewURL;
                }
            }
        }
        if (this.strFirstLocation == null) {
            this.strFirstLocation = strResult;
        }
        this.strLastLocation = strResult;
        return strResult;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\nUser-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through .  Proxy returns \"" + replyStr + "\"");
        }
    }
}

