/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.BrowserInfo;
import com.hynnet.util.FileOperation;
import com.hynnet.util.ParamUtils;
import com.hynnet.util.StringUtils;
import com.hynnet.util.Util;
import com.oreilly.servlet.ServletUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralHttpServletResponse
extends HttpServletResponseWrapper {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.GeneralHttpServletResponse");
    private boolean m_fixIISGZip;
    private String m_urlPrefix;
    private boolean m_allowSendData;
    private boolean m_isGotOutputStream;
    private boolean m_isGotWriter;

    public GeneralHttpServletResponse(HttpServletResponse response, boolean fixIISGZip, String urlPrefix, boolean allowSendData) {
        super(response);
        this.m_fixIISGZip = fixIISGZip;
        this.m_urlPrefix = urlPrefix;
        this.m_allowSendData = allowSendData;
    }

    public void close() {
        try {
            if (this.m_isGotOutputStream) {
                super.getOutputStream().close();
            }
            if (this.m_isGotWriter) {
                super.getWriter().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (!this.m_allowSendData) {
            RuntimeException e = new RuntimeException("\u4e0d\u5141\u8bb8\u8c03\u7528response\u7684getOutputStream()\uff0c\u53d1\u9001\u6587\u4ef6\u6570\u636e\u8bf7\u4f7f\u7528sendFile()\u65b9\u6cd5");
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        this.m_isGotOutputStream = true;
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (!this.m_allowSendData) {
            RuntimeException e = new RuntimeException("\u4e0d\u5141\u8bb8\u8c03\u7528response\u7684getWriter()\uff0c\u53d1\u9001\u6587\u4ef6\u6570\u636e\u8bf7\u4f7f\u7528sendFile()\u65b9\u6cd5");
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        this.m_isGotWriter = true;
        return super.getWriter();
    }

    private static final String encodingFileName(HttpServletRequest objRequest, String strFileName) {
        String strReturnFileName;
        block2: {
            strReturnFileName = null;
            try {
                String[] NAME_FIND = new String[]{"+", " "};
                String[] NAME_REPLACE = new String[]{"%20", "%20"};
                BrowserInfo objBrowser = new BrowserInfo(objRequest);
                BrowserInfo.BROWSER_TYPE nType = objBrowser.getType();
                strReturnFileName = nType == BrowserInfo.BROWSER_TYPE.TYPE_SAFARI || nType == BrowserInfo.BROWSER_TYPE.TYPE_FIREFOX ? StringUtils.replace(new String(strFileName.getBytes("GB2312"), "ISO8859-1"), NAME_FIND, NAME_REPLACE) : StringUtils.replace(URLEncoder.encode(strFileName, "UTF-8"), NAME_FIND, NAME_REPLACE);
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u7f16\u7801\u4e0d\u652f\u6301\u3002", (Throwable)e);
                if (!log.isInfoEnabled()) break block2;
                log.info("\u7f16\u7801\u4e0d\u652f\u6301\uff1a" + e);
            }
        }
        return strReturnFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendFile(InputStream objDataFileStream, String strDataFile, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage, boolean bAutoDelete, boolean bCheckLink) {
        bResult = false;
        strErrorMsg = null;
        this.setHeader("pragma", "max-age=10");
        this.setHeader("Cache-Control", "max-age=10");
        bShow = objRequest == null ? false : ParamUtils.getBooleanParameter(objRequest, "show", false);
        try {
            block70: {
                block69: {
                    strFileExt = null;
                    if (strDataFile == null || (strDataFile = strDataFile.trim()).length() == 0) break block69;
                    strModifiedSince = objRequest != null ? objRequest.getHeader("If-Modified-Since") : null;
                    objFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                    objFile = new File(strDataFile);
                    if (objFile.exists() == false) throw new ServletException("\u6307\u5b9a\u9644\u4ef6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u53d1\u5e03\u4eba\u91cd\u65b0\u53d1\u9001\uff01");
                    objFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
                    strModified = objFormater.format(new Date(objFile.lastModified()));
                    if (strModifiedSince == null || strModifiedSince.length() <= 0 || !strModifiedSince.equals(strModified)) ** GOTO lbl22
                    try {
                        this.sendError(304);
                        var19_32 = true;
                        return var19_32;
                    }
                    catch (IOException e) {
                        GeneralHttpServletResponse.log.error("\u8bbe\u7f6e\u4e0a\u6b21\u4fee\u6539\u65f6\u95f4\u65f6\u5f02\u5e38\u3002", (Throwable)e);
lbl22:
                        // 2 sources

                        this.setHeader("Last-Modified", strModified);
                        strDataFile = objFile.getAbsolutePath();
                        if (strContentType != null && strContentType.length() > 0) ** GOTO lbl31
                        strFileExt = FileOperation.getFileExtFromStr(strDataFile);
                        strContentType = Util.getContentType(strFileExt);
                    }
                    break block70;
                }
                if (objDataFileStream == null) return false;
                strDataFile = null;
            }
            if (bCheckLink && objRequest != null) {
                strReferer = objRequest.getHeader("Referer");
                if (strReferer != null && strReferer.length() > 0) {
                    strHost = objRequest.getServerName();
                    nIndex = strReferer.indexOf("://");
                    if (nIndex > 0) {
                        nSlash = strReferer.indexOf(47, nIndex + 3);
                        if (nSlash < 0) {
                            nSlash = strReferer.length();
                        }
                        if ((nSlash = (strReferer = strReferer.substring(nIndex + 3, nSlash)).indexOf(58)) > 0) {
                            strReferer = strReferer.substring(0, nSlash);
                        }
                        if (!strReferer.equalsIgnoreCase(strHost)) {
                            if (strErrorPage == null) throw new ServletException("\u8bf7\u8fdb\u5165\u7cfb\u7edf\u540e\u518d\u4e0b\u8f7d\u3002");
                            if (strErrorPage.length() <= 0) {
                                throw new ServletException("\u8bf7\u8fdb\u5165\u7cfb\u7edf\u540e\u518d\u4e0b\u8f7d\u3002");
                            }
                            try {
                                this.sendRedirect(strErrorPage);
                            }
                            catch (Exception var19_34) {
                                // empty catch block
                            }
                            var19_36 = false;
                            return var19_36;
                        }
                    }
                } else {
                    bError = true;
                    if (strReferer == null && (strReferer = objRequest.getHeader("Cookie")) != null && strReferer.indexOf("JSESSIONID=") >= 0) {
                        bError = false;
                    }
                    if (bError) {
                        if (strErrorPage == null) throw new ServletException("\u8bf7\u8fdb\u5165\u7cfb\u7edf\u540e\u518d\u4e0b\u8f7d\u3002");
                        if (strErrorPage.length() <= 0) {
                            throw new ServletException("\u8bf7\u8fdb\u5165\u7cfb\u7edf\u540e\u518d\u4e0b\u8f7d\u3002");
                        }
                        try {
                            this.sendRedirect(strErrorPage);
                        }
                        catch (Exception nIndex) {
                            // empty catch block
                        }
                        nIndex = false;
                        return nIndex;
                    }
                }
            }
            if (strShowFileName != null) {
                strFileName = strShowFileName;
            } else {
                v0 = strFileName = strDataFile != null ? strDataFile.substring(strDataFile.lastIndexOf(File.separatorChar) + 1) : "";
            }
            if (strFileExt == null || strFileExt.length() == 0) {
                strFileExt = FileOperation.getFileExtFromStr(strFileName);
            }
            if (!(strContentType != null && strContentType.length() != 0 || (strContentType = Util.getContentType(strFileExt)) != null && strContentType.length() != 0)) {
                strContentType = "application/x-msdownload";
            }
            if (this.m_fixIISGZip && "zip".equalsIgnoreCase(strFileExt)) {
                nPrefixPort = 80;
                nIndex = this.m_urlPrefix.indexOf("://");
                if (nIndex > 0 && (nIndex = this.m_urlPrefix.indexOf(58, nIndex + 3)) > 0) {
                    nIndexEnd = this.m_urlPrefix.indexOf(47, nIndex);
                    if (nIndexEnd < 0) {
                        nIndexEnd = this.m_urlPrefix.length();
                    }
                    try {
                        nPrefixPort = Integer.parseInt(this.m_urlPrefix.substring(nIndex + 1, nIndexEnd));
                    }
                    catch (Exception var18_21) {
                        // empty catch block
                    }
                }
                if (objRequest != null && (nServerPort = objRequest.getServerPort()) != nPrefixPort && nServerPort != 80 && nServerPort != 443) {
                    strFileName = strFileName + ".gz";
                }
            }
            this.setContentType(strContentType);
            if (strFileName.length() > 0 && !bShow) {
                this.setHeader("Content-Disposition", "attachment; filename=" + GeneralHttpServletResponse.encodingFileName(objRequest, strFileName));
            }
            objOut = super.getOutputStream();
            if (strDataFile != null) {
                ServletUtils.returnFile((String)strDataFile, (OutputStream)objOut);
                objOut.flush();
            } else {
                arrayData = new byte[1024];
                while ((nRead = objDataFileStream.read(arrayData)) != -1) {
                    objOut.write(arrayData, 0, nRead);
                    objOut.flush();
                }
                objDataFileStream.close();
            }
            this.flushBuffer();
            objOut.close();
            if (bAutoDelete && strDataFile != null) {
                new FileOperation().delete(strDataFile);
            }
            bResult = true;
            return bResult;
        }
        catch (FileNotFoundException eFileNotFound) {
            GeneralHttpServletResponse.log.warn("\u65e0\u6cd5\u4e0b\u8f7d\u9644\u4ef6\uff1a" + eFileNotFound);
            strErrorMsg = "\u6307\u5b9a\u9644\u4ef6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u53d1\u5e03\u4eba\u91cd\u65b0\u53d1\u9001\uff01";
            return bResult;
        }
        catch (IOException eIO) {
            strErrorMsg = "\u4e0b\u8f7d\u5df2\u88ab\u4e2d\u65ad\uff01" + eIO.getMessage();
            return bResult;
        }
        catch (ServletException e) {
            strErrorMsg = e.getMessage();
            return bResult;
        }
        catch (Exception e) {
            strErrorMsg = "\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\uff01" + e.getMessage();
            return bResult;
        }
        finally {
            try {
                if (!bResult) {
                    if (objRequest != null && strErrorMsg != null) {
                        objRequest.setAttribute("msg", (Object)strErrorMsg);
                    }
                    if (strErrorPage == null) throw new ServletException(strErrorMsg);
                    if (strErrorPage.length() <= 0) throw new ServletException(strErrorMsg);
                    this.sendRedirect(strErrorPage);
                }
            }
            catch (Exception eFileNotFound) {}
        }
    }

    public boolean sendFile(InputStream objDataFileStream) {
        return this.sendFile(objDataFileStream, null, null, null, null, null, false, true);
    }

    public boolean sendFile(InputStream objDataFileStream, HttpServletRequest objRequest, String strShowFileName) {
        return this.sendFile(objDataFileStream, null, objRequest, strShowFileName, null, null, false, true);
    }

    public boolean sendFile(InputStream objDataFileStream, HttpServletRequest objRequest, String strShowFileName, String strContentType) {
        return this.sendFile(objDataFileStream, null, objRequest, strShowFileName, strContentType, null, false, true);
    }

    public boolean sendFile(InputStream objDataFileStream, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage) {
        return this.sendFile(objDataFileStream, null, objRequest, strShowFileName, strContentType, strErrorPage, false, true);
    }

    public boolean sendFile(InputStream objDataFileStream, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage, boolean bCheckLink) {
        return this.sendFile(objDataFileStream, null, objRequest, strShowFileName, strContentType, strErrorPage, false, bCheckLink);
    }

    public boolean sendFile(String strDataFile) {
        return this.sendFile(null, strDataFile, null, null, null, null, false, true);
    }

    public boolean sendFile(String strDataFileName, HttpServletRequest objRequest, String strShowFileName) {
        return this.sendFile(null, strDataFileName, objRequest, strShowFileName, null, null, false, true);
    }

    public boolean sendFile(String strDataFileName, HttpServletRequest objRequest, String strShowFileName, String strContentType) {
        return this.sendFile(null, strDataFileName, objRequest, strShowFileName, strContentType, null, false, true);
    }

    public boolean sendFile(String strDataFileName, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage) {
        return this.sendFile(null, strDataFileName, objRequest, strShowFileName, strContentType, strErrorPage, false, true);
    }

    public boolean sendFile(String strDataFileName, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage, boolean bAutoDelete) {
        return this.sendFile(null, strDataFileName, objRequest, strShowFileName, strContentType, strErrorPage, bAutoDelete, true);
    }

    public boolean sendFile(String strDataFileName, HttpServletRequest objRequest, String strShowFileName, String strContentType, String strErrorPage, boolean bAutoDelete, boolean bCheckLink) {
        return this.sendFile(null, strDataFileName, objRequest, strShowFileName, strContentType, strErrorPage, bAutoDelete, bCheckLink);
    }
}

