/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.GeneralHttpParameters;
import com.hynnet.util.MultipartHttpServletRequest;
import com.hynnet.util.PropertyManager;
import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import com.oreilly.servlet.MultipartRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralHttpServletRequest
extends MultipartHttpServletRequest {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.GeneralHttpServletRequest");
    private Hashtable<String, String> m_parameters;
    ServletContext m_application;
    private char m_cSplit;
    private static String g_characterEncoding = "UTF-8";
    private GeneralHttpParameters m_postParameter;

    public GeneralHttpServletRequest(MultipartRequest multiRequest, HttpServletRequest request, ServletContext application) {
        block4: {
            super(multiRequest, request);
            this.m_parameters = null;
            this.m_cSplit = (char)58;
            this.m_application = application;
            if (multiRequest == null && request != null) {
                try {
                    if (request.getContentLength() > 0) {
                        this.m_postParameter = new GeneralHttpParameters(request);
                    }
                }
                catch (NoSuchMethodError e) {
                    if (request.getContentLengthLong() <= 0L) break block4;
                    this.m_postParameter = new GeneralHttpParameters(request);
                }
            }
        }
    }

    public final ServletContext getApplication() {
        return this.m_application;
    }

    private final boolean adjustInputCharset() {
        String strUserAgent = this.getHeader("User-Agent");
        if (strUserAgent != null && strUserAgent.toLowerCase().indexOf("msie") < 0) {
            try {
                if (!g_characterEncoding.equalsIgnoreCase(this.getCharacterEncoding())) {
                    this.setCharacterEncoding(g_characterEncoding);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u6574Firefox\u8bf7\u6c42\u65f6\u7684\u7f16\u7801\u5f02\u5e38\u3002");
            }
        }
        return false;
    }

    private static boolean setCharSet() {
        PropertyManager objPropManager = new PropertyManager("/com/hynnet/setting.properties");
        String strCharset = objPropManager.getProperty("InputCharSet");
        if (strCharset == null || strCharset.length() == 0) {
            strCharset = objPropManager.getProperty("InputCharset");
        }
        if (strCharset == null || strCharset.length() == 0) {
            return false;
        }
        g_characterEncoding = strCharset.trim().toUpperCase();
        log.debug("inputCharset=" + g_characterEncoding);
        return true;
    }

    public final boolean getAttributeBoolean(String name) {
        return this.getAttributeBoolean(name, false);
    }

    public final boolean getAttributeBoolean(String name, boolean defValue) {
        Object objAttr = this.getAttribute(name);
        if (objAttr instanceof String) {
            if ("true".equals(objAttr) || "on".equals(objAttr) || "1".equals(objAttr)) {
                return true;
            }
            if ("false".equals(objAttr) || "off".equals(objAttr) || "0".equals(objAttr)) {
                return false;
            }
        } else {
            if (objAttr instanceof Boolean) {
                return (Boolean)objAttr;
            }
            if (objAttr instanceof boolean[]) {
                if (((boolean[])objAttr).length > 0) {
                    return ((boolean[])objAttr)[0];
                }
            } else if (objAttr instanceof Boolean[]) {
                if (((Boolean[])objAttr).length > 0) {
                    return ((Boolean[])objAttr)[0];
                }
            } else if (objAttr instanceof Integer) {
                if ((Integer)objAttr == 1) {
                    return true;
                }
                if ((Integer)objAttr == 0) {
                    return false;
                }
            } else if (objAttr instanceof Long) {
                if ((Integer)objAttr == 1) {
                    return true;
                }
                if ((Integer)objAttr == 0) {
                    return false;
                }
            } else if (objAttr != null) {
                log.error("\u5c5e\u6027 " + name + " \u7684\u7c7b\u578b\u4e0d\u6b63\u786e" + name);
            }
        }
        return defValue;
    }

    public final boolean[] getAttributesBoolean(String name, boolean defaultVal) {
        Object objAttr = this.getAttribute(name);
        if (objAttr == null) {
            return null;
        }
        if (objAttr instanceof String[]) {
            if (((String[])objAttr).length < 1) {
                return new boolean[0];
            }
            boolean[] arrayValues = new boolean[((String[])objAttr).length];
            for (int i = 0; i < arrayValues.length; ++i) {
                try {
                    arrayValues[i] = Boolean.getBoolean(((String[])objAttr)[i]);
                    continue;
                }
                catch (Exception e) {
                    arrayValues[i] = defaultVal;
                }
            }
            return arrayValues;
        }
        if (objAttr instanceof boolean[]) {
            return (boolean[])objAttr;
        }
        if (objAttr instanceof Boolean[]) {
            boolean[] arrayValues = new boolean[((Boolean[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Boolean[])objAttr)[n];
            }
            return arrayValues;
        }
        if (objAttr instanceof Boolean) {
            boolean[] arrayValues = new boolean[]{(Boolean)objAttr};
            return arrayValues;
        }
        if (objAttr instanceof Integer[]) {
            boolean[] arrayValues = new boolean[((Integer[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Integer[])objAttr)[n] != 0;
            }
            return arrayValues;
        }
        if (objAttr instanceof Long[]) {
            boolean[] arrayValues = new boolean[((Long[])objAttr).length];
            for (int n = 0; n < arrayValues.length; ++n) {
                arrayValues[n] = ((Long[])objAttr)[n].intValue() != 0;
            }
            return arrayValues;
        }
        boolean[] arrayValues = new boolean[1];
        log.error("\u719f\u6089 " + name + " \u7684\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a" + objAttr);
        arrayValues[0] = defaultVal;
        return arrayValues;
    }

    public final boolean getParameterBoolean(String name) {
        return this.getParameterBoolean(name, true);
    }

    public final boolean getParameterBoolean(String name, boolean defaultVal) {
        String temp = this.getParameter(name);
        if ("true".equals(temp) || "on".equals(temp) || "1".equals(temp)) {
            return true;
        }
        if ("false".equals(temp) || "off".equals(temp) || "0".equals(temp)) {
            return false;
        }
        return defaultVal;
    }

    public final boolean[] getParameterValuesBoolean(String name, boolean defaultVal) {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultVal;
            }
        }
        return values;
    }

    public final boolean getSessionAttributeBoolean(String name) {
        String strValue = this.getSessionAttribute(name);
        if ("true".equals(strValue) || "on".equals(strValue) || "1".equals(strValue)) {
            return true;
        }
        if ("false".equals(strValue) || "off".equals(strValue) || "0".equals(strValue)) {
            return false;
        }
        return false;
    }

    public final boolean[] getSessionAttributesBoolean(String name, boolean defaultVal) {
        HttpSession objSession = this.getSession(false);
        if (objSession == null) {
            return null;
        }
        Object objAttr = objSession.getAttribute(name);
        if (objAttr instanceof boolean[]) {
            return (boolean[])objAttr;
        }
        String[] arrayValues = this.getSessionAttributes(name, false);
        if (arrayValues == null) {
            return null;
        }
        if (arrayValues.length < 1) {
            return new boolean[0];
        }
        boolean[] arrayResult = new boolean[arrayValues.length];
        for (int i = 0; i < arrayValues.length; ++i) {
            try {
                arrayResult[i] = Boolean.getBoolean(arrayValues[i]);
                continue;
            }
            catch (Exception e) {
                arrayResult[i] = defaultVal;
            }
        }
        return arrayResult;
    }

    public final double getAttributeDouble(String name, double defaultVal) {
        Object objAttr = this.getAttribute(name);
        if (objAttr instanceof double[]) {
            double[] arrayResult = (double[])objAttr;
            if (arrayResult.length > 0) {
                return arrayResult[0];
            }
            return defaultVal;
        }
        if (objAttr instanceof Double[]) {
            Double[] arrayData = (Double[])objAttr;
            double[] arrayResult = new double[arrayData.length];
            for (int n = 0; n < arrayData.length; ++n) {
                arrayResult[n] = arrayData[n] != null ? arrayData[n] : defaultVal;
            }
            if (arrayResult.length > 0) {
                return arrayResult[0];
            }
            return defaultVal;
        }
        if (objAttr instanceof String[]) {
            String[] arrayVal = (String[])objAttr;
            if (arrayVal.length > 0) {
                return Double.parseDouble(arrayVal[0]);
            }
            return defaultVal;
        }
        String strVal = (String)this.getAttribute(name);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = defaultVal;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dbVal;
        }
        return defaultVal;
    }

    public final double[] getAttributesDouble(String name, double defaultVal) {
        Object objAttr = this.getAttribute(name);
        if (objAttr instanceof double[]) {
            return (double[])objAttr;
        }
        if (objAttr instanceof Double[]) {
            Double[] arrayData = (Double[])objAttr;
            double[] arrayResult = new double[arrayData.length];
            for (int n = 0; n < arrayData.length; ++n) {
                arrayResult[n] = arrayData[n] != null ? arrayData[n] : defaultVal;
            }
            return arrayResult;
        }
        if (objAttr instanceof String[]) {
            String[] arrayVal = (String[])objAttr;
            double[] arrayResult = new double[arrayVal.length];
            for (int n = 0; n < arrayVal.length; ++n) {
                arrayResult[n] = arrayVal[n] != null ? Double.parseDouble(arrayVal[0]) : defaultVal;
            }
            return arrayResult;
        }
        String strVal = (String)this.getAttribute(name);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = defaultVal;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new double[]{dbVal};
        }
        return new double[]{defaultVal};
    }

    public final double getParameterDouble(String name, double dbDefault) {
        String strVal = this.getParameter(name);
        if (strVal != null && !strVal.equals("")) {
            double dbVal = dbDefault;
            try {
                dbVal = Double.parseDouble(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dbVal;
        }
        return dbDefault;
    }

    public final double[] getParameterValuesDouble(String name, double defaultNum) {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final float getParameterFloat(String name, float defaultNum) {
        String temp = this.getParameter(name);
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final float[] getParameterValuesFloat(String name, float defaultNum) {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new float[0];
        }
        float[] values = new float[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Float.parseFloat(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final int getAttributeInt(String name, int defaultNum) {
        Object objAttr = this.getAttribute(name);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                try {
                    if (((String)objAttr).length() > 0) {
                        return Integer.parseInt((String)objAttr);
                    }
                }
                catch (Exception exception) {}
            } else {
                if (objAttr instanceof Integer) {
                    return (Integer)objAttr;
                }
                if (objAttr instanceof Long) {
                    return ((Long)objAttr).intValue();
                }
                if (objAttr instanceof int[]) {
                    if (((int[])objAttr).length > 0) {
                        return ((int[])objAttr)[0];
                    }
                } else if (objAttr instanceof long[] && ((long[])objAttr).length > 0) {
                    return (int)((long[])objAttr)[0];
                }
            }
        }
        return defaultNum;
    }

    public final int getParameterInt(String name, int defaultNum) {
        String strVal = this.getParameter(name);
        if (strVal != null && !strVal.equals("")) {
            try {
                return Integer.parseInt(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultNum;
    }

    public final int getParameterInt(String name, int defaultVal, String radix) {
        String strVal = this.getParameter(name);
        return StringUtils.strToNumber(strVal, defaultVal, radix);
    }

    public final int[] getParameterValuesInt(String name, int defaultNum) {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final int getSessionAttributeInt(String name, int defaultNum) {
        String strValue = this.getSessionAttribute(name);
        if (strValue != null && strValue.length() > 0) {
            int nNum = defaultNum;
            try {
                nNum = Integer.parseInt(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return nNum;
        }
        return defaultNum;
    }

    public final long getAttributeLong(String name, long defaultNum) {
        Object objAttr = this.getAttribute(name);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                long lNum = defaultNum;
                try {
                    if (((String)objAttr).length() > 0) {
                        lNum = Long.parseLong((String)objAttr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return lNum;
            }
            if (objAttr instanceof Integer) {
                return ((Integer)objAttr).longValue();
            }
            if (objAttr instanceof Long) {
                return (Long)objAttr;
            }
            if (objAttr instanceof int[]) {
                if (((int[])objAttr).length > 0) {
                    return ((int[])objAttr)[0];
                }
            } else if (objAttr instanceof long[] && ((long[])objAttr).length > 0) {
                return ((long[])objAttr)[0];
            }
        }
        return defaultNum;
    }

    public final long[] getAttributesLong(String name, boolean isEmptyOK) {
        String[] arrayParamValue = this.getAttributesString(name);
        if (arrayParamValue != null && arrayParamValue.length >= 1) {
            int i;
            int nSize = arrayParamValue.length;
            long[] arrayValue = new long[nSize];
            int j = 0;
            for (i = 0; i < arrayParamValue.length; ++i) {
                try {
                    arrayValue[j] = Long.parseLong(arrayParamValue[i]);
                    ++j;
                    continue;
                }
                catch (Exception e) {
                    --nSize;
                }
            }
            if (nSize < arrayValue.length) {
                if (nSize <= 0) {
                    if (isEmptyOK) {
                        return new long[0];
                    }
                    return null;
                }
                long[] result = new long[nSize];
                for (i = 0; i < nSize; ++i) {
                    result[i] = arrayValue[i];
                }
                return result;
            }
            return arrayValue;
        }
        if (isEmptyOK) {
            return new long[0];
        }
        return null;
    }

    public final long getParameterLong(String name, long defaultNum) {
        String strVal = this.getParameter(name);
        if (strVal != null && !strVal.equals("")) {
            try {
                return Long.parseLong(strVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultNum;
    }

    public final long getParameterLong(String name, long defaultNum, String radix) {
        String strVal = this.getParameter(name);
        return StringUtils.strToNumber(strVal, defaultNum, radix);
    }

    public final long[] getParameterValuesLong(String name, boolean isEmptyOK) {
        return this.getLongValues(this.getParameterValues(name), isEmptyOK);
    }

    public final long[] getParameterValuesLong(String name, long defaultNum) {
        String[] paramValues = this.getParameterValues(name);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final long getSessionAttributeLong(String name, long defaultNum) {
        String strValue = this.getSessionAttribute(name);
        if (strValue != null && !strValue.equals("")) {
            long num = defaultNum;
            try {
                num = Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final long[] getSessionAttributesLong(String name, boolean isEmptyOK) {
        return this.getLongValues(this.getSessionAttributes(name), isEmptyOK);
    }

    private final long[] getLongValues(String[] longValues, boolean isEmptyOK) {
        if (longValues != null && longValues.length >= 1) {
            int n;
            int nSize = longValues.length;
            long[] arrayValue = new long[nSize];
            int i = 0;
            for (n = 0; n < longValues.length; ++n) {
                try {
                    arrayValue[i] = Long.parseLong(longValues[n]);
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    --nSize;
                }
            }
            if (nSize < arrayValue.length) {
                if (nSize <= 0) {
                    if (isEmptyOK) {
                        return new long[0];
                    }
                    return null;
                }
                long[] arrayResult = new long[nSize];
                for (n = 0; n < nSize; ++n) {
                    arrayResult[n] = arrayValue[n];
                }
                return arrayResult;
            }
            return arrayValue;
        }
        if (isEmptyOK) {
            return new long[0];
        }
        return null;
    }

    public final String getPostData() {
        return this.m_postParameter != null ? this.m_postParameter.getPostData("UTF-8") : null;
    }

    public final String getPostData(String charset) {
        return this.m_postParameter != null ? this.m_postParameter.getPostData(charset) : null;
    }

    public final byte[] getPostDataBytes() {
        return this.m_postParameter != null ? this.m_postParameter.getPostDataBytes() : null;
    }

    public final String getSessionAttribute(String name) {
        return this.getSessionAttribute(name, true);
    }

    public final String getSessionAttribute(String name, boolean isEmptyStringsOK) {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return isEmptyStringsOK ? "" : null;
        }
        Object attr = session.getAttribute(name);
        if (attr != null) {
            if (attr instanceof String) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                return (String)attr;
            }
            if (attr instanceof int[]) {
                int[] values = (int[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n]);
                }
                return value.toString();
            }
            if (attr instanceof long[]) {
                long[] values = (long[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n]);
                }
                return value.toString();
            }
            if (attr instanceof boolean[]) {
                boolean[] values = (boolean[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n]);
                }
                return value.toString();
            }
            if (attr instanceof Integer[]) {
                Integer[] values = (Integer[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n].toString());
                }
                return value.toString();
            }
            if (attr instanceof Long[]) {
                Long[] values = (Long[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n].toString());
                }
                return value.toString();
            }
            if (attr instanceof Boolean[]) {
                Boolean[] values = (Boolean[])attr;
                StringBuffer value = new StringBuffer();
                for (int n = 0; n < values.length; ++n) {
                    if (n > 0) {
                        value.append(',');
                    }
                    value.append(values[n].toString());
                }
                return value.toString();
            }
            if (attr instanceof Integer) {
                Integer value = (Integer)attr;
                return value.toString();
            }
            if (attr instanceof Long) {
                Long value = (Long)attr;
                return value.toString();
            }
            if (attr instanceof Boolean) {
                Boolean value = (Boolean)attr;
                return value.toString();
            }
            log.error("Session\u7684" + name + "\u5c5e\u6027\u7c7b\u578b\u4e0d\u6b63\u786e" + attr);
            return attr.toString();
        }
        if (isEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getSessionAttributes(String name) {
        return this.getSessionAttributes(name, true);
    }

    public final String[] getSessionAttributes(String name, boolean isEmptyStringsOK) {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return isEmptyStringsOK ? new String[]{} : null;
        }
        Object attr = session.getAttribute(name);
        if (attr != null) {
            if (attr instanceof String[]) {
                if (((String[])attr).length <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                return (String[])attr;
            }
            if (attr instanceof String) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                String[] values = new String[]{(String)attr};
                return values;
            }
            if (attr instanceof Integer) {
                String[] values = new String[]{((Integer)attr).toString()};
                return values;
            }
            if (attr instanceof Long) {
                String[] values = new String[]{((Long)attr).toString()};
                return values;
            }
            if (attr instanceof Boolean) {
                String[] values = new String[]{((Boolean)attr).toString()};
                return values;
            }
            if (attr instanceof int[]) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                String[] values = new String[((int[])attr).length];
                for (int n = 0; n < values.length; ++n) {
                    values[n] = String.valueOf(((int[])attr)[n]);
                }
                return values;
            }
            if (attr instanceof long[]) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                String[] values = new String[((long[])attr).length];
                for (int n = 0; n < values.length; ++n) {
                    values[n] = String.valueOf(((long[])attr)[n]);
                }
                return values;
            }
            if (attr instanceof boolean[]) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                String[] values = new String[((boolean[])attr).length];
                for (int n = 0; n < values.length; ++n) {
                    values[n] = String.valueOf(((boolean[])attr)[n]);
                }
                return values;
            }
            if (attr instanceof Integer[]) {
                if (((String)attr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                String[] values = new String[((Integer[])attr).length];
                for (int n = 0; n < values.length; ++n) {
                    values[n] = String.valueOf(((Integer[])attr)[n]);
                }
                return values;
            }
        }
        if (isEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public void removeSessionAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public void setSessionAttribute(String name, Object value) {
        HttpSession session = this.getSession(true);
        if (session != null) {
            session.setAttribute(name, value);
        }
    }

    public final boolean getParameterEndsWithBoolean(String nameEndWith) {
        return this.getParameterEndsWithBoolean(nameEndWith, true);
    }

    public final boolean getParameterEndsWithBoolean(String nameEndWith, boolean defaultVal) {
        String temp = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if ("true".equals(temp) || "on".equals(temp) || "1".equals(temp)) {
            return true;
        }
        if ("false".equals(temp) || "off".equals(temp) || "0".equals(temp)) {
            return false;
        }
        return defaultVal;
    }

    public final boolean[] getParametersEndsWithBoolean(String nameEndWith, boolean defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new boolean[0];
        }
        boolean[] values = new boolean[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Boolean.getBoolean(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final double getParameterEndsWithDouble(String nameEndWith, double defaultNum) {
        String temp = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (temp != null && !temp.equals("")) {
            double num = defaultNum;
            try {
                num = Double.parseDouble(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final double[] getParametersEndsWithDouble(String nameEndWith, double defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new double[0];
        }
        double[] values = new double[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Double.parseDouble(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final float getParameterEndsWithFloat(String nameEndWith, float defaultNum) {
        String temp = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (temp != null && !temp.equals("")) {
            float num = defaultNum;
            try {
                num = Float.parseFloat(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final float[] getParametersEndsWithFloat(String nameEndWith, float defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new float[0];
        }
        float[] values = new float[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Float.parseFloat(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final int getParameterEndsWithInt(String nameEndWith, int defaultNum) {
        String temp = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (temp != null && !temp.equals("")) {
            int num = defaultNum;
            try {
                num = Integer.parseInt(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return num;
        }
        return defaultNum;
    }

    public final int[] getParametersEndsWithInt(String nameEndWith, int defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new int[0];
        }
        int[] values = new int[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Integer.parseInt(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public final long getParameterEndsWithLong(String nameEndWith, long defaultNum) {
        String strValue = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (strValue != null && !strValue.equals("")) {
            long lNumber = defaultNum;
            try {
                lNumber = Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lNumber;
        }
        return defaultNum;
    }

    public final long[] getParametersEndsWithLong(String nameEndWith, boolean emptyOK) {
        int i;
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        if (paramValues.length < 1) {
            if (emptyOK) {
                return new long[0];
            }
            return null;
        }
        int size = paramValues.length;
        long[] values = new long[size];
        int j = 0;
        for (i = 0; i < paramValues.length; ++i) {
            try {
                values[j] = Long.parseLong(paramValues[i]);
                ++j;
                continue;
            }
            catch (Exception e) {
                --size;
            }
        }
        if (size < values.length) {
            if (size <= 0) {
                if (emptyOK) {
                    return new long[0];
                }
                return null;
            }
            long[] result = new long[size];
            for (i = 0; i < size; ++i) {
                result[i] = values[i];
            }
            return result;
        }
        return values;
    }

    public final long[] getParametersEndsWithLong(String nameEndWith, long defaultNum) {
        String[] paramValues = this.getParameterValuesEndsWith(nameEndWith);
        if (paramValues == null) {
            return null;
        }
        if (paramValues.length < 1) {
            return new long[0];
        }
        long[] values = new long[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            try {
                values[i] = Long.parseLong(paramValues[i]);
                continue;
            }
            catch (Exception e) {
                values[i] = defaultNum;
            }
        }
        return values;
    }

    public String getParameter(String name) {
        String val = super.getParameter(name);
        if (val == null && this.m_postParameter != null && this.m_postParameter.hasParameter()) {
            return this.m_postParameter.getParameter(name);
        }
        return val;
    }

    public String getParameter(String name, String charset) {
        String val;
        if (this.m_postParameter == null || (val = this.m_postParameter.getParameter(name, charset)) == null) {
            String query = this.getQueryString();
            if (query != null) {
                int indexBegin = 0;
                while ((indexBegin = query.indexOf(name + '=', indexBegin)) >= 0 && indexBegin != 0 && query.charAt(indexBegin - 1) != '&') {
                }
                if (indexBegin >= 0) {
                    int indexEnd = query.indexOf(38);
                    if (indexEnd < 0) {
                        indexEnd = query.length();
                    }
                    try {
                        return URLDecoder.decode(query.substring(indexBegin + name.length() + 1, indexEnd), charset);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
        } else {
            return val;
        }
        return this.getParameter(name);
    }

    public Map getParameterMap() {
        Map val = super.getParameterMap();
        if (this.m_postParameter != null && this.m_postParameter.hasParameter()) {
            HashMap<String, String[]> newVal = new HashMap<String, String[]>();
            newVal.putAll(val);
            for (String name : this.m_postParameter.getParameterNames()) {
                if (newVal.containsKey(name)) {
                    ArrayList<String> vals = new ArrayList<String>();
                    Object valObj = val.get(name);
                    if (valObj instanceof Collection) {
                        vals.addAll((Collection)valObj);
                    } else if (valObj instanceof Array) {
                        String[] parVals;
                        String[] stringArray = parVals = (String[])valObj;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String parVal = stringArray[i];
                            vals.add(parVal);
                        }
                    }
                    for (String parVal : this.m_postParameter.getParameterValues(name)) {
                        vals.add(parVal);
                    }
                    continue;
                }
                newVal.put(name, this.m_postParameter.getParameterValues(name));
            }
            return newVal;
        }
        return val;
    }

    public Enumeration getParameterNames() {
        Enumeration enu = super.getParameterNames();
        if (this.m_postParameter != null && this.m_postParameter.hasParameter()) {
            HashMap<String, String> names = new HashMap<String, String>();
            Set<String> parNames = this.m_postParameter.getParameterNames();
            while (enu.hasMoreElements()) {
                names.put((String)enu.nextElement(), "");
            }
            for (String name : parNames) {
                names.put(name, "");
            }
            return Collections.enumeration(names.keySet());
        }
        return enu;
    }

    public String[] getParameterValues(String name) {
        String[] vals = super.getParameterValues(name);
        if (this.m_postParameter != null && this.m_postParameter.hasParameter()) {
            String[] parVals = this.m_postParameter.getParameterValues(name);
            ArrayList<String> newVals = new ArrayList<String>();
            if (vals == null || vals.length == 0) {
                return parVals;
            }
            for (String val : vals) {
                newVals.add(val);
            }
            if (parVals != null) {
                for (String val : parVals) {
                    newVals.add(val);
                }
            }
            return newVals.toArray(new String[0]);
        }
        return vals;
    }

    public final String getParameterEndsWith(String nameEndWith) {
        return this.getParameterEndsWith(nameEndWith, true);
    }

    public final String getParameterEndsWith(String nameEndWith, boolean emptyStringsOK) {
        String temp = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (temp != null) {
            if (temp.equals("") && !emptyStringsOK) {
                return null;
            }
            return temp.trim();
        }
        if (emptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getParametersEndsWith(String nameEndWith) {
        return this.getParametersEndsWith(nameEndWith, true);
    }

    public final String[] getParametersEndsWith(String nameEndWith, boolean isEmptyStringsOK) {
        String[] arrayPar = this.getParameterValuesEndsWith(nameEndWith);
        if (arrayPar != null) {
            if (!isEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !isEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String tempstr = this.getParameter(this.getRealParamterNameOne(nameEndWith));
        if (tempstr != null) {
            if (tempstr.equals("") && !isEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{tempstr};
            return arrayPar;
        }
        if (isEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    private final String[] getParameterValuesEndsWith(String nameEndWith) {
        String strParameter = this.getRealParamterName(nameEndWith);
        String[] arrayName = strParameter.split("&");
        StringList lstValue = new StringList(this.m_parameters.size() / 2);
        for (int n = 0; n < arrayName.length; ++n) {
            String[] arrayValue = this.getParameterValues(arrayName[n]);
            for (int i = 0; i < arrayValue.length; ++i) {
                lstValue.add(arrayValue[i]);
            }
        }
        return lstValue.toStringArray();
    }

    private final String getRealParamterName(String name) {
        if (this.m_parameters == null) {
            this.m_parameters = new Hashtable();
            Enumeration objEnu = this.getParameterNames();
            while (objEnu.hasMoreElements()) {
                String strCurName = (String)objEnu.nextElement();
                int nIndex = strCurName.indexOf(this.m_cSplit);
                if (nIndex >= 0) {
                    String strKey = strCurName.substring(nIndex + 1);
                    if (!this.m_parameters.contains(strKey)) {
                        this.m_parameters.put(strKey, strCurName);
                        continue;
                    }
                    this.m_parameters.put(strKey, this.m_parameters.get(strKey) + "&" + strCurName);
                    continue;
                }
                this.m_parameters.put(strCurName, strCurName);
            }
        }
        if (!this.m_parameters.containsKey(name)) {
            return "";
        }
        return this.m_parameters.get(name);
    }

    private final String getRealParamterNameOne(String name) {
        String strValue = this.getRealParamterName(name);
        int nIndex = strValue.indexOf(38);
        if (nIndex >= 0) {
            return strValue.substring(0, nIndex);
        }
        return strValue;
    }

    public final String getAttributeString(String name) {
        return this.getAttributeString(name, true);
    }

    public final String getAttributeString(String name, boolean isEmptyStringsOK) {
        Object objAttr = this.getAttribute(name);
        if (objAttr != null) {
            if (objAttr instanceof String) {
                if (((String)objAttr).length() <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                return (String)objAttr;
            }
            if (objAttr instanceof int[]) {
                int[] arrayValues = (int[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof long[]) {
                long[] arrayValues = (long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof boolean[]) {
                boolean[] arrayValues = (boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n]);
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer[]) {
                Integer[] arrayValues = (Integer[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Long[]) {
                Long[] arrayValues = (Long[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Boolean[]) {
                Boolean[] arrayValues = (Boolean[])objAttr;
                StringBuffer sbufValue = new StringBuffer();
                for (int n = 0; n < arrayValues.length; ++n) {
                    if (n > 0) {
                        sbufValue.append(',');
                    }
                    sbufValue.append(arrayValues[n].toString());
                }
                return sbufValue.toString();
            }
            if (objAttr instanceof Integer) {
                Integer objValue = (Integer)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Long) {
                Long objValue = (Long)objAttr;
                return objValue.toString();
            }
            if (objAttr instanceof Boolean) {
                Boolean objValue = (Boolean)objAttr;
                return objValue.toString();
            }
            return objAttr.toString();
        }
        if (isEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getAttributesString(String name) {
        return this.getAttributesString(name, true);
    }

    public final String[] getAttributesString(String name, boolean isEmptyStringsOK) {
        Object objAttr = this.getAttribute(name);
        if (objAttr != null) {
            if (objAttr instanceof String[]) {
                if (((String[])objAttr).length <= 0 && !isEmptyStringsOK) {
                    return null;
                }
                return (String[])objAttr;
            }
            if (objAttr instanceof String) {
                String[] arrayAttr = new String[1];
                if (((String)objAttr).equals("") && !isEmptyStringsOK) {
                    return null;
                }
                arrayAttr[0] = (String)objAttr;
                return arrayAttr;
            }
            if (objAttr instanceof int[]) {
                int[] arrayValues = (int[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof long[]) {
                long[] arrayValues = (long[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof boolean[]) {
                boolean[] arrayValues = (boolean[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Integer[]) {
                Integer[] arrayValues = (Integer[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Integer) {
                String[] arrayResult = new String[]{String.valueOf((Integer)objAttr)};
                return arrayResult;
            }
            if (objAttr instanceof Long[]) {
                Long[] arrayValues = (Long[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Long) {
                String[] arrayResult = new String[]{String.valueOf((Long)objAttr)};
                return arrayResult;
            }
            if (objAttr instanceof Boolean[]) {
                Boolean[] arrayValues = (Boolean[])objAttr;
                String[] arrayResult = new String[arrayValues.length];
                for (int n = 0; n < arrayResult.length; ++n) {
                    arrayResult[n] = String.valueOf(arrayValues[n]);
                }
                return arrayResult;
            }
            if (objAttr instanceof Boolean) {
                String[] arrayResult = new String[]{String.valueOf((Boolean)objAttr)};
                return arrayResult;
            }
            String[] arrayAttr = new String[1];
            log.error("\u5c5e\u6027 " + name + " \u7684\u7c7b\u578b\u4e0d\u662f\u5b57\u7b26\u4e32\u6570\u7ec4\u3002");
            arrayAttr[0] = objAttr.toString();
            return arrayAttr;
        }
        if (isEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    public final String getParameterString(String name) {
        return this.getParameterString(name, true);
    }

    public final String getParameterString(String name, boolean isEmptyStringsOK) {
        this.adjustInputCharset();
        String strResult = this.getParameter(name);
        if (strResult != null) {
            if (strResult.equals("") && !isEmptyStringsOK) {
                return null;
            }
            return strResult.trim();
        }
        if (isEmptyStringsOK) {
            return "";
        }
        return null;
    }

    public final String[] getParameterValuesString(String name) {
        return this.getParameterValuesString(name, true);
    }

    public final String[] getParameterValuesString(String name, boolean isEmptyStringsOK) {
        String[] arrayPar = this.getParameterValues(name);
        if (arrayPar != null) {
            if (!isEmptyStringsOK) {
                StringList lstPar = new StringList(arrayPar.length);
                for (int n = 0; n < arrayPar.length; ++n) {
                    if (arrayPar[n] == null || arrayPar[n].length() <= 0) continue;
                    lstPar.add(arrayPar[n]);
                }
                if (arrayPar.length != lstPar.size()) {
                    arrayPar = lstPar.toStringArray();
                }
            }
            if (arrayPar.length <= 0 && !isEmptyStringsOK) {
                return null;
            }
            return arrayPar;
        }
        String strPar = this.getParameter(name);
        if (strPar != null) {
            if (strPar.equals("") && !isEmptyStringsOK) {
                return null;
            }
            arrayPar = new String[]{strPar};
            return arrayPar;
        }
        if (isEmptyStringsOK) {
            return new String[0];
        }
        return null;
    }

    static {
        GeneralHttpServletRequest.setCharSet();
    }
}

