/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.buf.B2CConverter;
import com.hynnet.util.buf.ByteChunk;
import com.hynnet.util.buf.UDecoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralHttpParameters {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.GeneralHttpParameters");
    private byte[] m_postData;
    private Charset m_charset;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private UDecoder urlDec;
    private final Map<String, List<String>> paramHashValues = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<byte[]>> paramHashByteValues = new LinkedHashMap<String, List<byte[]>>();
    private int limit = -1;
    private int parameterCount = 0;
    private boolean parseFailed = false;
    protected static int CACHED_POST_LEN = 8192;
    protected int maxPostSize = 0;
    private String m_requestIdLogInfo;

    public GeneralHttpParameters() {
    }

    public GeneralHttpParameters(HttpServletRequest request) {
        this.processPostData(request);
    }

    private final void processPostData(HttpServletRequest request) {
        int semicolon;
        String encoding = null;
        Integer reqId = (Integer)request.getAttribute("CS_ri");
        this.m_requestIdLogInfo = reqId != null ? String.format("%s\t", reqId) : "";
        String contentType = request.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if ((semicolon = contentType.indexOf(59)) >= 0) {
            int charsetIndex = contentType.indexOf("charset=", semicolon);
            if (charsetIndex > 0 && (charsetIndex = (encoding = contentType.substring(charsetIndex + 8, contentType.length()).trim()).indexOf(59)) > 0) {
                encoding = encoding.substring(0, charsetIndex).trim();
            }
            contentType = contentType.substring(0, semicolon).trim();
        } else {
            contentType = contentType.trim();
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            int len;
            boolean isFormData = "application/x-www-form-urlencoded".equalsIgnoreCase(contentType);
            if (encoding == null && ((encoding = request.getCharacterEncoding()) == null || (encoding = encoding.trim()).length() == 0)) {
                encoding = DEFAULT_ENCODING;
            }
            if ((len = request.getContentLength()) > 0) {
                if (this.maxPostSize > 0 && len > this.maxPostSize) {
                    if (log.isErrorEnabled()) {
                        log.error("{}\u63d0\u4ea4\u7684\u6570\u636e\u5927\u4e8ecoyoteRequest.postTooLarge\uff1a{}\uff08{}\uff09", new Object[]{this.m_requestIdLogInfo, this.maxPostSize, len});
                    }
                    return;
                }
                byte[] formData = new byte[len];
                try {
                    if (this.readPostBody(request, formData, len) != len) {
                        return;
                    }
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}coyoteRequest.parseParameters", (Object)this.m_requestIdLogInfo, (Object)e);
                    }
                    return;
                }
                this.m_postData = new byte[len];
                System.arraycopy(formData, 0, this.m_postData, 0, len);
                if (isFormData) {
                    this.m_charset = this.getCharset(encoding);
                    this.processParameters(formData, 0, len, this.m_charset);
                }
            } else if ("chunked".equalsIgnoreCase(request.getHeader("transfer-encoding"))) {
                byte[] formData = null;
                try {
                    formData = this.readChunkedPostBody(request);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}coyoteRequest.parseParameters", (Object)this.m_requestIdLogInfo, (Object)e);
                    }
                    return;
                }
                if (formData != null) {
                    this.m_postData = new byte[formData.length];
                    System.arraycopy(formData, 0, this.m_postData, 0, formData.length);
                    if (isFormData) {
                        this.m_charset = this.getCharset(encoding);
                        this.processParameters(formData, 0, formData.length, this.m_charset);
                    }
                }
            }
        }
    }

    private int readPostBody(HttpServletRequest request, byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = request.getInputStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    private byte[] readChunkedPostBody(HttpServletRequest request) throws IOException {
        ByteChunk body = new ByteChunk();
        byte[] buffer = new byte[CACHED_POST_LEN];
        int len = 0;
        while (len > -1) {
            len = request.getInputStream().read(buffer, 0, CACHED_POST_LEN);
            if (this.maxPostSize > 0 && body.getLength() + len > this.maxPostSize) {
                throw new IOException("coyoteRequest.chunkedPostTooLarge");
            }
            if (len <= 0) continue;
            body.append(buffer, 0, len);
        }
        if (body.getLength() == 0) {
            return null;
        }
        if (body.getLength() < body.getBuffer().length) {
            int length = body.getLength();
            byte[] result = new byte[length];
            System.arraycopy(body.getBuffer(), 0, result, 0, length);
            return result;
        }
        return body.getBuffer();
    }

    private Charset getCharset(String encoding) {
        if (encoding == null) {
            return DEFAULT_CHARSET;
        }
        try {
            return B2CConverter.getCharset(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return DEFAULT_CHARSET;
        }
    }

    private void urlDecode(ByteChunk bc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc, true);
    }

    public void addParameter(String key, String value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        ++this.parameterCount;
        if (this.limit > -1 && this.parameterCount > this.limit) {
            this.parseFailed = true;
            throw new IllegalStateException("parameters.maxCountFail: " + Integer.valueOf(this.limit));
        }
        List<String> values = this.paramHashValues.get(key);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.paramHashValues.put(key, values);
        }
        values.add(value);
    }

    public void addParameter(String key, byte[] value) throws IllegalStateException {
        if (key == null) {
            return;
        }
        if (this.limit > -1 && this.parameterCount > this.limit) {
            this.parseFailed = true;
            throw new IllegalStateException("parameters.maxCountFail: " + Integer.valueOf(this.limit));
        }
        List<byte[]> values = this.paramHashByteValues.get(key);
        if (values == null) {
            values = new ArrayList<byte[]>(1);
            this.paramHashByteValues.put(key, values);
        }
        values.add(value);
    }

    private void processParameters(byte[] bytes, int start, int len, Charset charset) {
        ByteChunk tmpName = new ByteChunk();
        ByteChunk tmpValue = new ByteChunk();
        ByteChunk origName = new ByteChunk();
        ByteChunk origValue = new ByteChunk();
        if (log.isTraceEnabled()) {
            log.trace("{}\u5904\u7406\u53c2\u6570\uff1a{}{}", new Object[]{this.m_requestIdLogInfo, new String(bytes, start, len <= 100 ? len : 100, DEFAULT_CHARSET), len <= 100 ? "" : "..."});
        }
        int decodeFailCount = 0;
        int pos = start;
        int end = start + len;
        while (pos < end) {
            block36: {
                int nameStart = pos;
                int nameEnd = -1;
                int valueStart = -1;
                int valueEnd = -1;
                boolean parsingName = true;
                boolean decodeName = false;
                boolean decodeValue = false;
                boolean parameterComplete = false;
                do {
                    switch (bytes[pos]) {
                        case 61: {
                            if (parsingName) {
                                nameEnd = pos++;
                                parsingName = false;
                                valueStart = pos;
                                break;
                            }
                            ++pos;
                            break;
                        }
                        case 38: {
                            if (parsingName) {
                                nameEnd = pos;
                            } else {
                                valueEnd = pos;
                            }
                            parameterComplete = true;
                            ++pos;
                            break;
                        }
                        case 37: 
                        case 43: {
                            if (parsingName) {
                                decodeName = true;
                            } else {
                                decodeValue = true;
                            }
                            ++pos;
                            break;
                        }
                        default: {
                            ++pos;
                        }
                    }
                } while (!parameterComplete && pos < end);
                if (pos == end) {
                    if (nameEnd == -1) {
                        nameEnd = pos;
                    } else if (valueStart > -1 && valueEnd == -1) {
                        valueEnd = pos;
                    }
                }
                if (log.isDebugEnabled() && valueStart == -1) {
                    log.debug("{}parameters.noequal NameStart={} NameEnd={}\uff1a{}", new Object[]{this.m_requestIdLogInfo, nameStart, nameEnd, new String(bytes, nameStart, nameEnd - nameStart, DEFAULT_CHARSET)});
                }
                if (nameEnd <= nameStart) {
                    if (valueStart == -1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("{}parameters.emptyChunk", (Object)this.m_requestIdLogInfo);
                        continue;
                    }
                    this.parseFailed = true;
                    continue;
                }
                tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
                if (valueStart >= 0) {
                    tmpValue.setBytes(bytes, valueStart, valueEnd - valueStart);
                } else {
                    tmpValue.setBytes(bytes, 0, 0);
                }
                if (log.isDebugEnabled()) {
                    try {
                        origName.append(bytes, nameStart, nameEnd - nameStart);
                        if (valueStart >= 0) {
                            origValue.append(bytes, valueStart, valueEnd - valueStart);
                        } else {
                            origValue.append(bytes, 0, 0);
                        }
                    }
                    catch (IOException ioe) {
                        log.error("{}parameters.copyFail", (Object)this.m_requestIdLogInfo, (Object)ioe);
                    }
                }
                try {
                    String value;
                    if (decodeName) {
                        this.urlDecode(tmpName);
                    }
                    tmpName.setCharset(charset);
                    String name = tmpName.toString();
                    if (valueStart >= 0) {
                        this.addParameter(name, (byte[])tmpValue.getBytes().clone());
                        if (decodeValue) {
                            this.urlDecode(tmpValue);
                        }
                        tmpValue.setCharset(charset);
                        value = tmpValue.toString();
                    } else {
                        value = "";
                    }
                    try {
                        this.addParameter(name, value);
                    }
                    catch (IllegalStateException ise) {
                        this.parseFailed = true;
                        break;
                    }
                }
                catch (IOException e) {
                    this.parseFailed = true;
                    if (++decodeFailCount != 1 && !log.isDebugEnabled() || !log.isDebugEnabled()) break block36;
                    log.debug("{}parameters.decodeFail.debug OrigName={} OrigVal={}", new Object[]{this.m_requestIdLogInfo, origName.toString(), origValue.toString(), e});
                }
            }
            tmpName.recycle();
            tmpValue.recycle();
            if (!log.isDebugEnabled()) continue;
            origName.recycle();
            origValue.recycle();
        }
        if (decodeFailCount > 1 && !log.isDebugEnabled()) {
            log.info("{}parameters.multipleDecodingFail count={}", (Object)this.m_requestIdLogInfo, (Object)decodeFailCount);
        }
    }

    public String getParameter(String name) {
        List<String> vals = this.paramHashValues.get(name);
        return vals == null ? null : (vals.size() > 0 ? vals.get(0) : "");
    }

    public String getParameter(String name, String charset) {
        List<byte[]> vals = this.paramHashByteValues.get(name);
        try {
            return vals == null ? null : (vals.size() > 0 ? URLDecoder.decode(new String(vals.get(0)), charset) : "");
        }
        catch (UnsupportedEncodingException e) {
            return this.getParameter(name);
        }
    }

    public Map<String, List<String>> getParameterMap() {
        return this.paramHashValues;
    }

    public Set<String> getParameterNames() {
        return this.paramHashValues.keySet();
    }

    public String[] getParameterValues(String name) {
        List<String> vals = this.paramHashValues.get(name);
        return vals == null ? null : vals.toArray(new String[0]);
    }

    public String getPostData(String charsetName) {
        if (this.m_postData == null) {
            return null;
        }
        Charset charset = charsetName == null || charsetName.length() == 0 ? (this.m_charset != null ? this.m_charset : Charset.forName(DEFAULT_ENCODING)) : Charset.forName(charsetName);
        return new String(this.m_postData, charset);
    }

    public byte[] getPostDataBytes() {
        return this.m_postData;
    }

    public boolean hasParameter() {
        return this.paramHashValues.size() > 0;
    }

    public boolean isParseFailed() {
        return this.parseFailed;
    }
}

