/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.FixTime;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FixTimeType implements FixTime
{
    FIX_TO_DAY_END_TIME_ALL_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_DAY_END_TIME_DAY_BEGIN_ONLY{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0) {
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                return cal.getTime();
            }
            return time;
        }
    }
    ,
    FIX_TO_DAY_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_MINUTE_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_MINUTE_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_HOUR_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_HOUR_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_WEEK_SUNDAY_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(7, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_WEEK_MONDAY_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(7, 2);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_WEEK_SATURDAY_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(7, 7);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_WEEK_SUNDAY_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(3, 1);
            cal.set(7, 1);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_MONTH_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_MONTH_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return new Date(cal.getTime().getTime() - 1L);
        }
    }
    ,
    FIX_TO_YEAR_START_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_YEAR_END_TIME{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            return cal.getTime();
        }
    }
    ,
    FIX_TO_NEXT_WEEK{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(3, 1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_TO_PREVIOUS_WEEK{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(3, -1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_TO_NEXT_YEAR{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(1, 1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_TO_PREVIOUS_YEAR{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(1, -1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_TO_NEXT_MONTH{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(2, 1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_TO_PREVIOUS_MONTH{

        public Date fix(Date time) {
            if (time == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(time);
            cal.add(2, -1);
            return new Date(cal.getTime().getTime());
        }
    }
    ,
    FIX_NONE{

        public Date fix(Date time) {
            return time;
        }
    };

}

