/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FindJarOfClass {
    protected String m_searchName;
    protected String m_strClassNameWithExt;
    protected boolean m_bShow;
    protected boolean m_isNoInter = false;
    private List<String> m_searchPath = new ArrayList<String>();
    protected ArrayList<String> m_lstJarFiles = new ArrayList();
    protected ArrayList<String> m_lstClassNames = new ArrayList();

    public FindJarOfClass() {
    }

    public FindJarOfClass(String[] args) throws IllegalParException {
        this.prasePar(args);
    }

    public FindJarOfClass(String strClassName) {
        this(strClassName, false);
    }

    public FindJarOfClass(String strClassName, boolean bShow) {
        this.setSearchName(strClassName);
        this.m_bShow = bShow;
    }

    protected void prasePar(String[] args) throws IllegalParException {
        String searchName = null;
        this.m_bShow = true;
        int len = args.length;
        for (int n = 0; n < len; ++n) {
            String arg = args[n].trim();
            if ("0".equals(arg) || "false".equalsIgnoreCase(arg)) {
                this.m_bShow = false;
                continue;
            }
            if ("-nointer".equalsIgnoreCase(arg)) {
                this.m_isNoInter = true;
                continue;
            }
            if (arg.length() <= 0) continue;
            if (searchName == null) {
                searchName = arg;
                continue;
            }
            this.m_searchPath.add(arg);
        }
        this.setSearchName(searchName);
    }

    public void setSearchName(String strClassName) {
        this.m_searchName = StringUtils.replace(strClassName, new String[]{"/", "\\"}, new String[]{".", "."});
        this.m_strClassNameWithExt = strClassName != null && !strClassName.toLowerCase().endsWith(".class") ? this.m_searchName + ".class" : null;
    }

    public List findClass(String strDir, boolean bRecurse) {
        this.searchDir(strDir, bRecurse, false);
        return this.m_lstJarFiles;
    }

    public List findClass(String strDir, boolean bRecurse, boolean bCaseSensitive) {
        this.searchDir(strDir, bRecurse, bCaseSensitive);
        return this.m_lstJarFiles;
    }

    protected void searchDir(String strDir, boolean bRecurse) {
        this.searchDir(strDir, bRecurse, false);
    }

    protected void searchDir(String strDir, boolean bRecurse, boolean bCaseSensitive) {
        try {
            File objDir = new File(strDir);
            if (!objDir.isDirectory()) {
                this.processFile(objDir.getAbsolutePath(), bCaseSensitive);
                return;
            }
            File[] arrayFiles = objDir.listFiles();
            for (int i = 0; i < arrayFiles.length; ++i) {
                if (bRecurse && arrayFiles[i].isDirectory()) {
                    this.searchDir(arrayFiles[i].getAbsolutePath(), true, bCaseSensitive);
                    continue;
                }
                String strFileName = arrayFiles[i].getAbsolutePath();
                this.processFile(strFileName, bCaseSensitive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processFile(String strFileName, boolean bCaseSensitive) {
        String fileExt;
        int index = strFileName.lastIndexOf(46);
        String string = fileExt = index >= 0 ? strFileName.substring(index + 1) : "";
        if (fileExt.equalsIgnoreCase("jar") || fileExt.equalsIgnoreCase("zip")) {
            try {
                ZipFile objZip = new ZipFile(strFileName);
                Enumeration<? extends ZipEntry> enuEntries = objZip.entries();
                while (enuEntries.hasMoreElements()) {
                    ZipEntry objEntry = enuEntries.nextElement();
                    String strThisClassName = this.getClassName(objEntry);
                    if (bCaseSensitive) {
                        if (!strThisClassName.equals(this.m_searchName) && (this.m_strClassNameWithExt == null || !strThisClassName.equals(this.m_strClassNameWithExt))) continue;
                        this.m_lstJarFiles.add(strFileName);
                        this.m_lstClassNames.add(strThisClassName);
                        if (this.m_bShow) {
                            System.out.println(strFileName + " \u4e2d\u5b58\u5728 " + strThisClassName);
                        }
                        break;
                    }
                    if (strThisClassName.length() < this.m_searchName.length()) continue;
                    String strCompare1 = strThisClassName.substring(strThisClassName.length() - this.m_searchName.length(), strThisClassName.length());
                    String strCompare2 = this.m_strClassNameWithExt != null && strThisClassName.length() >= this.m_strClassNameWithExt.length() ? strThisClassName.substring(strThisClassName.length() - this.m_strClassNameWithExt.length(), strThisClassName.length()) : null;
                    if (!strCompare1.equalsIgnoreCase(this.m_searchName) && (strCompare2 == null || !strCompare2.equalsIgnoreCase(this.m_strClassNameWithExt))) continue;
                    this.m_lstJarFiles.add(strFileName);
                    this.m_lstClassNames.add(strThisClassName);
                    if (!this.m_bShow) continue;
                    System.out.println(strFileName + " \u4e2d\u5b58\u5728 " + strThisClassName);
                }
            }
            catch (Exception e) {
                System.out.println("\u5904\u7406\u6587\u4ef6\uff1a" + strFileName + " \u65f6\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public List getFileNames() {
        return this.m_lstJarFiles;
    }

    public List getClassNames() {
        return this.m_lstClassNames;
    }

    protected String getClassName(ZipEntry objEntry) {
        StringBuffer strClassName = new StringBuffer(objEntry.getName().replace('/', '.'));
        return strClassName.toString();
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u641c\u7d22\u5305\u542b\u6307\u5b9a\u7c7b\u7684JAR\u7c7b\u5e93\u7684\u5de5\u5177");
            System.out.println("\u4f7f\u7528\u65b9\u6cd5\uff1aFindJarOfClass \u7c7b\u540d \u641c\u7d22\u7684\u8def\u5f84 [-nointer]\r\n\u8bf7\u6309\u56de\u8f66\u8fd4\u56de...");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        try {
            FindJarOfClass objFindInJar = new FindJarOfClass(args);
            objFindInJar.doSearch();
        }
        catch (IllegalParException e) {
            System.err.println(e.getMessage());
        }
        System.exit(0);
    }

    protected void doSearch() {
        List lstJarFiles;
        if (this.m_searchPath.isEmpty()) {
            this.showStartTitle("\u5f53\u524d\u76ee\u5f55", this.m_searchName, false);
            lstJarFiles = this.findClass("./", true, false);
        } else {
            lstJarFiles = new ArrayList();
            int len = this.m_searchPath.size();
            for (int n = 0; n < len; ++n) {
                this.showStartTitle(this.m_searchPath.get(n), this.m_searchName, true);
                lstJarFiles = this.findClass(this.m_searchPath.get(n), true, false);
            }
        }
        lstJarFiles = this.getFileNames();
        if (lstJarFiles.size() == 0) {
            if (!this.m_isNoInter) {
                System.out.println("\u627e\u4e0d\u5230JAR!\r\n\u8bf7\u6309\u56de\u8f66\u8fd4\u56de...");
            }
        } else {
            List lstClassNames = this.getClassNames();
            this.showResultTitle(this.m_searchName);
            for (int i = 0; i < lstJarFiles.size(); ++i) {
                this.showResultItem(i, (String)lstJarFiles.get(i), (String)lstClassNames.get(i));
            }
            if (!this.m_isNoInter) {
                System.out.println("\r\n\u67e5\u627e\u5b8c\u6210\u8bf7\u6309\u56de\u8f66\u8fd4\u56de...");
            }
        }
        if (!this.m_isNoInter) {
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void showStartTitle(String pathInfo, String searchName, boolean isMulti) {
        System.out.println((isMulti ? "\r\n\u5728" : "\u5728") + pathInfo + "\u4e2d\u67e5\u627e\u7c7b\uff1a" + searchName);
    }

    protected void showResultTitle(String searchName) {
        System.out.println("\r\n\u7c7b" + searchName + "\u5b58\u5728\u4e8e\uff1a");
    }

    protected void showResultItem(int index, String jarFileName, String className) {
        System.out.println(index + 1 + ". " + jarFileName + " \u4e2d\u5b58\u5728 " + className);
    }

    protected class IllegalParException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalParException(String msg) {
            super(msg);
        }
    }
}

