/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.FindJarOfClass;
import com.hynnet.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FindJarAndClassOfMethod
extends FindJarOfClass {
    private BytesClassLoader m_classLoader;
    private List<URL> m_classPaths;
    private Map<String, URL> m_allResource;
    private List<String> m_allClassName;
    private List<String> m_allJarFileNames;
    private boolean m_caseSensitive;

    public FindJarAndClassOfMethod(String[] args) throws FindJarOfClass.IllegalParException {
        ArrayList<String> allPar = new ArrayList<String>();
        this.m_classPaths = new ArrayList<URL>();
        this.m_allResource = new HashMap<String, URL>();
        this.m_allClassName = new ArrayList<String>();
        this.m_allJarFileNames = new ArrayList<String>();
        int size = args.length;
        for (int n = 0; n < size; ++n) {
            String par = args[n].trim();
            if ("-cp".equalsIgnoreCase(par) || "-classpath".equalsIgnoreCase(par) || "--cp".equalsIgnoreCase(par) || "--classpath".equalsIgnoreCase(par)) {
                if (n + 1 >= size) continue;
                par = args[n + 1].trim();
                if (!par.startsWith("-")) {
                    String[] classPaths;
                    for (String path : classPaths = par.split(";|,|:")) {
                        this.addClassPath(new File(path));
                    }
                }
                ++n;
                continue;
            }
            allPar.add(par);
        }
        this.prasePar(allPar.toArray(new String[0]));
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("\u5728\u6307\u5b9a\u8def\u5f84\u4e2d\u641c\u7d22\u5305\u542b\u6307\u5b9a\u65b9\u6cd5\u7684JAR\u7c7b\u5e93\u548c\u7c7b\u7684\u5de5\u5177");
            System.out.println("\u4f7f\u7528\u65b9\u6cd5\uff1aFindJarAndClassOfMethod \u65b9\u6cd5\u540d \u641c\u7d22\u7684\u8def\u5f84 [-cp \u4f9d\u8d56\u7c7b\u8def\u5f84] [-nointer]\r\n\u8bf7\u6309\u56de\u8f66\u8fd4\u56de...");
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        try {
            FindJarAndClassOfMethod objFindInJar = new FindJarAndClassOfMethod(args);
            objFindInJar.doSearch();
        }
        catch (FindJarOfClass.IllegalParException e) {
            System.err.println(e.getMessage());
        }
        System.exit(0);
    }

    private void addClassPath(File pathFile) {
        block8: {
            if (!pathFile.exists()) break block8;
            if (pathFile.isDirectory()) {
                File[] files;
                for (File file : files = pathFile.listFiles()) {
                    if (file == null) continue;
                    if (file.isDirectory()) {
                        this.addClassPath(file);
                        continue;
                    }
                    try {
                        this.m_classPaths.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            } else {
                try {
                    this.m_classPaths.add(pathFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    protected BytesClassLoader getClassLoader() {
        if (this.m_classLoader == null) {
            if (this.m_allResource != null && this.m_allResource.size() > 0) {
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.addAll(this.m_classPaths);
                urls.addAll(this.m_allResource.values());
                this.m_classLoader = new BytesClassLoader(urls.toArray(new URL[0]));
            } else {
                this.m_classLoader = new BytesClassLoader(this.m_classPaths.toArray(new URL[0]));
            }
        }
        return this.m_classLoader;
    }

    protected void processClass(Class cls, String strFileName, boolean bCaseSensitive) {
        Method[] allMethod = cls.getDeclaredMethods();
        int size = allMethod.length;
        for (int n = 0; n < size; ++n) {
            boolean isVaild;
            boolean bl = isVaild = bCaseSensitive ? allMethod[n].getName().equals(this.m_searchName) : allMethod[n].getName().equalsIgnoreCase(this.m_searchName);
            if (!isVaild) continue;
            this.m_lstJarFiles.add(strFileName);
            this.m_lstClassNames.add(cls.getName());
            if (!this.m_bShow) break;
            System.out.println(strFileName + " \u4e2d\u5b58\u5728 " + cls.getName() + '.' + allMethod[n].getName() + "()");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(String strFileName, boolean bCaseSensitive) {
        block17: {
            String className = null;
            int index = strFileName.lastIndexOf(46);
            String fileExt = index >= 0 ? strFileName.substring(index + 1) : "";
            this.m_caseSensitive = bCaseSensitive;
            try {
                Class cls = null;
                if (fileExt.equalsIgnoreCase("jar") || fileExt.equalsIgnoreCase("zip")) {
                    ZipFile objZip = new ZipFile(strFileName);
                    Enumeration<? extends ZipEntry> enuEntries = objZip.entries();
                    while (enuEntries.hasMoreElements()) {
                        ZipEntry objEntry = enuEntries.nextElement();
                        long size = objEntry.getSize();
                        if (size <= 0L || !(className = this.getClassName(objEntry)).endsWith(".class")) continue;
                        if (this.m_allResource != null) {
                            if (!this.m_allResource.containsKey(strFileName)) {
                                this.m_allResource.put(strFileName, new File(strFileName).toURI().toURL());
                                this.m_classLoader = null;
                            }
                            this.m_allClassName.add(className.substring(0, className.length() - 6));
                            this.m_allJarFileNames.add(strFileName);
                            continue;
                        }
                        byte[] classBytes = new byte[(int)size];
                        InputStream inputStream = objZip.getInputStream(objEntry);
                        size = inputStream.read(classBytes);
                        try {
                            cls = this.getClassLoader().getClass(classBytes);
                            if (cls == null) continue;
                            this.processClass(cls, strFileName, bCaseSensitive);
                        }
                        catch (Error e) {
                            try {
                                if (!(e instanceof LinkageError)) {
                                    System.out.println("\u52a0\u8f7d\u7c7b\uff1a" + className + " \u5f02\u5e38\uff1a" + e.getClass().getName() + " - " + e.getMessage());
                                    e.printStackTrace();
                                }
                                try {
                                    cls = this.getClass().getClassLoader().loadClass(className.substring(0, className.length() - 6));
                                }
                                catch (Error ex) {
                                    System.out.println("\u65e0\u6cd5\u52a0\u8f7d" + strFileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u5f02\u5e38\uff1a" + ex.getClass().getName() + " - " + ex.getMessage());
                                    ex.printStackTrace();
                                }
                                if (cls == null) continue;
                                this.processClass(cls, strFileName, bCaseSensitive);
                            }
                            catch (Throwable throwable) {
                                if (cls != null) {
                                    this.processClass(cls, strFileName, bCaseSensitive);
                                }
                                throw throwable;
                            }
                        }
                    }
                    break block17;
                }
                if (fileExt.equalsIgnoreCase("class")) {
                    BufferedInputStream inStream = null;
                    File file = new File(strFileName);
                    inStream = new BufferedInputStream(new FileInputStream(file));
                    byte[] classBytes = new byte[inStream.available()];
                    inStream.read(classBytes);
                    inStream.close();
                    cls = this.getClassLoader().getClass(classBytes);
                    className = cls.getName();
                    this.processClass(cls, strFileName, bCaseSensitive);
                }
            }
            catch (NoClassDefFoundError e) {
                System.out.println("\u52a0\u8f7d\u6587\u4ef6\uff1a" + strFileName + "\u4e2d\u7684" + className + " \u7c7b\u65e0\u6cd5\u52a0\u8f7d\u7c7b\uff1a" + e.getMessage());
            }
            catch (LinkageError e) {
                System.out.println("\u52a0\u8f7d\u6587\u4ef6\uff1a" + strFileName + "\u4e2d\u7684" + className + " \u65f6LinkageError\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (Exception e) {
                System.out.println("\u52a0\u8f7d\u6587\u4ef6\uff1a" + strFileName + "\u4e2d\u7684" + className + " \u65f6\u5f02\u5e38\uff1a" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public List getFileNames() {
        if (this.m_allResource != null && this.m_allResource.size() > 0) {
            BytesClassLoader loader = this.getClassLoader();
            int size = this.m_allClassName.size();
            for (int n = 0; n < size; ++n) {
                String className = this.m_allClassName.get(n);
                String fileName = this.m_allJarFileNames.get(n);
                try {
                    Class<?> cls = loader.loadClass(className);
                    this.processClass(cls, fileName, this.m_caseSensitive);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u65f6\u53d1\u73b0\u627e\u4e0d\u5230\u7c7b\uff1a" + e.getMessage());
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u65f6\u53d1\u73b0\u7f3a\u5c11\u7c7b\uff1a" + e.getMessage());
                    continue;
                }
                catch (VerifyError e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u6821\u9a8c\u9519\u8bef\uff1a" + e.getMessage());
                    continue;
                }
                catch (SecurityException e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u5b89\u5168\u5f02\u5e38\uff1a" + e.getMessage());
                    continue;
                }
                catch (IllegalAccessError e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u975e\u6cd5\u8bbf\u95ee\uff1a" + e.getMessage());
                    continue;
                }
                catch (Error e) {
                    System.out.println("\u5904\u7406" + fileName + "\u4e2d\u7684\u7c7b\uff1a" + className + " \u5f02\u5e38\uff1a" + e.getClass().getName() + " - " + e.getMessage());
                    e.printStackTrace();
                }
            }
            this.m_allResource.clear();
        }
        return this.m_lstJarFiles;
    }

    public void setSearchName(String strClassName) {
        this.m_searchName = StringUtils.replace(strClassName, new String[]{"/", "\\"}, new String[]{".", "."});
        this.m_strClassNameWithExt = null;
    }

    protected void showStartTitle(String pathInfo, String searchName, boolean isMulti) {
        System.out.println((isMulti ? "\r\n\u5728" : "\u5728") + pathInfo + "\u4e2d\u67e5\u627e\u65b9\u6cd5\uff1a" + searchName);
    }

    protected void showResultTitle(String searchName) {
        System.out.println("\r\n\u65b9\u6cd5" + searchName + "\u5b58\u5728\u4e8e\uff1a");
    }

    protected void showResultItem(int index, String jarFileName, String className) {
        System.out.println(index + 1 + ". " + jarFileName + " \u4e2d\u5b58\u5728 " + className + '.' + this.m_searchName + "()");
    }

    public class BytesClassLoader
    extends URLClassLoader {
        public BytesClassLoader(URL[] urls) {
            super(urls);
        }

        public Class getClass(byte[] classBytes) {
            return this.defineClass(null, classBytes, 0, classBytes.length);
        }

        public Class getClass(String className, byte[] classBytes) {
            return this.defineClass(className, classBytes, 0, classBytes.length);
        }

        public Class getClass(String className) throws ClassNotFoundException {
            return this.findClass(className.substring(0, className.length() - 6));
        }
    }
}

