/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.BufferedRandomAccessFile;
import com.hynnet.util.ObjectComparator;
import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import com.hynnet.util.ZipMaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOperation {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.FileOperation");
    private static boolean native_lib_init_pending = true;
    private static final String[] FILENAME_FIND = new String[]{":", "*", "?", "<", ">", "|"};
    private static final String[] FILENAME_REPLACE = new String[]{"\uff1a", "\u00d7", "\uff1f", "\uff1c", "\uff1e", "\uff5c"};
    private static final int BUFFER_SIZE = 2048;
    private String[] m_lstDir;
    private String[] m_lstFile;
    private String[] m_lstFullname;
    private String m_strErrorMessage = "";
    private static HashMap g_lstTask = new HashMap();
    public static final String IMAGE_FILE_EXT = "jpg;jpeg;png;gif;bmp;ico";
    public static final String ATTACHE_FILE_EXT = "doc;zip;rar;pdf";
    public static final String FORBID_FILE_EXT = "jsp;com;bat;cmd";
    public static final String EXE_FILE_EXT = "exe;com;bat;cmd";

    private static native int ExtractRAR(String var0, String var1, String var2);

    public String getErrorMessage() {
        return this.m_strErrorMessage;
    }

    public boolean createDir(String strDirectory) {
        return this.createDir(strDirectory, System.currentTimeMillis());
    }

    public boolean createDir(String strDirectory, long lLastModified) {
        String strPath;
        if (strDirectory == null) {
            this.m_strErrorMessage = "\u5fc5\u987b\u6307\u5b9a\u8def\u5f84\u3002";
            return false;
        }
        if (File.separatorChar == '\\') {
            strDirectory = strDirectory.replace('/', '\\');
        } else if (File.separatorChar == '/') {
            strDirectory = strDirectory.replace('\\', '/');
        }
        if (strDirectory.endsWith("\\") || strDirectory.endsWith("/") || strDirectory.indexOf(47) < 0 && strDirectory.indexOf(92) < 0) {
            strPath = strDirectory;
        } else {
            int nPos2;
            int nPos = strDirectory.lastIndexOf(47);
            if (nPos <= 0 && (nPos2 = strDirectory.lastIndexOf(92)) > nPos) {
                nPos = nPos2;
            }
            strPath = strDirectory.substring(0, nPos);
        }
        File objDir = new File(strPath);
        if (objDir.exists()) {
            return true;
        }
        boolean bSuccess = objDir.mkdir();
        if (!bSuccess) {
            int nPos;
            if (strPath.endsWith("/") || strPath.endsWith("\\") ? (nPos = strPath.lastIndexOf(47, strPath.length() - 2)) < 0 && (nPos = strPath.lastIndexOf(92, strPath.length() - 2)) < 0 : (nPos = strPath.lastIndexOf(47)) < 0 && (nPos = strPath.lastIndexOf(92)) < 0) {
                return false;
            }
            String strSubPath = strPath.substring(0, nPos + 1);
            bSuccess = this.createDir(strSubPath, lLastModified);
            bSuccess = objDir.mkdir();
        }
        objDir.setLastModified(lLastModified);
        return bSuccess;
    }

    public boolean delete(String strFileName) {
        File[] arraySub;
        if (strFileName == null) {
            this.m_strErrorMessage = "\u5fc5\u987b\u6307\u5b9a\u6587\u4ef6\u6216\u76ee\u5f55\u3002";
            return false;
        }
        File objFile = new File(strFileName);
        if (!objFile.exists()) {
            this.m_strErrorMessage = "\u6307\u5b9a\u6587\u4ef6\u6216\u76ee\u5f55\u4e0d\u5b58\u5728\u3002" + objFile.getAbsolutePath();
            return false;
        }
        boolean bIsDelFile = objFile.delete();
        if (!bIsDelFile && (arraySub = objFile.listFiles()) != null && arraySub.length > 0) {
            for (int n = 0; n <= arraySub.length - 1; ++n) {
                if (arraySub[n].isDirectory()) {
                    this.delete(arraySub[n].getAbsolutePath());
                }
                bIsDelFile = arraySub[n].delete();
            }
            bIsDelFile = objFile.delete();
        }
        if (!bIsDelFile) {
            this.m_strErrorMessage = "\u5220\u9664\u6307\u5b9a\u6587\u4ef6\u6216\u76ee\u5f55\u5931\u8d25\u3002" + objFile.getAbsolutePath();
        }
        return bIsDelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String strDestFileName, String strSourceName) {
        File objSrcFile = new File(strSourceName);
        File objDestFile = new File(strDestFileName);
        if (objSrcFile.getAbsolutePath().equals(objDestFile.getAbsolutePath())) {
            return true;
        }
        HashMap hashMap = g_lstTask;
        synchronized (hashMap) {
            g_lstTask.put(this, this);
        }
        try {
            boolean bResult;
            if (objDestFile.exists()) {
                objDestFile.delete();
            }
            boolean bl = bResult = objSrcFile.renameTo(objDestFile);
            return bl;
        }
        catch (NoClassDefFoundError eClass) {
            log.error("\u7f3a\u5c11\u76f8\u5173JAR\u5305\uff0c\u627e\u4e0d\u5230\u7c7b\uff1a{}", (Object)eClass.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            HashMap hashMap2 = g_lstTask;
            synchronized (hashMap2) {
                g_lstTask.remove(this);
            }
        }
    }

    public final boolean isDirecotry(String strName) {
        return new File(strName).isDirectory();
    }

    public final String[] getDIR() {
        return this.m_lstDir;
    }

    public final String getDIR(int nIndex) {
        return this.m_lstDir[nIndex];
    }

    public final String[] getFileName() {
        return this.m_lstFile;
    }

    public final String getFileName(int nIndex) {
        return this.m_lstFile[nIndex];
    }

    public final String[] getFullName() {
        return this.m_lstFullname;
    }

    public final String getFullName(int nIndex) {
        return this.m_lstFullname[nIndex];
    }

    public String getPath(String strName) {
        String strPath = "";
        File objFile = new File(strName);
        strPath = objFile.getPath();
        try {
            strPath = strPath.replace('\\', '/');
        }
        catch (Exception exception) {
            // empty catch block
        }
        strPath = strPath + "/";
        return strPath;
    }

    public String getParent(String strName) {
        String strParent = "";
        File objFile = new File(strName);
        strParent = objFile.getParent();
        try {
            strParent = strParent.replace('\\', '/');
        }
        catch (Exception exception) {
            // empty catch block
        }
        strParent = strParent + "/";
        return strParent;
    }

    public boolean isFile(String name) {
        boolean check = false;
        File f1 = new File(name);
        if (f1.isFile()) {
            check = true;
        }
        return check;
    }

    public String[] listFile(String strDirName) {
        int i = 0;
        int j = 0;
        int k = 0;
        File objDir = new File(strDirName);
        String[] lstFileName = objDir.list();
        if (lstFileName == null) {
            lstFileName = new String[]{};
            return lstFileName;
        }
        int nLen = lstFileName.length;
        StringList lstDir = new StringList(nLen);
        StringList lstFile = new StringList(nLen);
        this.m_lstFullname = new String[nLen];
        int nPathlen = 0;
        nPathlen = objDir.getPath().length();
        try {
            while (lstFileName[i] != null) {
                boolean bCheckfile = objDir.getPath().substring(nPathlen - 1, nPathlen) == "/" ? this.isDirecotry(objDir.getPath() + lstFileName[i]) : this.isDirecotry(objDir.getPath() + "/" + lstFileName[i]);
                if (bCheckfile) {
                    lstDir.add("[\u76ee\u5f55]" + lstFileName[i]);
                    ++j;
                    ++i;
                }
                if (!(bCheckfile = objDir.getPath().substring(nPathlen - 1, nPathlen) == "/" ? this.isFile(objDir.getPath() + lstFileName[i]) : this.isFile(objDir.getPath() + "/" + lstFileName[i]))) continue;
                lstFile.add(lstFileName[i]);
                ++k;
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        j = 0;
        try {
            for (i = 0; i < lstDir.size() && lstDir.get(i) != null; ++i) {
                lstFileName[i] = lstDir.getString(i);
                this.m_lstFullname[i] = lstFileName[i].substring(4, lstFileName[i].length());
                this.m_lstFullname[i] = objDir.getPath().substring(nPathlen - 1, nPathlen) == "/" ? objDir.getPath() + this.m_lstFullname[i] : objDir.getPath() + File.separatorChar + this.m_lstFullname[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (j < lstFile.size() && lstFile.get(j) != null) {
                lstFileName[i] = lstFile.getString(j);
                this.m_lstFullname[i] = objDir.getPath().substring(nPathlen - 1, nPathlen) == "/" ? objDir.getPath() + lstFileName[i] : objDir.getPath() + File.separatorChar + lstFileName[i];
                ++j;
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_lstDir = lstDir.toStringArray();
        this.m_lstFile = lstFile.toStringArray();
        return lstFileName;
    }

    public String[] listAllFile(String strDir) {
        return this.listAllFile(strDir, true, true, null);
    }

    public String[] listAllFile(String strDir, boolean bWithSubDir) {
        return this.listAllFile(strDir, bWithSubDir, true, null);
    }

    public String[] listAllFile(String strDir, boolean bWithSubDir, boolean bWithFile) {
        return this.listAllFile(strDir, bWithSubDir, bWithFile, null);
    }

    public String[] listAllFile(String strDir, FileFilter filter) {
        return this.listAllFile(strDir, true, true, filter);
    }

    public String[] listAllFile(String strDir, boolean bWithSubDir, FileFilter filter) {
        return this.listAllFile(strDir, bWithSubDir, true, filter);
    }

    public String[] listAllFile(String strDir, boolean bWithSubDir, boolean bWithFile, FileFilter filter) {
        if (strDir == null) {
            log.error("\u6e90\u76ee\u5f55\u4e3a\u7a7a\uff01", (Throwable)new Exception("\u6e90\u76ee\u5f55\u4e3a\u7a7a\uff01"));
            return new String[0];
        }
        StringList lstAllFile = new StringList(20);
        try {
            File objDir = new File(strDir);
            File[] arrayFile = filter == null ? objDir.listFiles() : objDir.listFiles(filter);
            if (arrayFile == null) {
                return new String[0];
            }
            for (int n = 0; n < arrayFile.length; ++n) {
                if (bWithFile && arrayFile[n].isFile()) {
                    lstAllFile.add(arrayFile[n].getAbsolutePath());
                    continue;
                }
                if (!arrayFile[n].isDirectory()) continue;
                if (bWithSubDir) {
                    lstAllFile.add(arrayFile[n].getAbsolutePath());
                }
                String[] arraySub = this.listAllFile(arrayFile[n].getAbsolutePath(), bWithSubDir, bWithFile, filter);
                for (int i = 0; i < arraySub.length; ++i) {
                    lstAllFile.add(arraySub[i]);
                }
            }
        }
        catch (Exception e) {
            String strMsg = "\u5217\u6240\u6709\u6587\u4ef6\u65f6\u5f02\u5e38\u3002" + strDir + bWithSubDir + bWithFile;
            log.error(strMsg, (Throwable)e);
            this.m_strErrorMessage = strMsg + e.getMessage();
        }
        return lstAllFile.toStringArray();
    }

    public final boolean moveFile(String strSource, String strDest) {
        return this.copyFile(strSource, strDest, false, true, false);
    }

    public final boolean moveFile(String strSource, String strDest, boolean bSubOnly) {
        return this.copyFile(strSource, strDest, bSubOnly, true, false);
    }

    public final boolean copyFile(String strSource, String strDest) {
        return this.copyFile(strSource, strDest, false, false);
    }

    public final boolean copyFile(String strSource, String strDest, boolean bSubOnly, boolean bDelSrc) {
        return this.copyFile(strSource, strDest, bSubOnly, bDelSrc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFile(String strSource, String strDest, boolean bSubOnly, boolean bDelSrc, boolean bAutoRename) {
        FileLock objLock = null;
        try {
            Serializable objSrc = new File(strSource);
            boolean bResult = true;
            if (((File)objSrc).exists() && ((File)objSrc).isFile()) {
                boolean bl;
                String strDestFile;
                this.m_strErrorMessage = "";
                if (strSource == null || strDest == null) {
                    this.m_strErrorMessage = "\u5fc5\u987b\u6307\u5b9a\u6e90\u6587\u4ef6\u548c\u76ee\u6807\u6587\u4ef6\u3002";
                    boolean bl2 = false;
                    return bl2;
                }
                if (strDest.endsWith("/") || strDest.endsWith("\\")) {
                    int nPos = strSource.lastIndexOf(47);
                    if (nPos < 0) {
                        nPos = strSource.lastIndexOf(92);
                    }
                    strDestFile = nPos < 0 ? strDest + strSource : strDest + strSource.substring(nPos + 1);
                } else {
                    strDestFile = strDest;
                }
                if (bAutoRename) {
                    strDestFile = FileOperation.getValidFileName(strDestFile);
                }
                this.createDir(strDestFile, ((File)objSrc).lastModified());
                HashMap nPos = g_lstTask;
                synchronized (nPos) {
                    g_lstTask.put(this, this);
                }
                if (bDelSrc) {
                    File objDestFile = new File(strDestFile);
                    if (objDestFile.getAbsolutePath().equals(((File)objSrc).getAbsolutePath())) {
                        this.m_strErrorMessage = "\u79fb\u52a8\u6587\u4ef6\u6e90\u8def\u5f84\u548c\u76ee\u7684\u8def\u5f84\u4e0d\u80fd\u76f8\u540c\uff1a" + objDestFile.getAbsolutePath();
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (objDestFile.exists()) {
                        objDestFile.delete();
                    }
                    if (((File)objSrc).renameTo(objDestFile)) {
                        boolean bl4 = true;
                        return bl4;
                    }
                }
                FileInputStream objInputStream = new FileInputStream(strSource);
                FileOutputStream objOutputStream = new FileOutputStream(strDestFile, false);
                byte[] arrayData = new byte[1000];
                FileChannel objChannel = objOutputStream.getChannel();
                while ((objLock = objChannel.tryLock()) == null || !objLock.isValid()) {
                    log.info("\u590d\u5236\u6587\u4ef6\u65f6\u6709\u5176\u4ed6\u7ebf\u7a0b\uff0c\u7b49\u5f85\u534a\u79d2:" + strDestFile);
                    Thread.sleep(500L);
                }
                int n = objInputStream.read(arrayData);
                while (n > 0) {
                    objOutputStream.write(arrayData, 0, n);
                    objOutputStream.flush();
                    n = objInputStream.read(arrayData);
                }
                objInputStream.close();
                objOutputStream.close();
                new File(strDestFile).setLastModified(((File)objSrc).lastModified());
                if (bDelSrc) {
                    bl = ((File)objSrc).delete();
                }
                bl = bResult;
                return bl;
            }
            if (((File)objSrc).exists()) {
                File[] arraySub = ((File)objSrc).listFiles();
                File objDest = new File(strDest);
                boolean bNoError = true;
                if (!objDest.exists()) {
                    objDest.mkdirs();
                } else if (!objDest.isDirectory()) {
                    this.m_strErrorMessage = strDest + " \u76ee\u7684\u4e0d\u662f\u76ee\u5f55\u3002";
                    log.error(this.m_strErrorMessage);
                    boolean bl = false;
                    return bl;
                }
                long lLastModified = ((File)objSrc).lastModified();
                String strDestPath = objDest.getAbsolutePath() + File.separatorChar;
                if (!bSubOnly) {
                    strDestPath = strDestPath + ((File)objSrc).getName() + File.separatorChar;
                }
                StringBuffer sbufMsg = new StringBuffer();
                for (int n = 0; n < arraySub.length; ++n) {
                    if (this.copyFile(arraySub[n].getAbsolutePath(), strDestPath, false, bNoError && bDelSrc)) continue;
                    bNoError = false;
                    sbufMsg.append(this.m_strErrorMessage);
                }
                objDest.setLastModified(lLastModified);
                if (bNoError && bDelSrc) {
                    bResult = ((File)objSrc).delete();
                    if (!bResult) {
                        this.m_strErrorMessage = "\u5220\u9664\u6e90\u76ee\u5f55\uff1a" + ((File)objSrc).getAbsolutePath() + "\u5931\u8d25\uff01";
                        log.info(this.m_strErrorMessage);
                    }
                } else if (!bNoError) {
                    this.m_strErrorMessage = sbufMsg.toString();
                }
                boolean bl = bNoError;
                return bl;
            }
            this.m_strErrorMessage = "\u6e90\u6587\u4ef6\"" + strSource + "\"\u4e0d\u5b58\u5728";
        }
        catch (NoClassDefFoundError eClass) {
            log.error("\u7f3a\u5c11\u76f8\u5173JAR\u5305\uff0c\u627e\u4e0d\u5230\u7c7b\uff1a{}", (Object)eClass.getMessage());
            this.m_strErrorMessage = eClass.getMessage();
        }
        catch (Exception exception) {
            this.m_strErrorMessage = exception.getMessage();
            log.error(this.m_strErrorMessage, (Throwable)exception);
        }
        finally {
            if (objLock != null) {
                try {
                    objLock.release();
                }
                catch (Exception eClass) {}
            }
            HashMap eClass = g_lstTask;
            synchronized (eClass) {
                g_lstTask.remove(this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFileBinaryData(String strFilePath) {
        File objFile = new File(strFilePath);
        if (objFile.exists() && objFile.isFile()) {
            FileInputStream objInputStream = null;
            if (objFile.length() > Integer.MAX_VALUE) {
                log.error("\u53d1\u73b0\u4e8c\u8fdb\u5236\u6570\u636e\u5927\u4e8e2147483647\u5b57\u8282\uff0c\u6b64\u65b9\u6cd5\u53ea\u80fd\u8fd4\u56de\u90e8\u5206\u6570\u636e\uff01");
            }
            byte[] arrayData = new byte[(int)objFile.length()];
            try {
                objInputStream = new FileInputStream(objFile);
                int nRead = objInputStream.read(arrayData);
                if ((long)nRead != objFile.length()) {
                    log.warn("\u8bfb\u53d6\u6587\u4ef6\u201c" + objFile.getAbsolutePath() + "\u201d\u5f97\u5230\u6570\u636e" + nRead + "\u5b57\u8282\uff0c\u6587\u4ef6\u957f\u5ea6\uff1a" + objFile.length());
                }
                byte[] byArray = arrayData;
                return byArray;
            }
            catch (Exception e) {
                log.warn("\u8bfb\u53d6\u6587\u4ef6\u201c" + objFile.getAbsolutePath() + "\u201d\u5931\u8d25\uff1a" + e.getMessage());
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (objInputStream != null) {
                    try {
                        objInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    public static final StringBuffer readFileData(String strFilePath) {
        return FileOperation.readFileData(strFilePath, "UTF-8");
    }

    public static StringBuffer readFileData(String filePath, String encoding) {
        StringBuffer sbufResult = new StringBuffer();
        try {
            File file = null;
            FileInputStream inputStream = null;
            InputStreamReader reader = null;
            BufferedReader bufferedReader = null;
            String in = "";
            file = new File(filePath);
            if (file.isFile()) {
                inputStream = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)inputStream, encoding);
                bufferedReader = new BufferedReader(reader);
                while ((in = bufferedReader.readLine()) != null) {
                    if (in.length() <= 0) continue;
                    sbufResult.append(in).append("\r\n");
                }
                bufferedReader.close();
                reader.close();
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6" + filePath + "\u7684\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
        }
        return sbufResult;
    }

    public static String getFileNameFromStr(String strPath) {
        if (strPath == null) {
            return "";
        }
        int nStart = strPath.lastIndexOf(92);
        int nStartOth = strPath.lastIndexOf(47);
        nStart = nStartOth >= 0 && nStartOth > nStart ? nStartOth + 1 : (nStart >= 0 ? ++nStart : 0);
        int nEnd = strPath.lastIndexOf(63);
        if (nEnd < nStart && (nEnd = strPath.lastIndexOf(35)) < nStart) {
            nEnd = strPath.length();
        }
        return strPath.substring(nStart, nEnd);
    }

    public static String getFileExtFromStr(String strPath) {
        if (strPath == null || strPath.length() == 0) {
            return "";
        }
        int nDot = strPath.lastIndexOf(46);
        if (nDot < 0) {
            return "";
        }
        int nSlash = strPath.lastIndexOf(47);
        if (nSlash < 0) {
            nSlash = strPath.lastIndexOf(92);
        }
        if (nSlash > nDot) {
            return "";
        }
        nSlash = strPath.indexOf(35, nDot);
        if (nSlash < nDot && (nSlash = strPath.indexOf(63)) < nDot) {
            nSlash = strPath.length();
        }
        return strPath.substring(nDot + 1, nSlash);
    }

    public static String getFileNameWithNoExtFromStr(String strPath) {
        if (strPath == null) {
            return "";
        }
        int nSlash = strPath.lastIndexOf(92);
        nSlash = nSlash < 0 || nSlash >= strPath.length() - 1 ? ((nSlash = strPath.lastIndexOf(47)) < 0 || nSlash >= strPath.length() - 1 ? 0 : ++nSlash) : ++nSlash;
        int nDot = strPath.lastIndexOf(46);
        if (nDot < nSlash && (nDot = strPath.lastIndexOf(63)) < nSlash && (nDot = strPath.lastIndexOf(35)) < nSlash) {
            nDot = strPath.length();
        }
        return strPath.substring(nSlash, nDot);
    }

    public static FileFilter getIncludeExcludeFileFilter(String strInclude, String strExclude) {
        return new IncludeExcludeFileFilter(strInclude, strExclude);
    }

    public static FileFilter getIncludeExcludeFileFilter(String[] arrayInclude, String[] arrayExclude) {
        return new IncludeExcludeFileFilter(arrayInclude, arrayExclude);
    }

    public static FileFilter getIncludeExcludeFileFilter(StringList lstInclude, StringList lstExclude) {
        return new IncludeExcludeFileFilter(lstInclude, lstExclude);
    }

    public static String getValidFileName(String strFileName) {
        if (strFileName != null) {
            int n;
            String[] arrayPath = (strFileName = strFileName.trim()).split("\\\\|/");
            if (arrayPath == null || arrayPath.length <= 1) {
                return FileOperation.replaceInvalidChar(strFileName);
            }
            boolean nFindColon = false;
            StringList lstPath = new StringList(arrayPath.length);
            for (n = 0; n < arrayPath.length; ++n) {
                String strValid;
                if (arrayPath[n] == null || (strValid = arrayPath[n].trim()).length() <= 0) continue;
                if (lstPath.size() == 0 && strValid.length() >= 2 && strValid.charAt(1) == ':') {
                    strValid = strValid.substring(0, 1) + ":" + FileOperation.replaceInvalidChar(strValid.substring(2));
                    nFindColon = true;
                } else {
                    strValid = FileOperation.replaceInvalidChar(strValid);
                }
                lstPath.add(strValid);
            }
            StringBuffer sbufData = new StringBuffer(strFileName.length());
            if (!nFindColon && strFileName.charAt(0) == '\\' || strFileName.charAt(0) == '/') {
                sbufData.append(File.separatorChar);
            }
            for (n = 0; n < lstPath.size(); ++n) {
                String strPath = lstPath.getString(n);
                if (n > 0) {
                    sbufData.append(File.separatorChar);
                }
                if (n == 0 || strPath.length() >= 2 && strPath.charAt(1) == ':') {
                    sbufData.append(strPath);
                    continue;
                }
                sbufData.append(FileOperation.replaceInvalidChar(strPath));
            }
            return sbufData.toString();
        }
        return "";
    }

    private static final String replaceInvalidChar(String strFileName) {
        String strValid = StringUtils.replace(strFileName, FILENAME_FIND, FILENAME_REPLACE);
        for (int n = 0; n < strValid.length(); ++n) {
            char ch = strValid.charAt(n);
            if (ch >= '\u4e00' && ch <= '\u9fa5' || ch >= '!' && ch <= '}') continue;
            strValid.replace(ch, '_');
        }
        while (strValid.indexOf("__") >= 0) {
            strValid = strValid.replaceAll("__", "_");
        }
        return strValid;
    }

    public static int setTime(File objFile, long lLastModified) {
        if (objFile.exists()) {
            if (objFile.isFile()) {
                if (objFile.length() == 0L && objFile.setLastModified(lLastModified)) {
                    return 1;
                }
                return 0;
            }
            File[] arrayFile = objFile.listFiles();
            int nResult = 0;
            if (arrayFile != null) {
                for (int n = 0; n < arrayFile.length; ++n) {
                    nResult += FileOperation.setTime(arrayFile[n], lLastModified);
                }
            }
            objFile.setLastModified(lLastModified);
            return ++nResult;
        }
        return 0;
    }

    public static int setTime(String strPath, long lLastModified) {
        return FileOperation.setTime(new File(strPath), lLastModified);
    }

    public static boolean isAttacheFile(String strFileName) {
        return FileOperation.checkExtFile(ATTACHE_FILE_EXT, strFileName);
    }

    public static boolean isForbidFile(String strFileName) {
        return FileOperation.checkExtFile(FORBID_FILE_EXT, strFileName);
    }

    public static boolean isImageFile(String strFileName) {
        return FileOperation.checkExtFile(IMAGE_FILE_EXT, strFileName);
    }

    public static boolean isExeFile(String strFileName) {
        return FileOperation.checkExtFile(EXE_FILE_EXT, strFileName);
    }

    public static boolean checkExtFile(String strExtList, String strFileName) {
        if (strExtList == null) {
            return false;
        }
        String[] arrayExt = strExtList.split(";");
        String strFileNameLowerCase = strFileName.toLowerCase();
        for (int i = 0; i < arrayExt.length; ++i) {
            if (!strFileNameLowerCase.endsWith("." + arrayExt[i])) continue;
            return true;
        }
        return false;
    }

    public static int cleanEmpty(String strPath) {
        return FileOperation.cleanEmpty(new File(strPath));
    }

    public static int cleanEmpty(File objFile) {
        if (objFile.exists()) {
            if (objFile.isFile()) {
                if (objFile.length() == 0L && objFile.delete()) {
                    return 1;
                }
                return 0;
            }
            File[] arrayFile = objFile.listFiles();
            if (arrayFile != null && arrayFile.length == 0) {
                if (objFile.delete()) {
                    return 1;
                }
                return 0;
            }
            if (arrayFile != null) {
                long lLastModified = objFile.lastModified();
                int nResult = 0;
                for (int n = 0; n < arrayFile.length; ++n) {
                    nResult += FileOperation.cleanEmpty(arrayFile[n]);
                }
                arrayFile = objFile.listFiles();
                if (arrayFile != null && arrayFile.length == 0) {
                    if (objFile.delete()) {
                        ++nResult;
                    }
                } else if (arrayFile != null && nResult > 0) {
                    objFile.setLastModified(lLastModified);
                }
                return nResult;
            }
            return 0;
        }
        return 0;
    }

    public static boolean writeFile(String fileName, String data) {
        if (fileName != null && data != null) {
            try {
                if (fileName.indexOf(47) >= 0 || fileName.indexOf(92) >= 0) {
                    new FileOperation().createDir(fileName);
                }
                FileWriter writer = new FileWriter(fileName);
                writer.write(data);
                writer.close();
                return true;
            }
            catch (Exception e) {
                log.error("\u5199\u5165\u6587\u4ef6\u5f02\u5e38:" + fileName, (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String strFileName, byte[] arrayData) {
        if (arrayData != null) {
            FileOutputStream objOutputStream = null;
            try {
                objOutputStream = new FileOutputStream(strFileName, false);
                objOutputStream.write(arrayData);
                objOutputStream.flush();
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException eNotFound) {
                if (strFileName.indexOf(47) >= 0 || strFileName.indexOf(92) >= 0) {
                    new FileOperation().createDir(strFileName);
                }
                if (objOutputStream != null) {
                    try {
                        objOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    objOutputStream = new FileOutputStream(strFileName, false);
                    objOutputStream.write(arrayData);
                    objOutputStream.flush();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.error("\u5199\u5165\u6587\u4ef6\u5f02\u5e38:" + strFileName, (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("\u5199\u5165\u6587\u4ef6\u5f02\u5e38:" + strFileName, (Throwable)e);
            }
            finally {
                if (objOutputStream != null) {
                    try {
                        objOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String fileName, InputStream inputStream) {
        FileOutputStream outputStream = null;
        try {
            if (fileName.indexOf(47) >= 0 || fileName.indexOf(92) >= 0) {
                new FileOperation().createDir(fileName);
            }
            outputStream = new FileOutputStream(fileName, false);
            byte[] arrayData = new byte[1000];
            int i = inputStream.read(arrayData);
            while (i > 0) {
                outputStream.write(arrayData, 0, i);
                outputStream.flush();
                i = inputStream.read(arrayData);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6587\u4ef6\u5f02\u5e38:{}", (Object)fileName, (Object)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFiles(String strZipFileName, String[] arrayFileName) {
        ZipMaker objStream = new ZipMaker();
        try {
            int i;
            objStream.init(strZipFileName);
            for (i = 0; i < arrayFileName.length; ++i) {
                objStream.putFile(new File(arrayFileName[i]), FileOperation.getFileNameFromStr(arrayFileName[i]));
            }
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            String strErrorMessage = "\u538b\u7f29\u6587\u4ef6\u5f02\u5e38" + e.getMessage();
            log.error(strErrorMessage);
        }
        finally {
            objStream.close();
        }
        return false;
    }

    public static long totalSize(File objFile) {
        if (objFile.isFile()) {
            return objFile.length();
        }
        if (objFile.isDirectory()) {
            File[] arraySub = objFile.listFiles();
            if (arraySub != null) {
                long lResult = 0L;
                for (int n = 0; n < arraySub.length; ++n) {
                    lResult += FileOperation.totalSize(arraySub[n]);
                }
                return lResult;
            }
            System.out.print("\u201c" + objFile.getAbsolutePath() + "\u201d\u65e0\u6cd5\u5217\u51fa\u76ee\u5f55");
        }
        return 0L;
    }

    public static boolean unrarFile(String strRARFileName, String strOutputDir, String strPassword) {
        if (native_lib_init_pending) {
            try {
                System.loadLibrary("dllinuxj");
                native_lib_init_pending = false;
            }
            catch (UnsatisfiedLinkError e2) {
                e2.printStackTrace();
                System.err.println("\u4e0d\u80fd\u521d\u59cb\u5316RAR\u89e3\u538b\u5e93\u3002");
                log.error("\u4e0d\u80fd\u521d\u59cb\u5316RAR\u89e3\u538b\u5e93\u3002", (Throwable)e2);
            }
        }
        try {
            File objFile = new File(strRARFileName);
            if (!objFile.exists()) {
                return false;
            }
            return FileOperation.ExtractRAR(strRARFileName, strOutputDir, strPassword) == 0;
        }
        catch (UnsatisfiedLinkError e2) {
            log.error("RAR\u6587\u4ef6\u89e3\u538bUnsatisfiedLinkError\u5f02\u5e38\uff01\u6570\u636e\uff1a" + strRARFileName + " \u5230\uff1a" + strOutputDir);
        }
        catch (Exception e) {
            log.error("RAR\u6587\u4ef6\u89e3\u538b\u5f02\u5e38\uff01\u6570\u636e\uff1a" + strRARFileName + " \u5230\uff1a" + strOutputDir);
        }
        return false;
    }

    public static boolean unzipFile(String strZipFileName, String strOutputDir) {
        if ("rar".equalsIgnoreCase(FileOperation.getFileExtFromStr(strZipFileName)) && FileOperation.unrarFile(strZipFileName, strOutputDir, null)) {
            return true;
        }
        try {
            ZipFile objZipFile = new ZipFile(strZipFileName);
            Enumeration enuEntry = objZipFile.getEntries();
            ZipEntry objZipEntry = null;
            boolean bCheckParent = true;
            while (enuEntry.hasMoreElements()) {
                int c;
                if (bCheckParent) {
                    File objDir = new File(strOutputDir + File.separatorChar);
                    if (!objDir.exists()) {
                        objDir.mkdirs();
                    }
                    bCheckParent = false;
                }
                if ((objZipEntry = (ZipEntry)enuEntry.nextElement()).isDirectory()) {
                    String strName = objZipEntry.getName();
                    strName = strName.substring(0, strName.length() - 1);
                    File objSubDir = new File(strOutputDir + File.separatorChar + strName);
                    objSubDir.mkdir();
                    objSubDir.setLastModified(objZipEntry.getTime());
                    continue;
                }
                File objFile = new File(strOutputDir + File.separatorChar + objZipEntry.getName());
                byte[] arrayData = new byte[1024];
                objFile.getParentFile().mkdirs();
                objFile.createNewFile();
                InputStream objInput = objZipFile.getInputStream(objZipEntry);
                FileOutputStream objOutput = new FileOutputStream(objFile);
                while ((c = objInput.read(arrayData)) != -1) {
                    objOutput.write(arrayData, 0, c);
                }
                objOutput.close();
                objInput.close();
                objFile.setLastModified(objZipEntry.getTime());
            }
            objZipFile.close();
            return true;
        }
        catch (Exception e) {
            String strErrorMessage = "\u89e3\u538b\u6587\u4ef6\u5f02\u5e38\uff1a" + strZipFileName + " :" + e.getMessage();
            log.error(strErrorMessage, (Throwable)e);
            return false;
        }
    }

    public static void main(String[] arrayArg) throws Exception {
        if (arrayArg.length >= 2) {
            if (arrayArg[0].trim().equalsIgnoreCase("copy")) {
                if (arrayArg.length >= 3) {
                    FileOperation objOper = new FileOperation();
                    boolean bResult = arrayArg.length >= 6 ? objOper.copyFile(arrayArg[1], arrayArg[2], "1".equals(arrayArg[3].trim()) || "true".equals(arrayArg[3].trim()), "1".equals(arrayArg[4].trim()) || "true".equals(arrayArg[4].trim()), "1".equals(arrayArg[5].trim()) || "true".equals(arrayArg[5].trim())) : (arrayArg.length >= 4 ? objOper.copyFile(arrayArg[1], arrayArg[2], "1".equals(arrayArg[3].trim()) || "true".equals(arrayArg[3].trim()), "1".equals(arrayArg[4].trim()) || "true".equals(arrayArg[4].trim())) : objOper.copyFile(arrayArg[1], arrayArg[2]));
                    if (!bResult) {
                        System.out.println("\u590d\u5236\u201c" + arrayArg[1] + "\u201d\u5230\u201c" + arrayArg[2] + "\u201d\u5931\u8d25\uff1a" + objOper.getErrorMessage());
                    } else {
                        System.out.println("\u590d\u5236\u201c" + arrayArg[1] + "\u201d\u5230\u201c" + arrayArg[2] + "\u201d\u6210\u529f\u3002");
                    }
                    System.exit(bResult ? 0 : 1);
                }
                System.exit(0);
                return;
            }
            if (arrayArg[0].trim().equalsIgnoreCase("move")) {
                if (arrayArg.length >= 3) {
                    FileOperation objOper = new FileOperation();
                    boolean bResult = arrayArg.length >= 4 ? objOper.moveFile(arrayArg[1], arrayArg[2], "1".equals(arrayArg[3].trim()) || "true".equals(arrayArg[3].trim())) : objOper.moveFile(arrayArg[1], arrayArg[2]);
                    if (!bResult) {
                        System.out.println("\u79fb\u52a8\u201c" + arrayArg[1] + "\u201d\u5230\u201c" + arrayArg[2] + "\u201d\u5931\u8d25\uff1a" + objOper.getErrorMessage());
                    } else {
                        System.out.println("\u79fb\u52a8\u201c" + arrayArg[1] + "\u201d\u5230\u201c" + arrayArg[2] + "\u201d\u6210\u529f\u3002");
                    }
                    System.exit(bResult ? 0 : 1);
                }
                System.exit(0);
                return;
            }
            if (arrayArg[0].trim().equalsIgnoreCase("clean")) {
                int nResult = FileOperation.cleanEmpty(arrayArg[1]);
                System.out.println("\u6e05\u7406\u4e86\u76ee\u5f55\uff1a" + new File(arrayArg[1]).getAbsolutePath() + " \u4e2d\u7684" + nResult + "\u4e2a\u7a7a\u6587\u4ef6\u6216\u76ee\u5f55\u3002");
                System.exit(nResult);
                return;
            }
            if (arrayArg[0].trim().equalsIgnoreCase("time")) {
                if (arrayArg.length >= 3) {
                    long lTime = Long.parseLong(arrayArg[2]);
                    int nResult = FileOperation.setTime(arrayArg[1], lTime);
                    System.out.println("\u8bbe\u7f6e\u4e86\u76ee\u5f55\uff1a" + new File(arrayArg[1]).getAbsolutePath() + " \u4e2d\u7684" + nResult + "\u4e2a\u6587\u4ef6\u6216\u76ee\u5f55\u7684\u65f6\u95f4\u4e3a\uff1a" + new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss.sss").format(new Date(lTime)) + "\u3002");
                    System.exit(nResult);
                }
                return;
            }
            if (arrayArg[0].trim().equalsIgnoreCase("size")) {
                File objDir = new File(arrayArg[1]);
                if (objDir.isFile()) {
                    System.out.println("\u6587\u4ef6\uff1a" + objDir.getAbsolutePath() + " \u7684\u5927\u5c0f\u4e3a" + StringUtils.numberToStr(FileOperation.totalSize(objDir)) + "\u5b57\u8282\u3002");
                } else if (objDir.isDirectory()) {
                    int n;
                    File[] arraySub = objDir.listFiles();
                    long lTotalSize = 0L;
                    int nMaxFileNameLen = 0;
                    System.out.println("\u76ee\u5f55\uff1a" + objDir.getAbsolutePath() + " \u4e2d\u5171\u6709" + arraySub.length + "\u4e2a\u6587\u4ef6\u548c\u76ee\u5f55\uff1a\r\n");
                    Arrays.sort(arraySub, new ObjectComparator((Object)arraySub, "getName", String.class));
                    Arrays.sort(arraySub, new ObjectComparator((Object)arraySub, "isFile", Boolean.class));
                    for (n = 0; n < arraySub.length; ++n) {
                        if (arraySub[n].getName().getBytes().length <= nMaxFileNameLen) continue;
                        nMaxFileNameLen = arraySub[n].getName().getBytes().length;
                    }
                    if (nMaxFileNameLen > 46) {
                        nMaxFileNameLen = 46;
                    }
                    for (n = 0; n < arraySub.length; ++n) {
                        int i;
                        String strSizeInfo;
                        if (!arraySub[n].exists()) {
                            System.out.println(arraySub[n].getName() + "\t\u5df2\u4e0d\u5b58\u5728\uff01");
                            continue;
                        }
                        int nSpace = nMaxFileNameLen - arraySub[n].getName().getBytes().length;
                        if (arraySub[n].isDirectory()) {
                            int i2;
                            System.out.print("\u76ee\u5f55\uff1a" + arraySub[n].getName());
                            for (i2 = 0; i2 < nSpace; ++i2) {
                                System.out.print(' ');
                            }
                            System.out.print(" \u5927\u5c0f\u4e3a ");
                            long lSize = FileOperation.totalSize(arraySub[n]);
                            strSizeInfo = StringUtils.numberToStr(lSize);
                            for (i2 = 0; i2 < 14 - strSizeInfo.length(); ++i2) {
                                System.out.print(' ');
                            }
                            System.out.println(strSizeInfo + " \u5b57\u8282");
                            lTotalSize += lSize;
                            continue;
                        }
                        System.out.print("\u6587\u4ef6\uff1a" + arraySub[n].getName());
                        for (i = 0; i < nSpace; ++i) {
                            System.out.print(' ');
                        }
                        System.out.print(" \u5927\u5c0f\u4e3a ");
                        strSizeInfo = StringUtils.numberToStr(arraySub[n].length());
                        for (i = 0; i < 14 - strSizeInfo.length(); ++i) {
                            System.out.print(' ');
                        }
                        System.out.println(strSizeInfo + " \u5b57\u8282");
                        lTotalSize += arraySub[n].length();
                    }
                    System.out.println("\r\n" + objDir.getAbsolutePath() + " \u603b\u5927\u5c0f\uff1a" + StringUtils.numberToStr(lTotalSize) + " \u5b57\u8282\u3002");
                } else {
                    System.out.println(objDir.getAbsolutePath() + (objDir.exists() ? " \u65e0\u6548\uff01" : " \u4e0d\u5b58\u5728\u3002"));
                }
                System.exit(0);
                return;
            }
            if (arrayArg[0].trim().equalsIgnoreCase("valid")) {
                System.out.println("\u6709\u6548\u6587\u4ef6\u540d\uff1a" + FileOperation.getValidFileName(arrayArg[1]));
                System.exit(0);
                return;
            }
        } else {
            System.out.println("\u6d4b\u8bd5\u53ca\u5e38\u7528\u5de5\u5177\u7684\u51fd\u6570\u3002\r\n");
            System.out.println("\u5f53\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\u5c0f\u5199\u7684 copy \u65f6\uff0c\u8fdb\u884c\u590d\u5236\u64cd\u4f5c\uff1a");
            System.out.println("          \u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u6e90\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u4e09\u4e2a\u53c2\u6570\u4e3a\u76ee\u6807\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u56db\u4e2a\u53c2\u6570\u4e3a\u662f\u5426\u53ea\u79fb\u52a8\u6e90\u76ee\u5f55\u4e0b\u7684\u5b50\u76ee\u5f55\u548c\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u4e94\u4e2a\u53c2\u6570\u4e3a\u662f\u5426\u64cd\u4f5c\u6210\u529f\u540e\u662f\u5426\u5220\u9664\u6e90\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u516d\u4e2a\u53c2\u6570\u4e3a\u662f\u5426\u81ea\u52a8\u91cd\u547d\u540d\u4e0d\u5408\u6cd5\u7684\u76ee\u6807\u6587\u4ef6\u540d\u3002");
            System.out.println(" \u5f53\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\u5c0f\u5199\u7684 move \u65f6\uff0c\u8fdb\u884c\u79fb\u52a8\u64cd\u4f5c\uff1a");
            System.out.println("          \u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u6e90\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u4e09\u4e2a\u53c2\u6570\u4e3a\u76ee\u6807\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u56db\u4e2a\u53c2\u6570\u4e3a\u662f\u5426\u53ea\u79fb\u52a8\u6e90\u76ee\u5f55\u4e0b\u7684\u5b50\u76ee\u5f55\u548c\u6587\u4ef6\u3002");
            System.out.println(" \u5f53\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\u5c0f\u5199\u7684 clean \u65f6\uff0c\u8fdb\u884c\u6e05\u7406\u64cd\u4f5c\uff1a");
            System.out.println("          \u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u6e05\u7406\u7684\u8def\u5f84\uff1b");
            System.out.println(" \u5f53\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\u5c0f\u5199\u7684 time \u65f6\uff0c\u8fdb\u884c\u8bbe\u7f6e\u65f6\u95f4\u64cd\u4f5c\uff1a");
            System.out.println("          \u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u6e90\u6587\u4ef6\uff1b");
            System.out.println("          \u7b2c\u4e09\u4e2a\u53c2\u6570\u4e3a\u65f6\u95f4\u957f\u6574\u578b\u503c\u3002");
            System.out.println(" \u5f53\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a\u5c0f\u5199\u7684 size \u65f6\uff0c\u5217\u51fa\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u5b50\u76ee\u5f55\u53ca\u6587\u4ef6\u5927\u5c0f\uff1a");
            System.out.println("          \u7b2c\u4e8c\u4e2a\u53c2\u6570\u4e3a\u8981\u5217\u51fa\u5927\u5c0f\u7684\u8def\u5f84\uff1b");
        }
        RandomAccessFile raf = new RandomAccessFile(new File("c:\\test.txt"), "rw");
        FileChannel fc = raf.getChannel();
        FileLock fl = fc.tryLock();
        Thread objThread1 = null;
        Thread objThread2 = null;
        Thread objThread3 = null;
        if (arrayArg.length >= 2 && ("rar".equalsIgnoreCase(FileOperation.getFileExtFromStr(arrayArg[0])) || "zip".equalsIgnoreCase(FileOperation.getFileExtFromStr(arrayArg[0])))) {
            System.out.println("\u89e3\u538b\u6587\u4ef6\uff1a" + arrayArg[0] + " \u5230\u76ee\u5f55\uff1a" + arrayArg[1] + "\r\n\u7ed3\u679c:" + FileOperation.unzipFile(arrayArg[0], arrayArg[1]));
            return;
        }
        String strTestData = "\\/C:\\:?<>|";
        System.out.println(" getValidFileName(\"" + strTestData + "\") => " + FileOperation.getValidFileName(strTestData));
        raf.readLine();
        MappedByteBuffer mbbi = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        if (fl.isValid()) {
            System.out.println("get the lock!");
            objThread1 = new Thread(){

                public void run() {
                    this.setName("\u6d4b\u8bd5\u7ebf\u7a0b");
                    while (!this.isInterrupted()) {
                        try {
                            int c;
                            Thread.sleep(1000L);
                            FileReader fr = new FileReader(new File("c:\\test.txt"));
                            while ((c = fr.read()) != -1) {
                                System.out.print("\u7ebf\u7a0b1");
                                System.out.println((char)c);
                            }
                            fr.close();
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("\u7ebf\u7a0b1\u5f02\u5e38" + e);
                        }
                    }
                }
            };
            objThread1.start();
            objThread2 = new Thread(){

                public void run() {
                    this.setName("\u6d4b\u8bd5\u7ebf\u7a0b2");
                    while (!this.isInterrupted()) {
                        try {
                            String strData;
                            File file = new File("c:\\test.txt");
                            FileInputStream fis = new FileInputStream(file);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
                            FileChannel fcin = fis.getChannel();
                            FileLock flin = null;
                            while ((flin = fcin.tryLock(0L, Long.MAX_VALUE, true)) == null) {
                                System.out.println("2\u6709\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u64cd\u4f5c\u8be5\u6587\u4ef6\uff0c\u5f53\u524d\u7ebf\u7a0b\u4f11\u77201000\u6beb\u79d2");
                                2.sleep(1000L);
                            }
                            byte[] buf = new byte[1024];
                            StringBuffer sb = new StringBuffer();
                            System.out.println("2\u7ebf\u7a0b\u5f00\u59cb\u8bfb");
                            long lStartTime = System.currentTimeMillis();
                            while ((strData = reader.readLine()) != null) {
                                System.out.println("2\u7ebf\u7a0b\u8bfb\u53d6\u6570\u636e:" + strData);
                            }
                            System.out.println("2\u7ebf\u7a0b\u7ed3\u675f" + (System.currentTimeMillis() - lStartTime));
                            flin.release();
                            fcin.close();
                            fis.close();
                            Object var2_3 = null;
                        }
                        catch (Exception e) {
                            System.out.println("\u7ebf\u7a0b2\u5f02\u5e38" + e);
                        }
                    }
                }
            };
            objThread2.start();
            objThread3 = new Thread(){

                public void run() {
                    this.setName("\u6d4b\u8bd5\u7ebf\u7a0b3");
                    while (!this.isInterrupted()) {
                        try {
                            FileLock objLock;
                            File objListFile = new File("c:\\test.txt");
                            BufferedRandomAccessFile objFile = new BufferedRandomAccessFile(objListFile, "rw");
                            FileChannel objChannel = objFile.getChannel();
                            while ((objLock = objChannel.tryLock(0L, Long.MAX_VALUE, true)) == null) {
                                System.out.println("3\u6709\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u64cd\u4f5c\u8be5\u6587\u4ef6\uff0c\u5f53\u524d\u7ebf\u7a0b\u4f11\u77201000\u6beb\u79d2");
                                3.sleep(1000L);
                            }
                            StringBuffer sb = new StringBuffer();
                            long lStartTime = System.currentTimeMillis();
                            System.out.println("3\u7ebf\u7a0b\u8bfb\u53d6\u6570\u636e: " + objFile.getFilePointer());
                            System.out.println("3\u7ebf\u7a0b\u7ed3\u675f" + (System.currentTimeMillis() - lStartTime) + " \u7ed3\u679c:" + sb.toString());
                            objLock.release();
                            objFile.close();
                            Object var2_3 = null;
                        }
                        catch (Exception e) {
                            System.out.println("\u7ebf\u7a0b3\u5f02\u5e38" + e);
                        }
                    }
                }
            };
            objThread3.start();
            Thread.sleep(200L);
            raf.write("kingfish(\u516b\u767e\u91cc\u79e6\u5ddd@\u9f99\u57ce\u5f02\u5ba2)\r\n".getBytes());
            raf.write("\u7b2c\u4e8c\u884c".getBytes());
            System.out.println("\u5199\u6570\u636e\u3002");
            Thread.sleep(1000L);
            System.out.println("release the lock!");
            fl.release();
        }
        raf.close();
        Thread.sleep(2000L);
        System.out.println("\u7ed3\u675f\u3002");
        objThread1.interrupt();
        objThread2.interrupt();
        objThread3.interrupt();
        System.exit(0);
        FileOperation objTest = new FileOperation();
        File fileNew = new File("c:\\AUTOEXEC.BAT");
        String strFile = "c:\\myTest\\1\\2\\3\\11.bmp";
        String strDir = "c:\\myTest\\1\\2\\3-1\\4\\";
        strFile = "C:\\S";
        strDir = "C:\\D";
        log.debug("copyFile\u7ed3\u679c\uff1a" + objTest.copyFile(strFile, strDir, true, true) + objTest.getErrorMessage());
        strDir = "E:\\PTHL\\site\\doc";
        log.debug(strDir + "\u4e2d\u7684\u6587\u4ef6\uff1a");
        String[] arrayFile = objTest.listAllFile(strDir, true, false);
        for (int n = 0; n < arrayFile.length; ++n) {
            System.out.println(arrayFile[n]);
        }
        if (!objTest.copyFile("c:\\codestyle2.bmp", strFile)) {
            log.debug("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff1a" + objTest.getErrorMessage());
        }
        if (!objTest.moveFile(strFile, strDir)) {
            log.debug("\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff1a" + objTest.getErrorMessage());
        }
    }

    static {
        Runtime runtime = Runtime.getRuntime();
        Class<?> c = runtime.getClass();
        try {
            Method m = c.getMethod("addShutdownHook", Thread.class);
            ShutdownThread objThread = new ShutdownThread();
            objThread.setThreadInfo();
            m.invoke((Object)runtime, objThread);
        }
        catch (NoSuchMethodException m) {
        }
        catch (IllegalArgumentException m) {
        }
        catch (InvocationTargetException m) {
        }
        catch (Exception e) {
            log.debug("\u521b\u5efa\u6587\u4ef6\u5173\u95ed\u76d1\u63a7\u7ebf\u7a0b\u65f6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private static class IncludeExcludeFileFilter
    implements FileFilter {
        private StringList m_lstInclude;
        private StringList m_lstExclude;

        IncludeExcludeFileFilter(String strInclude, String strExclude) {
            if (strInclude != null && strInclude.length() > 0) {
                this.m_lstInclude = new StringList();
                this.m_lstInclude.add(strInclude);
            }
            if (strExclude != null && strExclude.length() > 0) {
                this.m_lstExclude = new StringList();
                this.m_lstExclude.add(strExclude);
            }
        }

        IncludeExcludeFileFilter(String[] arrayInclude, String[] arrayExclude) {
            int n;
            if (arrayInclude != null && arrayInclude.length > 0) {
                this.m_lstInclude = new StringList(arrayInclude.length);
                for (n = 0; n < arrayInclude.length; ++n) {
                    if (arrayInclude[n] == null || arrayInclude[n].length() <= 0) continue;
                    this.m_lstInclude.add(arrayInclude[n]);
                }
                if (this.m_lstInclude.size() == 0) {
                    this.m_lstInclude = null;
                }
            }
            if (arrayExclude != null && arrayExclude.length > 0) {
                this.m_lstExclude = new StringList(arrayExclude.length);
                for (n = 0; n < arrayExclude.length; ++n) {
                    if (arrayExclude[n] == null || arrayExclude[n].length() <= 0) continue;
                    this.m_lstExclude.add(arrayExclude[n]);
                }
                if (this.m_lstExclude.size() == 0) {
                    this.m_lstExclude = null;
                }
            }
        }

        IncludeExcludeFileFilter(StringList lstInclude, StringList lstExclude) {
            String strVal;
            int n;
            if (lstInclude != null && lstInclude.size() > 0) {
                this.m_lstInclude = new StringList(lstInclude.size());
                for (n = 0; n < lstInclude.size(); ++n) {
                    strVal = lstInclude.getString(n);
                    if (strVal == null || strVal.length() <= 0) continue;
                    this.m_lstInclude.add(strVal);
                }
                if (this.m_lstInclude.size() == 0) {
                    this.m_lstInclude = null;
                }
            }
            if (lstExclude != null && lstExclude.size() > 0) {
                this.m_lstExclude = new StringList(lstExclude.size());
                for (n = 0; n < lstExclude.size(); ++n) {
                    strVal = lstExclude.getString(n);
                    if (strVal == null || strVal.length() <= 0) continue;
                    this.m_lstExclude.add(strVal);
                }
                if (this.m_lstExclude.size() == 0) {
                    this.m_lstExclude = null;
                }
            }
        }

        public boolean accept(File objFile) {
            String strFullPath = objFile.getAbsolutePath();
            try {
                int n;
                if (this.m_lstExclude != null) {
                    for (n = 0; n < this.m_lstExclude.size(); ++n) {
                        if (!strFullPath.matches(this.m_lstExclude.getString(n))) continue;
                        return false;
                    }
                }
                if (this.m_lstInclude != null) {
                    for (n = 0; n < this.m_lstInclude.size(); ++n) {
                        if (!strFullPath.matches(this.m_lstInclude.getString(n))) continue;
                        return true;
                    }
                    return false;
                }
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u201c" + strFullPath + "\u201d\u5339\u914d" + (this.m_lstExclude != null ? "\u6392\u9664\u6761\u4ef6\uff1a" + this.m_lstExclude : "") + (this.m_lstInclude != null ? "\u5305\u542b\u6761\u4ef6\uff1a" + this.m_lstInclude : "") + "\u65f6\u5f02\u5e38", (Throwable)e);
            }
            return true;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private void setThreadInfo() {
            try {
                this.setPriority(5);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setName("\u6587\u4ef6\u64cd\u4f5c\u5bf9\u8c61\u5173\u95ed\u7ebf\u7a0b");
        }

        public void run() {
            try {
                long lCount = 0L;
                while (g_lstTask != null && g_lstTask.size() > 0) {
                    ShutdownThread.sleep(10L);
                    if (++lCount % 500L != 0L) continue;
                    log.info("XML\u5c5e\u6027\u5904\u7406\u7b49\u5f85\u5173\u95ed\u5df2\u5c1d\u8bd5\u6b21\u6570" + lCount);
                }
            }
            catch (Throwable e) {
                log.debug("\u7b49\u5f85\u6587\u4ef6\u64cd\u4f5c\u5bf9\u8c61\u5173\u95ed\u65f6\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        }
    }
}

