/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Base64;
import com.hynnet.util.EncryptionInterface;
import com.hynnet.util.MD5;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Encryption implements EncryptionInterface
{
    AES_128_CBC{

        public String encode(byte[] datas) {
            log.error("AES-128-CBC\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u52a0\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            log.info("AES-128-CBC\u4e00\u822c\u9700\u8981\u504f\u79fb\u91cf\u52a0\u5bc6");
            return this.encode(datas, key, key);
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            if (null != datas) {
                try {
                    SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    cipher.init(1, (Key)skeySpec, ivSpec);
                    return cipher.doFinal(datas);
                }
                catch (Exception e) {
                    log.error("AES-128-CBC\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] decode(byte[] datas) {
            log.error("AES-128-CBC\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.info("AES-128-CBC\u4e00\u822c\u9700\u8981\u504f\u79fb\u91cf\u89e3\u5bc6");
            return this.decode(datas, key, key);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            if (datas != null) {
                try {
                    SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    cipher.init(2, (Key)skeySpec, ivSpec);
                    return cipher.doFinal(datas);
                }
                catch (Exception e) {
                    log.error("AES-12-CBC\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("AES-128-CBC\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("AES-128-CBC\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    AES_CBC_NOPADDING{

        public String encode(byte[] datas) {
            log.error("AES/CBC/NoPadding\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u52a0\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            return this.encode(datas, key, key);
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            if (null != datas) {
                try {
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    int blockSize = cipher.getBlockSize();
                    int plaintextLength = datas.length;
                    if (plaintextLength % blockSize != 0) {
                        plaintextLength += blockSize - plaintextLength % blockSize;
                    }
                    byte[] plaintext = new byte[plaintextLength];
                    System.arraycopy(datas, 0, plaintext, 0, datas.length);
                    SecretKeySpec keyspec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    cipher.init(1, (Key)keyspec, ivSpec);
                    return cipher.doFinal(plaintext);
                }
                catch (Exception e) {
                    log.error("AES/CBC/NoPadding\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] decode(byte[] datas) {
            log.error("AES/CBC/NoPadding\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return this.decode(datas, key, key);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            if (datas != null) {
                try {
                    SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(2, (Key)skeySpec, ivSpec);
                    return cipher.doFinal(datas);
                }
                catch (Exception e) {
                    log.error("AES/CBC/NoPadding\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("AES/CBC/NoPadding\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("AES/CBC/NoPadding\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    AES_ECB_PKCS5PADDING{

        public String encode(byte[] datas) {
            log.error("AES/ECB/PKCS5Padding\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u52a0\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            return this.encode(datas, key, null);
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            if (null != datas) {
                try {
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    int blockSize = cipher.getBlockSize();
                    int plaintextLength = datas.length;
                    if (plaintextLength % blockSize != 0) {
                        plaintextLength += blockSize - plaintextLength % blockSize;
                    }
                    byte[] plaintext = new byte[plaintextLength];
                    System.arraycopy(datas, 0, plaintext, 0, datas.length);
                    SecretKeySpec keyspec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv != null ? iv : "0000000000000000".getBytes());
                    cipher.init(1, (Key)keyspec, ivSpec);
                    return cipher.doFinal(plaintext);
                }
                catch (Exception e) {
                    log.error("AES/ECB/PKCS5Padding\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] decode(byte[] datas) {
            log.error("AES/ECB/PKCS5Padding\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return this.decode(datas, key, key);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            if (datas != null) {
                try {
                    SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    cipher.init(2, (Key)skeySpec, ivSpec);
                    return cipher.doFinal(datas);
                }
                catch (Exception e) {
                    log.error("AES/ECB/PKCS5Padding\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
            return null;
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("AES/ECB/PKCS5Padding\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("AES/ECB/PKCS5Padding\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    SHA{

        public String encode(byte[] datas) {
            StringBuffer result = null;
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA");
                byte[] bytes = sha.digest(datas);
                result = new StringBuffer(bytes.length * 2);
                for (int i = 0; i < bytes.length; ++i) {
                    int byteValue = bytes[i] + 127;
                    String hex = Long.toHexString(byteValue).toUpperCase();
                    result.append(hex);
                }
                return result.toString();
            }
            catch (Exception e) {
                log.error("SHA\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA");
                return sha.digest(datas);
            }
            catch (Exception e) {
                log.error("SHA\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("SHA\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("SHA\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("SHA\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("SHA\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    SHA1{

        public String encode(byte[] datas) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                return HEX.encode(sha.digest(datas));
            }
            catch (Exception e) {
                log.error("SHA-1\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                return sha.digest(datas);
            }
            catch (Exception e) {
                log.error("SHA-1\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("SHA-1\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("SHA-1\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("SHA-1\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("SHA-1\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    HMAC_SHA1{

        public String encode(byte[] datas) {
            log.error("HMAC SHA-1\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u52a0\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                if (key != null && key.length > 0) {
                    Mac mac = Mac.getInstance("HmacSHA1");
                    SecretKeySpec secret = new SecretKeySpec(key, mac.getAlgorithm());
                    mac.init(secret);
                    return mac.doFinal(datas);
                }
                log.error("HMAC SHA-1\u52a0\u5bc6\u65f6\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
                return null;
            }
            catch (Exception e) {
                log.error("HMAC SHA-1\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("HMAC SHA-1\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("HMAC SHA-1\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("HMAC SHA-1\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("HMAC SHA-1\u4e0d\u652f\u6301\u6570\u5b57\u6821\u9a8c");
            return false;
        }
    }
    ,
    HMAC_SHA256{

        public String encode(byte[] datas) {
            log.error("HMAC SHA256\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u7f16\u7801");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                SecretKeySpec secret_key = new SecretKeySpec(key, "HmacSHA256");
                Mac sha256_HMAC = Mac.getInstance(secret_key.getAlgorithm());
                sha256_HMAC.init(secret_key);
                return sha256_HMAC.doFinal(datas);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("\u7b97\u6cd5\u4e0d\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            catch (InvalidKeyException e) {
                log.error("\u5bc6\u94a5\u65e0\u6548\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("HMAC SHA256\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u7f16\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("HMAC_SHA256\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("HMAC_SHA256\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    HMAC_SHA512{

        public String encode(byte[] datas) {
            log.error("HMAC SHA512\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u7f16\u7801");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                SecretKeySpec secret_key = new SecretKeySpec(key, "HmacSHA512");
                Mac mac = Mac.getInstance(secret_key.getAlgorithm());
                mac.init(secret_key);
                return mac.doFinal(datas);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("\u7b97\u6cd5\u4e0d\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            catch (InvalidKeyException e) {
                log.error("\u5bc6\u94a5\u65e0\u6548\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("HMAC SHA512\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u7f16\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("HMAC_SHA512\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("HMAC_SHA512\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    RSA_PRIVATE_KEY{

        public String encode(byte[] datas) {
            log.error("RSA\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u52a0\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(1, privateKey);
                return cipher.doFinal(datas);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("\u65e0\u7b97\u6cd5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                log.error("\u5bc6\u94a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                log.error("\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            catch (InvalidKeyException e) {
                log.error("\u5bc6\u94a5\u65e0\u6548\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                log.error("\u5757\u5927\u5c0f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            catch (BadPaddingException e) {
                log.error("\u52a0\u5bc6\u586b\u5145\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("RSA\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(2, privateKey);
                return cipher.doFinal(datas);
            }
            catch (Exception e) {
                log.error("\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return null;
            }
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            try {
                PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey2 = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initSign(privateKey2);
                signature.update(datas);
                return signature.sign();
            }
            catch (Exception e) {
                log.error("RSA\u79c1\u94a5\u6570\u5b57\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return null;
            }
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("RSA\u4f7f\u7528\u516c\u94a5\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return RSA_PUBLIC_KEY.verify(datas, key, sign);
        }
    }
    ,
    RSA_PUBLIC_KEY{

        public String encode(byte[] datas) {
            log.error("RSA\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            try {
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(1, publicKey);
                return cipher.doFinal(datas);
            }
            catch (Exception e) {
                log.error("RSA\u516c\u94a5\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("RSA\u4e0d\u652f\u6301\u65e0\u5bc6\u94a5\u89e3\u5bc6");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            try {
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(2, publicKey);
                return cipher.doFinal(datas);
            }
            catch (Exception e) {
                log.error("RSA\u516c\u94a5\u89e3\u5bc6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return null;
            }
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("RSA\u4f7f\u7528\u79c1\u94a5\u8fdb\u884c\u6570\u5b57\u7b7e\u540d");
            return RSA_PRIVATE_KEY.sign(datas, key);
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            try {
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initVerify(publicKey2);
                signature.update(datas);
                return signature.verify(sign);
            }
            catch (Exception e) {
                log.error("RSA\u516c\u94a5\u8fdb\u884c\u6570\u5b57\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return false;
            }
        }
    }
    ,
    MD5{

        public String encode(byte[] datas) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("JDK MD5\u521d\u59cb\u5316\u5931\u8d25\uff0c\u81ea\u52a8\u91c7\u7528FastMD5\u5904\u7406");
                return FASTMD5.encode(datas);
            }
            digest.update(datas);
            String res = com.hynnet.util.MD5.toHex(digest.digest());
            return res;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("JDK MD5\u521d\u59cb\u5316\u5931\u8d25\uff0c\u81ea\u52a8\u91c7\u7528FastMD5\u5904\u7406");
                return FASTMD5.encode(datas, key);
            }
            digest.update(datas);
            return digest.digest();
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    MD5_16BIT{

        public String encode(byte[] datas) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("JDK MD5\u521d\u59cb\u5316\u5931\u8d25\uff0c\u81ea\u52a8\u91c7\u7528FastMD5\u5904\u7406");
                return FASTMD5.encode(datas);
            }
            digest.update(datas);
            String res = com.hynnet.util.MD5.toHex(digest.digest());
            return res.substring(8, 24);
        }

        public byte[] encode(byte[] datas, byte[] key) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("JDK MD5\u521d\u59cb\u5316\u5931\u8d25\uff0c\u81ea\u52a8\u91c7\u7528FastMD5\u5904\u7406");
                return FASTMD5.encode(datas, key);
            }
            digest.update(datas);
            byte[] res = new byte[16];
            System.arraycopy(digest.digest(), 8, res, 0, 16);
            return res;
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    FASTMD5{

        public String encode(byte[] datas) {
            return com.hynnet.util.MD5.hash(datas);
        }

        public byte[] encode(byte[] datas, byte[] key) {
            String result = com.hynnet.util.MD5.hash(datas);
            try {
                return result != null ? result.getBytes("UTF-8") : null;
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u83b7\u53d6\u201c{}\u201d\u7684\u5b57\u8282\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)result, (Object)e.getMessage());
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u89e3\u7801");
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("MD5\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    Base64{

        public String encode(byte[] datas) {
            return com.hynnet.util.Base64.encodeBytes(datas);
        }

        public byte[] encode(byte[] datas, byte[] key) {
            String result = com.hynnet.util.Base64.encodeBytes(datas);
            try {
                return result != null ? result.getBytes("UTF-8") : null;
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u83b7\u53d6\u201c{}\u201d\u7684\u5b57\u8282\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)result, (Object)e.getMessage());
                return null;
            }
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            return com.hynnet.util.Base64.decode(datas, 0, datas.length);
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return com.hynnet.util.Base64.decode(datas, 0, datas.length);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("Base64\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("Base64\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    HEX{

        public String encode(byte[] datas) {
            return com.hynnet.util.MD5.toHex(datas);
        }

        public byte[] encode(byte[] datas, byte[] key) {
            log.error("HEX\u4e0d\u652f\u6301\u901a\u8fc7\u5bc6\u94a5\u7f16\u7801");
            return this.encode(datas).getBytes();
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return this.encode(datas, key);
        }

        public byte[] decode(byte[] datas) {
            int len = datas.length;
            if ((len & 1) != 0) {
                log.error("\u8f93\u5165\u7684\u5b57\u8282\u6570\u4e3a\u5947\u6570\uff1a{}", (Object)len);
                return null;
            }
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                int f = Encryption.toDigit(datas[j], j) << 4;
                f |= Encryption.toDigit(datas[++j], j);
                ++j;
                out[i] = (byte)(f & 0xFF);
                ++i;
            }
            return out;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            log.error("HEX\u4e0d\u652f\u6301\u5e26\u5bc6\u94a5\u89e3\u7801");
            return this.decode(datas);
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return this.decode(datas, key);
        }

        public byte[] sign(byte[] datas, byte[] key) {
            log.error("HEX\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
            return this.encode(datas).getBytes();
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            log.error("HEX\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d\u6821\u9a8c");
            return false;
        }
    }
    ,
    UNKNOWN{

        public String encode(byte[] datas) {
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key) {
            return null;
        }

        public byte[] encode(byte[] datas, byte[] key, byte[] iv) {
            return null;
        }

        public byte[] decode(byte[] datas) {
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key) {
            return null;
        }

        public byte[] decode(byte[] datas, byte[] key, byte[] iv) {
            return null;
        }

        public byte[] sign(byte[] datas, byte[] key) {
            return null;
        }

        public boolean verify(byte[] datas, byte[] key, byte[] sign) {
            return false;
        }
    };

    private static final Logger log;

    public static Encryption get(String methodName) {
        if (methodName != null && (methodName = methodName.trim().toUpperCase()).length() > 0) {
            if ("MD5".equals(methodName)) {
                return MD5;
            }
            if ("SHA".equals(methodName)) {
                return SHA;
            }
            if ("BASE64".equals(methodName)) {
                return Base64;
            }
            if ("HMACSHA256".equals(methodName) || "HMAC_SHA256".equals(methodName) || "HMAC SHA256".equals(methodName) || "HMAC-SHA256".equals(methodName)) {
                return HMAC_SHA256;
            }
        }
        return UNKNOWN;
    }

    private static int toDigit(byte ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            log.error("Illegal hexadecimal character {} at index {}", (Object)Character.valueOf((char)ch), (Object)index);
        }
        return digit;
    }

    static {
        log = LoggerFactory.getLogger(Encryption.class);
    }
}

