/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAGen {
    public static void main(String[] argv) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("\r\n1\u3001\u751f\u6210\u5bc6\u94a5\u5bf9\t2\u3001\u4ea7\u751f\u7b7e\u540d\u6570\u636e\t3\u3001\u7b7e\u540d\u6821\u9a8c");
        String strFunction = null;
        int iFunction = -1;
        try {
            LineNumberReader objin = new LineNumberReader(new InputStreamReader(System.in));
            System.out.print("\r\n\u8bf7\u8f93\u5165\u60a8\u7684\u9009\u62e9\uff1a");
            strFunction = objin.readLine();
            iFunction = Integer.parseInt(strFunction);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        String strPubKeyFile = null;
        String strPriKeyFile = null;
        String strMyInfoFile = null;
        String strMySigFile = null;
        String strInfo = null;
        boolean bHex = false;
        switch (iFunction) {
            case 1: {
                try {
                    LineNumberReader objin = new LineNumberReader(new InputStreamReader(System.in));
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u516c\u94a5\u6587\u4ef6\u540d(myPubKey.dat)\uff1a");
                    strPubKeyFile = objin.readLine();
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u79c1\u94a5\u6587\u4ef6\u540d(myPriKey.dat)\uff1a");
                    strPriKeyFile = objin.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                    return;
                }
                if (strPubKeyFile == null || "".equals(strPubKeyFile)) {
                    strPubKeyFile = "myPubKey.dat";
                }
                if (strPriKeyFile == null || "".equals(strPriKeyFile)) {
                    strPriKeyFile = "myPriKey.dat";
                }
                if (!DSAGen.KeyGen(strPubKeyFile, strPriKeyFile)) {
                    System.out.print("\r\n\u751f\u6210\u5bc6\u94a5\u5931\u8d25\uff01");
                    break;
                }
                System.out.print("\r\n\u751f\u6210\u5bc6\u94a5\u6210\u529f\u3002");
                break;
            }
            case 2: {
                try {
                    LineNumberReader objin = new LineNumberReader(new InputStreamReader(System.in));
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u79c1\u94a5\u6587\u4ef6\u540d(myPriKey.dat)\uff1a");
                    strPriKeyFile = objin.readLine();
                    System.out.print("\r\n\u79c1\u94a5\u662f\u5426\u4e3aHex\u683c\u5f0f(no)\uff1a");
                    String strHex = objin.readLine();
                    if ("yes".equals(strHex)) {
                        bHex = true;
                    }
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u4fe1\u606f\u6587\u4ef6\u540d(myInfo.dat)\uff1a");
                    strMyInfoFile = objin.readLine();
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u7b7e\u540d\u6587\u4ef6\u540d(mySig.dat)\uff1a");
                    strMySigFile = objin.readLine();
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u52a0\u5bc6\u7684\u4fe1\u606f\uff1a");
                    strInfo = objin.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                    return;
                }
                if (strPriKeyFile == null || "".equals(strPriKeyFile)) {
                    strPriKeyFile = "myPriKey.dat";
                }
                if (strMyInfoFile == null || "".equals(strMyInfoFile)) {
                    strMyInfoFile = "myInfo.dat";
                }
                if (strMySigFile == null || "".equals(strMySigFile)) {
                    strMySigFile = "mySig.dat";
                }
                if (!DSAGen.InfoGen(strPriKeyFile, strMyInfoFile, strMySigFile, strInfo, bHex)) {
                    System.out.print("\r\n\u52a0\u5bc6\u5931\u8d25\uff01");
                    break;
                }
                System.out.print("\r\n\u52a0\u5bc6\u6210\u529f\u3002");
                break;
            }
            case 3: {
                try {
                    LineNumberReader objin = new LineNumberReader(new InputStreamReader(System.in));
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u516c\u94a5\u6587\u4ef6\u540d(myPubKey.dat)\uff1a");
                    strPubKeyFile = objin.readLine();
                    System.out.print("\r\n\u79c1\u94a5\u662f\u5426\u4e3aHex\u683c\u5f0f(no)\uff1a");
                    String strHex = objin.readLine();
                    if ("yes".equals(strHex)) {
                        bHex = true;
                    }
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u4fe1\u606f\u6587\u4ef6\u540d(myInfo.dat)\uff1a");
                    strMyInfoFile = objin.readLine();
                    System.out.print("\r\n\u8bf7\u8f93\u5165\u7b7e\u540d\u6587\u4ef6\u540d(mySig.dat)\uff1a");
                    strMySigFile = objin.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                    return;
                }
                if (strPubKeyFile == null || "".equals(strPubKeyFile)) {
                    strPubKeyFile = "myPubKey.dat";
                }
                if (strMyInfoFile == null || "".equals(strMyInfoFile)) {
                    strMyInfoFile = "myInfo.dat";
                }
                if (strMySigFile == null || "".equals(strMySigFile)) {
                    strMySigFile = "mySig.dat";
                }
                if (!DSAGen.InfoCheck(strPubKeyFile, strMyInfoFile, strMySigFile, bHex)) {
                    System.out.print("\r\n\u6821\u9a8c\u5931\u8d25\uff01");
                    break;
                }
                System.out.print("\r\n\u6821\u9a8c\u6210\u529f\u3002");
                break;
            }
        }
        System.out.println("\r\n");
    }

    public static boolean KeyGen(String pubKeyFile, String priKeyFile) {
        try {
            KeyPairGenerator keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024);
            KeyPair keys = keygen.generateKeyPair();
            PublicKey pubkey = keys.getPublic();
            PrivateKey prikey = keys.getPrivate();
            System.out.println("\u516c\u94a5\u683c\u5f0f\uff1a" + pubkey.getFormat());
            System.out.println("\u79c1\u94a5\u683c\u5f0f\uff1a" + prikey.getFormat());
            FileOutputStream outFile = new FileOutputStream(priKeyFile);
            outFile.write(prikey.getEncoded());
            outFile.close();
            outFile = new FileOutputStream(pubKeyFile);
            outFile.write(pubkey.getEncoded());
            outFile.close();
            outFile = new FileOutputStream(pubKeyFile + ".txt");
            outFile.write(DSAGen.encodeHex(pubkey.getEncoded()).getBytes());
            outFile.close();
        }
        catch (Exception e) {
            System.out.println("Error!");
            e.printStackTrace();
            System.out.println("\r\n");
            return false;
        }
        return true;
    }

    public static boolean InfoGen(String priKeyFile, String infoFile, String sigFile, String myinfo, boolean bHex) {
        try {
            FileInputStream inFile = new FileInputStream(priKeyFile);
            File fileRead = new File(priKeyFile);
            byte[] abyte0 = new byte[(int)fileRead.length()];
            inFile.read(abyte0);
            inFile.close();
            if (bHex) {
                String data = new String(abyte0, 0, abyte0.length);
                abyte0 = DSAGen.decodeHex(data);
            }
            PKCS8EncodedKeySpec pkcs8encodedkeyspec = new PKCS8EncodedKeySpec(abyte0);
            KeyFactory keyfactory = KeyFactory.getInstance("DSA");
            PrivateKey myprikey = keyfactory.generatePrivate(pkcs8encodedkeyspec);
            System.out.println("\u79c1\u94a5\u683c\u5f0f\uff1a" + myprikey.getFormat());
            Signature signet = Signature.getInstance("DSA");
            signet.initSign(myprikey);
            signet.update(myinfo.getBytes());
            byte[] signed = signet.sign();
            FileOutputStream outFile = new FileOutputStream(infoFile);
            outFile.write(myinfo.getBytes());
            outFile.close();
            outFile = new FileOutputStream(sigFile);
            outFile.write(signed);
            outFile.close();
        }
        catch (Exception e) {
            System.out.println("Error!");
            e.printStackTrace();
            System.out.println("\r\n");
            return false;
        }
        return true;
    }

    public static boolean InfoCheck(String pubKeyFile, String infoFile, String sigFile, boolean bHex) {
        try {
            int iRead;
            FileInputStream inFile = new FileInputStream(pubKeyFile);
            File fileRead = new File(pubKeyFile);
            byte[] abyte0 = new byte[(int)fileRead.length()];
            inFile.read(abyte0);
            inFile.close();
            if (bHex) {
                String data = new String(abyte0, 0, abyte0.length);
                abyte0 = DSAGen.decodeHex(data);
            }
            X509EncodedKeySpec x509encodedkeyspec = new X509EncodedKeySpec(abyte0);
            KeyFactory keyfactory = KeyFactory.getInstance("DSA");
            PublicKey pubkey = keyfactory.generatePublic(x509encodedkeyspec);
            System.out.println("\u516c\u94a5\u683c\u5f0f\uff1a" + pubkey.getFormat());
            StringBuffer buf = new StringBuffer();
            byte[] readBuf = new byte[50];
            inFile = new FileInputStream(infoFile);
            while ((iRead = inFile.read(readBuf)) > 0) {
                buf.append(new String(readBuf, 0, iRead));
            }
            inFile.close();
            String info = buf.toString();
            fileRead = new File(sigFile);
            byte[] signed = new byte[(int)fileRead.length()];
            inFile = new FileInputStream(sigFile);
            inFile.read(signed);
            inFile.close();
            Signature signetcheck = Signature.getInstance("DSA");
            signetcheck.initVerify(pubkey);
            signetcheck.update(info.getBytes());
            if (!signetcheck.verify(signed)) {
                System.out.println("\u975e\u6b63\u5e38\u7b7e\u540d");
                return false;
            }
            System.out.println("info = " + info + "\t\u7b7e\u540d\u5927\u5c0f\uff1a" + signed.length);
            System.out.println("\u7b7e\u540d\u6b63\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final byte[] decodeHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCount = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | DSAGen.hexCharToByte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (byte)(newByte | DSAGen.hexCharToByte(chars[i + 1]));
            ++byteCount;
        }
        return bytes;
    }

    private static final byte hexCharToByte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }
}

