/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.ConfProperties;
import com.hynnet.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.Configuration");
    private static final String CONFIGURATION_FILE = "config.properties";
    private static ConfProperties g_objConfiguration;
    public static File g_objConfigFile;

    public static synchronized boolean readConfigFile(File objFile) {
        try {
            FileInputStream objConfigurationStream = new FileInputStream(objFile);
            g_objConfiguration = new ConfProperties();
            g_objConfiguration.load(objConfigurationStream);
            objConfigurationStream.close();
            g_objConfigFile = objFile;
            return true;
        }
        catch (IOException e) {
            String strMsg = g_objConfigFile != null ? "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff1a" + g_objConfigFile.getAbsolutePath() : "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002";
            log.warn(strMsg);
            return false;
        }
    }

    public static synchronized boolean readConfigFile(InputStream objStream) throws IOException {
        g_objConfiguration = new ConfProperties();
        g_objConfiguration.load(objStream);
        return true;
    }

    public static void loadConfigFile(String strConfigFilePath) {
        try {
            File objConfigFile = new File(strConfigFilePath);
            if (objConfigFile.exists() && objConfigFile.isFile()) {
                Configuration.readConfigFile(objConfigFile);
                return;
            }
            URL[] arrayURL = new URL[1];
            InputStream objConfigurationStream = Util.getResourceAsStream(strConfigFilePath, Configuration.class, arrayURL);
            g_objConfiguration = new ConfProperties();
            if (objConfigurationStream != null) {
                g_objConfiguration.load(objConfigurationStream);
                objConfigurationStream.close();
                log.info("\u914d\u7f6e\u6587\u4ef6\uff1a" + arrayURL[0].toString());
            }
        }
        catch (IOException e) {
            log.warn("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    public static void readConfigFile() {
        try {
            FileInputStream configurationStream = new FileInputStream(g_objConfigFile);
            g_objConfiguration = new ConfProperties();
            g_objConfiguration.load(configurationStream);
            configurationStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfiguration() {
        try {
            g_objConfiguration.store(new FileOutputStream(g_objConfigFile), "e-Commerce System");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String get(String key, String defaultValue) {
        String value = null;
        try {
            value = g_objConfiguration.getProperty(key, defaultValue);
        }
        catch (NullPointerException e) {
            try {
                Configuration.loadConfigFile(CONFIGURATION_FILE);
                value = g_objConfiguration.getProperty(key, defaultValue);
            }
            catch (NullPointerException eg) {
                value = defaultValue;
            }
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String get(String key) {
        String value = null;
        try {
            value = g_objConfiguration.getProperty(key);
        }
        catch (NullPointerException e) {
            try {
                Configuration.loadConfigFile(CONFIGURATION_FILE);
                value = g_objConfiguration.getProperty(key);
            }
            catch (NullPointerException eg) {
                value = "";
            }
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public static int get(String key, int nDefaultValue) {
        try {
            return Integer.parseInt(Configuration.get(key, String.valueOf(nDefaultValue)));
        }
        catch (Exception e) {
            return nDefaultValue;
        }
    }

    public static long get(String key, long lDefaultValue) {
        try {
            return Long.parseLong(Configuration.get(key, String.valueOf(lDefaultValue)));
        }
        catch (Exception e) {
            return lDefaultValue;
        }
    }

    public static boolean get(String strKey, boolean bDefaultValue) {
        String strValue = Configuration.get(strKey, String.valueOf(String.valueOf(bDefaultValue))).trim().toLowerCase();
        if ("1".equals(strValue) || "true".equals(strValue)) {
            return true;
        }
        if ("0".equals(strValue) || "false".equals(strValue)) {
            return false;
        }
        return bDefaultValue;
    }

    public static String[] getKey(String strKeyPrefix) {
        return g_objConfiguration.getPropertyName(strKeyPrefix);
    }

    public static void set(String strKey, String strValue) {
        g_objConfiguration.setProperty(strKey, strValue);
    }

    public static void main(String[] args) {
        log.debug(Configuration.get("dbuser", "dbuser"));
        log.debug(Configuration.get("dbuser"));
    }

    static {
        g_objConfigFile = null;
    }
}

