/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.StringList;
import com.hynnet.util.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class ConfProperties
extends Properties {
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String DEFAULT_MEMO = "";
    private Hashtable m_mapMemo = new Hashtable();
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String getMemo(String strKey) {
        StringList lstMemo;
        if (this.m_mapMemo.containsKey(strKey) && (lstMemo = (StringList)this.m_mapMemo.get(strKey)) != null && lstMemo.size() > 0) {
            StringBuffer sbufResult = new StringBuffer();
            for (int n = 0; n < lstMemo.size(); ++n) {
                String strMemo;
                if (n > 0) {
                    sbufResult.append("\r\n");
                }
                if ((strMemo = lstMemo.getString(n)).startsWith("##")) {
                    sbufResult.append(strMemo);
                    continue;
                }
                if (strMemo.startsWith("#")) {
                    sbufResult.append("# ").append(strMemo.substring(1).trim());
                    continue;
                }
                sbufResult.append(strMemo);
            }
            return sbufResult.toString();
        }
        return DEFAULT_MEMO;
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append(aChar);
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        StringList lstKey = new StringList();
        String strLastKey = null;
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            ConfProperties.writeln(awriter, "#" + header);
        }
        ConfProperties.writeln(awriter, "#" + new Date().toString());
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            lstKey.add((String)e.nextElement());
        }
        Object[] arrayKey = lstKey.toStringArray();
        Arrays.sort(arrayKey);
        for (int n = 0; n < arrayKey.length; ++n) {
            int nIndexDot;
            Object key = arrayKey[n];
            String val = (String)this.get(key);
            String strMemo = this.getMemo((String)key);
            if (!("system.app.name".equals(key = this.saveConvert((String)key, true)) || "system.email.administrator".equals(key) || ((String)key).toLowerCase().startsWith("message."))) {
                val = this.saveConvert(val, false);
            }
            if ((nIndexDot = ((String)key).indexOf(46)) > 0) {
                if (!((String)key).substring(0, nIndexDot).equals(strLastKey)) {
                    strLastKey = ((String)key).substring(0, nIndexDot);
                    ConfProperties.writeln(awriter, DEFAULT_MEMO);
                }
            } else {
                ConfProperties.writeln(awriter, DEFAULT_MEMO);
            }
            if (strMemo.length() > 0) {
                ConfProperties.writeln(awriter, strMemo);
            }
            ConfProperties.writeln(awriter, (String)key + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public synchronized void load(InputStream inStream) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        LineReader lr = new LineReader(inStream);
        int nFirstLine = 0;
        StringList lstMemo = new StringList();
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            if (lr.isCommentLine() && nFirstLine >= 2) {
                lstMemo.add(StringUtils.ascii2Native(new String(lr.lineBuf, 0, limit), "ISO8859_1"));
                continue;
            }
            if (lr.isCommentLine()) {
                ++nFirstLine;
                continue;
            }
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            char[] arrayValue = this.converNative(lr.lineBuf, valueStart, limit - valueStart);
            String value = this.loadConvert(arrayValue, 0, arrayValue.length, convtBuf);
            this.put(key, value);
            if (lstMemo.size() <= 0) continue;
            this.m_mapMemo.put(key, lstMemo);
            lstMemo = new StringList();
        }
    }

    public String[] getPropertyName(String strKeyPrefix) {
        StringList lstName = new StringList(this.size());
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String strName = (String)e.nextElement();
            if (strName == null || !strName.startsWith(strKeyPrefix)) continue;
            lstName.add(strName);
        }
        return lstName.toStringArray();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                if ((aChar = in[off++]) == 'u') {
                    int value = 0;
                    StringBuffer sbuf = new StringBuffer(7);
                    sbuf.append("\\u");
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        sbuf.append(aChar);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 't') {
                    aChar = '\t';
                } else if (aChar == 'r') {
                    aChar = '\r';
                } else if (aChar == 'n') {
                    aChar = '\n';
                } else if (aChar == 'f') {
                    aChar = '\f';
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private char[] converNative(char[] arrayIn, int nOffset, int nLen) {
        String strResult = StringUtils.ascii2Native(new String(arrayIn, nOffset, nLen), "ISO8859_1");
        return strResult.toCharArray();
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        boolean m_bIsCommentLine = false;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
        }

        boolean isCommentLine() {
            return this.m_bIsCommentLine;
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            this.m_bIsCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || this.m_bIsCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = (char)(0xFF & this.inBuf[this.inOff++]);
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        this.m_bIsCommentLine = true;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (len == 0) {
                    this.m_bIsCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

