/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CnToSpell {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.CnToSpell");
    public static final char UNKNOW_CHAR = '-';
    private static final int GB_SP_DIFF = 160;
    private static final int[] arraySecPosvalueList = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600};
    private static final char[] arrayFirstLetter = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'w', 'x', 'y', 'z'};
    private static LinkedHashMap m_lstPpellMap = null;

    public static String getLetter(String strOri) {
        String str = strOri.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            char[] temp = new char[]{ch};
            byte[] uniCode = new String(temp).getBytes();
            if (uniCode[0] < 128 && uniCode[0] > 0) {
                buffer.append(temp);
                continue;
            }
            ch = CnToSpell.convert(uniCode);
            buffer.append(ch);
            if (ch != '-') continue;
            log.error("\u4e0d\u80fd\u8bc6\u522b\u6c49\u5b57\uff1a" + str.charAt(i));
        }
        return buffer.toString().replaceAll(" ", "");
    }

    public static String getFirstLetter(String strOri) {
        return String.valueOf(CnToSpell.getLetter(strOri).charAt(0));
    }

    private static char convert(byte[] arrayBytes) {
        int result = 45;
        int secPosvalue = 0;
        int i = 0;
        while (i < arrayBytes.length) {
            int n = i++;
            arrayBytes[n] = (byte)(arrayBytes[n] - 160);
        }
        secPosvalue = arrayBytes[0] * 100 + arrayBytes[1];
        for (i = 0; i < 23; ++i) {
            if (secPosvalue < arraySecPosvalueList[i] || secPosvalue >= arraySecPosvalueList[i + 1]) continue;
            result = arrayFirstLetter[i];
            break;
        }
        if (i >= 23) {
            switch (secPosvalue) {
                case 102: 
                case 189: 
                case 308: 
                case 309: {
                    result = 32;
                    break;
                }
                case 7907: {
                    result = 97;
                    break;
                }
                case 7375: 
                case 7851: {
                    result = 98;
                    break;
                }
                case 6145: {
                    result = 99;
                    break;
                }
                case 6874: {
                    result = 104;
                    break;
                }
                case 7570: {
                    result = 106;
                    break;
                }
                case 7914: {
                    result = 108;
                    break;
                }
                case 7150: 
                case 8080: {
                    result = 115;
                    break;
                }
                case 5971: 
                case 7849: 
                case 7959: {
                    result = 116;
                    break;
                }
                case 7571: {
                    result = 121;
                    break;
                }
                default: {
                    log.error("\u4e0d\u80fd\u8bc6\u522b\u7684\u6c49\u5b57\uff0c\u7f16\u7801=" + secPosvalue);
                }
            }
        }
        return (char)result;
    }

    private static void spellPut(String strSpell, int nAscii) {
        m_lstPpellMap.put(strSpell, new Integer(nAscii));
    }

    private static void initialize() {
        CnToSpell.spellPut("A", -20319);
        CnToSpell.spellPut("Ai", -20317);
        CnToSpell.spellPut("An", -20304);
        CnToSpell.spellPut("Ang", -20295);
        CnToSpell.spellPut("Ao", -20292);
        CnToSpell.spellPut("Ba", -20283);
        CnToSpell.spellPut("Bai", -20265);
        CnToSpell.spellPut("Ban", -20257);
        CnToSpell.spellPut("Bang", -20242);
        CnToSpell.spellPut("Bao", -20230);
        CnToSpell.spellPut("Bei", -20051);
        CnToSpell.spellPut("Ben", -20036);
        CnToSpell.spellPut("Beng", -20032);
        CnToSpell.spellPut("Bi", -20026);
        CnToSpell.spellPut("Bian", -20002);
        CnToSpell.spellPut("Biao", -19990);
        CnToSpell.spellPut("Bie", -19986);
        CnToSpell.spellPut("Bin", -19982);
        CnToSpell.spellPut("Bing", -19976);
        CnToSpell.spellPut("Bo", -19805);
        CnToSpell.spellPut("Bu", -19784);
        CnToSpell.spellPut("Ca", -19775);
        CnToSpell.spellPut("Cai", -19774);
        CnToSpell.spellPut("Can", -19763);
        CnToSpell.spellPut("Cang", -19756);
        CnToSpell.spellPut("Cao", -19751);
        CnToSpell.spellPut("Ce", -19746);
        CnToSpell.spellPut("Ceng", -19741);
        CnToSpell.spellPut("Cha", -19739);
        CnToSpell.spellPut("Chai", -19728);
        CnToSpell.spellPut("Chan", -19725);
        CnToSpell.spellPut("Chang", -19715);
        CnToSpell.spellPut("Chao", -19540);
        CnToSpell.spellPut("Che", -19531);
        CnToSpell.spellPut("Chen", -19525);
        CnToSpell.spellPut("Cheng", -19515);
        CnToSpell.spellPut("Chi", -19500);
        CnToSpell.spellPut("Chong", -19484);
        CnToSpell.spellPut("Chou", -19479);
        CnToSpell.spellPut("Chu", -19467);
        CnToSpell.spellPut("Chuai", -19289);
        CnToSpell.spellPut("Chuan", -19288);
        CnToSpell.spellPut("Chuang", -19281);
        CnToSpell.spellPut("Chui", -19275);
        CnToSpell.spellPut("Chun", -19270);
        CnToSpell.spellPut("Chuo", -19263);
        CnToSpell.spellPut("Ci", -19261);
        CnToSpell.spellPut("Cong", -19249);
        CnToSpell.spellPut("Cou", -19243);
        CnToSpell.spellPut("Cu", -19242);
        CnToSpell.spellPut("Cuan", -19238);
        CnToSpell.spellPut("Cui", -19235);
        CnToSpell.spellPut("Cun", -19227);
        CnToSpell.spellPut("Cuo", -19224);
        CnToSpell.spellPut("Da", -19218);
        CnToSpell.spellPut("Dai", -19212);
        CnToSpell.spellPut("Dan", -19038);
        CnToSpell.spellPut("Dang", -19023);
        CnToSpell.spellPut("Dao", -19018);
        CnToSpell.spellPut("De", -19006);
        CnToSpell.spellPut("Deng", -19003);
        CnToSpell.spellPut("Di", -18996);
        CnToSpell.spellPut("Dian", -18977);
        CnToSpell.spellPut("Diao", -18961);
        CnToSpell.spellPut("Die", -18952);
        CnToSpell.spellPut("Ding", -18783);
        CnToSpell.spellPut("Diu", -18774);
        CnToSpell.spellPut("Dong", -18773);
        CnToSpell.spellPut("Dou", -18763);
        CnToSpell.spellPut("Du", -18756);
        CnToSpell.spellPut("Duan", -18741);
        CnToSpell.spellPut("Dui", -18735);
        CnToSpell.spellPut("Dun", -18731);
        CnToSpell.spellPut("Duo", -18722);
        CnToSpell.spellPut("E", -18710);
        CnToSpell.spellPut("En", -18697);
        CnToSpell.spellPut("Er", -18696);
        CnToSpell.spellPut("Fa", -18526);
        CnToSpell.spellPut("Fan", -18518);
        CnToSpell.spellPut("Fang", -18501);
        CnToSpell.spellPut("Fei", -18490);
        CnToSpell.spellPut("Fen", -18478);
        CnToSpell.spellPut("Feng", -18463);
        CnToSpell.spellPut("Fo", -18448);
        CnToSpell.spellPut("Fou", -18447);
        CnToSpell.spellPut("Fu", -18446);
        CnToSpell.spellPut("Ga", -18239);
        CnToSpell.spellPut("Gai", -18237);
        CnToSpell.spellPut("Gan", -18231);
        CnToSpell.spellPut("Gang", -18220);
        CnToSpell.spellPut("Gao", -18211);
        CnToSpell.spellPut("Ge", -18201);
        CnToSpell.spellPut("Gei", -18184);
        CnToSpell.spellPut("Gen", -18183);
        CnToSpell.spellPut("Geng", -18181);
        CnToSpell.spellPut("Gong", -18012);
        CnToSpell.spellPut("Gou", -17997);
        CnToSpell.spellPut("Gu", -17988);
        CnToSpell.spellPut("Gua", -17970);
        CnToSpell.spellPut("Guai", -17964);
        CnToSpell.spellPut("Guan", -17961);
        CnToSpell.spellPut("Guang", -17950);
        CnToSpell.spellPut("Gui", -17947);
        CnToSpell.spellPut("Gun", -17931);
        CnToSpell.spellPut("Guo", -17928);
        CnToSpell.spellPut("Ha", -17922);
        CnToSpell.spellPut("Hai", -17759);
        CnToSpell.spellPut("Han", -17752);
        CnToSpell.spellPut("Hang", -17733);
        CnToSpell.spellPut("Hao", -17730);
        CnToSpell.spellPut("He", -17721);
        CnToSpell.spellPut("Hei", -17703);
        CnToSpell.spellPut("Hen", -17701);
        CnToSpell.spellPut("Heng", -17697);
        CnToSpell.spellPut("Hong", -17692);
        CnToSpell.spellPut("Hou", -17683);
        CnToSpell.spellPut("Hu", -17676);
        CnToSpell.spellPut("Hua", -17496);
        CnToSpell.spellPut("Huai", -17487);
        CnToSpell.spellPut("Huan", -17482);
        CnToSpell.spellPut("Huang", -17468);
        CnToSpell.spellPut("Hui", -17454);
        CnToSpell.spellPut("Hun", -17433);
        CnToSpell.spellPut("Huo", -17427);
        CnToSpell.spellPut("Ji", -17417);
        CnToSpell.spellPut("Jia", -17202);
        CnToSpell.spellPut("Jian", -17185);
        CnToSpell.spellPut("Jiang", -16983);
        CnToSpell.spellPut("Jiao", -16970);
        CnToSpell.spellPut("Jie", -16942);
        CnToSpell.spellPut("Jin", -16915);
        CnToSpell.spellPut("Jing", -16733);
        CnToSpell.spellPut("Jiong", -16708);
        CnToSpell.spellPut("Jiu", -16706);
        CnToSpell.spellPut("Ju", -16689);
        CnToSpell.spellPut("Juan", -16664);
        CnToSpell.spellPut("Jue", -16657);
        CnToSpell.spellPut("Jun", -16647);
        CnToSpell.spellPut("Ka", -16474);
        CnToSpell.spellPut("Kai", -16470);
        CnToSpell.spellPut("Kan", -16465);
        CnToSpell.spellPut("Kang", -16459);
        CnToSpell.spellPut("Kao", -16452);
        CnToSpell.spellPut("Ke", -16448);
        CnToSpell.spellPut("Ken", -16433);
        CnToSpell.spellPut("Keng", -16429);
        CnToSpell.spellPut("Kong", -16427);
        CnToSpell.spellPut("Kou", -16423);
        CnToSpell.spellPut("Ku", -16419);
        CnToSpell.spellPut("Kua", -16412);
        CnToSpell.spellPut("Kuai", -16407);
        CnToSpell.spellPut("Kuan", -16403);
        CnToSpell.spellPut("Kuang", -16401);
        CnToSpell.spellPut("Kui", -16393);
        CnToSpell.spellPut("Kun", -16220);
        CnToSpell.spellPut("Kuo", -16216);
        CnToSpell.spellPut("La", -16212);
        CnToSpell.spellPut("Lai", -16205);
        CnToSpell.spellPut("Lan", -16202);
        CnToSpell.spellPut("Lang", -16187);
        CnToSpell.spellPut("Lao", -16180);
        CnToSpell.spellPut("Le", -16171);
        CnToSpell.spellPut("Lei", -16169);
        CnToSpell.spellPut("Leng", -16158);
        CnToSpell.spellPut("Li", -16155);
        CnToSpell.spellPut("Lia", -15959);
        CnToSpell.spellPut("Lian", -15958);
        CnToSpell.spellPut("Liang", -15944);
        CnToSpell.spellPut("Liao", -15933);
        CnToSpell.spellPut("Lie", -15920);
        CnToSpell.spellPut("Lin", -15915);
        CnToSpell.spellPut("Ling", -15903);
        CnToSpell.spellPut("Liu", -15889);
        CnToSpell.spellPut("Long", -15878);
        CnToSpell.spellPut("Lou", -15707);
        CnToSpell.spellPut("Lu", -15701);
        CnToSpell.spellPut("Lv", -15681);
        CnToSpell.spellPut("Luan", -15667);
        CnToSpell.spellPut("Lue", -15661);
        CnToSpell.spellPut("Lun", -15659);
        CnToSpell.spellPut("Luo", -15652);
        CnToSpell.spellPut("Ma", -15640);
        CnToSpell.spellPut("Mai", -15631);
        CnToSpell.spellPut("Man", -15625);
        CnToSpell.spellPut("Mang", -15454);
        CnToSpell.spellPut("Mao", -15448);
        CnToSpell.spellPut("Me", -15436);
        CnToSpell.spellPut("Mei", -15435);
        CnToSpell.spellPut("Men", -15419);
        CnToSpell.spellPut("Meng", -15416);
        CnToSpell.spellPut("Mi", -15408);
        CnToSpell.spellPut("Mian", -15394);
        CnToSpell.spellPut("Miao", -15385);
        CnToSpell.spellPut("Mie", -15377);
        CnToSpell.spellPut("Min", -15375);
        CnToSpell.spellPut("Ming", -15369);
        CnToSpell.spellPut("Miu", -15363);
        CnToSpell.spellPut("Mo", -15362);
        CnToSpell.spellPut("Mou", -15183);
        CnToSpell.spellPut("Mu", -15180);
        CnToSpell.spellPut("Na", -15165);
        CnToSpell.spellPut("Nai", -15158);
        CnToSpell.spellPut("Nan", -15153);
        CnToSpell.spellPut("Nang", -15150);
        CnToSpell.spellPut("Nao", -15149);
        CnToSpell.spellPut("Ne", -15144);
        CnToSpell.spellPut("Nei", -15143);
        CnToSpell.spellPut("Nen", -15141);
        CnToSpell.spellPut("Neng", -15140);
        CnToSpell.spellPut("Ni", -15139);
        CnToSpell.spellPut("Nian", -15128);
        CnToSpell.spellPut("Niang", -15121);
        CnToSpell.spellPut("Niao", -15119);
        CnToSpell.spellPut("Nie", -15117);
        CnToSpell.spellPut("Nin", -15110);
        CnToSpell.spellPut("Ning", -15109);
        CnToSpell.spellPut("Niu", -14941);
        CnToSpell.spellPut("Nong", -14937);
        CnToSpell.spellPut("Nu", -14933);
        CnToSpell.spellPut("Nv", -14930);
        CnToSpell.spellPut("Nuan", -14929);
        CnToSpell.spellPut("Nue", -14928);
        CnToSpell.spellPut("Nuo", -14926);
        CnToSpell.spellPut("N", -14922);
        CnToSpell.spellPut("Ou", -14921);
        CnToSpell.spellPut("Pa", -14914);
        CnToSpell.spellPut("Pai", -14908);
        CnToSpell.spellPut("Pan", -14902);
        CnToSpell.spellPut("Pang", -14894);
        CnToSpell.spellPut("Pao", -14889);
        CnToSpell.spellPut("Pei", -14882);
        CnToSpell.spellPut("Pen", -14873);
        CnToSpell.spellPut("Peng", -14871);
        CnToSpell.spellPut("Pi", -14857);
        CnToSpell.spellPut("Pian", -14678);
        CnToSpell.spellPut("Piao", -14674);
        CnToSpell.spellPut("Pie", -14670);
        CnToSpell.spellPut("Pin", -14668);
        CnToSpell.spellPut("Ping", -14663);
        CnToSpell.spellPut("Po", -14654);
        CnToSpell.spellPut("Pu", -14645);
        CnToSpell.spellPut("Qi", -14630);
        CnToSpell.spellPut("Qia", -14594);
        CnToSpell.spellPut("Qian", -14429);
        CnToSpell.spellPut("Qiang", -14407);
        CnToSpell.spellPut("Qiao", -14399);
        CnToSpell.spellPut("Qie", -14384);
        CnToSpell.spellPut("Qin", -14379);
        CnToSpell.spellPut("Qing", -14368);
        CnToSpell.spellPut("Qiong", -14355);
        CnToSpell.spellPut("Qiu", -14353);
        CnToSpell.spellPut("Qu", -14345);
        CnToSpell.spellPut("Quan", -14170);
        CnToSpell.spellPut("Que", -14159);
        CnToSpell.spellPut("Qun", -14151);
        CnToSpell.spellPut("Ran", -14149);
        CnToSpell.spellPut("Rang", -14145);
        CnToSpell.spellPut("Rao", -14140);
        CnToSpell.spellPut("Re", -14137);
        CnToSpell.spellPut("Ren", -14135);
        CnToSpell.spellPut("Reng", -14125);
        CnToSpell.spellPut("Ri", -14123);
        CnToSpell.spellPut("Rong", -14122);
        CnToSpell.spellPut("Rou", -14112);
        CnToSpell.spellPut("Ru", -14109);
        CnToSpell.spellPut("Ruan", -14099);
        CnToSpell.spellPut("Rui", -14097);
        CnToSpell.spellPut("Run", -14094);
        CnToSpell.spellPut("Ruo", -14092);
        CnToSpell.spellPut("Sa", -14090);
        CnToSpell.spellPut("Sai", -14087);
        CnToSpell.spellPut("San", -14083);
        CnToSpell.spellPut("Sang", -13917);
        CnToSpell.spellPut("Sao", -13914);
        CnToSpell.spellPut("Se", -13910);
        CnToSpell.spellPut("Sen", -13907);
        CnToSpell.spellPut("Seng", -13906);
        CnToSpell.spellPut("Sha", -13905);
        CnToSpell.spellPut("Shai", -13896);
        CnToSpell.spellPut("Shan", -13894);
        CnToSpell.spellPut("Shang", -13878);
        CnToSpell.spellPut("Shao", -13870);
        CnToSpell.spellPut("She", -13859);
        CnToSpell.spellPut("Shen", -13847);
        CnToSpell.spellPut("Sheng", -13831);
        CnToSpell.spellPut("Shi", -13658);
        CnToSpell.spellPut("Shou", -13611);
        CnToSpell.spellPut("Shu", -13601);
        CnToSpell.spellPut("Shua", -13406);
        CnToSpell.spellPut("Shuai", -13404);
        CnToSpell.spellPut("Shuan", -13400);
        CnToSpell.spellPut("Shuang", -13398);
        CnToSpell.spellPut("Shui", -13395);
        CnToSpell.spellPut("Shun", -13391);
        CnToSpell.spellPut("Shuo", -13387);
        CnToSpell.spellPut("Si", -13383);
        CnToSpell.spellPut("Song", -13367);
        CnToSpell.spellPut("Sou", -13359);
        CnToSpell.spellPut("Su", -13356);
        CnToSpell.spellPut("Suan", -13343);
        CnToSpell.spellPut("Sui", -13340);
        CnToSpell.spellPut("Sun", -13329);
        CnToSpell.spellPut("Suo", -13326);
        CnToSpell.spellPut("Ta", -13318);
        CnToSpell.spellPut("Tai", -13147);
        CnToSpell.spellPut("Tan", -13138);
        CnToSpell.spellPut("Tang", -13120);
        CnToSpell.spellPut("Tao", -13107);
        CnToSpell.spellPut("Te", -13096);
        CnToSpell.spellPut("Teng", -13095);
        CnToSpell.spellPut("Ti", -13091);
        CnToSpell.spellPut("Tian", -13076);
        CnToSpell.spellPut("Tiao", -13068);
        CnToSpell.spellPut("Tie", -13063);
        CnToSpell.spellPut("Ting", -13060);
        CnToSpell.spellPut("Tong", -12888);
        CnToSpell.spellPut("Tou", -12875);
        CnToSpell.spellPut("Tu", -12871);
        CnToSpell.spellPut("Tuan", -12860);
        CnToSpell.spellPut("Tui", -12858);
        CnToSpell.spellPut("Tun", -12852);
        CnToSpell.spellPut("Tuo", -12849);
        CnToSpell.spellPut("Wa", -12838);
        CnToSpell.spellPut("Wai", -12831);
        CnToSpell.spellPut("Wan", -12829);
        CnToSpell.spellPut("Wang", -12812);
        CnToSpell.spellPut("Wei", -12802);
        CnToSpell.spellPut("Wen", -12607);
        CnToSpell.spellPut("Weng", -12597);
        CnToSpell.spellPut("Wo", -12594);
        CnToSpell.spellPut("Wu", -12585);
        CnToSpell.spellPut("Xi", -12556);
        CnToSpell.spellPut("Xia", -12359);
        CnToSpell.spellPut("Xian", -12346);
        CnToSpell.spellPut("Xiang", -12320);
        CnToSpell.spellPut("Xiao", -12300);
        CnToSpell.spellPut("Xie", -12120);
        CnToSpell.spellPut("Xin", -12099);
        CnToSpell.spellPut("Xing", -12089);
        CnToSpell.spellPut("Xiong", -12074);
        CnToSpell.spellPut("Xiu", -12067);
        CnToSpell.spellPut("Xu", -12058);
        CnToSpell.spellPut("Xuan", -12039);
        CnToSpell.spellPut("Xue", -11867);
        CnToSpell.spellPut("Xun", -11861);
        CnToSpell.spellPut("Ya", -11847);
        CnToSpell.spellPut("Yan", -11831);
        CnToSpell.spellPut("Yang", -11798);
        CnToSpell.spellPut("Yao", -11781);
        CnToSpell.spellPut("Ye", -11604);
        CnToSpell.spellPut("Yi", -11589);
        CnToSpell.spellPut("Yin", -11536);
        CnToSpell.spellPut("Ying", -11358);
        CnToSpell.spellPut("Yo", -11340);
        CnToSpell.spellPut("Yong", -11339);
        CnToSpell.spellPut("You", -11324);
        CnToSpell.spellPut("Yu", -11303);
        CnToSpell.spellPut("Yuan", -11097);
        CnToSpell.spellPut("Yue", -11077);
        CnToSpell.spellPut("Yun", -11067);
        CnToSpell.spellPut("Za", -11055);
        CnToSpell.spellPut("Zai", -11052);
        CnToSpell.spellPut("Zan", -11045);
        CnToSpell.spellPut("Zang", -11041);
        CnToSpell.spellPut("Zao", -11038);
        CnToSpell.spellPut("Ze", -11024);
        CnToSpell.spellPut("Zei", -11020);
        CnToSpell.spellPut("Zen", -11019);
        CnToSpell.spellPut("Zeng", -11018);
        CnToSpell.spellPut("Zha", -11014);
        CnToSpell.spellPut("Zhai", -10838);
        CnToSpell.spellPut("Zhan", -10832);
        CnToSpell.spellPut("Zhang", -10815);
        CnToSpell.spellPut("Zhao", -10800);
        CnToSpell.spellPut("Zhe", -10790);
        CnToSpell.spellPut("Zhen", -10780);
        CnToSpell.spellPut("Zheng", -10764);
        CnToSpell.spellPut("Zhi", -10587);
        CnToSpell.spellPut("Zhong", -10544);
        CnToSpell.spellPut("Zhou", -10533);
        CnToSpell.spellPut("Zhu", -10519);
        CnToSpell.spellPut("Zhua", -10331);
        CnToSpell.spellPut("Zhuai", -10329);
        CnToSpell.spellPut("Zhuan", -10328);
        CnToSpell.spellPut("Zhuang", -10322);
        CnToSpell.spellPut("Zhui", -10315);
        CnToSpell.spellPut("Zhun", -10309);
        CnToSpell.spellPut("Zhuo", -10307);
        CnToSpell.spellPut("Zi", -10296);
        CnToSpell.spellPut("Zong", -10281);
        CnToSpell.spellPut("Zou", -10274);
        CnToSpell.spellPut("Zu", -10270);
        CnToSpell.spellPut("Zuan", -10262);
        CnToSpell.spellPut("Zui", -10260);
        CnToSpell.spellPut("Zun", -10256);
        CnToSpell.spellPut("Zuo", -10254);
    }

    public static int getCnAscii(char chCn) {
        byte[] bytes = null;
        try {
            bytes = String.valueOf(chCn).getBytes("GBK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bytes == null || bytes.length > 2 || bytes.length <= 0) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            int ascii = 256 * hightByte + lowByte - 65536;
            return ascii;
        }
        return 0;
    }

    public static String getSpellByAscii(int nAscii) {
        if (nAscii > 0 && nAscii < 160) {
            return String.valueOf((char)nAscii);
        }
        if (nAscii < -20319 || nAscii > -10247) {
            return CnToSpell.getKnowSpell(nAscii);
        }
        Set keySet = m_lstPpellMap.keySet();
        Iterator it = keySet.iterator();
        String spell0 = null;
        String spell = null;
        int nAsciiRang0 = -20319;
        while (it.hasNext()) {
            spell = (String)it.next();
            Object valObj = m_lstPpellMap.get(spell);
            if (!(valObj instanceof Integer)) continue;
            int nAsciiRang = (Integer)valObj;
            if (nAscii >= nAsciiRang0 && nAscii < nAsciiRang) {
                return spell0 == null ? spell : spell0;
            }
            spell0 = spell;
            nAsciiRang0 = nAsciiRang;
        }
        return CnToSpell.getKnowSpell(nAscii);
    }

    private static String getKnowSpell(int nAscii) {
        switch (nAscii) {
            case -24158: 
            case -24071: 
            case -23640: 
            case -23639: {
                return "";
            }
            case -5653: {
                return "Bin";
            }
            case -4133: {
                return "Tang";
            }
            case -9241: {
                return "Tuo";
            }
            case -4399: {
                return "Tai";
            }
            case -8755: {
                return "Cui";
            }
            case -4185: {
                return "An";
            }
            case -5146: {
                return "Jing";
            }
            case -4397: {
                return "Ban";
            }
            case -6190: {
                return "Sao";
            }
            case -6934: {
                return "Huang";
            }
            case -5145: {
                return "Yan";
            }
            case -3856: {
                return "Sha";
            }
            case -4178: {
                return "Li";
            }
            case -10249: {
                return "Zuo";
            }
        }
        return null;
    }

    private static boolean isAlphabet(int nAscii) {
        return nAscii > 0 && nAscii < 160;
    }

    public static String getFullSpell(String cnStr) {
        if (null == cnStr || cnStr.trim().length() == 0) {
            return cnStr;
        }
        boolean isChinese = false;
        char[] chars = cnStr.toCharArray();
        StringBuffer retuBuf = new StringBuffer();
        StringBuffer resultBuf = new StringBuffer();
        int Len = chars.length;
        for (int i = 0; i < Len; ++i) {
            int ascii = CnToSpell.getCnAscii(chars[i]);
            if (ascii == 0) {
                retuBuf.append(chars[i]);
                continue;
            }
            String spell = CnToSpell.getSpellByAscii(ascii);
            if (spell == null) {
                log.error("\u4e0d\u80fd\u8bc6\u522b\u4e2d\u6587\u7684\u62fc\u97f3\uff1acase " + ascii + ":\r\n// " + chars[i] + "\r\nreturn \"\";\r\n");
                retuBuf.append(chars[i]);
            } else {
                retuBuf.append(spell);
            }
            if (CnToSpell.isAlphabet(ascii)) continue;
            isChinese = true;
            retuBuf.append("");
        }
        if (isChinese) {
            resultBuf.append("");
            resultBuf.append(retuBuf.toString());
        } else {
            resultBuf.append(retuBuf.toString());
        }
        return resultBuf.toString();
    }

    public static String getFirstSpell(String strCn) {
        return CnToSpell.getFirstLetter(strCn);
    }

    public static void main(String[] args) {
        String str = null;
        log.info("\u5b57\u7b26\u6d4b\u8bd5======================================");
        log.info(CnToSpell.getLetter("\u6c49\u5b57"));
        log.info(CnToSpell.getLetter("a\u6c49\u5b57"));
        log.info(CnToSpell.getLetter(";\u6c49\u5b57"));
        log.info(CnToSpell.getLetter(" \u6c49\u5b57"));
        log.info(CnToSpell.getLetter("0\u6c49\u5b57"));
        try {
            str = new String("\u4e2d\u56fd".getBytes(), "GBK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Spell=" + CnToSpell.getFullSpell(str));
        log.info("Spell=" + CnToSpell.getFullSpell("\u4e2d\u56fd"));
        log.info("\u9557=" + CnToSpell.getFirstLetter("\u9557\u5768") + " \u9557=" + CnToSpell.getLetter("\u9557\u5768") + " : " + CnToSpell.getFullSpell("\u9557\u5768"));
        str = "\u6ba1\u4eea\u670d\u52a1\u5458\uff08\uff09\u203b\u3001\u9a73\u7b51\u3001\u96c6\u62c6\u5768\u76d0\u5de5\u8f6c\u6362\u949b\u51b6\u70bc\u5de5\u8f6c\u6362\u8403\u53d6\u5de5\u949b\u51b6\u70bc\u785d\u9178\u94f5\u751f\u4ea7\u78b3\u9178\u6c22\u94f5\u4e19\u70ef\u8148\u4e01\u4e8c\u70ef\u82ef\u4e59\u70ef\u5171\u805a\u7269\u51b7\u4f5c\u94a3\u91d1\u7f2b\u4e1d\u5370\u67d3\u6210\u54c1\u5b9a\u7b49\u88c5\u6f62\u9171\u814c\u83dc\u4fdd\u5065\u522e\u75e7\u5e08\u9502\u79bb\u5b50\u84c4\u7535\u6c60";
        log.info(str + " \r\n\u9996\u5b57\u7b26\uff1a" + CnToSpell.getLetter(str));
        log.info("\u5168\u62fc\uff1a" + CnToSpell.getFullSpell(str));
    }

    static {
        if (m_lstPpellMap == null) {
            m_lstPpellMap = new LinkedHashMap(400);
        }
        CnToSpell.initialize();
    }
}

