/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.CnToSpell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseNameUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.ChineseNameUtil");
    private static final String BLANK_ENGLISH = " ";
    private static final String BLANK_CHINESE = "\u3000";
    private static final String[] m_arrayFamilyName = new String[]{"\u5b89\u9675", "\u5b89\u5e73", "\u5b89\u671f", "\u5b89\u9633", "\u767d\u9a6c", "\u767e\u91cc", "\u67cf\u4faf", "\u9c8d\u4fce", "\u5317\u5bab", "\u5317\u90ed", "\u5317\u95e8", "\u5317\u5c71", "\u5317\u5510", "\u5954\u6c34", "\u903c\u9633", "\u5bbe\u725f", "\u8584\u595a", "\u8584\u91ce", "\u66f9\u725f", "\u66f9\u4e18", "\u5e38\u6d9b", "\u957f\u9c7c", "\u8f66\u975e", "\u6210\u529f", "\u6210\u9633", "\u4e58\u9a6c", "\u53f1\u5362", "\u4e11\u95e8", "\u6a17\u91cc", "\u7a7f\u5c01", "\u6df3\u5b50", "\u7b54\u7984", "\u8fbe\u52c3", "\u8fbe\u6b65", "\u8fbe\u595a", "\u6de1\u53f0", "\u9093\u9675", "\u7b2c\u4e94", "\u5730\u8fde", "\u5730\u4f26", "\u4e1c\u65b9", "\u4e1c\u91cc", "\u4e1c\u5357", "\u4e1c\u5bab", "\u4e1c\u95e8", "\u4e1c\u4e61", "\u4e1c\u4e39", "\u4e1c\u90ed", "\u4e1c\u9675", "\u4e1c\u5173", "\u4e1c\u95fe", "\u4e1c\u9633", "\u4e1c\u91ce", "\u4e1c\u83b1", "\u8c46\u5362", "\u6597\u4e8e", "\u90fd\u5c09", "\u72ec\u5b64", "\u7aef\u6728", "\u6bb5\u5e72", "\u591a\u5b50", "\u5c14\u6731", "\u65b9\u96f7", "\u4e30\u5c06", "\u5c01\u4eba", "\u5c01\u7236", "\u592b\u8499", "\u592b\u9980", "\u6d6e\u4e18", "\u5085\u4f59", "\u5e72\u5df2", "\u9ad8\u8f66", "\u9ad8\u9675", "\u9ad8\u5802", "\u9ad8\u9633", "\u9ad8\u8f9b", "\u768b\u843d", "\u54e5\u8212", "\u76d6\u697c", "\u5e9a\u6851", "\u6897\u9633", "\u5bab\u5b59", "\u516c\u7f8a", "\u516c\u826f", "\u516c\u5b59", "\u516c\u7f54", "\u516c\u897f", "\u516c\u51b6", "\u516c\u655b", "\u516c\u6881", "\u516c\u8f93", "\u516c\u4e0a", "\u516c\u5c71", "\u516c\u6237", "\u516c\u7389", "\u516c\u4eea", "\u516c\u4ef2", "\u516c\u575a", "\u516c\u4f2f", "\u516c\u7956", "\u516c\u4e58", "\u516c\u6670", "\u516c\u65cf", "\u59d1\u5e03", "\u53e4\u53e3", "\u53e4\u9f99", "\u53e4\u5b59", "\u8c37\u6881", "\u8c37\u6d51", "\u74dc\u7530", "\u5173\u9f99", "\u9c91\u9633", "\u5f52\u6d77", "\u51fd\u6cbb", "\u97e9\u9980", "\u7f55\u4e95", "\u6d69\u751f", "\u6d69\u661f", "\u7ea5\u9aa8", "\u7ea5\u595a", "\u7ea5\u4e8e", "\u8d3a\u62e8", "\u8d3a\u5170", "\u8d3a\u697c", "\u8d6b\u8fde", "\u9ed1\u9f7f", "\u9ed1\u80b1", "\u4faf\u5188", "\u547c\u5ef6", "\u58f6\u4e18", "\u547c\u884d", "\u659b\u5f8b", "\u80e1\u975e", "\u80e1\u6bcd", "\u80e1\u6bcb", "\u7687\u752b", "\u7687\u7236", "\u5140\u5b98", "\u5409\u767d", "\u5373\u58a8", "\u5b63\u74dc", "\u5b63\u8fde", "\u5b63\u5b59", "\u8304\u4f17", "\u848b\u4e18", "\u91d1\u9f7f", "\u664b\u695a", "\u4eac\u57ce", "\u6cfe\u9633", "\u4e5d\u767e", "\u4e5d\u65b9", "\u7762\u9e20", "\u6cae\u6e20", "\u5de8\u6bcd", "\u52d8\u963b", "\u6e34\u4faf", "\u6e34\u5355", "\u53ef\u6c57", "\u7a7a\u6850", "\u7a7a\u76f8", "\u6606\u543e", "\u8001\u9633", "\u4e50\u7f8a", "\u8354\u83f2", "\u680e\u9633", "\u6881\u4e18", "\u6881\u7531", "\u6881\u9980", "\u6881\u57a3", "\u9675\u9633", "\u4f36\u821f", "\u51b7\u6ca6", "\u4ee4\u72d0", "\u5218\u738b", "\u67f3\u4e0b", "\u9f99\u4e18", "\u5362\u5983", "\u5362\u84b2", "\u9c81\u6b65", "\u9646\u8d39", "\u89d2\u91cc", "\u95fe\u4e18", "\u9a6c\u77e2", "\u9ea6\u4e18", "\u8305\u5937", "\u5f25\u725f", "\u5bc6\u9769", "\u5bc6\u8305", "\u58a8\u5937", "\u58a8\u53f0", "\u4e07\u4fca", "\u660c\u987f", "\u6155\u5bb9", "\u6728\u95e8", "\u6728\u6613", "\u5357\u5bab", "\u5357\u90ed", "\u5357\u95e8", "\u5357\u8363", "\u6b27\u4faf", "\u6b27\u9633", "\u9004\u95e8", "\u76c6\u6210", "\u5f6d\u7956", "\u5e73\u9675", "\u5e73\u5b81", "\u7834\u4e11", "\u4ec6\u56fa", "\u6fee\u9633", "\u6f06\u96d5", "\u5947\u4ecb", "\u7da6\u6bcd", "\u7da6\u6bcb", "\u7da6\u8fde", "\u7941\u8fde", "\u4e5e\u4f0f", "\u7eee\u91cc", "\u5343\u4ee3", "\u5343\u4e58", "\u52e4\u5bbf", "\u9752\u9633", "\u4e18\u4e3d", "\u4e18\u9675", "\u5c48\u4faf", "\u5c48\u7a81", "\u5c48\u7537", "\u5c48\u5362", "\u5c48\u540c", "\u5c48\u95e8", "\u5c48\u5f15", "\u58e4\u56db", "\u6270\u9f99", "\u5bb9\u6210", "\u6c5d\u5ae3", "\u8428\u5b64", "\u4e09\u996d", "\u4e09\u95fe", "\u4e09\u5dde", "\u6851\u4e18", "\u5546\u77bf", "\u4e0a\u5b98", "\u5c1a\u65b9", "\u5c11\u5e08", "\u5c11\u65bd", "\u5c11\u5ba4", "\u5c11\u53d4", "\u5c11\u6b63", "\u793e\u5357", "\u793e\u5317", "\u7533\u5c60", "\u7533\u5f92", "\u6c88\u72b9", "\u80dc\u5c60", "\u77f3\u4f5c", "\u77f3\u725b", "\u4f8d\u5176", "\u58eb\u5b63", "\u58eb\u5f31", "\u58eb\u5b59", "\u58eb\u8d1e", "\u53d4\u5b59", "\u53d4\u5148", "\u53d4\u4fc3", "\u6c34\u4e18", "\u53f8\u57ce", "\u53f8\u7a7a", "\u53f8\u5bc7", "\u53f8\u9e3f", "\u53f8\u9a6c", "\u53f8\u5f92", "\u53f8\u58eb", "\u4f3c\u548c", "\u7d20\u548c", "\u5919\u6c99", "\u5b59\u9633", "\u7d22\u9633", "\u7d22\u5362", "\u6c93\u5362", "\u592a\u53f2", "\u592a\u53d4", "\u592a\u9633", "\u6fb9\u53f0", "\u5510\u5c71", "\u5802\u6eaa", "\u9676\u4e18", "\u540c\u8e44", "\u7edf\u595a", "\u79c3\u53d1", "\u6d82\u94a6", "\u5410\u706b", "\u5410\u8d3a", "\u5410\u4e07", "\u5410\u7f57", "\u5410\u95e8", "\u5410\u96be", "\u5410\u7f36", "\u5410\u6d51", "\u5410\u595a", "\u5410\u548c", "\u5c6f\u6d51", "\u8131\u8131", "\u62d3\u62e8", "\u5b8c\u989c", "\u738b\u5b59", "\u738b\u5b98", "\u738b\u4eba", "\u5fae\u751f", "\u5c3e\u52fa", "\u6e29\u5b64", "\u6e29\u7a3d", "\u95fb\u4eba", "\u5c4b\u6237", "\u5deb\u9a6c", "\u543e\u4e18", "\u65e0\u5eb8", "\u65e0\u94a9", "\u4e94\u9e7f", "\u606f\u592b", "\u897f\u9675", "\u897f\u4e5e", "\u897f\u94a5", "\u897f\u4e61", "\u897f\u95e8", "\u897f\u5468", "\u897f\u90ed", "\u897f\u65b9", "\u897f\u91ce", "\u897f\u5bab", "\u620f\u9633", "\u7455\u5415", "\u971e\u9732", "\u590f\u4faf", "\u9c9c\u865e", "\u9c9c\u4e8e", "\u9c9c\u9633", "\u54b8\u4e18", "\u76f8\u91cc", "\u89e3\u6787", "\u8c22\u4e18", "\u65b0\u57a3", "\u8f9b\u57a3", "\u4fe1\u90fd", "\u4fe1\u5e73", "\u4fee\u9c7c", "\u5f90\u543e", "\u5ba3\u4e8e", "\u8f69\u8f95", "\u8f69\u4e18", "\u960f\u6c0f", "\u5ef6\u9675", "\u7f54\u6cd5", "\u94c5\u9675", "\u7f8a\u89d2", "\u8036\u5f8b", "\u53f6\u9633", "\u4f0a\u7941", "\u4f0a\u8006", "\u7317\u5362", "\u4e49\u6e20", "\u9091\u7531", "\u56e0\u5b59", "\u94f6\u9f7f", "\u5c39\u6587", "\u96cd\u95e8", "\u6e38\u6c34", "\u7531\u543e", "\u53f3\u5e08", "\u5ba5\u8fde", "\u65bc\u9675", "\u865e\u4e18", "\u76c2\u4e18", "\u5b87\u6587", "\u5c09\u8fdf", "\u4e50\u7f8a", "\u4e50\u6b63", "\u8fd0\u5944", "\u8fd0\u671f", "\u5bb0\u7236", "\u8f97\u8fdf", "\u6e5b\u5362", "\u7ae0\u4ec7", "\u4ec9\u7763", "\u957f\u5b59", "\u957f\u513f", "\u771f\u9102", "\u6b63\u4ee4", "\u6267\u5934", "\u4e2d\u592e", "\u4e2d\u957f", "\u4e2d\u884c", "\u4e2d\u91ce", "\u4e2d\u82f1", "\u4e2d\u6881", "\u4e2d\u5792", "\u949f\u79bb", "\u949f\u543e", "\u7ec8\u9ece", "\u7ec8\u8475", "\u4ef2\u5b59", "\u4ef2\u957f", "\u5468\u9633", "\u5468\u6c0f", "\u5468\u751f", "\u6731\u9633", "\u8bf8\u845b", "\u4e3b\u7236", "\u989b\u5b59", "\u989b\u987c", "\u8a3e\u8fb1", "\u6dc4\u4e18", "\u5b50\u8a00", "\u5b50\u4eba", "\u5b50\u670d", "\u5b50\u5bb6", "\u5b50\u6851", "\u5b50\u53d4", "\u5b50\u8f66", "\u5b50\u9633", "\u5b97\u4f2f", "\u5b97\u6b63", "\u5b97\u653f", "\u5c0a\u5362", "\u6628\u548c", "\u5de6\u4eba", "\u5de6\u4e18", "\u5de6\u5e08", "\u5de6\u884c", "\u5218\u6587", "\u989d\u5c14", "\u8fbe\u529b", "\u8521\u65af", "\u6d69\u8d4f", "\u659b\u65af", "\u5939\u8c37", "\u63ed\u9633"};
    private static final String[] m_arrayRepeatedFamilyName = new String[]{"\u6b27\u9633", "\u592a\u53f2", "\u7aef\u6728", "\u4e0a\u5b98", "\u53f8\u9a6c", "\u4e1c\u65b9", "\u72ec\u5b64", "\u5357\u5bab", "\u4e07\u4fdf", "\u95fb\u4eba", "\u590f\u4faf", "\u8bf8\u845b", "\u5c09\u8fdf", "\u516c\u7f8a", "\u8d6b\u8fde", "\u6fb9\u53f0", "\u7687\u752b", "\u5b97\u653f", "\u6fee\u9633", "\u516c\u51b6", "\u592a\u53d4", "\u7533\u5c60", "\u516c\u5b59", "\u6155\u5bb9", "\u4ef2\u5b59", "\u949f\u79bb", "\u957f\u5b59", "\u5b87\u6587", "\u53f8\u5f92", "\u9c9c\u4e8e", "\u53f8\u7a7a", "\u95fe\u4e18", "\u5b50\u8f66", "\u4e93\u5b98", "\u53f8\u5bc7", "\u5deb\u9a6c", "\u516c\u897f", "\u989b\u5b59", "\u58e4\u9a77", "\u516c\u826f", "\u6f06\u96d5", "\u4e50\u6b63", "\u5bb0\u7236", "\u8c37\u6881", "\u62d3\u8dcb", "\u5939\u8c37", "\u8f69\u8f95", "\u4ee4\u72d0", "\u6bb5\u5e72", "\u767e\u91cc", "\u547c\u5ef6", "\u4e1c\u90ed", "\u5357\u95e8", "\u7f8a\u820c", "\u5fae\u751f", "\u516c\u6237", "\u516c\u7389", "\u516c\u4eea", "\u6881\u4e18", "\u516c\u4ef2", "\u516c\u4e0a", "\u516c\u95e8", "\u516c\u5c71", "\u516c\u575a", "\u5de6\u4e18", "\u516c\u4f2f", "\u897f\u95e8", "\u516c\u7956", "\u7b2c\u4e94", "\u516c\u4e58", "\u8d2f\u4e18", "\u516c\u7699", "\u5357\u8363", "\u4e1c\u91cc", "\u4e1c\u5bab", "\u4ef2\u957f", "\u5b50\u4e66", "\u5b50\u6851", "\u5373\u58a8", "\u8fbe\u595a", "\u891a\u5e08"};

    public static String getFamilyName(String strName) {
        if (strName == null || strName.length() <= 0) {
            return null;
        }
        if (strName.length() == 1) {
            return strName;
        }
        for (int n = 0; n < m_arrayRepeatedFamilyName.length; ++n) {
            if (strName.indexOf(m_arrayRepeatedFamilyName[n]) != 0) continue;
            return m_arrayRepeatedFamilyName[n];
        }
        return strName.substring(0, 1);
    }

    public static String getFirstName(String strName) {
        if (strName == null || strName.length() <= 0) {
            return null;
        }
        if (strName.length() == 1) {
            return strName;
        }
        for (int n = 0; n < m_arrayRepeatedFamilyName.length; ++n) {
            if (strName.indexOf(m_arrayRepeatedFamilyName[n]) != 0) continue;
            return strName.substring(m_arrayRepeatedFamilyName[n].length());
        }
        return strName.substring(1);
    }

    public static String getFullNameSpell(String strName) {
        return ChineseNameUtil.getFullNameSpell(strName, true);
    }

    public static String getFullNameSpell(String strName, boolean bIsBlank) {
        if (strName == null || strName.length() <= 0) {
            return null;
        }
        String strFullNameSpell = CnToSpell.getFullSpell(strName);
        if (bIsBlank) {
            if (strName.length() == 1) {
                return strFullNameSpell;
            }
            String strFamilyName = ChineseNameUtil.getFamilyName(strName);
            String strFirstName = ChineseNameUtil.getFirstName(strName);
            if (strFamilyName == null || strFamilyName.length() <= 0 || strFirstName == null || strFirstName.length() <= 0) {
                return null;
            }
            String strFamilyNameSpell = CnToSpell.getFullSpell(strFamilyName);
            String strFirstNameSpell = CnToSpell.getFullSpell(strFirstName);
            if (strFamilyNameSpell == null || strFamilyNameSpell.length() <= 0 || strFirstNameSpell == null || strFirstNameSpell.length() <= 0) {
                return null;
            }
            return strFamilyNameSpell + BLANK_ENGLISH + strFirstNameSpell;
        }
        return strFullNameSpell;
    }

    public static boolean isCompoundSurname(String strName) {
        for (int n = 0; n < m_arrayRepeatedFamilyName.length; ++n) {
            if (strName.indexOf(m_arrayRepeatedFamilyName[n]) != 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

