/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.CnToSpell;
import com.hynnet.util.StringUtils;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseFileRenamePolicy
implements FileRenamePolicy {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.ChineseFileRenamePolicy");

    public File rename(File objFile) {
        String strNewName;
        String strName = objFile.getName();
        if (StringUtils.hasNoASCII(strName)) {
            try {
                strNewName = CnToSpell.getFullSpell(strName);
                objFile = new File(objFile.getParent(), strNewName.toLowerCase());
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u540d\u8f6c\u6362\u4e3a\u82f1\u6587\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
        if (this.createNewFile(objFile)) {
            return objFile;
        }
        String strBody = null;
        String strExt = null;
        int nDot = strName.lastIndexOf(".");
        if (nDot != -1) {
            strBody = strName.substring(0, nDot);
            strExt = strName.substring(nDot);
        } else {
            strBody = strName;
            strExt = "";
        }
        int count = 0;
        while (!this.createNewFile(objFile) && count < 9999) {
            strNewName = strBody + ++count + strExt;
            objFile = new File(objFile.getParent(), strNewName);
        }
        return objFile;
    }

    private boolean createNewFile(File objFile) {
        try {
            return objFile.createNewFile();
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

