/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

public class ByteConvert {
    public static byte[] longToBytes(long val) {
        byte[] datas = new byte[8];
        datas[7] = (byte)(val & 0xFFL);
        datas[6] = (byte)(val >> 8 & 0xFFL);
        datas[5] = (byte)(val >> 16 & 0xFFL);
        datas[4] = (byte)(val >> 24 & 0xFFL);
        datas[3] = (byte)(val >> 32 & 0xFFL);
        datas[2] = (byte)(val >> 40 & 0xFFL);
        datas[1] = (byte)(val >> 48 & 0xFFL);
        datas[0] = (byte)(val >> 56 & 0xFFL);
        return datas;
    }

    public static void longToBytes(long val, byte[] array, int offset) {
        array[7 + offset] = (byte)(val & 0xFFL);
        array[6 + offset] = (byte)(val >> 8 & 0xFFL);
        array[5 + offset] = (byte)(val >> 16 & 0xFFL);
        array[4 + offset] = (byte)(val >> 24 & 0xFFL);
        array[3 + offset] = (byte)(val >> 32 & 0xFFL);
        array[2 + offset] = (byte)(val >> 40 & 0xFFL);
        array[1 + offset] = (byte)(val >> 48 & 0xFFL);
        array[0 + offset] = (byte)(val >> 56 & 0xFFL);
    }

    public static long bytesToLong(byte[] array) {
        return ((long)array[0] & 0xFFL) << 56 | ((long)array[1] & 0xFFL) << 48 | ((long)array[2] & 0xFFL) << 40 | ((long)array[3] & 0xFFL) << 32 | ((long)array[4] & 0xFFL) << 24 | ((long)array[5] & 0xFFL) << 16 | ((long)array[6] & 0xFFL) << 8 | ((long)array[7] & 0xFFL) << 0;
    }

    public static long bytesToLong(byte[] array, int offset) {
        return ((long)array[offset + 0] & 0xFFL) << 56 | ((long)array[offset + 1] & 0xFFL) << 48 | ((long)array[offset + 2] & 0xFFL) << 40 | ((long)array[offset + 3] & 0xFFL) << 32 | ((long)array[offset + 4] & 0xFFL) << 24 | ((long)array[offset + 5] & 0xFFL) << 16 | ((long)array[offset + 6] & 0xFFL) << 8 | ((long)array[offset + 7] & 0xFFL) << 0;
    }

    public static byte[] intToBytes(int n) {
        byte[] datas = new byte[4];
        datas[3] = (byte)(n & 0xFF);
        datas[2] = (byte)(n >> 8 & 0xFF);
        datas[1] = (byte)(n >> 16 & 0xFF);
        datas[0] = (byte)(n >> 24 & 0xFF);
        return datas;
    }

    public static void intToBytes(int n, byte[] array, int offset) {
        array[3 + offset] = (byte)(n & 0xFF);
        array[2 + offset] = (byte)(n >> 8 & 0xFF);
        array[1 + offset] = (byte)(n >> 16 & 0xFF);
        array[offset] = (byte)(n >> 24 & 0xFF);
    }

    public static int bytesToInt(byte[] datas) {
        return datas[3] & 0xFF | (datas[2] & 0xFF) << 8 | (datas[1] & 0xFF) << 16 | (datas[0] & 0xFF) << 24;
    }

    public static int bytesToInt(byte[] datas, int offset) {
        return datas[offset + 3] & 0xFF | (datas[offset + 2] & 0xFF) << 8 | (datas[offset + 1] & 0xFF) << 16 | (datas[offset] & 0xFF) << 24;
    }

    public static byte[] uintToBytes(long val) {
        byte[] datas = new byte[4];
        datas[3] = (byte)(val & 0xFFL);
        datas[2] = (byte)(val >> 8 & 0xFFL);
        datas[1] = (byte)(val >> 16 & 0xFFL);
        datas[0] = (byte)(val >> 24 & 0xFFL);
        return datas;
    }

    public static byte[] uintToCBytes(long val) {
        byte[] datas = new byte[]{(byte)(val & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 24 & 0xFFL)};
        return datas;
    }

    public static void uintToBytes(long val, byte[] array, int offset) {
        array[3 + offset] = (byte)val;
        array[2 + offset] = (byte)(val >> 8 & 0xFFL);
        array[1 + offset] = (byte)(val >> 16 & 0xFFL);
        array[offset] = (byte)(val >> 24 & 0xFFL);
    }

    public static long bytesToUint(byte[] array) {
        return (long)(array[3] & 0xFF) | (long)(array[2] & 0xFF) << 8 | (long)(array[1] & 0xFF) << 16 | (long)(array[0] & 0xFF) << 24;
    }

    public static long bytesToUint(byte[] array, int offset) {
        return (long)(array[offset + 3] & 0xFF) | (long)(array[offset + 2] & 0xFF) << 8 | (long)(array[offset + 1] & 0xFF) << 16 | (long)(array[offset] & 0xFF) << 24;
    }

    public static long cBytesToUint(byte[] array) {
        return (long)(array[0] & 0xFF) | (long)(array[1] & 0xFF) << 8 | (long)(array[2] & 0xFF) << 16 | (long)(array[3] & 0xFF) << 24;
    }

    public static long cBytesToUint(byte[] array, int offset) {
        return (long)(array[offset] & 0xFF) | (long)(array[offset + 1] & 0xFF) << 8 | (long)(array[offset + 2] & 0xFF) << 16 | (long)(array[offset + 3] & 0xFF) << 24;
    }

    public static byte[] shortToBytes(short val) {
        byte[] datas = new byte[2];
        datas[1] = (byte)(val & 0xFF);
        datas[0] = (byte)(val >> 8 & 0xFF);
        return datas;
    }

    public static byte[] shortToCBytes(short val) {
        byte[] datas = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF)};
        return datas;
    }

    public static void shortToBytes(short val, byte[] array, int offset) {
        array[offset + 1] = (byte)(val & 0xFF);
        array[offset] = (byte)(val >> 8 & 0xFF);
    }

    public static short bytesToShort(byte[] datas) {
        return (short)(datas[1] & 0xFF | (datas[0] & 0xFF) << 8);
    }

    public static short bytesToShort(byte[] datas, int offset) {
        return (short)(datas[offset + 1] & 0xFF | (datas[offset] & 0xFF) << 8);
    }

    public static short cBytesToShort(byte[] datas) {
        return (short)(datas[0] & 0xFF | (datas[1] & 0xFF) << 8);
    }

    public static short cBytesToShort(byte[] datas, int offset) {
        return (short)(datas[offset] & 0xFF | (datas[offset + 1] & 0xFF) << 8);
    }

    public static byte[] ushortToBytes(int n) {
        byte[] datas = new byte[2];
        datas[1] = (byte)(n & 0xFF);
        datas[0] = (byte)(n >> 8 & 0xFF);
        return datas;
    }

    public static byte[] ushortToCBytes(int n) {
        byte[] datas = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return datas;
    }

    public static void ushortToBytes(int n, byte[] array, int offset) {
        array[offset + 1] = (byte)(n & 0xFF);
        array[offset] = (byte)(n >> 8 & 0xFF);
    }

    public static void ushortToCBytes(int n, byte[] array, int offset) {
        array[offset] = (byte)(n & 0xFF);
        array[offset + 1] = (byte)(n >> 8 & 0xFF);
    }

    public static int bytesToUshort(byte[] datas) {
        return datas[1] & 0xFF | (datas[0] & 0xFF) << 8;
    }

    public static int bytesToUshort(byte[] datas, int offset) {
        return datas[offset + 1] & 0xFF | (datas[offset] & 0xFF) << 8;
    }

    public static int cBytesToUshort(byte[] datas) {
        return datas[0] & 0xFF | (datas[1] & 0xFF) << 8;
    }

    public static int cBytesToUshort(byte[] datas, int offset) {
        return datas[offset] & 0xFF | (datas[offset + 1] & 0xFF) << 8;
    }

    public static byte[] ubyteToBytes(int n) {
        byte[] datas = new byte[]{(byte)(n & 0xFF)};
        return datas;
    }

    public static void ubyteToBytes(int n, byte[] array, int offset) {
        array[0] = (byte)(n & 0xFF);
    }

    public static int bytesToUbyte(byte[] array) {
        return array[0] & 0xFF;
    }

    public static int bytesToUbyte(byte[] array, int offset) {
        return array[offset] & 0xFF;
    }

    public static String byte2HexStr(byte[] datas) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < datas.length; ++n) {
            stmp = Integer.toHexString(datas[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }
}

