/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.BufferedRandomAccessFile");
    static ResourceBundle res = ResourceBundle.getBundle("com.hynnet.util.BufferedRandomAccessFileRes");
    private static final int DEFAULT_BUFFER_BIT_LEN = 10;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    protected byte[] buf;
    protected int bufbitlen;
    protected int bufsize;
    protected long bufmask;
    protected boolean bufdirty;
    protected int bufusedsize;
    protected long m_lcurpos;
    protected long bufstartpos;
    protected long bufendpos;
    protected long fileendpos;
    protected boolean append;
    protected String filename;
    protected long initfilelen;
    private boolean m_bFilling = false;

    public BufferedRandomAccessFile(String name) throws IOException {
        this(name, res.getString("r"), 10);
    }

    public BufferedRandomAccessFile(File file) throws IOException, FileNotFoundException {
        this(file.getPath(), res.getString("r"), 10);
    }

    public BufferedRandomAccessFile(String name, int bufbitlen) throws IOException {
        this(name, res.getString("r"), bufbitlen);
    }

    public BufferedRandomAccessFile(File file, int bufbitlen) throws IOException, FileNotFoundException {
        this(file.getPath(), res.getString("r"), bufbitlen);
    }

    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(name, mode, 10);
    }

    public BufferedRandomAccessFile(File file, String mode) throws IOException, FileNotFoundException {
        this(file.getPath(), mode, 10);
    }

    public BufferedRandomAccessFile(String name, String mode, int bufbitlen) throws IOException {
        super(name, mode);
        this.init(name, mode, bufbitlen);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufbitlen) throws IOException, FileNotFoundException {
        this(file.getPath(), mode, bufbitlen);
    }

    private void init(String name, String mode, int bufbitlen) throws IOException {
        this.append = !mode.equals(res.getString("r"));
        this.filename = name;
        this.initfilelen = super.length();
        this.fileendpos = this.initfilelen - 1L;
        this.m_lcurpos = super.getFilePointer();
        if (bufbitlen < 0) {
            throw new IllegalArgumentException(res.getString("bufbitlen_size_must_0"));
        }
        this.bufbitlen = bufbitlen;
        this.bufsize = 1 << bufbitlen;
        this.buf = new byte[this.bufsize];
        this.bufmask = (long)this.bufsize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.bufdirty = false;
        this.bufusedsize = 0;
        this.bufstartpos = -1L;
        this.bufendpos = -1L;
        this.m_bFilling = false;
    }

    private void flushbuf() throws IOException {
        if (this.bufdirty) {
            long lOldpos = this.m_lcurpos;
            this.m_bFilling = true;
            try {
                if (super.getFilePointer() != this.bufstartpos) {
                    super.seek(this.bufstartpos);
                }
                this.m_lcurpos = this.bufstartpos + (long)this.bufusedsize;
                super.write(this.buf, 0, this.bufusedsize);
                this.m_lcurpos = lOldpos;
                this.bufdirty = false;
            }
            catch (IOException eio) {
                throw eio;
            }
            finally {
                this.m_bFilling = false;
            }
        }
    }

    private int fillbuf() throws IOException {
        long lOldpos = this.m_lcurpos;
        this.m_bFilling = true;
        super.seek(this.bufstartpos);
        this.bufdirty = false;
        try {
            int nResult = super.read(this.buf);
            this.m_lcurpos = lOldpos;
            int n = nResult;
            return n;
        }
        catch (IOException eio) {
            throw eio;
        }
        catch (Exception e) {
            log.error("fillbuf\u5f02\u5e38", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            this.m_bFilling = false;
        }
    }

    public byte read(long pos) throws IOException {
        if (pos < this.bufstartpos || pos > this.bufendpos) {
            this.flushbuf();
            this.seek(pos);
            if (pos < this.bufstartpos || pos > this.bufendpos) {
                throw new IOException();
            }
        }
        this.m_lcurpos = pos;
        return this.buf[(int)(pos - this.bufstartpos)];
    }

    public byte readByteData() throws IOException, EOFException {
        if (this.m_lcurpos >= this.length()) {
            throw new EOFException("\u5df2\u5230\u6587\u4ef6\u672b\u7aef\u3002");
        }
        byte cData = this.read(this.m_lcurpos);
        ++this.m_lcurpos;
        return cData;
    }

    public int readLine(byte[] arrayByte) throws IOException {
        int c = -1;
        boolean eol = false;
        int nIndex = 0;
        try {
            block6: while (!eol) {
                byte by = this.readByteData();
                c = by;
                switch (by) {
                    case -1: 
                    case 10: {
                        eol = true;
                        continue block6;
                    }
                    case 13: {
                        eol = true;
                        long cur = this.getFilePointer();
                        if (this.readByteData() == 10) continue block6;
                        this.seek(cur);
                        continue block6;
                    }
                }
                arrayByte[nIndex] = c;
                ++nIndex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nIndex;
    }

    public boolean write(byte bw) throws IOException {
        return this.write(bw, this.m_lcurpos);
    }

    public boolean append(byte bw) throws IOException {
        return this.write(bw, this.fileendpos + 1L);
    }

    public boolean write(byte bw, long pos) throws IOException {
        if (pos >= this.bufstartpos && pos <= this.bufendpos) {
            this.buf[(int)(pos - this.bufstartpos)] = bw;
            this.bufdirty = true;
            if (pos == this.fileendpos + 1L) {
                ++this.fileendpos;
                ++this.bufusedsize;
            }
        } else {
            this.seek(pos);
            if (pos >= 0L && pos <= this.fileendpos && this.fileendpos != 0L) {
                this.buf[(int)(pos - this.bufstartpos)] = bw;
            } else if (pos == 0L && this.fileendpos == 0L || pos == this.fileendpos + 1L) {
                this.buf[0] = bw;
                ++this.fileendpos;
                this.bufusedsize = 1;
            } else {
                throw new IndexOutOfBoundsException();
            }
            this.bufdirty = true;
        }
        this.m_lcurpos = pos;
        return true;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        long writeendpos = this.m_lcurpos + (long)len - 1L;
        if (writeendpos <= this.bufendpos) {
            System.arraycopy(b, off, this.buf, (int)(this.m_lcurpos - this.bufstartpos), len);
            this.bufdirty = true;
            this.bufusedsize = (int)(writeendpos - this.bufstartpos + 1L);
        } else {
            long lOldpos = this.m_lcurpos;
            try {
                this.m_bFilling = true;
                super.seek(this.m_lcurpos);
                this.m_lcurpos += (long)len;
                super.write(b, off, len);
                this.m_lcurpos = lOldpos;
            }
            catch (IOException eio) {
                throw eio;
            }
            finally {
                this.m_bFilling = false;
            }
        }
        if (writeendpos > this.fileendpos) {
            this.fileendpos = writeendpos;
        }
        this.seek(writeendpos + 1L);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.m_bFilling) {
            long readendpos = this.m_lcurpos + (long)len - 1L;
            if (readendpos <= this.bufendpos && readendpos <= this.fileendpos) {
                System.arraycopy(this.buf, (int)(this.m_lcurpos - this.bufstartpos), b, off, len);
            } else {
                long lOldpos = this.m_lcurpos;
                if (readendpos > this.fileendpos) {
                    len = (int)(this.length() - this.m_lcurpos + 1L);
                }
                try {
                    this.m_bFilling = true;
                    super.seek(this.m_lcurpos);
                    this.m_lcurpos += (long)len;
                    len = super.read(b, off, len);
                    this.m_lcurpos = lOldpos;
                }
                catch (IOException eio) {
                    throw eio;
                }
                finally {
                    this.m_bFilling = false;
                }
                readendpos = this.m_lcurpos + (long)len - 1L;
            }
            this.seek(readendpos + 1L);
            return len;
        }
        return super.read(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void seek(long pos) throws IOException {
        if (this.m_lcurpos == pos && pos > 0L) {
            return;
        }
        if (!this.m_bFilling) {
            this.flushbuf();
            if (pos < this.bufstartpos || pos > this.bufendpos) {
                if (pos >= 0L && pos <= this.fileendpos && this.fileendpos != 0L) {
                    this.bufstartpos = pos & this.bufmask;
                    this.m_lcurpos = pos;
                    this.bufusedsize = this.fillbuf();
                    this.bufstartpos = pos & this.bufmask;
                } else if (pos == 0L && this.fileendpos == 0L || pos == this.fileendpos + 1L) {
                    this.bufstartpos = pos;
                    this.bufusedsize = 0;
                }
                this.bufendpos = this.bufstartpos + (long)this.bufsize - 1L;
            }
            this.m_lcurpos = pos;
        }
    }

    public long length() throws IOException {
        return this.max(this.fileendpos + 1L, this.initfilelen);
    }

    public void setLength(long newLength) throws IOException {
        this.fileendpos = newLength > 0L ? newLength - 1L : 0L;
        super.setLength(newLength);
    }

    public long getFilePointer() throws IOException {
        if (!this.m_bFilling) {
            return this.m_lcurpos;
        }
        return super.getFilePointer();
    }

    private long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public void close() throws IOException {
        this.flushbuf();
        super.close();
    }

    public static void main(String[] args) throws IOException {
        int readcount;
        long readfilelen = 0L;
        BufferedRandomAccessFile brafReadFile = new BufferedRandomAccessFile("C:\\WINNT\\Fonts\\STKAITI.TTF");
        readfilelen = brafReadFile.initfilelen;
        BufferedRandomAccessFile brafWriteFile = new BufferedRandomAccessFile(".\\STKAITI.001", "rw", 10);
        byte[] buf = new byte[1024];
        long start = System.currentTimeMillis();
        while ((readcount = brafReadFile.read(buf)) != -1) {
            brafWriteFile.write(buf, 0, readcount);
        }
        brafWriteFile.close();
        brafReadFile.close();
        System.out.println("BufferedRandomAccessFile Copy & Write File: " + brafReadFile.filename + "    FileSize: " + Integer.toString((int)readfilelen >> 1024) + " (KB)    Spend: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "(s)");
        FileInputStream fdin = new FileInputStream("C:\\WINNT\\Fonts\\STKAITI.TTF");
        BufferedInputStream bis = new BufferedInputStream(fdin, 1024);
        DataInputStream dis = new DataInputStream(bis);
        FileOutputStream fdout = new FileOutputStream(".\\STKAITI.002");
        BufferedOutputStream bos = new BufferedOutputStream(fdout, 1024);
        DataOutputStream dos = new DataOutputStream(bos);
        start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < readfilelen) {
            dos.write(dis.readByte());
            ++i;
        }
        dos.close();
        dis.close();
        System.out.println("DataBufferedios Copy & Write File: " + brafReadFile.filename + "    FileSize: " + Integer.toString((int)readfilelen >> 1024) + " (KB)    Spend: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "(s)");
    }
}

