/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.LongList;
import com.hynnet.util.StringList;
import com.hynnet.util.StringSearchAndReplace;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserInfo {
    private static final Logger log = LoggerFactory.getLogger(BrowserInfo.class);
    private static final int INDEX_KEY_MSIE = 0;
    private static final int INDEX_KEY_MSIE_VER = 1;
    private static final int INDEX_KEY_MSIE11 = 2;
    private static final int INDEX_KEY_TRIDENT = 3;
    private static final int INDEX_KEY_WINDOWS = 4;
    private static final int INDEX_KEY_VERSION = 5;
    private static final int INDEX_KEY_COMPATIBLE = 6;
    private static final int INDEX_KEY_SECURITY_N = 7;
    private static final int INDEX_KEY_SECURITY_I = 8;
    private static final int INDEX_KEY_SECURITY_U = 9;
    private static final int INDEX_KEY_ZH_CN = 10;
    private static final int INDEX_KEY_ZH_TW = 11;
    private static final int INDEX_KEY_EN_US = 12;
    private static final int INDEX_KEY_FIREFOX = 13;
    private static final int INDEX_KEY_CHROME = 14;
    private static final int INDEX_KEY_SAFARI = 15;
    private static final int INDEX_KEY_MICROMESSENGER = 16;
    private static final int INDEX_KEY_IPAD = 17;
    private static final int INDEX_KEY_CPU_OS = 18;
    private static final int INDEX_KEY_ANDROID = 19;
    private static final int INDEX_KEY_BUILD = 20;
    private static final int INDEX_KEY_NETTYPE = 21;
    private static final int INDEX_KEY_WOW = 22;
    private static final int INDEX_KEY_X86 = 23;
    private static final int INDEX_KEY_X64 = 24;
    private static final int INDEX_KEY_X128 = 25;
    private static final int INDEX_KEY_WIN_VER = 26;
    private static final int INDEX_KEY_LINUX = 27;
    private static final int INDEX_KEY_FREEBSD = 28;
    private static final int INDEX_KEY_OPENBSD = 29;
    private static final int INDEX_KEY_I386_PC = 30;
    private static final char[][] MATCH_KEY_START = new char[][]{"MSIE".toCharArray(), "rv:".toCharArray(), "like Gecko".toCharArray(), "Trident".toCharArray(), "Windows".toCharArray(), "Version".toCharArray(), "compatible".toCharArray(), "N".toCharArray(), "I".toCharArray(), "U".toCharArray(), "zh-cn".toCharArray(), "zh-tw".toCharArray(), "en-US".toCharArray(), "Firefox".toCharArray(), "Chrome".toCharArray(), "Safari".toCharArray(), "MicroMessenger".toCharArray(), "iPad".toCharArray(), "CPU OS".toCharArray(), "Android".toCharArray(), " Build/".toCharArray(), "NetType/".toCharArray(), "WOW".toCharArray(), "x86".toCharArray(), "x64".toCharArray(), "x128".toCharArray(), "Win".toCharArray(), "Linux".toCharArray(), "FreeBSD".toCharArray(), "OpenBSD".toCharArray(), "i386-pc-".toCharArray()};
    private static final char[][] MATCH_KEY_END = new char[][]{";)".toCharArray(), ";)".toCharArray(), ";) ".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), " ".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), ";)".toCharArray(), " ;)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), " ".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ";)".toCharArray(), ") ;".toCharArray()};
    private static final char[][] MATCH_KEY_BEFORE = new char[][]{" ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), "".toCharArray(), "".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), " ".toCharArray()};
    private static final char[][] MATCH_KEY_FIRST_ALLOW = new char[][]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, " ".toCharArray(), " ".toCharArray(), null, null, null, null, null, null, null, " ".toCharArray(), " ".toCharArray(), " ".toCharArray(), null};
    private static final char[][] MATCH_KEY_DATA_ALLOW = new char[][]{null, null, null, null, null, null, "".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), null, null, null, null, null, null, null, null, "0123456789._".toCharArray(), "0123456789.".toCharArray(), null, null, "0123456789".toCharArray(), "".toCharArray(), "".toCharArray(), "".toCharArray(), "123468".toCharArray(), null, null, null, null};
    private static final boolean[] MATCH_KEY_IGNORE_CASE = new boolean[]{false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, true};
    private String m_engineName;
    private int m_engineMajorVersion;
    private int m_engineMinorVersion;
    private int m_engineRevision;
    private String m_userAgent;
    private String m_acceptEncoding;
    private String m_acceptLanguage;
    private BROWSER_TYPE m_browserType;
    private String m_browserName;
    private int m_majorVersion;
    private int m_minorVersion;
    private int m_revision;
    private String m_netTypeName;
    private ARCHITECTURE m_architecture = ARCHITECTURE.ARCHITECTURE_UNKNOWN;
    private OSTYPE m_osType;
    private String m_osName;
    private int m_osMajorVersion;
    private int m_osMinorVersion;
    private int m_osRevision;
    private DEVTYPE m_deviceType;
    private String m_deviceBuild;
    private String m_deviceName;
    private SECURITY_LEVEL m_securityLevel;
    private String m_lang;
    private boolean m_hasCompatibleMode = false;
    private boolean m_isCompatibleMode = false;

    public BrowserInfo(String userAgent) {
        this.init(userAgent);
    }

    public BrowserInfo(HttpServletRequest request) {
        this.m_acceptEncoding = request.getHeader("Accept-Encoding");
        this.m_acceptLanguage = request.getHeader("Accept-Language");
        this.init(request != null ? request.getHeader("User-Agent") : null);
    }

    private final void init(String userAgent) {
        this.m_browserType = BROWSER_TYPE.TYPE_UNKNOWN;
        this.m_osType = OSTYPE.OSTYPE_UNKNOWN;
        this.m_deviceType = DEVTYPE.DEVTYPE_UNKNOWN;
        this.m_securityLevel = SECURITY_LEVEL.SECURITY_LEVEL_UNKNOWN;
        if (userAgent != null && userAgent.length() > 0) {
            int start = userAgent.indexOf(40);
            int slash = userAgent.indexOf(47);
            BrowserParse parser = new BrowserParse();
            this.m_userAgent = userAgent;
            if (slash > 0 && (start < 0 || slash < start)) {
                this.m_engineName = userAgent.substring(0, slash).trim();
                long[] arrayVer = this.getVersion(start < 0 ? userAgent.substring(slash + 1) : userAgent.substring(slash + 1, start));
                if (arrayVer.length >= 1) {
                    this.m_engineMajorVersion = (int)arrayVer[0];
                }
                if (arrayVer.length >= 2) {
                    this.m_engineMinorVersion = (int)arrayVer[1];
                }
                if (arrayVer.length >= 3) {
                    this.m_engineRevision = (int)arrayVer[2];
                }
                if ("Opera".equals(this.m_engineName)) {
                    this.m_browserType = BROWSER_TYPE.TYPE_OPERA;
                } else if ("curl".equals(this.m_engineName)) {
                    this.m_browserType = BROWSER_TYPE.TYPE_CURL;
                    this.m_majorVersion = this.m_engineMajorVersion;
                    this.m_minorVersion = this.m_engineMinorVersion;
                    this.m_revision = this.m_engineRevision;
                    if (start < 0) {
                        this.m_osType = OSTYPE.OSTYPE_OTHER;
                        this.m_deviceType = DEVTYPE.DEVTYPE_OTHER;
                    }
                } else if ("IntelliJ IDEA".equals(this.m_engineName)) {
                    this.m_browserType = BROWSER_TYPE.TYPE_INTELLIJ;
                    this.m_majorVersion = this.m_engineMajorVersion;
                    this.m_minorVersion = this.m_engineMinorVersion;
                    this.m_revision = this.m_engineRevision;
                }
            }
            if (start > 0) {
                parser.searchAndReplace(userAgent.substring(start + 1));
            }
            if (userAgent.indexOf("iPhone") > 0) {
                this.m_deviceType = DEVTYPE.DEVTYPE_PHONE;
            }
            if (userAgent.indexOf("Mac OS X") > 0) {
                OSTYPE oSTYPE = this.m_osType = this.m_deviceType == DEVTYPE.DEVTYPE_PHONE || this.m_deviceType == DEVTYPE.DEVTYPE_PAD ? OSTYPE.OSTYPE_IOS : OSTYPE.OSTYPE_MACOS;
            }
        }
        if ((this.m_browserType == BROWSER_TYPE.TYPE_UNKNOWN || this.m_osType == OSTYPE.OSTYPE_UNKNOWN || this.m_deviceType == DEVTYPE.DEVTYPE_UNKNOWN) && this.m_browserType != BROWSER_TYPE.TYPE_INTELLIJ) {
            log.debug("\u65e0\u6cd5\u8fa8\u8bc6\u5ba2\u6237\u7aef{}{}{}{}{}\u6d4f\u89c8\u5668\u4fe1\u606f\uff1aUserAgent:{}", new Object[]{this.m_browserType == BROWSER_TYPE.TYPE_UNKNOWN ? "\u6d4f\u89c8\u5668\u7c7b\u578b" : "", this.m_browserType == BROWSER_TYPE.TYPE_UNKNOWN ? "\uff0c" : "", this.m_osType == OSTYPE.OSTYPE_UNKNOWN ? "\u7cfb\u7edf\u7c7b\u578b" : "", this.m_browserType == BROWSER_TYPE.TYPE_UNKNOWN || this.m_osType == OSTYPE.OSTYPE_UNKNOWN ? "\uff0c" : "", this.m_deviceType == DEVTYPE.DEVTYPE_UNKNOWN ? "\u8bbe\u5907\u7c7b\u578b" : "", this.m_userAgent});
        }
    }

    public final String getEngineName() {
        return this.m_engineName;
    }

    public final int getEngineMajorVersion() {
        return this.m_engineMajorVersion;
    }

    public final int getEngineMinorVersion() {
        return this.m_engineMinorVersion;
    }

    public final int getEngineRevision() {
        return this.m_engineRevision;
    }

    public final BROWSER_TYPE getType() {
        return this.m_browserType;
    }

    public final String getName() {
        return this.m_browserName;
    }

    public final int getMajorVersion() {
        return this.m_majorVersion;
    }

    public final int getMinorVersion() {
        return this.m_minorVersion;
    }

    public final int getRevision() {
        return this.m_revision;
    }

    public final NETTYPE getNetType() {
        return NETTYPE.get(this.m_netTypeName);
    }

    public final String getNetTypeName() {
        return this.m_netTypeName;
    }

    public final ARCHITECTURE getArchitecture() {
        return this.m_architecture;
    }

    public final OSTYPE getOsType() {
        return this.m_osType;
    }

    public final String getOsName() {
        return this.m_osName;
    }

    public final int getOsMajorVersion() {
        return this.m_osMajorVersion;
    }

    public final int getOsMinorVersion() {
        return this.m_osMinorVersion;
    }

    public final int getOsRevision() {
        return this.m_osRevision;
    }

    public final DEVTYPE getDeviceType() {
        return this.m_deviceType;
    }

    public final String getDeviceBuild() {
        return this.m_deviceBuild;
    }

    public final String getDeviceName() {
        return this.m_deviceName;
    }

    public final SECURITY_LEVEL getSecurityLevel() {
        return this.m_securityLevel;
    }

    public final String getLang() {
        return this.m_lang;
    }

    public final String getAcceptEncodingData() {
        return this.m_acceptEncoding;
    }

    public final String getAcceptLanguageData() {
        return this.m_acceptLanguage;
    }

    public final Charset getAcceptLanguage() {
        if (this.m_acceptLanguage != null) {
            String[] encs;
            for (String enc : encs = this.m_acceptLanguage.split(",")) {
                try {
                    return Charset.forName(enc);
                }
                catch (IllegalCharsetNameException e) {
                }
                catch (UnsupportedCharsetException e) {
                    // empty catch block
                }
            }
        }
        if (this.m_lang != null) {
            try {
                return Charset.forName(this.m_lang);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return null;
    }

    public final Charset[] getAcceptLanguages() {
        HashSet<Charset> charsets = new HashSet<Charset>(1);
        if (this.m_acceptLanguage != null) {
            String[] encs;
            for (String enc : encs = this.m_acceptLanguage.split(",")) {
                try {
                    Charset ch = Charset.forName(enc);
                    if (charsets.contains(ch)) continue;
                    charsets.add(ch);
                }
                catch (IllegalCharsetNameException e) {
                }
                catch (UnsupportedCharsetException e) {
                    // empty catch block
                }
            }
        }
        if (this.m_lang != null) {
            try {
                Charset ch = Charset.forName(this.m_lang);
                if (!charsets.contains(ch)) {
                    charsets.add(ch);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charsets.toArray(new Charset[0]);
    }

    public final String getUserAgent() {
        return this.m_userAgent;
    }

    public String[] getAllVersion(String strKey) {
        StringList lstVer = new StringList();
        return lstVer.toStringArray();
    }

    public final boolean isCompatibleMode() {
        return this.m_isCompatibleMode;
    }

    private final long[] getVersion(String strVer) {
        char ch;
        int len;
        if (strVer == null || (len = strVer.length()) == 0) {
            return new long[0];
        }
        LongList lstIndexDot = new LongList();
        LongList lstVal = new LongList();
        int nIndex = 0;
        while (nIndex < len) {
            int pos = strVer.indexOf(46, nIndex);
            if (pos >= 0 || (pos = strVer.indexOf(95, nIndex)) >= 0) {
                lstIndexDot.add(pos);
            }
            if (pos < 0) break;
            nIndex = pos + 1;
        }
        for (nIndex = 0; nIndex < len && ((ch = strVer.charAt(nIndex)) < '0' || ch > '9'); ++nIndex) {
            if (nIndex < strVer.length()) continue;
            return new long[0];
        }
        for (int n = 0; n <= lstIndexDot.size(); ++n) {
            String strNum;
            if (n < lstIndexDot.size()) {
                strNum = strVer.substring(nIndex, (int)lstIndexDot.getLong(n)).trim();
            } else {
                int nIndexEnd;
                if (n > 0) {
                    nIndex = (int)lstIndexDot.getLong(n - 1) + 1;
                }
                for (nIndexEnd = strVer.length(); nIndexEnd > 0 && ((ch = strVer.charAt(nIndexEnd - 1)) < '0' || ch > '9'); --nIndexEnd) {
                }
                strNum = strVer.substring(nIndex, nIndexEnd > nIndex ? nIndexEnd : nIndex).trim();
            }
            try {
                if (strNum.length() >= 2 && strNum.charAt(0) == '0' && n == 1 && lstIndexDot.size() < 2) {
                    lstVal.add(0L);
                }
                lstVal.add(Long.parseLong(strNum));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= lstIndexDot.size()) continue;
            nIndex = (int)lstIndexDot.getLong(n) + 1;
        }
        return lstVal.toLongArray();
    }

    private final void setVersion(String ver) {
        long[] arrayVer = this.getVersion(ver);
        if (arrayVer.length >= 1) {
            this.m_majorVersion = (int)arrayVer[0];
        }
        if (arrayVer.length >= 2) {
            this.m_minorVersion = (int)arrayVer[1];
        }
        if (arrayVer.length >= 3) {
            this.m_revision = (int)arrayVer[2];
        }
    }

    private final void setOsVersion(String ver) {
        long[] arrayVer = this.getVersion(ver);
        if (arrayVer.length >= 1) {
            this.m_osMajorVersion = (int)arrayVer[0];
        }
        if (arrayVer.length >= 2) {
            this.m_osMinorVersion = (int)arrayVer[1];
        }
        if (arrayVer.length >= 3) {
            this.m_osRevision = (int)arrayVer[2];
        }
    }

    public static void main(String[] args) {
        BrowserInfo objBrowser = new BrowserInfo("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; Trident/5.0; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; .NET4.0C; .NET4.0E; InfoPath.3)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 4) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_IE) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 9) + "\tCompatibleMode:" + objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.0; Trident/5.0)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_IE) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 9) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 4) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_IE) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 8) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; InfoPath.1; .NET CLR 2.0.50727; .NET CLR 3.0.04506.648; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 4) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_IE) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 8) + "\tCompatibleMode:" + objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 2.0.50727; .NET4.0C)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 4) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_IE) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 7) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Opera/9.80 (Windows NT 6.0; U; zh-cn) Presto/2.9.168 Version/11.51");
        System.out.println("test... EngineName:" + "Opera".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 9) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 80) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_OPERA) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 11) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 51) + "\tLang:" + "zh-cn".equals(objBrowser.getLang()) + "\tSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\r\nCompatibleMode:" + !objBrowser.isCompatibleMode());
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; zh-CN; rv:1.9.1.3) Gecko/20090824 Firefox/3.5.3 (.NET CLR 3.5.30729)");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_FIREFOX) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 3) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 5) + "\tRevision:" + (objBrowser.getRevision() == 3) + "\tLang:" + "zh-cn".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/534.1 (KHTML, like Gecko) Chrome/6.0.419.0 Safari/534.1");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_CHROME) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 6) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 0) + "\tRevision:" + (objBrowser.getRevision() == 419) + "\tLang:" + "en-US".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/533.3 (KHTML, like Gecko) Chrome/5.0.361.0 Safari/533.3");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_CHROME) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 5) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 0) + "\tRevision:" + (objBrowser.getRevision() == 361) + "\tLang:" + "en-us".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_CHROME) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 0) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 2) + "\tRevision:" + (objBrowser.getRevision() == 149) + "\tLang:" + "en-us".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; zh-CN) AppleWebKit/531.21.8 (KHTML, like Gecko) Version/4.0.4 Safari/531.21.10");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_SAFARI) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 4) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 0) + "\tRevision:" + (objBrowser.getRevision() == 4) + "\tLang:" + "zh-cn".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
        objBrowser = new BrowserInfo("Mozilla/5.0 (Windows; U; Windows NT 6.0; zh-CN) AppleWebKit/533.18.1 (KHTML, like Gecko) Version/5.0.2 Safari/533.18.5");
        System.out.println("test... EngineName:" + "Mozilla".equals(objBrowser.getEngineName()) + "\tEngineMajorVersion:" + (objBrowser.getEngineMajorVersion() == 5) + "\tEngineMinorVerson:" + (objBrowser.getEngineMinorVersion() == 0) + "\tType:" + (objBrowser.getType() == BROWSER_TYPE.TYPE_SAFARI) + "\tMajorVerson:" + (objBrowser.getMajorVersion() == 5) + "\tMinorVerson:" + (objBrowser.getMinorVersion() == 0) + "\tRevision:" + (objBrowser.getRevision() == 2) + "\tLang:" + "zh-cn".equals(objBrowser.getLang()) + "\r\nSecurityLevel:" + (objBrowser.getSecurityLevel() == SECURITY_LEVEL.SECURITY_LEVEL_STRONG) + "\tCompatibleMode:" + !objBrowser.isCompatibleMode() + "\tOSType:" + (objBrowser.getOsType() == OSTYPE.OSTYPE_WINVISTA));
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Type=").append((Object)this.getType()).append(" MajorVersion=").append(this.getMajorVersion()).append(" MinorVersion=").append(this.getMinorVersion()).append(" OSType=").append((Object)this.getOsType()).append(" UserAgent:").append(this.m_userAgent);
        return sbuf.toString();
    }

    private class BrowserParse
    extends StringSearchAndReplace {
        private BrowserParse() {
        }

        protected char[][] getMatchAllowFirstChar() {
            return MATCH_KEY_FIRST_ALLOW;
        }

        protected char[][] getMatchDataAllowChar() {
            return MATCH_KEY_DATA_ALLOW;
        }

        protected char[][] getMatchEndChar() {
            return MATCH_KEY_END;
        }

        protected char[][] getMatchKeyAllowAfterChar() {
            return MATCH_KEY_BEFORE;
        }

        protected boolean[] getMatchKeyIgnoreCase() {
            return MATCH_KEY_IGNORE_CASE;
        }

        protected char[][] getMatchKeyStart() {
            return MATCH_KEY_START;
        }

        protected boolean isNotEndChar(char chCur) {
            return false;
        }

        protected StringBuffer processMatchData(int nMatch, StringBuffer sbufCurrentResult, StringBuffer sbufMatchKey, StringBuffer sbufMatchData, char endChar) {
            switch (nMatch) {
                case 0: {
                    BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_IE;
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length >= 1) {
                        BrowserInfo.this.m_majorVersion = (int)arrayVer[0];
                    }
                    if (arrayVer.length >= 2) {
                        BrowserInfo.this.m_minorVersion = (int)arrayVer[1];
                    }
                    if (arrayVer.length < 3) break;
                    BrowserInfo.this.m_revision = (int)arrayVer[2];
                    break;
                }
                case 1: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length >= 1) {
                        BrowserInfo.this.m_majorVersion = (int)arrayVer[0];
                    }
                    if (arrayVer.length >= 2) {
                        BrowserInfo.this.m_minorVersion = (int)arrayVer[1];
                    }
                    if (arrayVer.length < 3) break;
                    BrowserInfo.this.m_revision = (int)arrayVer[2];
                    break;
                }
                case 2: {
                    if (BrowserInfo.this.m_majorVersion <= 0) break;
                    BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_IE;
                    break;
                }
                case 3: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length < 1 || BrowserInfo.this.m_majorVersion != 7) break;
                    switch ((int)arrayVer[0]) {
                        case 4: {
                            BrowserInfo.this.m_majorVersion = 8;
                            BrowserInfo.this.m_isCompatibleMode = BrowserInfo.this.m_hasCompatibleMode;
                            break;
                        }
                        case 5: {
                            BrowserInfo.this.m_majorVersion = 9;
                            BrowserInfo.this.m_isCompatibleMode = BrowserInfo.this.m_hasCompatibleMode;
                        }
                    }
                    break;
                }
                case 4: {
                    int nIndex = sbufMatchData.indexOf("NT");
                    if (nIndex >= 0) {
                        long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.substring(nIndex + 2));
                        if (arrayVer.length >= 1) {
                            BrowserInfo.this.m_osMajorVersion = (int)arrayVer[0];
                        }
                        if (arrayVer.length >= 2) {
                            BrowserInfo.this.m_osMinorVersion = (int)arrayVer[1];
                        }
                        if (arrayVer.length >= 3) {
                            BrowserInfo.this.m_osRevision = (int)arrayVer[2];
                        }
                        block35 : switch (BrowserInfo.this.m_osMajorVersion) {
                            case 5: {
                                switch (BrowserInfo.this.m_osMinorVersion) {
                                    case 1: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WINXP;
                                        break block35;
                                    }
                                    case 2: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN2003;
                                        break block35;
                                    }
                                }
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_OTHER;
                                break;
                            }
                            case 6: {
                                switch (BrowserInfo.this.m_osMinorVersion) {
                                    case 0: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WINVISTA;
                                        break block35;
                                    }
                                    case 1: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN7;
                                        break block35;
                                    }
                                    case 2: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN8;
                                        break block35;
                                    }
                                    case 3: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN81;
                                        break block35;
                                    }
                                    case 4: {
                                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN10;
                                        break block35;
                                    }
                                }
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_OTHER;
                                break;
                            }
                            case 10: {
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WIN10;
                            }
                        }
                        BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_COMPUTER;
                        break;
                    }
                    nIndex = sbufMatchData.indexOf("Phone");
                    if (nIndex < 0) break;
                    BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WINDOWS_PHONE;
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_PHONE;
                    break;
                }
                case 19: {
                    BrowserInfo.this.m_osType = OSTYPE.OSTYPE_ANDROID;
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_PHONE;
                    BrowserInfo.this.setOsVersion(sbufMatchData.toString());
                    break;
                }
                case 5: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length >= 1) {
                        BrowserInfo.this.m_majorVersion = (int)arrayVer[0];
                    }
                    if (arrayVer.length >= 2) {
                        BrowserInfo.this.m_minorVersion = (int)arrayVer[1];
                    }
                    if (arrayVer.length < 3) break;
                    BrowserInfo.this.m_revision = (int)arrayVer[2];
                    break;
                }
                case 6: {
                    BrowserInfo.this.m_hasCompatibleMode = true;
                    break;
                }
                case 7: {
                    BrowserInfo.this.m_securityLevel = SECURITY_LEVEL.SECURITY_LEVEL_NONE;
                    break;
                }
                case 8: {
                    BrowserInfo.this.m_securityLevel = SECURITY_LEVEL.SECURITY_LEVEL_WEAK;
                    break;
                }
                case 9: {
                    BrowserInfo.this.m_securityLevel = SECURITY_LEVEL.SECURITY_LEVEL_STRONG;
                    break;
                }
                case 10: {
                    BrowserInfo.this.m_lang = "zh-cn";
                    break;
                }
                case 11: {
                    BrowserInfo.this.m_lang = "zh-tw";
                    break;
                }
                case 12: {
                    BrowserInfo.this.m_lang = "en-us";
                    break;
                }
                case 13: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length >= 1) {
                        BrowserInfo.this.m_majorVersion = (int)arrayVer[0];
                        BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_FIREFOX;
                    }
                    if (arrayVer.length >= 2) {
                        BrowserInfo.this.m_minorVersion = (int)arrayVer[1];
                    }
                    if (arrayVer.length < 3) break;
                    BrowserInfo.this.m_revision = (int)arrayVer[2];
                    break;
                }
                case 14: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length >= 1) {
                        BrowserInfo.this.m_majorVersion = (int)arrayVer[0];
                        BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_CHROME;
                    }
                    if (arrayVer.length >= 2) {
                        BrowserInfo.this.m_minorVersion = (int)arrayVer[1];
                    }
                    if (arrayVer.length < 3) break;
                    BrowserInfo.this.m_revision = (int)arrayVer[2];
                    break;
                }
                case 15: {
                    if (BrowserInfo.this.m_browserType != BROWSER_TYPE.TYPE_UNKNOWN) break;
                    BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_SAFARI;
                    BrowserInfo.this.setVersion(sbufMatchData.toString());
                    break;
                }
                case 16: {
                    BrowserInfo.this.m_browserType = BROWSER_TYPE.TYPE_MICROMESSENGER;
                    BrowserInfo.this.setVersion(sbufMatchData.toString());
                    break;
                }
                case 30: {
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_COMPUTER;
                    if ("win32".equalsIgnoreCase(sbufMatchData.toString())) {
                        BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_32BIT;
                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WINDOWS;
                        break;
                    }
                    if ("win64".equalsIgnoreCase(sbufMatchData.toString())) {
                        BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_64BIT;
                        BrowserInfo.this.m_osType = OSTYPE.OSTYPE_WINDOWS;
                        break;
                    }
                    log.info("\u672a\u5b8c\u5168\u652f\u6301\u7684\u6570\u636e\uff1a{}", (Object)BrowserInfo.this.m_userAgent);
                    break;
                }
                case 17: {
                    BrowserInfo.this.m_osType = OSTYPE.OSTYPE_IOS;
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_PAD;
                    break;
                }
                case 18: {
                    BrowserInfo.this.setOsVersion(sbufMatchData.toString());
                    break;
                }
                case 20: {
                    int nIndex = sbufCurrentResult.lastIndexOf(";");
                    if (nIndex < 0) {
                        nIndex = sbufCurrentResult.lastIndexOf("(");
                    }
                    if (nIndex >= 0) {
                        int len = sbufCurrentResult.length();
                        ++nIndex;
                        while (nIndex < len && sbufCurrentResult.charAt(nIndex) == ' ') {
                            ++nIndex;
                        }
                        BrowserInfo.this.m_deviceName = sbufCurrentResult.substring(nIndex).trim();
                    }
                    if (sbufMatchData.length() > 0 && sbufMatchData.charAt(0) == '/') {
                        sbufMatchData.delete(0, 1);
                    }
                    if ((nIndex = sbufMatchData.length()) > 0 && sbufMatchData.charAt(nIndex - 1) == ')') {
                        sbufMatchData.delete(nIndex - 1, nIndex);
                    }
                    BrowserInfo.this.m_deviceBuild = sbufMatchData.toString().trim();
                    if (BrowserInfo.this.m_deviceType != DEVTYPE.DEVTYPE_UNKNOWN || BrowserInfo.this.m_osType != OSTYPE.OSTYPE_ANDROID) break;
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_PHONE;
                    break;
                }
                case 21: {
                    BrowserInfo.this.m_netTypeName = sbufMatchData.toString().trim();
                    break;
                }
                case 22: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length < 1) break;
                    switch ((int)arrayVer[0]) {
                        case 32: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_WOW32;
                            break;
                        }
                        case 64: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_WOW64;
                            break;
                        }
                        case 128: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_WOW128;
                        }
                    }
                    break;
                }
                case 23: {
                    BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_32BIT;
                    break;
                }
                case 24: {
                    BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_64BIT;
                    break;
                }
                case 25: {
                    BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_128BIT;
                    break;
                }
                case 26: {
                    long[] arrayVer = BrowserInfo.this.getVersion(sbufMatchData.toString());
                    if (arrayVer.length < 1) break;
                    switch ((int)arrayVer[0]) {
                        case 32: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_32BIT;
                            break;
                        }
                        case 64: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_64BIT;
                            break;
                        }
                        case 128: {
                            BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_128BIT;
                        }
                    }
                    break;
                }
                case 27: 
                case 28: 
                case 29: {
                    if (sbufMatchData.length() <= 1) break;
                    String version = sbufMatchData.toString().trim();
                    if (version.length() > 1 && version.charAt(version.length() - 1) == ';') {
                        version = version.substring(0, version.length() - 1);
                    }
                    if (version.length() <= 0) break;
                    BrowserInfo.this.m_deviceType = DEVTYPE.DEVTYPE_COMPUTER;
                    if (BrowserInfo.this.m_osType == OSTYPE.OSTYPE_UNKNOWN) {
                        switch (nMatch) {
                            case 27: {
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_LINUX;
                                break;
                            }
                            case 28: {
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_FREEBSD;
                                break;
                            }
                            case 29: {
                                BrowserInfo.this.m_osType = OSTYPE.OSTYPE_OPENBSD;
                            }
                        }
                    }
                    if ("i686".equals(version) || "i386".equals(version)) {
                        BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_32BIT;
                        break;
                    }
                    if ("x86_64".equals(version)) {
                        BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_64BIT;
                        break;
                    }
                    if (!"x86_128".equals(version)) break;
                    BrowserInfo.this.m_architecture = ARCHITECTURE.ARCHITECTURE_128BIT;
                }
            }
            StringBuffer res = new StringBuffer();
            res.append(sbufMatchKey).append(sbufMatchData);
            if (endChar != '\u0000') {
                res.append(endChar);
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SECURITY_LEVEL {
        SECURITY_LEVEL_UNKNOWN,
        SECURITY_LEVEL_NONE,
        SECURITY_LEVEL_WEAK,
        SECURITY_LEVEL_STRONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DEVTYPE {
        DEVTYPE_UNKNOWN,
        DEVTYPE_OTHER,
        DEVTYPE_COMPUTER,
        DEVTYPE_PHONE,
        DEVTYPE_NOTE,
        DEVTYPE_PAD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ARCHITECTURE {
        ARCHITECTURE_16BIT,
        ARCHITECTURE_32BIT,
        ARCHITECTURE_64BIT,
        ARCHITECTURE_128BIT,
        ARCHITECTURE_WOW32,
        ARCHITECTURE_WOW64,
        ARCHITECTURE_WOW128,
        ARCHITECTURE_UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSTYPE {
        OSTYPE_UNKNOWN,
        OSTYPE_WIN3,
        OSTYPE_WIN98,
        OSTYPE_WINNT,
        OSTYPE_WIN2000,
        OSTYPE_WINXP,
        OSTYPE_WIN2003,
        OSTYPE_WINVISTA,
        OSTYPE_WIN7,
        OSTYPE_WIN8,
        OSTYPE_WIN81,
        OSTYPE_WIN10,
        OSTYPE_WINDOWS,
        OSTYPE_LINUX,
        OSTYPE_FREEBSD,
        OSTYPE_OPENBSD,
        OSTYPE_MACOS,
        OSTYPE_IOS,
        OSTYPE_ANDROID,
        OSTYPE_WINDOWS_PHONE,
        OSTYPE_OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NETTYPE {
        NETTYPE_CMNET,
        NETTYPE_CMWAP,
        NETTYPE_3GNET,
        NETTYPE_CTNET,
        NETTYPE_WIFI,
        NETTYPE_OTHER;


        static NETTYPE get(String netTypeName) {
            if ("CMNET".equalsIgnoreCase(netTypeName)) {
                return NETTYPE_CMNET;
            }
            if ("3gnet".equalsIgnoreCase(netTypeName)) {
                return NETTYPE_3GNET;
            }
            if ("CMWAP".equalsIgnoreCase(netTypeName)) {
                return NETTYPE_CMWAP;
            }
            if ("CTNET".equalsIgnoreCase(netTypeName)) {
                return NETTYPE_CTNET;
            }
            if ("WIFI".equalsIgnoreCase(netTypeName)) {
                return NETTYPE_WIFI;
            }
            return NETTYPE_OTHER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BROWSER_TYPE {
        TYPE_UNKNOWN,
        TYPE_IE,
        TYPE_FIREFOX,
        TYPE_OPERA,
        TYPE_CHROME,
        TYPE_SAFARI,
        TYPE_UC,
        TYPE_MICROMESSENGER,
        TYPE_CURL,
        TYPE_INTELLIJ,
        TYPE_OTHER;

    }
}

