/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.util;

import com.hynnet.util.Base64;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARACrypt {
    private static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.util.ARACrypt");
    private byte[] csKey = null;
    private byte[] m_csKey = null;
    private int m_LFSR_A = 324508639;
    private int m_LFSR_B = 610839776;
    private int m_LFSR_C = -38177487;
    private static final int m_Mask_A = -2147483550;
    private static final int m_Mask_B = 0x40000020;
    private static final int m_Mask_C = 0x10000002;
    private static final int m_Rot0_A = Integer.MAX_VALUE;
    private static final int m_Rot0_B = 0x3FFFFFFF;
    private static final int m_Rot0_C = 0xFFFFFFF;
    private static final int m_Rot1_A = Integer.MIN_VALUE;
    private static final int m_Rot1_B = -1073741824;
    private static final int m_Rot1_C = -268435456;

    public void setKey(byte[] csKey) {
        byte[] csSeed = null;
        this.m_csKey = csKey;
        csSeed = this.m_csKey.length == 0 ? new byte[]{67, -56, 33, -45, -12, -77, 16, 39, 9, -86, 24, 86} : this.m_csKey;
        int nIdx = 0;
        nIdx = 0;
        while (csSeed.length < 12) {
            byte[] arrayBy = new byte[csSeed.length + 1];
            for (int i = 0; i < csSeed.length; ++i) {
                arrayBy[i] = csSeed[i];
            }
            arrayBy[arrayBy.length - 1] = csSeed[nIdx];
            csSeed = arrayBy;
            ++nIdx;
        }
        for (nIdx = 0; nIdx < 4; ++nIdx) {
            this.m_LFSR_A <<= 8;
            this.m_LFSR_A |= csSeed[nIdx + 0];
            this.m_LFSR_B <<= 8;
            this.m_LFSR_B |= csSeed[nIdx + 4];
            this.m_LFSR_C <<= 8;
            this.m_LFSR_C |= csSeed[nIdx + 8];
        }
        if (0 == this.m_LFSR_A) {
            this.m_LFSR_A = 324508639;
        }
        if (0 == this.m_LFSR_B) {
            this.m_LFSR_B = 610839776;
        }
        if (0 == this.m_LFSR_C) {
            this.m_LFSR_C = -38177487;
        }
    }

    public byte[] getKey() {
        return this.csKey;
    }

    private char transformChar(char cTarget) {
        char Crypto = '\u0000';
        int Out_B = this.m_LFSR_B & 1;
        int Out_C = this.m_LFSR_C & 1;
        for (int counter = 0; counter < 8; ++counter) {
            if ((this.m_LFSR_A & 1) == 1) {
                this.m_LFSR_A = (this.m_LFSR_A ^ 0x80000062) >> 1 | Integer.MIN_VALUE;
                if ((this.m_LFSR_B & 1) == 1) {
                    this.m_LFSR_B = (this.m_LFSR_B ^ 0x40000020) >> 1 | 0xC0000000;
                    Out_B = 1;
                } else {
                    this.m_LFSR_B = this.m_LFSR_B >> 1 & 0x3FFFFFFF;
                    Out_B = 0;
                }
            } else {
                this.m_LFSR_A = this.m_LFSR_A >> 1 & Integer.MAX_VALUE;
                if ((this.m_LFSR_C & 1) == 1) {
                    this.m_LFSR_C = (this.m_LFSR_C ^ 0x10000002) >> 1 | 0xF0000000;
                    Out_C = 1;
                } else {
                    this.m_LFSR_C = this.m_LFSR_C >> 1 & 0xFFFFFFF;
                    Out_C = 0;
                }
            }
            Crypto = (char)(Crypto << 1 | Out_B ^ Out_C);
        }
        if ((cTarget = (char)(cTarget ^ Crypto)) == '\u0000') {
            cTarget = (char)(cTarget ^ Crypto);
        }
        return cTarget;
    }

    private char transformChar(byte cTarget) {
        int Counter = 0;
        char Crypto = '\u0000';
        int Out_B = this.m_LFSR_B & 1;
        int Out_C = this.m_LFSR_C & 1;
        for (Counter = 0; Counter < 8; ++Counter) {
            if ((this.m_LFSR_A & 1) == 1) {
                this.m_LFSR_A = (this.m_LFSR_A ^ 0x80000062) >> 1 | Integer.MIN_VALUE;
                if ((this.m_LFSR_B & 1) == 1) {
                    this.m_LFSR_B = (this.m_LFSR_B ^ 0x40000020) >> 1 | 0xC0000000;
                    Out_B = 1;
                } else {
                    this.m_LFSR_B = this.m_LFSR_B >> 1 & 0x3FFFFFFF;
                    Out_B = 0;
                }
            } else {
                this.m_LFSR_A = this.m_LFSR_A >> 1 & Integer.MAX_VALUE;
                if ((this.m_LFSR_C & 1) == 1) {
                    this.m_LFSR_C = (this.m_LFSR_C ^ 0x10000002) >> 1 | 0xF0000000;
                    Out_C = 1;
                } else {
                    this.m_LFSR_C = this.m_LFSR_C >> 1 & 0xFFFFFFF;
                    Out_C = 0;
                }
            }
            Crypto = (char)(Crypto << 1 | Out_B ^ Out_C);
        }
        if ((cTarget = (byte)(cTarget ^ Crypto)) == 0) {
            cTarget = (byte)(cTarget ^ Crypto);
        }
        return (char)cTarget;
    }

    private byte transformByte(char cTarget) {
        char Crypto = '\u0000';
        int Out_B = this.m_LFSR_B & 1;
        int Out_C = this.m_LFSR_C & 1;
        for (int counter = 0; counter < 8; ++counter) {
            if ((this.m_LFSR_A & 1) == 1) {
                this.m_LFSR_A = (this.m_LFSR_A ^ 0x80000062) >> 1 | Integer.MIN_VALUE;
                if ((this.m_LFSR_B & 1) == 1) {
                    this.m_LFSR_B = (this.m_LFSR_B ^ 0x40000020) >> 1 | 0xC0000000;
                    Out_B = 1;
                } else {
                    this.m_LFSR_B = this.m_LFSR_B >> 1 & 0x3FFFFFFF;
                    Out_B = 0;
                }
            } else {
                this.m_LFSR_A = this.m_LFSR_A >> 1 & Integer.MAX_VALUE;
                if ((this.m_LFSR_C & 1) == 1) {
                    this.m_LFSR_C = (this.m_LFSR_C ^ 0x10000002) >> 1 | 0xF0000000;
                    Out_C = 1;
                } else {
                    this.m_LFSR_C = this.m_LFSR_C >> 1 & 0xFFFFFFF;
                    Out_C = 0;
                }
            }
            Crypto = (char)(Crypto << 1 | Out_B ^ Out_C);
        }
        if ((cTarget = (char)(cTarget ^ Crypto)) == '\u0000') {
            cTarget = (char)(cTarget ^ Crypto);
        }
        return (byte)cTarget;
    }

    private byte transformByte(byte cTarget) {
        int Counter = 0;
        char Crypto = '\u0000';
        int Out_B = this.m_LFSR_B & 1;
        int Out_C = this.m_LFSR_C & 1;
        for (Counter = 0; Counter < 8; ++Counter) {
            if ((this.m_LFSR_A & 1) == 1) {
                this.m_LFSR_A = (this.m_LFSR_A ^ 0x80000062) >> 1 | Integer.MIN_VALUE;
                if ((this.m_LFSR_B & 1) == 1) {
                    this.m_LFSR_B = (this.m_LFSR_B ^ 0x40000020) >> 1 | 0xC0000000;
                    Out_B = 1;
                } else {
                    this.m_LFSR_B = this.m_LFSR_B >> 1 & 0x3FFFFFFF;
                    Out_B = 0;
                }
            } else {
                this.m_LFSR_A = this.m_LFSR_A >> 1 & Integer.MAX_VALUE;
                if ((this.m_LFSR_C & 1) == 1) {
                    this.m_LFSR_C = (this.m_LFSR_C ^ 0x10000002) >> 1 | 0xF0000000;
                    Out_C = 1;
                } else {
                    this.m_LFSR_C = this.m_LFSR_C >> 1 & 0xFFFFFFF;
                    Out_C = 0;
                }
            }
            Crypto = (char)(Crypto << 1 | Out_B ^ Out_C);
        }
        if ((cTarget = (byte)(cTarget ^ Crypto)) == 0) {
            cTarget = (byte)(cTarget ^ Crypto);
        }
        return cTarget;
    }

    private String transformString(String csKey, String csTarget) {
        this.setKey(csKey.getBytes());
        int nLen = csTarget.length();
        StringBuffer sbufData = new StringBuffer();
        for (int nPos = 0; nPos < nLen; ++nPos) {
            sbufData.append(this.transformChar(csTarget.charAt(nPos)));
        }
        return sbufData.toString();
    }

    private String transformString(String csKey, byte[] csTarget) {
        this.setKey(csKey.getBytes());
        int nLen = csTarget.length;
        StringBuffer sbufData = new StringBuffer();
        for (int nPos = 0; nPos < nLen; ++nPos) {
            sbufData.append(this.transformChar(csTarget[nPos]));
        }
        return sbufData.toString();
    }

    public byte[] transformData(String csKey, byte[] csTarget) {
        this.setKey(csKey.getBytes());
        int nLen = csTarget.length;
        byte[] arrayData = new byte[nLen];
        for (int nPos = 0; nPos < nLen; ++nPos) {
            arrayData[nPos] = this.transformByte(csTarget[nPos]);
        }
        return arrayData;
    }

    public static void main(String[] args) {
        ARACrypt crypt = new ARACrypt();
        System.out.println("begin to encrypt...");
        String enStr = crypt.transformString("yes", "abcd");
        System.out.println("begin to decrypt...");
        String deStr = crypt.transformString("yes", enStr);
        new Base64();
        byte[] arrayData = Base64.decode("ks69cdsK");
        byte[] arrayDecode = crypt.transformData("KPYGPLiuJunCong@gamil.com", arrayData);
        String strGB = null;
        try {
            String strKey;
            strGB = new String(arrayDecode, "GB2312");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            do {
                System.out.print("\u8bf7\u8f93\u5165\u5bc6\u94a5\uff1a");
                strKey = in.readLine();
                if (strKey == null || strKey.length() <= 0) continue;
                System.out.print("\u8bf7\u8f93\u5165\u660e\u6587\uff1a");
                String strText = in.readLine();
                String strCrypt = crypt.transformString(strKey, strText);
                System.out.println("\u52a0\u5bc6\u540e\u5bc6\u6587\uff1a" + strCrypt + " \u957f\u5ea6\uff1a" + strCrypt.length());
                String strBase64 = Base64.encodeBytes(strCrypt.getBytes("8859_1"));
                System.out.println("\u5bc6\u6587\u7f16\u7801\u540e\uff1a" + strBase64);
                String strDecode = crypt.transformString(strKey, strCrypt);
                System.out.println("\u89e3\u5bc6\u540e\u6587\u672c\uff1a" + strDecode);
                new Base64();
                strDecode = crypt.transformString(strKey, Base64.decode(strBase64));
                System.out.println("\u89e3\u5bc6\u540e\u6587\u672c\uff1a" + strDecode + " \u957f\u5ea6\uff1a" + strDecode.length());
            } while (strKey != null && strKey.length() > 0);
            System.out.println("\u7ed3\u675f\u3002bye");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

