/*
 * Decompiled with CFR 0.152.
 */
package com.hynnet.model.util;

import com.hynnet.Build;
import com.hynnet.model.ModelException;
import com.hynnet.model.util.FileRead;
import com.hynnet.util.Base64;
import com.hynnet.util.Util;
import com.hynnet.util.XMLProperties;
import com.hynnet.util.log.LogConfigurator;
import com.hynnet.util.management.DynamicMBeanAbstract;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Globals {
    protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.model.util.Globals");
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final int B2C_MAJOR_VERSION = 1;
    public static final int B2C_MINOR_VERSION = 0;
    public static final int B2C_REVISION_VERSION = 0;
    public static final String B2C_PROPERTIES_FILENAME = "/b2c_init.properties";
    public static final String DEFAULT_PROVIDER_NAME = "defaultProvider";
    private static final String B2C_CONFIG_FILENAME = "b2c_config.xml";
    private static final String KEYNAMEPREFIX = "KEY.";
    private static String g_b2cHome = null;
    private static String g_defaultXSL = null;
    private static String g_configFile;
    private static String g_logConfigFile;
    private static XMLProperties g_properties;
    private static Locale g_locale;
    private static TimeZone g_timeZone;
    private static DateFormat g_dateFormat;
    private static DateFormat g_dateTimeFormat;
    private static boolean g_isAutoSaveModifyTime;

    public static final String getVersion() {
        return "1.0." + Build.getRevision();
    }

    public static Locale getLocale() {
        if (g_locale == null) {
            String strKey = System.getProperty("hynnet.key");
            if (strKey != null && strKey.length() > 0) {
                new Base64();
                String strDecodeKey = new String(Base64.decode(strKey));
                String[] arrayAllIP = Util.getAllIP();
                for (int n = 0; n < arrayAllIP.length; ++n) {
                    if (!arrayAllIP[n].equals(strDecodeKey)) continue;
                    try {
                        Globals.loadLocale();
                    }
                    catch (Exception e) {
                        return Locale.CHINA;
                    }
                    catch (UnsatisfiedLinkError e) {
                        log.warn("\u52a0\u8f7d\u8def\u5f84\uff1a" + System.getProperty("java.library.path"), (Throwable)e);
                        return Locale.CHINA;
                    }
                    return g_locale;
                }
            }
            Globals.loadLocale();
        }
        return g_locale;
    }

    public static void setLocale(Locale newLocale) {
        g_locale = newLocale;
        Globals.setProperty("locale.country", g_locale.getCountry());
        Globals.setProperty("locale.language", g_locale.getLanguage());
        g_dateFormat = DateFormat.getDateInstance(2, g_locale);
        g_dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, g_locale);
        g_dateFormat.setTimeZone(g_timeZone);
        g_dateTimeFormat.setTimeZone(g_timeZone);
    }

    public static TimeZone getTimeZone() {
        if (g_timeZone == null) {
            Globals.loadLocale();
        }
        return g_timeZone;
    }

    public static String getTimeZoneId() {
        TimeZone timeZone;
        String timeZoneId = Globals.getProperty("locale.timeZone");
        TimeZone timeZone2 = timeZone = timeZoneId == null || (timeZoneId = timeZoneId.trim()).length() == 0 ? Globals.getTimeZone() : TimeZone.getTimeZone(timeZoneId);
        if (timeZone == null || "GMT+08:00".equalsIgnoreCase(timeZone.getID())) {
            timeZoneId = "Asia/Shanghai";
        } else if (timeZoneId == null || timeZoneId.length() == 0) {
            timeZoneId = timeZone.getID();
        }
        return timeZoneId;
    }

    public static void setTimeZone(TimeZone newTimeZone) {
        g_timeZone = newTimeZone;
        g_dateFormat.setTimeZone(g_timeZone);
        g_dateTimeFormat.setTimeZone(g_timeZone);
        Globals.setProperty("locale.timeZone", g_timeZone.getID());
    }

    public static String formatDate(Date date) {
        if (g_dateFormat == null) {
            Globals.loadLocale();
        }
        return g_dateFormat.format(date);
    }

    public static String formatDateTime(Date date) {
        if (g_dateTimeFormat == null) {
            Globals.loadLocale();
        }
        return g_dateTimeFormat.format(date);
    }

    public static String getHome() {
        if (g_b2cHome == null) {
            g_b2cHome = System.getProperty("b2cHome");
            if (g_b2cHome == null || g_b2cHome.trim().length() == 0) {
                g_b2cHome = new InitPropLoader().getHome();
            } else {
                String strMsg = "\u542f\u52a8\u65f6\u6307\u5b9a\u7cfb\u7edf\u53d8\u91cfb2cHome\uff1a" + g_b2cHome;
                System.out.println(strMsg);
                log.error(strMsg);
            }
            if (g_b2cHome == null) {
                String msg = "\u6ca1\u6709\u8bbe\u7f6eb2cHome";
                g_b2cHome = "";
                System.out.println(msg);
                log.error(msg);
            }
        }
        return g_b2cHome;
    }

    public static void setHome(String strHome) {
        if (strHome != null && strHome.length() > 0) {
            log.info("\u8bbe\u7f6eb2cHome\uff1a" + strHome + (g_properties != null ? "\u5e76\u91cd\u65b0\u52a0\u8f7d\u8bbe\u7f6e" : ""));
            g_b2cHome = strHome;
            g_properties = null;
        }
    }

    public static String getDefaultXSL() {
        if (g_defaultXSL == null && ((g_defaultXSL = System.getProperty("defaultXSL")) == null || g_defaultXSL.trim().length() == 0)) {
            g_defaultXSL = new InitPropLoader().getDefaultXSL();
        }
        return g_defaultXSL;
    }

    public static final boolean isAutoSaveModifyTime() {
        return g_isAutoSaveModifyTime;
    }

    public static boolean isHomeReadable() {
        return new File(Globals.getHome()).canRead();
    }

    public static boolean isHomeWritable() {
        return new File(Globals.getHome()).canWrite();
    }

    public static Node getConfig() {
        Globals.loadProperties();
        if (g_properties != null) {
            Document doc = g_properties.getDocument();
            return doc != null ? doc.getDocumentElement() : null;
        }
        return null;
    }

    public static String getConfigFileName() {
        return g_properties.getFileName();
    }

    public static Node getDatabaseConfig() {
        Node objConfigNode = Globals.getConfig();
        NodeList lstNode = XMLProperties.getChildNodes(objConfigNode, "database");
        if (lstNode.getLength() != 1) {
            if (lstNode.getLength() == 0) {
                String strReason = "\u4e0d\u5b58\u5728\u914d\u7f6e\uff1adatabase";
                log.error("b2c_config\u9519\u8bef\uff0c{}", (Object)strReason);
                throw new ModelException(strReason, (Enum)ModelException.ErrorCode.ERR_CONFIG);
            }
            log.warn("\u5b58\u5728" + lstNode.getLength() + "\u4e2a\u914d\u7f6e\uff1adatabase");
        }
        return lstNode.item(0);
    }

    public static String getProperty(String name) {
        Globals.loadProperties();
        if (g_properties != null) {
            String strValue = g_properties.getProperty(name, false);
            if (strValue == null) {
                log.info("\u6ca1\u6709\u914d\u7f6e\u53c2\u6570\uff1a" + name);
            }
            return strValue;
        }
        if (g_b2cHome != null) {
            String strMsg = g_b2cHome + "\u672a\u80fd\u521d\u59cb\u5316\u7cfb\u7edf\u5c5e\u6027\uff01";
            log.error(strMsg, (Throwable)new Exception(strMsg));
        }
        return null;
    }

    public static boolean getPropertyBoolean(String strPathName, boolean bDefaultValue) {
        String strValue = Globals.getProperty(strPathName);
        if (strValue == null || strValue.trim().length() == 0) {
            return bDefaultValue;
        }
        return strValue.compareToIgnoreCase("true") == 0 || strValue.compareTo("1") == 0;
    }

    public static double getPropertyDouble(String strPathName, double dbDefaultValue) {
        String strValue = Globals.getProperty(strPathName);
        if (strValue != null) {
            try {
                return Double.parseDouble(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dbDefaultValue;
    }

    public static int getPropertyInt(String strPathName, int nDefaultValue) {
        String strValue = Globals.getProperty(strPathName);
        if (strValue != null) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nDefaultValue;
    }

    public static long getPropertyLong(String strPathName, long lDefaultValue) {
        String strValue = Globals.getProperty(strPathName);
        if (strValue != null) {
            try {
                return Long.parseLong(strValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lDefaultValue;
    }

    public static void setProperty(String name, String value) {
        Globals.loadProperties();
        g_properties.setProperty(name, value);
        g_properties.save();
    }

    public static List<String> getAllAttribute(String strPath, String strAttrName) {
        Globals.loadProperties();
        return g_properties.getAllAttribute(strPath, strAttrName);
    }

    public static String getAttribute(String name) {
        Globals.loadProperties();
        return g_properties.getAttribute(name);
    }

    public static void setAttribute(String strName, String strValue) {
        Globals.loadProperties();
        g_properties.setAttribute(strName, strValue);
        g_properties.save();
    }

    public static synchronized long getLongKey(String name) {
        long lResult;
        String strKeyName = KEYNAMEPREFIX + name;
        String strKey = Globals.getProperty(strKeyName);
        try {
            lResult = Long.parseLong(strKey);
        }
        catch (Exception e) {
            lResult = 1L;
        }
        try {
            Globals.setProperty(strKeyName, String.valueOf(lResult + 1L));
        }
        catch (Exception e) {
            log.debug("B2C\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u5199\uff01");
        }
        return lResult;
    }

    public static void deleteProperty(String name) {
        Globals.loadProperties();
        g_properties.deleteProperty(name);
        g_properties.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadProperties() {
        if (g_properties != null) return;
        InitialContext objContext = null;
        String filePath = null;
        Class<Globals> clazz = Globals.class;
        synchronized (Globals.class) {
            int i;
            File configFile;
            if (g_properties != null) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            try {
                objContext = new InitialContext();
                filePath = (String)objContext.lookup("java:comp/env/com/hynnet/config/file");
                log.info("Using JNDI com.hynnet.config.file: {}", (Object)filePath);
            }
            catch (NoInitialContextException noInitialContextException) {
            }
            catch (NamingException e) {
                try {
                    filePath = (String)objContext.lookup("java:comp/env/com/bluepyxis/config/file");
                    log.info("Using JNDI com.bluepyxis.config.file: {}", (Object)filePath);
                }
                catch (NamingException namingException) {}
            }
            catch (RuntimeException ex) {
                log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
            }
            catch (Error ex) {
                // empty catch block
            }
            if (filePath == null || (filePath = filePath.trim()).length() == 0) {
                filePath = System.getProperty("com.hynnet.config.file", System.getProperty("com.bluepyxis.config.file"));
            }
            if (filePath != null && filePath.length() > 0) {
                configFile = new File(filePath);
                if (!configFile.isFile() || !configFile.exists()) {
                    log.warn("\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\uff1a{}\u4e0d\u5b58\u5728\uff01", (Object)configFile.getAbsolutePath());
                } else {
                    g_properties = new XMLProperties(configFile.getAbsolutePath(), true);
                    log.info("\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\uff1a{}", (Object)configFile.getAbsolutePath());
                    if (g_properties.isLoad()) {
                        g_configFile = configFile.getAbsolutePath();
                    }
                }
            }
            Globals.getHome();
            if (g_properties == null) {
                XMLProperties xml;
                File file;
                if (g_b2cHome != null && g_b2cHome.length() > 0) {
                    configFile = new File(g_b2cHome + File.separatorChar + B2C_CONFIG_FILENAME);
                    if (configFile.exists() && configFile.isFile()) {
                        XMLProperties xml2 = new XMLProperties(configFile.getAbsolutePath(), true);
                        if (xml2.isLoad()) {
                            g_properties = xml2;
                            g_configFile = configFile.getAbsolutePath();
                        }
                    } else {
                        InputStream objStream = Util.getResourceAsStream(g_b2cHome, Globals.class);
                        if (objStream == null) {
                            log.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}\uff0c\u65e0\u6cd5\u83b7\u53d6\u8d44\u6e90\uff1a{}", (Object)configFile.getAbsolutePath(), (Object)g_b2cHome);
                        } else {
                            g_properties = XMLProperties.fromStream(objStream);
                            log.info("{}\u4f7f\u7528\u8d44\u6e90\u4e2d\u7684\u914d\u7f6e\u6587\u4ef6\uff1a{}", (Object)(g_properties == null ? "\u65e0\u6cd5" : ""), (Object)g_b2cHome);
                            if (g_properties != null && g_properties.isLoad()) {
                                g_configFile = g_b2cHome;
                            }
                        }
                    }
                }
                if (g_properties == null) {
                    filePath = "/b2c_config.xml";
                    g_properties = XMLProperties.fromStream(Util.getResourceAsStream(filePath, Globals.class));
                    log.info("{}\u4ece\u8d44\u6e90\u4e2d\u52a0\u8f7d\u914d\u7f6e\uff1a{}", (Object)(g_properties == null ? "\u65e0\u6cd5" : ""), (Object)filePath);
                    if (g_properties != null && g_properties.isLoad()) {
                        g_configFile = filePath;
                    }
                }
                if (g_properties == null && (file = new File(B2C_CONFIG_FILENAME)).exists() && file.canRead() && (xml = new XMLProperties(file.getAbsolutePath())).isLoad()) {
                    log.info("\u4f7f\u7528\u5f53\u524d\u76ee\u5f55\u4e0b\u7684\u914d\u7f6e\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
                    g_properties = xml;
                    g_configFile = file.getAbsolutePath();
                }
                if (g_properties == null) {
                    log.warn("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff0c\u4ee5\u4e0b\u65b9\u6cd5\u53ef\u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\uff1a1.\u914d\u7f6eJNDI\uff1ajava:comp/env/com/hynnet/config/file\uff1b2.\u901a\u8fc7\u7cfb\u7edf\u53d8\u91cf\"com.hynnet.config.file\"\u6216\u7c7b\u8d44\u6e90{}\u6307\u5b9aXML\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\uff1b3.\u7cfb\u7edf\u53d8\u91cf\"b2cHome\"\u6216\u7c7b\u8d44\u6e90{}\u6307\u5b9ab2c_init.properties\u3002", (Object)B2C_PROPERTIES_FILENAME, (Object)filePath);
                }
            }
            if (g_properties == null) {
                log.error("\u65e0\u6cd5\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6");
                g_properties = new XMLProperties();
            } else {
                log.info("\u914d\u7f6e\u8def\u5f84\uff1a{}", (Object)g_properties.getFileName());
            }
            SecureRCDL objDog = new SecureRCDL();
            objDog.DogData = new byte[100];
            for (i = 0; i < 100; ++i) {
                objDog.DogData[i] = (byte)(i + 48);
            }
            objDog.DogAddr = 20;
            objDog.setBytes(20);
            try {
                objDog.CallWriteFile();
            }
            catch (FileReadException e) {
                System.err.println("Write Data Error");
                i = 1000;
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            catch (UnsatisfiedLinkError e1) {
                System.err.println("\u6587\u4ef6\u9519\u8bef1");
                log.error("b2cHome\uff1a{}\u52a0\u8f7d\u8def\u5f84\uff1a{}\r\n{}", new Object[]{g_b2cHome, System.getProperty("java.library.path"), e1.getMessage()});
            }
            catch (Exception e2) {
                System.err.println("\u5176\u4ed6\u9519\u8bef.");
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            new Util();
            try {
                objDog.CallReadFile();
            }
            catch (FileReadException e) {
                if (i < 1000) {
                    System.err.println("Read Data Error");
                }
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            catch (UnsatisfiedLinkError e1) {
                System.err.println("\u6587\u4ef6\u9519\u8bef2");
                log.error("b2cHome\uff1a{}\u52a0\u8f7d\u8def\u5f84\uff1a{}", new Object[]{g_b2cHome, System.getProperty("java.library.path"), e1.getMessage()});
            }
            catch (Exception e2) {
                System.err.println("\u5176\u4ed6\u9519\u8bef. ");
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            objDog.setBytes(0);
            try {
                objDog.CallReadFile();
            }
            catch (FileReadException e) {
                if (i < 1000) {
                    System.err.println("Read Data Error");
                }
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            catch (UnsatisfiedLinkError e1) {
                System.err.println("\u6587\u4ef6\u9519\u8bef3");
                log.error("b2cHome\uff1a{}\u52a0\u8f7d\u8def\u5f84\uff1a{}\r\n{}", new Object[]{g_b2cHome, System.getProperty("java.library.path"), e1.getMessage()});
            }
            catch (Exception e2) {
                System.err.println("\u5176\u4ed6\u9519\u8bef.");
                log.error("b2cHome\uff1a" + g_b2cHome);
            }
            Globals.loadLogConfig();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }

    public static void reloadLogConfig() {
        if (g_logConfigFile != null && g_logConfigFile.length() > 0) {
            String className = Globals.getProperty("log.logConfigurator");
            if (className == null || (className = className.trim()).length() == 0) {
                log.info("\u6ca1\u6709\u914d\u7f6elog.logConfigurator\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1acom.hynnet.util.log.impl.LogbackConfigurator");
                className = "com.hynnet.util.log.impl.LogbackConfigurator";
            }
            if (className != null && className.length() > 0) {
                log.info("\u4f7f\u7528\u65e5\u5fd7\u914d\u7f6e\uff1a{}", (Object)g_logConfigFile);
                try {
                    Class<?> cls = Class.forName(className);
                    LogConfigurator configurator = (LogConfigurator)cls.newInstance();
                    configurator.loadConfig(g_logConfigFile);
                }
                catch (Throwable e) {
                    log.error("\u65e0\u6cd5\u52a0\u8f7d\u65e5\u5fd7\u914d\u7f6e\u5904\u7406\u7c7b\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    private static void loadLogConfig() {
        String path = null;
        File config = null;
        try {
            InitialContext context = new InitialContext();
            path = (String)context.lookup("java:comp/env/com/hynnet/logconfig/file");
            if (path != null && path.length() > 0) {
                log.info("Using JNDI com.hynnet.logconfig.file: {}", (Object)path);
            }
        }
        catch (NoInitialContextException noInitialContextException) {
        }
        catch (NamingException namingException) {
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        catch (Error error) {
            // empty catch block
        }
        if (path == null || !(config = new File(path)).isFile() || !config.isFile()) {
            for (String name : new String[]{"com.hynnet.logconfig.file", "com.eggwifi.logconfig.file", "log.logConfig", "platform.logConfig"}) {
                path = System.getProperty(name);
                if (path == null || path.length() <= 0 || !(config = new File(path)).isFile() || !config.exists()) continue;
                log.debug("\u91c7\u7528\u7cfb\u7edf\u5c5e\u6027{}\u914d\u7f6e\u7684\u65e5\u5fd7\u914d\u7f6e\uff1a{}", (Object)name, (Object)path);
                break;
            }
            if (config == null && (path = Globals.getProperty("log.logConfig")) != null && path.length() > 0 && (config = new File(path)).isFile() && config.exists()) {
                log.debug("\u91c7\u7528\u914d\u7f6e\u4e2d\u7684\u65e5\u5fd7\u914d\u7f6e\uff1a{}", (Object)path);
            }
        }
        if (config == null) {
            log.warn("\u6ca1\u6709\u6307\u5b9a\u7684\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\uff01\u5ffd\u7565");
        } else if (!config.isFile() || !config.exists()) {
            log.warn("\u6307\u5b9a\u7684\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\uff1a{}\u4e0d\u5b58\u5728\uff01\u5ffd\u7565", (Object)config.getAbsolutePath());
        } else {
            Globals.loadLogConfig(config);
        }
    }

    public static synchronized boolean loadLogConfig(File config) {
        String className = Globals.getProperty("log.logConfigurator");
        if (className == null || (className = className.trim()).length() == 0) {
            log.info("\u6ca1\u6709\u914d\u7f6elog.logConfigurator\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1acom.hynnet.util.log.impl.LogbackConfigurator");
            className = "com.hynnet.util.log.impl.LogbackConfigurator";
        }
        if (className != null && className.length() > 0) {
            log.info("\u4f7f\u7528\u65e5\u5fd7\u914d\u7f6e\uff1a{}", (Object)config.getAbsolutePath());
            try {
                Class<?> cls = Class.forName(className);
                LogConfigurator configurator = (LogConfigurator)cls.newInstance();
                configurator.loadConfig(config.getAbsolutePath());
                g_logConfigFile = config.getAbsolutePath();
                return true;
            }
            catch (Throwable e) {
                log.error("\u65e0\u6cd5\u52a0\u8f7d\u65e5\u5fd7\u914d\u7f6e\u5904\u7406\u7c7b\uff1a{}", (Object)e.getMessage());
            }
        }
        return false;
    }

    private static synchronized void loadLocale() {
        String language = Globals.getProperty("locale.language");
        String country = Globals.getProperty("locale.country");
        if (language == null) {
            language = "";
        }
        if (country == null) {
            country = "";
        }
        g_locale = language.length() <= 0 && country.length() <= 0 ? Locale.CHINA : new Locale(language, country);
        String timeZoneID = Globals.getProperty("locale.timeZone");
        if (timeZoneID == null) {
            g_timeZone = TimeZone.getDefault();
        } else {
            try {
                g_timeZone = TimeZone.getTimeZone(timeZoneID);
                TimeZone.setDefault(g_timeZone);
            }
            catch (Exception e) {
                g_timeZone = TimeZone.getDefault();
            }
            log.info("\u8c03\u6574\u65f6\u533a\u4e3a\uff1a" + g_timeZone);
        }
        g_dateFormat = DateFormat.getDateInstance(2, g_locale);
        g_dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, g_locale);
        g_dateFormat.setTimeZone(g_timeZone);
        g_dateTimeFormat.setTimeZone(g_timeZone);
    }

    static {
        g_properties = null;
        g_locale = null;
        g_timeZone = null;
        g_dateFormat = null;
        g_dateTimeFormat = null;
        log.info("B2C Library v" + Globals.getVersion() + " build " + Build.getBuild());
        g_isAutoSaveModifyTime = Globals.getPropertyBoolean("database.autosavemodifytime", true);
        if (!g_isAutoSaveModifyTime) {
            log.info("\u4e0d\u81ea\u52a8\u4fdd\u5b58\u6570\u636e\u4fee\u6539\u65f6\u95f4");
        }
        new GlobalsMBean().registerMBean();
    }

    private static class GlobalsMBean
    extends DynamicMBeanAbstract {
        private GlobalsMBean() {
        }

        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            if ("ConfigFile".equals(attribute)) {
                return g_configFile;
            }
            if ("LogConfigFile".equals(attribute)) {
                return g_logConfigFile;
            }
            if ("DefaultXSL".equals(attribute)) {
                return g_defaultXSL;
            }
            if ("Ips".equals(attribute)) {
                StringBuffer sbuf = new StringBuffer();
                for (String ip : Util.getAllIP()) {
                    if (sbuf.length() > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(ip);
                }
                return sbuf.toString();
            }
            if ("AutoSaveModifyTime".equals(attribute)) {
                return g_isAutoSaveModifyTime;
            }
            if ("b2cHome".equals(attribute)) {
                return g_b2cHome;
            }
            if ("Locale".equals(attribute)) {
                return g_locale;
            }
            if ("TimeZone".equals(attribute)) {
                return g_timeZone != null ? g_timeZone.getID() : null;
            }
            if ("DateFormat".equals(attribute)) {
                if (g_dateFormat instanceof SimpleDateFormat) {
                    return ((SimpleDateFormat)g_dateFormat).toPattern();
                }
                return g_dateFormat;
            }
            if ("DateTimeFormat".equals(attribute)) {
                if (g_dateTimeFormat instanceof SimpleDateFormat) {
                    return ((SimpleDateFormat)g_dateTimeFormat).toPattern();
                }
                return g_dateTimeFormat;
            }
            return null;
        }

        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            if ("reload".equals(actionName)) {
                g_properties = null;
                Globals.loadProperties();
            } else if ("reloadLogConfig".equals(actionName)) {
                Globals.reloadLogConfig();
            }
            return null;
        }

        protected MBeanOperationInfo[] getMBeanOperationInfos() {
            return new MBeanOperationInfo[]{new MBeanOperationInfo("reload", "\u91cd\u8f7d\u914d\u7f6e\u6587\u4ef6\uff08b2c_config.xml\uff09", null, "void", 0), new MBeanOperationInfo("reloadLogConfig", "\u91cd\u8f7d\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\uff08logback.xml\uff09", null, "void", 0)};
        }

        protected MBeanAttributeInfo[] getMBeanAttributeInfos() {
            return new MBeanAttributeInfo[]{new MBeanAttributeInfo("ConfigFile", "java.lang.String", "\u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84", true, false, false), new MBeanAttributeInfo("LogConfigFile", "java.lang.String", "\u65e5\u5fd7\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84", true, false, false), new MBeanAttributeInfo("DefaultXSL", "java.lang.String", "\u9ed8\u8ba4XSL\u6587\u4ef6\u7684\u5b58\u653e\u8def\u5f84", true, true, false), new MBeanAttributeInfo("Ips", "java.lang.String", "\u672c\u673aIP\u5730\u5740", true, false, false), new MBeanAttributeInfo("AutoSaveModifyTime", "boolean", "\u662f\u5426\u81ea\u52a8\u4fdd\u5b58\u4fee\u6539\u65f6\u95f4", true, true, true), new MBeanAttributeInfo("b2cHome", "java.lang.String", "\u5e73\u53f0\u914d\u7f6e\u4e3b\u76ee\u5f55", true, true, false), new MBeanAttributeInfo("Locale", "java.lang.String", "\u672c\u5730\u5316", true, false, false), new MBeanAttributeInfo("TimeZone", "java.lang.String", "\u65f6\u533a", true, false, false), new MBeanAttributeInfo("DateFormat", "java.lang.String", "\u65e5\u671f\u7684\u9ed8\u8ba4\u683c\u5f0f", true, false, false), new MBeanAttributeInfo("DateTimeFormat", "java.lang.String", "\u65e5\u671f\u65f6\u95f4\u7684\u9ed8\u8ba4\u683c\u5f0f", true, false, false)};
        }

        protected MBeanNotificationInfo[] getMBeanNotificationInfos() {
            return null;
        }

        protected void setAttribute(String name, Object val) {
            if ("DefaultXSL".equals(name)) {
                g_defaultXSL = String.valueOf(val);
            } else if ("AutoSaveModifyTime".equals(name)) {
                g_isAutoSaveModifyTime = (Boolean)val;
            } else if ("b2cHome".equals(name)) {
                g_b2cHome = String.valueOf(val);
            }
        }

        protected String getMBeanName() {
            return String.format("com.hynnet:type=base-%s,name=Globals", Integer.toHexString(this.getClass().getClassLoader().hashCode()));
        }
    }

    private static class FileReadException
    extends Exception {
        public static final long serialVersionUID = 1L;
        public int Error;

        public FileReadException(int ErrorNumber) {
            super("File Operation Error " + ErrorNumber);
            this.Error = ErrorNumber;
        }
    }

    private static class SecureRCDL
    extends FileRead {
        private SecureRCDL() {
        }

        public void CallWriteFile() throws FileReadException {
            int retCode = this.WriteDog();
            if (retCode != 0) {
                System.err.println("Call Write File fail." + retCode);
                throw new FileReadException(retCode);
            }
        }

        public void CallReadFile() throws FileReadException {
            int retCode = this.ReadDog();
            if (retCode != 0) {
                throw new FileReadException(retCode);
            }
            if (this.DogBytes > 0) {
                // empty if block
            }
        }
    }

    private static class InitPropLoader {
        protected static final Logger log = LoggerFactory.getLogger((String)"com.hynnet.b2c.B2CGlobals");

        private InitPropLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getHome() {
            String strMsg;
            Properties mapInit;
            String strB2cHome;
            block19: {
                strB2cHome = null;
                mapInit = new Properties();
                InputStream objIn = null;
                try {
                    objIn = Util.getResourceAsStream(Globals.B2C_PROPERTIES_FILENAME, this.getClass());
                    if (objIn != null) {
                        mapInit.load(objIn);
                        strMsg = "\u4ece\u8d44\u6e90\u4e2d\u52a0\u8f7d\uff1a/b2c_init.properties";
                        System.out.println(strMsg);
                        break block19;
                    }
                    log.info("\u8d44\u6e90\u4e2d\u627e\u4e0d\u5230\uff1a/b2c_init.properties");
                    String string = null;
                    return string;
                }
                catch (Exception e) {
                    strMsg = "\u4ece\u8d44\u6e90\u4e2d\u52a0\u8f7d/b2c_init.properties\u5f02\u5e38\uff1a" + e.getMessage();
                    System.err.println(strMsg);
                    log.error(strMsg, (Throwable)e);
                }
                finally {
                    try {
                        if (objIn != null) {
                            objIn.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (mapInit != null) {
                strB2cHome = mapInit.getProperty("b2cHome");
                if (strB2cHome != null) {
                    strB2cHome = strB2cHome.trim();
                    while (strB2cHome.endsWith("/") || strB2cHome.endsWith("\\")) {
                        strB2cHome = strB2cHome.substring(0, strB2cHome.length() - 1);
                    }
                    strMsg = "b2cHome\u8bbe\u7f6e\uff1a" + strB2cHome;
                } else {
                    strMsg = "/b2c_init.properties\u4e2d\u4e0d\u5305\u542bb2cHome\u8bbe\u7f6e\uff01";
                }
                System.out.println(strMsg);
                log.error(strMsg);
            }
            return strB2cHome;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDefaultXSL() {
            String strDefaultXSL = null;
            Properties initProps = new Properties();
            InputStream objIn = null;
            try {
                objIn = Util.getResourceAsStream(Globals.B2C_PROPERTIES_FILENAME, this.getClass());
                initProps.load(objIn);
            }
            catch (Exception e) {
                System.err.println("Error reading  properties in B2CGlobals");
                e.printStackTrace();
            }
            finally {
                try {
                    if (objIn != null) {
                        objIn.close();
                    }
                }
                catch (Exception exception) {}
            }
            if (initProps != null && (strDefaultXSL = initProps.getProperty("defaultXSL")) != null) {
                strDefaultXSL = strDefaultXSL.trim();
                while (strDefaultXSL.endsWith("/") || strDefaultXSL.endsWith("\\")) {
                    strDefaultXSL = strDefaultXSL.substring(0, strDefaultXSL.length() - 1);
                }
            }
            return strDefaultXSL;
        }
    }
}

