/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import com.hierynomus.sshj.key.KeyAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.NegotiatedAlgorithms;
import net.schmizz.sshj.transport.TransportException;

class Proposal {
    private final List<String> kex;
    private final List<String> sig;
    private final List<String> c2sCipher;
    private final List<String> s2cCipher;
    private final List<String> c2sMAC;
    private final List<String> s2cMAC;
    private final List<String> c2sComp;
    private final List<String> s2cComp;
    private final SSHPacket packet;

    public Proposal(Config config) {
        this.kex = Factory.Named.Util.getNames(config.getKeyExchangeFactories());
        this.sig = Factory.Named.Util.getNames(config.getKeyAlgorithms());
        this.s2cCipher = Factory.Named.Util.getNames(config.getCipherFactories());
        this.c2sCipher = this.s2cCipher;
        this.s2cMAC = Factory.Named.Util.getNames(config.getMACFactories());
        this.c2sMAC = this.s2cMAC;
        this.s2cComp = Factory.Named.Util.getNames(config.getCompressionFactories());
        this.c2sComp = this.s2cComp;
        this.packet = new SSHPacket(Message.KEXINIT);
        this.packet.ensureCapacity(16);
        config.getRandomFactory().create().fill(this.packet.array(), this.packet.wpos(), 16);
        this.packet.wpos(this.packet.wpos() + 16);
        this.packet.putString(Proposal.toCommaString(this.kex));
        this.packet.putString(Proposal.toCommaString(this.sig));
        this.packet.putString(Proposal.toCommaString(this.c2sCipher));
        this.packet.putString(Proposal.toCommaString(this.s2cCipher));
        this.packet.putString(Proposal.toCommaString(this.c2sMAC));
        this.packet.putString(Proposal.toCommaString(this.s2cMAC));
        this.packet.putString(Proposal.toCommaString(this.c2sComp));
        this.packet.putString(Proposal.toCommaString(this.s2cComp));
        this.packet.putString("");
        this.packet.putString("");
        this.packet.putBoolean(false);
        this.packet.putUInt32(0L);
    }

    public Proposal(SSHPacket packet) throws TransportException {
        this.packet = packet;
        int savedPos = packet.rpos();
        packet.rpos(packet.rpos() + 17);
        try {
            this.kex = Proposal.fromCommaString(packet.readString());
            this.sig = Proposal.fromCommaString(packet.readString());
            this.c2sCipher = Proposal.fromCommaString(packet.readString());
            this.s2cCipher = Proposal.fromCommaString(packet.readString());
            this.c2sMAC = Proposal.fromCommaString(packet.readString());
            this.s2cMAC = Proposal.fromCommaString(packet.readString());
            this.c2sComp = Proposal.fromCommaString(packet.readString());
            this.s2cComp = Proposal.fromCommaString(packet.readString());
        }
        catch (Buffer.BufferException be) {
            throw new TransportException(be);
        }
        packet.rpos(savedPos);
    }

    public List<String> getKeyExchangeAlgorithms() {
        return this.kex;
    }

    public List<String> getHostKeyAlgorithms() {
        return this.sig;
    }

    public List<String> getClient2ServerCipherAlgorithms() {
        return this.c2sCipher;
    }

    public List<String> getServer2ClientCipherAlgorithms() {
        return this.s2cCipher;
    }

    public List<String> getClient2ServerMACAlgorithms() {
        return this.c2sMAC;
    }

    public List<String> getServer2ClientMACAlgorithms() {
        return this.s2cMAC;
    }

    public List<String> getClient2ServerCompressionAlgorithms() {
        return this.c2sComp;
    }

    public List<String> getServer2ClientCompressionAlgorithms() {
        return this.s2cComp;
    }

    public SSHPacket getPacket() {
        return new SSHPacket(this.packet);
    }

    public NegotiatedAlgorithms negotiate(Proposal other) throws TransportException {
        return new NegotiatedAlgorithms(Proposal.firstMatch(this.getKeyExchangeAlgorithms(), other.getKeyExchangeAlgorithms()), Proposal.firstMatch(this.getHostKeyAlgorithms(), other.getHostKeyAlgorithms()), Proposal.firstMatch(this.getClient2ServerCipherAlgorithms(), other.getClient2ServerCipherAlgorithms()), Proposal.firstMatch(this.getServer2ClientCipherAlgorithms(), other.getServer2ClientCipherAlgorithms()), Proposal.firstMatch(this.getClient2ServerMACAlgorithms(), other.getClient2ServerMACAlgorithms()), Proposal.firstMatch(this.getServer2ClientMACAlgorithms(), other.getServer2ClientMACAlgorithms()), Proposal.firstMatch(this.getClient2ServerCompressionAlgorithms(), other.getClient2ServerCompressionAlgorithms()), Proposal.firstMatch(this.getServer2ClientCompressionAlgorithms(), other.getServer2ClientCompressionAlgorithms()), other.getHostKeyAlgorithms().containsAll(KeyAlgorithms.SSH_RSA_SHA2_ALGORITHMS));
    }

    private static String firstMatch(List<String> a, List<String> b) throws TransportException {
        for (String aa : a) {
            if (!b.contains(aa)) continue;
            return aa;
        }
        throw new TransportException("Unable to reach a settlement: " + a + " and " + b);
    }

    private static List<String> allMatch(List<String> a, List<String> b) throws TransportException {
        ArrayList<String> res = new ArrayList<String>();
        for (String aa : a) {
            if (!b.contains(aa)) continue;
            res.add(aa);
        }
        if (res.isEmpty()) {
            throw new TransportException("Unable to reach a settlement: " + a + " and " + b);
        }
        return res;
    }

    private static String toCommaString(List<String> sl) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : sl) {
            if (i++ != 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static List<String> fromCommaString(String s) {
        return Arrays.asList(s.split(","));
    }
}

