/*
 * Copyright (C)2009 - SSHJ Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.schmizz.sshj.connection.channel.direct;

import net.schmizz.sshj.connection.Connection;

/** A channel for creating a direct TCP/IP connection from the server to a remote address. */
public class DirectConnection extends DirectTCPIPChannel {
    public static final String LOCALHOST = "localhost";
    public static final int LOCALPORT = 65536;

    public DirectConnection(Connection conn, String remoteHost, int remotePort) {
        super(conn, new Parameters(LOCALHOST, LOCALPORT, remoteHost, remotePort));
    }

    public String getRemoteHost() {
        return parameters.getRemoteHost();
    }

    public int getRemotePort() {
        return parameters.getRemotePort();
    }
}