/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.support.utils.content;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.hendraanggrian.support.utils.content.UrisKt;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u00a8\u0006\u000b"}, d2={"isMimeType", "", "", "type", "toExtension", "toMime", "Landroid/net/Uri;", "resolver", "Landroid/content/ContentResolver;", "context", "Landroid/content/Context;", "support-utils_release"})
public final class MimeTypesKt {
    public static final boolean isMimeType(@NotNull String $receiver, @NotNull String type) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        CharSequence charSequence = $receiver;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl2 = bl = !Pattern.compile("[a-z]+/[a-z]+").matcher($receiver).matches();
        if (!bl) {
            String string = $receiver + " is not in correct mime type format.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return StringsKt.startsWith$default((String)$receiver, (String)type, (boolean)false, (int)2, null);
    }

    @Nullable
    public static final String toMime(@NotNull Uri $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"context.contentResolver");
        return MimeTypesKt.toMime($receiver, contentResolver);
    }

    @Nullable
    public static final String toMime(@NotNull Uri $receiver, @NotNull ContentResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        return UrisKt.isContent($receiver) ? resolver.getType($receiver) : MimeTypesKt.toMime($receiver, resolver);
    }

    @Nullable
    public static final String toMime(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (TextUtils.isEmpty((CharSequence)$receiver)) {
            return null;
        }
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension($receiver);
    }

    @Nullable
    public static final String toExtension(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return MimeTypeMap.getSingleton().getExtensionFromMimeType($receiver);
    }
}

