/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.text;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import com.hendraanggrian.support.utils.text.SpanSupplier;
import com.hendraanggrian.support.utils.text.Spannables;
import com.hendraanggrian.text.Spannable2;
import com.hendraanggrian.text.SpannedArg;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class SpannableText
extends SpannableString
implements Spannable2 {
    public SpannableText(@NonNull CharSequence text) {
        super(text);
    }

    public SpannableText(@NonNull CharSequence text, Object ... spans) {
        this(text, 33, spans);
    }

    public SpannableText(@NonNull CharSequence text, int flags, Object ... spans) {
        super(text);
        Spannables.setSpans((Spannable)this, (int)flags, (Object[])spans);
    }

    @Override
    public void setSpans(int start, int end, int flags, Object ... spans) {
        Spannables.setSpans((Spannable)this, (int)start, (int)end, (int)flags, (Object[])spans);
    }

    @Override
    public void setSpans(int start, int end, Object ... spans) {
        Spannables.setSpans((Spannable)this, (int)start, (int)end, (Object[])spans);
    }

    @Override
    public void setSpans(int flags, Object ... spans) {
        Spannables.setSpans((Spannable)this, (int)flags, (Object[])spans);
    }

    @Override
    public void setSpans(Object ... spans) {
        Spannables.setSpans((Spannable)this, (Object[])spans);
    }

    @Override
    public void removeSpans(Object ... spans) {
        Spannables.removeSpans((Spannable)this, (Object[])spans);
    }

    @Override
    @NonNull
    public Object[] putSpans(@NonNull CharSequence text, int flags, SpanSupplier ... suppliers) {
        return Spannables.putSpans((Spannable)this, (CharSequence)text, (int)flags, (SpanSupplier[])suppliers);
    }

    @Override
    @NonNull
    public Object[] putSpans(@NonNull CharSequence text, SpanSupplier ... suppliers) {
        return Spannables.putSpans((Spannable)this, (CharSequence)text, (SpanSupplier[])suppliers);
    }

    @Override
    @NonNull
    public Object[] putSpansAll(@NonNull Pattern regex, int flags, SpanSupplier ... suppliers) {
        return Spannables.putSpansAll((Spannable)this, (Pattern)regex, (int)flags, (SpanSupplier[])suppliers);
    }

    @Override
    @NonNull
    public Object[] putSpansAll(@NonNull String regex, int flags, SpanSupplier ... suppliers) {
        return Spannables.putSpansAll((Spannable)this, (String)regex, (int)flags, (SpanSupplier[])suppliers);
    }

    @Override
    @NonNull
    public Object[] putSpansAll(@NonNull Pattern regex, SpanSupplier ... suppliers) {
        return Spannables.putSpansAll((Spannable)this, (Pattern)regex, (SpanSupplier[])suppliers);
    }

    @Override
    @NonNull
    public Object[] putSpansAll(@NonNull String regex, SpanSupplier ... suppliers) {
        return Spannables.putSpansAll((Spannable)this, (String)regex, (SpanSupplier[])suppliers);
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder((CharSequence)((Object)this));
    }

    @NonNull
    public static SpannableText format(@NonNull String format, Object ... args) {
        List<Integer> list = SpannableText.listOccurrences(format, "%");
        for (int start : SpannableText.listOccurrences(format, "%%")) {
            list.remove((Object)start);
            list.remove((Object)(start + 1));
        }
        if (list.size() != args.length) {
            throw new IllegalArgumentException("Expected argument " + list.size() + ", was " + args.length);
        }
        Builder builder = new Builder();
        String remaining = format;
        int lastIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            String subformat = format.substring(lastIndex, list.get(i) + 2);
            lastIndex = list.get(i) + 2;
            remaining = remaining.substring(subformat.length());
            builder.append(subformat.substring(0, subformat.length() - 2));
            Object arg = args[i];
            if (arg instanceof SpannedArg) {
                builder.append((CharSequence)String.format(subformat.substring(subformat.length() - 2), ((SpannedArg)arg).arg), ((SpannedArg)arg).flags, ((SpannedArg)arg).spans);
                continue;
            }
            builder.append(String.format(subformat.substring(subformat.length() - 2), arg));
        }
        builder.append(remaining);
        return builder.build();
    }

    @NonNull
    public static SpannableText valueOf(@NonNull CharSequence text) {
        return text instanceof SpannableText ? (SpannableText)((Object)text) : new SpannableText(text);
    }

    @NonNull
    private static List<Integer> listOccurrences(@NonNull String string, @NonNull String substring) {
        ArrayList<Integer> lastIndexes = new ArrayList<Integer>();
        int lastIndex = 0;
        while (lastIndex != -1) {
            if ((lastIndex = string.indexOf(substring, lastIndex)) == -1) continue;
            lastIndexes.add(lastIndex);
            lastIndex += substring.length();
        }
        return lastIndexes;
    }

    public static final class Builder
    extends SpannableStringBuilder
    implements Spannable2 {
        public Builder() {
            this("");
        }

        public Builder(@NonNull CharSequence text) {
            this(text, 0, text.length());
        }

        public Builder(@NonNull CharSequence text, int start, int end) {
            super(text, start, end);
        }

        @Override
        public void setSpans(int start, int end, int flags, Object ... spans) {
            Spannables.setSpans((Spannable)this, (int)start, (int)end, (int)flags, (Object[])spans);
        }

        @Override
        public void setSpans(int start, int end, Object ... spans) {
            Spannables.setSpans((Spannable)this, (int)start, (int)end, (Object[])spans);
        }

        @Override
        public void setSpans(int flags, Object ... spans) {
            Spannables.setSpans((Spannable)this, (int)flags, (Object[])spans);
        }

        @Override
        public void setSpans(Object ... spans) {
            Spannables.setSpans((Spannable)this, (Object[])spans);
        }

        @Override
        public void removeSpans(Object ... spans) {
            Spannables.removeSpans((Spannable)this, (Object[])spans);
        }

        @Override
        @NonNull
        public Object[] putSpans(@NonNull CharSequence text, int flags, SpanSupplier ... suppliers) {
            return Spannables.putSpans((Spannable)this, (CharSequence)text, (int)flags, (SpanSupplier[])suppliers);
        }

        @Override
        @NonNull
        public Object[] putSpans(@NonNull CharSequence text, SpanSupplier ... suppliers) {
            return Spannables.putSpans((Spannable)this, (CharSequence)text, (SpanSupplier[])suppliers);
        }

        @Override
        @NonNull
        public Object[] putSpansAll(@NonNull Pattern regex, int flags, SpanSupplier ... suppliers) {
            return Spannables.putSpansAll((Spannable)this, (Pattern)regex, (int)flags, (SpanSupplier[])suppliers);
        }

        @Override
        @NonNull
        public Object[] putSpansAll(@NonNull String regex, int flags, SpanSupplier ... suppliers) {
            return Spannables.putSpansAll((Spannable)this, (String)regex, (int)flags, (SpanSupplier[])suppliers);
        }

        @Override
        @NonNull
        public Object[] putSpansAll(@NonNull Pattern regex, SpanSupplier ... suppliers) {
            return Spannables.putSpansAll((Spannable)this, (Pattern)regex, (SpanSupplier[])suppliers);
        }

        @Override
        @NonNull
        public Object[] putSpansAll(@NonNull String regex, SpanSupplier ... suppliers) {
            return Spannables.putSpansAll((Spannable)this, (String)regex, (SpanSupplier[])suppliers);
        }

        @NonNull
        public Builder append(char text) {
            super.append(text);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text) {
            super.append(text);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, int start, int end) {
            super.append(text, start, end);
            return this;
        }

        @RequiresApi(value=21)
        @NonNull
        public Builder append(@NonNull CharSequence text, @NonNull Object what, int flags) {
            super.append(text, what, flags);
            return this;
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, Object ... spans) {
            return this.append(text, 33, spans);
        }

        @NonNull
        public Builder append(@NonNull CharSequence text, int flags, Object ... spans) {
            super.append(text);
            int end = this.length();
            int start = end - text.length();
            for (Object what : spans) {
                this.setSpan(what, start, end, flags);
            }
            return this;
        }

        @NonNull
        public SpannableText build() {
            return new SpannableText((CharSequence)((Object)this));
        }

        @NonNull
        public static Builder valueOf(@NonNull CharSequence text) {
            return text instanceof Builder ? (Builder)((Object)text) : new Builder(text);
        }
    }
}

