/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.text.style;

import android.annotation.SuppressLint;
import android.content.res.AssetManager;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;
import java.io.File;

@SuppressLint(value={"ParcelCreator"})
public class FontSpan
extends TypefaceSpan {
    @NonNull
    private final Typeface typeface;

    public FontSpan(@NonNull String file) {
        this(Typeface.createFromFile((String)file));
    }

    public FontSpan(String family, @NonNull String file) {
        this(family, Typeface.createFromFile((String)file));
    }

    public FontSpan(@NonNull File file) {
        this(Typeface.createFromFile((File)file));
    }

    public FontSpan(String family, @NonNull File file) {
        this(family, Typeface.createFromFile((File)file));
    }

    public FontSpan(@NonNull AssetManager mgr, @NonNull String path) {
        this(Typeface.createFromAsset((AssetManager)mgr, (String)path));
    }

    public FontSpan(String family, @NonNull AssetManager mgr, @NonNull String path) {
        this(family, Typeface.createFromAsset((AssetManager)mgr, (String)path));
    }

    public FontSpan(@NonNull Typeface typeface) {
        this("", typeface);
    }

    public FontSpan(String family, @NonNull Typeface typeface) {
        super(family);
        this.typeface = typeface;
    }

    public void updateDrawState(TextPaint textPaint) {
        this.applyCustomTypeface((Paint)textPaint);
    }

    public void updateMeasureState(TextPaint paint) {
        this.applyCustomTypeface((Paint)paint);
    }

    private void applyCustomTypeface(Paint paint) {
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int fake = oldStyle & ~this.typeface.getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(this.typeface);
    }
}

