/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.text;

import android.support.annotation.NonNull;
import android.text.Spannable;
import com.hendraanggrian.text.SpanGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Spannables {
    private Spannables() {
    }

    public static void setSpans(@NonNull Spannable spannable, int start, int end, int flags, Object ... spans) {
        for (Object span : spans) {
            spannable.setSpan(span, start, end, flags);
        }
    }

    public static void setSpans(@NonNull Spannable spannable, int start, int end, Object ... spans) {
        Spannables.setSpans(spannable, start, end, 33, spans);
    }

    public static void setSpans(@NonNull Spannable spannable, int flags, Object ... spans) {
        Spannables.setSpans(spannable, 0, spannable.length(), flags, spans);
    }

    public static void setSpans(@NonNull Spannable spannable, Object ... spans) {
        Spannables.setSpans(spannable, 0, spannable.length(), 33, spans);
    }

    @NonNull
    public static Collection<Object> putSpans(@NonNull Spannable spannable, @NonNull CharSequence text, int flags, SpanGetter ... getters) {
        String string = spannable.toString();
        String substring = text.toString();
        ArrayList<Object> spans = new ArrayList<Object>();
        for (int start : Spannables.listOccurrences(string, substring)) {
            int end = start + substring.length();
            for (SpanGetter getter : getters) {
                Object span = getter.getSpan();
                spannable.setSpan(span, start, end, flags);
                spans.add(span);
            }
        }
        return spans;
    }

    @NonNull
    public static Collection<Object> putSpans(@NonNull Spannable spannable, @NonNull CharSequence text, SpanGetter ... getters) {
        return Spannables.putSpans(spannable, text, 33, getters);
    }

    @NonNull
    public static Collection<Object> putSpansAll(@NonNull Spannable spannable, @NonNull Pattern regex, int flags, SpanGetter ... getters) {
        Matcher matcher = regex.matcher((CharSequence)spannable);
        ArrayList<Object> spans = new ArrayList<Object>();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            for (SpanGetter getter : getters) {
                Object span = getter.getSpan();
                spannable.setSpan(span, start, end, flags);
                spans.add(span);
            }
        }
        return spans;
    }

    @NonNull
    public static Collection<Object> putSpansAll(@NonNull Spannable spannable, @NonNull String regex, int flags, SpanGetter ... getters) {
        return Spannables.putSpansAll(spannable, Pattern.compile(regex), flags, getters);
    }

    @NonNull
    public static Collection<Object> putSpansAll(@NonNull Spannable spannable, @NonNull Pattern regex, SpanGetter ... getters) {
        return Spannables.putSpansAll(spannable, regex, 33, getters);
    }

    @NonNull
    public static Collection<Object> putSpansAll(@NonNull Spannable spannable, @NonNull String regex, SpanGetter ... getters) {
        return Spannables.putSpansAll(spannable, regex, 33, getters);
    }

    public static void removeSpans(@NonNull Spannable spannable, Object ... spans) {
        for (Object span : spans) {
            spannable.removeSpan(span);
        }
    }

    @NonNull
    static List<Integer> listOccurrences(@NonNull String string, @NonNull String substring) {
        ArrayList<Integer> lastIndexes = new ArrayList<Integer>();
        int lastIndex = 0;
        while (lastIndex != -1) {
            if ((lastIndex = string.indexOf(substring, lastIndex)) == -1) continue;
            lastIndexes.add(lastIndex);
            lastIndex += substring.length();
        }
        return lastIndexes;
    }
}

